@extends('app')
@section('content')
<title>Manage Vendors</title>
	<div class="content-wrapper">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                	<button style="float:right;margin-right:2%;margin-top:1%" id="add" data-toggle="tooltip" title="Add New Vendor" class="btn btn-primary display_button"><a href="managevendor/create"><i class="fa fa-plus"></i></a></button>
                    <form method="POST" action="">
						<input type="hidden" name="_method" value="DELETE">
						<input type="hidden" name="_token" value="{{ csrf_token() }}">
						<button type="submit" id="delete" data-toggle="tooltip" title="Delete entry" class="btn btn-danger pull-right display_button" style="margin-right:0.5%;margin-top:1%" disabled><i class="fa fa-trash-o"></i></button>
						<button id="edit" data-toggle="tooltip" title="Edit details" class="btn btn-info pull-right display_button" style="margin-right:0.5%;margin-top:1%"  disabled ><a id="edit_a"  href="" ><i class="fa fa-pencil"></i></a></button>
						<button id="view" data-toggle="tooltip" title="View details" class="btn btn-warning pull-right display_button" style="margin-right:0.5%;margin-top:1%" disabled><a id="view_a" href="" ><i class="fa fa-street-view"></i></a></button>
						<!-- @if (Auth::user()->can('create_shipment'))
							<a href="/create_shipment" target="_blank" data-toggle="tooltip" title="Create Shipment" class="btn btn-primary"><i class="fa fa-external-link"></i></a>
						@endif -->
					</form>
                    <form methd="get" action="/managevendor<?php echo $filter['url']; ?>">
                        <div class="col-md-3 pull-right" style="margin-top: 1%;">
                             <input type="text" class="form-control" placeholder="Search by Name or Company Name" name="filter_name" value="<?php if(!empty($_GET['filter_name'])) { echo $_GET['filter_name']; } ?>"/>
                        </div>
                    </form>
                    <h1 class="page-head-line">Vendors list</h1>
                </div>
           	</div>
            <div class="row">
            	<div class="col-md-12">
                	@if(Session::has('flash_message'))
			    		<div class="alert alert-success">
			        		{{ Session::get('flash_message') }}
			    		</div>
					@endif
							
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered table-hover">
                        	<thead>
							<tr>
								<th><input type="checkbox" onclick="$('input[name*=\'selected\']').prop('checked', this.checked).change();"/></th>
						        <th>
						        	<?php if ($filter['sort'] == 'vendor.name') { ?>
                                        <a href="/managevendor<?php echo $filter['url']; ?>&sort=vendor.name" class="<?php echo strtolower($filter['order']); ?>">Contact Person Name</a>
                                    <?php } else { ?>
                                        <a href="/managevendor<?php echo $filter['url']; ?>&sort=vendor.name">Contact Person Name</a>
                                    <?php } ?>
						        </th>
						        <th>
						        	<?php if ($filter['sort'] == 'vendor.company_name') { ?>
                                        <a href="/managevendor<?php echo $filter['url']; ?>&sort=vendor.company_name" class="<?php echo strtolower($filter['order']); ?>">Company Name</a>
                                    <?php } else { ?>
                                        <a href="/managevendor<?php echo $filter['url']; ?>&sort=vendor.company_name">Company Name</a>
                                    <?php } ?>
						        </th>
						        <th>
						        	<?php if ($filter['sort'] == 'vendor.mobile_no') { ?>
                                        <a href="/managevendor<?php echo $filter['url']; ?>&sort=vendor.mobile_no" class="<?php echo strtolower($filter['order']); ?>">Mobile</a>
                                        <?php } else { ?>
                                        <a href="/managevendor<?php echo $filter['url']; ?>&sort=vendor.mobile_no">Mobile</a>
                                    <?php } ?>
						        </th>
						        <th>
						        	<?php if ($filter['sort'] == 'vendor.email') { ?>
                                        <a href="/managevendor<?php echo $filter['url']; ?>&sort=vendor.email" class="<?php echo strtolower($filter['order']); ?>">Email</a>
                                        <?php } else { ?>
                                        <a href="/managevendor<?php echo $filter['url']; ?>&sort=vendor.email">Email</a>
                                    <?php } ?>
						        </th>
						        <th>
						        	<?php if ($filter['sort'] == 'vendor.status') { ?>
                                        <a href="/managevendor<?php echo $filter['url']; ?>&sort=vendor.status" class="<?php echo strtolower($filter['order']); ?>">Status</a>
                                        <?php } else { ?>
                                        <a href="/managevendor<?php echo $filter['url']; ?>&sort=vendor.status">Status</a>
                                    <?php } ?>
						        </th>
						        <th>Password</th>
						    </tr>
						    </thead>
						<tbody>
							@if($vendors)
							@foreach($vendors as $vendor)
		                    	<?php 
		                    		$domain = str_ireplace('www.', '', parse_url(url(), PHP_URL_HOST));
		                    		$url = "http://seller.".$domain."/autologin/".base64_encode($vendor->email.'|__|'.$vendor->id.'|__|'.time());
		                    	?>
								<tr>
									<td><input type="checkbox" name="selected[]" class="selected" value="{{ $vendor->id }}" data-amount="{{ $vendor->id }}"/></td>
									<td>{{ $vendor->name }}</td>
									<td>{{ $vendor->company_name }}</td>
									<td>{{ $vendor->mobile_no }}</td>
									<td>{{ $vendor->email }}</td>
									<td>{{ $vendor->status }}</td>
									<td>{{ $vendor->plain_password}}</td>
								</tr>
							@endforeach
							@else
							<tr>No Records Found</tr>
							@endif		
						</tbody>
                        </table>
                    </div>
                        <?php echo $vendors->render(); ?>
            	</div>
        	</div>
        </div>
    </div>
<script type="text/javascript">
$(document).ready(function () {
	//alert("Raman3");					
});
 
 $('#delete').click (function ConfirmDelete()
  {
  var x = confirm("Are you sure you want to delete?");
  if (x)
    return true;
  else
    return false;
  });

  $(".selected").change(function() {
		//$('.selected').each(function () {
			var total_selected = $('input.selected:checked').length;
			//alert(total_selected);
			if(total_selected == 1) {
				//alert("Raman");
				// ONLY DISABLING Add BUTTON 
				$('#view').prop('disabled', false);
				$('#delete').prop('disabled', false);
				$('#edit').prop('disabled', false);
				$('#add').prop('disabled', true); 

				id = (this.checked ? $(this).val() : "");	
				var view_url = '{{ route("managevendor.show", ":id") }}';
				view_url = view_url.replace(':id',id);
				//alert(view_url);
				$("#view_a").prop("href", view_url);
				$("#edit_a").prop("href", view_url);
				//console.log(id, view_url); 			

			}else if(total_selected > 1) {
				//alert("Raman2");
				// ONLY ENABLING  Delete BUTTON 
				$('#view').prop('disabled', true);
				$('#delete').prop('disabled', false);
				$('#edit').prop('disabled', true);
				$('#add').prop('disabled', true);  			
					
				} 
			// alert(checked_boxes);
		       //val = (this.checked ? $(this).attr('data-amount') : "");
		       //total_amount = (+total_amount) + (+val);
	//});
	});
</script>
@endsection
