@extends('app')
@section('content')
<title>SLA Settings</title>
<div class="content-wrapper">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h1 class="page-head-line">SLA SETTINGS</h1>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-default">
                    <div class="panel-body">
                        @if(Session::has('flash_message'))
                            <div class="alert alert-success">
                                {{ Session::get('flash_message') }}
                            </div>
                        @endif	

                        <form class="form-horizontal" role="form" method="POST" action="/sla_setting/sla_formUpdate"  enctype="multipart/form-data" onsubmit="return validate_slasettings_form();">
                            <input type="hidden" name="_token" value="{{ csrf_token() }}" />

                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="control-label1 col-md-2 col-sm-3 col-xs-12">SLA Turn Around Time : 
                                    </label>
                                    <div class="col-md-5 col-sm-6 col-xs-12">
                                        <input type="number" name="sla_turn_around_time" id="sla_turn_around_time" class="form-control" value="<?php echo $sla_form['sla_turn_around_time']; ?>" required>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label1 col-md-2 col-sm-3 col-xs-12">SLA Close Time : 
                                    </label>
                                    <div class="col-md-5 col-sm-6 col-xs-12">
                                        <input type="number" name="sla_close_time" id="sla_close_time" class="form-control" value="<?php echo $sla_form['sla_close_time']; ?>" required>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label1 col-md-2 col-sm-3 col-xs-12">Service Turn Around Time : 
                                    </label>
                                    <div class="col-md-5 col-sm-6 col-xs-12">
                                        <input type="number" name="service_turn_around_time" id="service_turn_around_time" class="form-control" value="<?php echo $sla_form['service_turn_around_time']; ?>" required>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label1 col-md-2 col-sm-3 col-xs-12">Service Close Time : 
                                    </label>
                                    <div class="col-md-5 col-sm-6 col-xs-12">
                                        <input type="number" name="service_close_time" id="service_close_time" class="form-control" value="<?php echo $sla_form['service_close_time']; ?>" required>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label1 col-md-2 col-sm-3 col-xs-12">ESC Email : 
                                    </label>
                                    <div class="col-md-5 col-sm-6 col-xs-12">
                                        <input type="text" name="esc_email" id="esc_email" class="form-control" value="<?php echo $sla_form['esc_email']; ?>" required>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label class="control-label1 col-md-2 col-sm-3 col-xs-12">SLA ESC Email : 
                                    </label>
                                    <div class="col-md-5 col-sm-6 col-xs-12">
                                        <input type="text" name="sla_esc_email" id="sla_esc_email" class="form-control" value="<?php echo $sla_form['sla_esc_email']; ?>" required>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="col-md-4 col-sm-6 col-xs-12 col-md-offset-5">
                                        <button type="text" class="btn btn-success">Save</button>       
                                    </div>
                                </div>
                            </div>
                        </form> 
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
    
    /*
    *   Validate the form data
    */
    function validate_slasettings_form()
	{
        var esc_email = $("#esc_email").val();
        var sla_esc_email = $("#sla_esc_email").val();

        isvalid_esc_mail = validatation_email(esc_email);
    	if(!isvalid_esc_mail){ 
            alert("You have entered an invalid ESC Email address!"); 
            return false; 
        }

        isvalid_sla_esc_mail = validatation_email(sla_esc_email);
    	if(!isvalid_sla_esc_mail){ 
            alert("You have entered an invalid SLA ESC Email address!"); 
            return false; 
        }
    }

    /*
    *   Validate the email
    */
    function validatation_email(email) 
	{
        if (/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(email)) { 
            return true; 
        }else { 
            return false; 
        }
	}
   
</script>
@endsection
