@extends('app')
@section('content')
<title>Reports</title>
<style type="text/css">
label {
	text-align: left !important;
}
.text_font{
		font-size: 11px;
		text-align: left !important;
}
.padding_filter{
		padding-top: 5px !important;
}
td, th {
		font-size: 12px;
}
.radio label, .checkbox label {
		min-height: 0px;
}
.form-horizontal .radio, .form-horizontal .checkbox {
		min-height: 0px;
}

/* For fixed table thead */
table {
		table-layout:fixed;
}

.div-table-content {
	max-height: 445px;
	overflow-y:auto;
}
.scorll {
	width: 98.5%;
	margin-bottom: 0px;
	border-bottom: none !important;
}
</style>
<div class="content-wrapper">
		<div class="container-fluid">
			<div class="row">
				<div class="col-md-12">
					<?php 
							if( !count($_GET) ) { 
									$url_parameter = '?report=1';
							} else {
									$url_parameter = $_SERVER['REQUEST_URI'].'&report=1';
							}
					?>
						<a href="<?php echo $url_parameter; ?>" data-toggle="tooltip" title="" class="btn btn-primary" data-original-title="Download Exel" style="float:right;margin-right:2%;margin-top:1%"><i class="fa fa-download"></i></a>
						<h1 class="page-head-line">Billing And Acc. Report</h1>
				</div>
			</div>
		<div class="row">
			  <div class="col-md-2 report_leftpanel">
						<form class="form-horizontal" role="form" method="GET" action="/billing_n_acc_report">
								<input type="hidden" name="_token" id="token" value="{{ csrf_token() }}" />
								<label class="col-md-12 control-label" style="padding:0px;margin-top: 2%;text-align:left;">Start Date: </label>
								<div class="col-md-12 padding_filter" style="padding:0px">
									<div class="input-group date">
											<input type="text" id="report_start_date" name="start_date" class="form-control" placeholder="Enter Start Date" value = "<?php if(isset($_GET['start_date'])) echo $_GET['start_date']; ?>" data-format="DD-MM-YYYY">
											<span class="input-group-btn">
													<button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
											</span>
									</div>
								</div>
								<label class="col-md-12 control-label" style="padding:0px;margin-top: 2%;text-align:left;">End Date: </label>
								<div class="col-md-12 padding_filter" style="padding:0px">
									<div class="input-group date">
											<input type="text" id="report_end_date" name="end_date" class="form-control" placeholder="Enter End Date" value = "<?php if(isset($_GET['end_date'])) echo $_GET['end_date']; ?>" data-format="DD-MM-YYYY">
											<span class="input-group-btn">
													<button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
											</span>
									</div>
								</div>
								<label class="col-md-12 control-label" style="padding:0px;margin-top: 2%;text-align:left;">Shipment Type: </label>
									<div class="col-md-12">
									@foreach($shipment_type as $type)
										<div class="checkbox">
											<label style="padding-left: 10px;">
												<input type="checkbox" name="delivery_type[]" value="<?php echo $type; ?>" class="check" style="margin-top: 0px !important;padding-top: 3px;" <?php if(isset($_GET['delivery_type'])) { if(in_array($type, $_GET['delivery_type'])) echo "checked"; } ?>> {{ ucwords(str_replace("_"," ",$type)) }}
											</label>
										</div>
									@endforeach
									</div>
								<label class="col-md-12 control-label" style="padding:0px;margin-top: 2%;text-align:left;">Payment Mode: </label>
									<div class="col-md-12">
									@foreach($payment_type as $type)
										<div class="checkbox">
											<label style="padding-left: 10px;">
												<input type="checkbox" name="payment_mode[]" value="<?php echo $type; ?>" class="check" style="margin-top: 0px !important;padding-top: 3px;" <?php if(isset($_GET['payment_mode'])) { if(in_array($type, $_GET['payment_mode'])) echo "checked"; } ?>> {{ ucwords($type) }}
											</label>
										</div>
									@endforeach
									</div>
								<!-- <label class="col-md-12 control-label" style="padding:0px;margin-top: 2%;text-align:left;">Shipment Type: </label>
									<div class="col-md-12 padding_filter" style="padding:0px">
										<select name="delivery_type" id="delivery_type" class="form-control">
												<option value="">Select Shipment Type</option>
												<option value="4_hours_delivery" <?php if(isset($_GET['delivery_type']) && $_GET['delivery_type'] == '4_hours_delivery') echo 'selected = "selected"'; ?>>4 Hours Delivery</option>
												<option value="same_day_delivery" <?php if(isset($_GET['delivery_type']) && $_GET['delivery_type'] == 'same_day_delivery') echo 'selected = "selected"'; ?>>Same Day Delivery</option>
												<option value="next_day_delivery" <?php if(isset($_GET['delivery_type']) && $_GET['delivery_type'] == 'next_day_delivery') echo 'selected = "selected"'; ?>>Next Day Delivery</option>
										</select>
									</div> -->
								<!-- <label class="col-md-12 control-label" style="padding:0px;margin-top: 2%;text-align:left;">Payment Mode: </label>
									<div class="col-md-12 padding_filter" style="padding:0px">
										<select name="payment_mode" id="payment_mode" class="form-control">
												<option value="">Select Payment Mode</option>
												<option value="cod" <?php if(isset($_GET['payment_mode']) && $_GET['payment_mode'] == 'cod') echo 'selected = "selected"'; ?>>COD</option>
												<option value="online"  <?php if(isset($_GET['payment_mode']) && $_GET['payment_mode'] == 'online') echo 'selected = "selected"'; ?>>ONLINE</option>
										</select>
									</div> -->
								<!-- <label class="col-md-12 control-label" style="padding:0px;margin-top: 2%;">Shipment Status:</label>
									<div class="col-md-12">
									@foreach($statuses as $status)
										<div class="checkbox">
											<label style="padding-left: 10px;">
												<input type="checkbox" name="delivery_status[]" value="<?php echo $status; ?>" class="check" style="margin-top: 0px !important;padding-top: 3px;" <?php if(isset($_GET['delivery_status'])) { if(in_array($status, $_GET['delivery_status'])){ echo "checked"; } } ?>> {{ $status }}
											</label>
										</div>
									@endforeach
									</div> -->

								<label class="col-md-12 control-label" style="padding:0px;margin-top: 2%;text-align:left;">Vendor: </label>
									<div class="col-md-12 padding_filter" style="padding:0px">
										<p style="margin-bottom:0px"><span id="tags-input" class="selectivity-input" name="vendor_list" id="vendor_list" style="width:100%;font-size: 11px;"></span></p>
										<textarea name="vendor_id" id="vendor_id" style="display:none;"></textarea>
									</div>

									<!-- <div class="col-md-12 padding_filter" style="padding:0px">
										<input type="text" id="start_weight" name="start_weight" class="form-control" placeholder="Enter Start Weight" value = "<?php //if(!empty($_GET)) //echo $_GET['start_weight']; ?>">
									</div> -->
							 
									<!-- <div class="col-md-12 padding_filter" style="padding:0px">
										<input type="text" id="end_weight" name="end_weight" class="form-control" placeholder="Enter End Weight" value = "<?php //if(!empty($_GET)) echo $_GET['end_weight']; ?>" >
									</div> -->
								<p style="clear: both;text-align: center;padding-top: 3%;"><input type="submit" class="btn btn-success" value="Search" id="billing_acc_form"></P>
						</form>


			</div>
			<div class="col-md-9 table-responsive">
				<table class="table table-striped table-bordered scorll" id="header_table">
					<thead>
						<tr>
							<th style="width: 3%;"></th>
							<th>Date</th>
							<th style="width:18%">AWB No.</th>
							 <th>Vendor Name</th>
							<th>Shipment Type</th>
							<th>Payment Mode</th>
							<th>Distance (Kms)</th>
							<th>Invoice Value</th>
							<th>Total Cost</th>
							<th>Shipping Charges</th>
							<th>Insurance Charges</th>
							<th>Payment Mode Charges</th>
							<th>Total Weight</th>
						</tr>
					</thead>
				</table>
				<?php
		            if(isset($_COOKIE['shipments'])) {
		                $shipment_array = explode(',', $_COOKIE['shipments']);
		            } else{
		                $shipment_array = array();
		            }
		        ?>
				<div class="div-table-content">
					<table class="table table-striped table-bordered" id="content_table">
						<tbody>
							<?php 
								$total_invoice_amt = 0;
								$total_cost = 0;
								$total_distance = 0;
								$total_cal_weight = 0;
								$total_insurance_fee = 0;
								$total_payment_mode_fee = 0;
								$total_shipping_fee = 0;
							?>
							@foreach($orders as $order)
							<?php 
								$total_invoice_amt = $order->invoice_amount + $total_invoice_amt;
								$total_distance = $order->distance + $total_distance;
								$total_cost = $order->cost + $total_cost;
								$total_cal_weight = $order->total_weight + $total_cal_weight;
								$total_shipping_fee = $order->shipping_fee + $total_shipping_fee;
								$total_insurance_fee = $order->insurance_fee + $total_insurance_fee;
								$total_payment_mode_fee = $order->payment_mode_charge + $total_payment_mode_fee;
							?>
							<tr>
								<td style="width: 3%;">
                                    <input type="checkbox" class="check_download" name="check_download" value="<?php echo $order->awb_no ?>" <?php if(in_array($order->awb_no, $shipment_array)) echo 'checked'; ?>>
                                </td>
								<td><?php echo ((new DateTime($order->order_time))->format('d-m-Y')); ?></td>
								<td class="awb_no" id="<?php echo $order->awb_no ?>" style="width:18%">{{ $order->awb_no }}</td>
								<td>{{ $order->vendor_name }}</td>
								<!-- <td>{{ $order->type }}</td> -->
								<td><?php echo ucwords(str_replace("_"," ", $order->type)); ?></td>
								<td><?php echo strtoupper($order->payment_mode); ?></td>
								<td>{{ $order->distance }}</td>
								<td>{{ number_format($order->invoice_amount,2) }}</td>
								<td>{{ number_format($order->cost,2) }}</td>
								<td>{{ number_format($order->shipping_fee,2) }}</td>
								<td>{{ number_format($order->insurance_fee,2) }}</td>
								<td>{{ number_format($order->payment_mode_charge,2) }}</td>
								<td>{{ $order->total_weight }}</td>
							</tr>
							@endforeach
							<tr>
								<td colspan="6" style="text-align:right;font-weight:bold">Total: </td>
								<td>{{ $total_distance }}</td>
								<td>{{ number_format($total_invoice_amt,2) }}</td>
								<td>{{ number_format($total_cost,2) }}</td>
								<td>{{ number_format($total_shipping_fee,2) }}</td>
								<td>{{ number_format($total_payment_mode_fee,2) }}</td>
								<td>{{ number_format($total_insurance_fee,2) }}</td>
								<td>{{ $total_cal_weight }}</td>
							</tr>
						</tbody>
					</table>
				</div>
				<?php echo $orders->appends($_GET)->render(); ?>
			</div>
		</div>
	</div>
</div>
<!-- For Storing Data in browser Cookie -->
<script src="/assets/js/jquery.cookie.js"></script>

<!-- Bikers Auto list js -->
<link href="/assets/autocomplete/selectivity-full.css" rel="stylesheet">
<script src="/assets/autocomplete/zepto.js"></script>
<script src="/assets/autocomplete/selectivity-full.js"></script>

<script type="text/javascript">
$(document).ready(function(){
			$("#report_end_date").datetimepicker({
				<?php if(!isset($_GET['end_date'])) { ?>
					defaultDate: new Date()
				<?php } ?>
			});
			var currentDate = new Date();
			var currentMonth = currentDate.getMonth() - 1;
			var currentYear = currentDate.getFullYear();
			var currentDay = currentDate.getDate();
			$("#report_start_date").datetimepicker({
					<?php if(!isset($_GET['start_date'])) { ?>
							defaultDate: new Date(currentYear, currentMonth, currentDay)
					<?php } ?>
			});
			$('#tags-input').selectivity({
				items: [<?php foreach ($vendors as $key => $vendor) { ?>{id: <?php echo $vendor->id; ?>, text:"<?php echo $vendor->name ?>"}, <?php } ?>],
					multiple: true,
			});

			$('#billing_acc_form').click(function() {
						var data = $('.selectivity-input').selectivity('data');
						console.log(data);
						var vendor_id = [];
						for (var i = 0; i < data.length; i++) {
								vendor_id[i] = data[i].id;
						};
						$('#vendor_id').val(vendor_id.toString());
			});
			<?php
			if(!empty($_GET['vendor_id'])){
				$selected = explode(',', $_GET['vendor_id']);
				foreach ($selected as $value) { ?>
					$('#tags-input').selectivity('add', <?php echo $value; ?>);
			<?php } } ?>
			$("#content_table").width($("#header_table").width());
});
// Check and download script
var cookieList = function(cookieName) {
    var cookie = $.cookie(cookieName);
    var items = cookie ? cookie.split(/,/) : new Array();
    return {
        "add": function(val) {
            items.push(val);
            $.cookie(cookieName, items.join(','));
        },
        "remove": function (val) { 
            indx = items.indexOf(val); 
            if(indx!=-1) items.splice(indx, 1); 
            $.cookie(cookieName, items.join(','));
        },
        "clear": function() {
            var cookies = document.cookie.split(";");
            for(var i=0; i < cookies.length; i++) {
                var equals = cookies[i].indexOf("=");
                var name = equals > -1 ? cookies[i].substr(0, equals) : cookies[i];
                document.cookie = name + "=;expires=Thu, 01 Jan 1970 00:00:00 GMT";
            }
        },
        "items": function() {
            return items;
        }
    }
};
var shipments = new cookieList("shipments"); 
$('.check_download').change(function() { 
    if (this.checked) {
        shipments.add($(this).val());
    } else {
        shipments.remove($(this).val());
    }
});
<?php if(!isset($_GET['page'])) { ?>
    var shipments = new cookieList("shipments"); 
    shipments.clear();
<?php } ?>
</script>
@endsection