<?php

namespace App\Http\Controllers\Report;
 
use App\Http\Requests;
use Request;
use App\Http\Controllers\Controller;
use DB;
use Session;
use App\VendorShipment;
use App\Vendor;
use App\Substation;
use Input;
use Carbon\Carbon;
use App\Amcs;
use DateTime;
use DateInterval;
use App\Bikers;
use App\StatusHistory;


class ReportController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(){
        //$substation_id = Session::get('sub_station_id');
        $date = new DateTime();
        $date->sub(new DateInterval('P1M'));
        $start_date = $date->format('Y-m-d 00:00:00');
        $end_date = new DateTime('NOW');
        $end_date = $end_date->format('Y-m-d 23:59:59');
        $bikers_query = Bikers::select('id','first_name','last_name','deleted_at');
        $bikers_query->where('bikers.status','=','Active');
		$bikers_query->where('bikers.deleted_at','=',NULL);
        $bikers = $bikers_query->get();
        $query = DB::table('shipment as sh')
                ->join('vendor as v','v.id','=','sh.vendor_id')
                ->join('bikers as bi','bi.id','=','sh.biker_id')
                ->select('sh.awb_no','sh.order_time','sh.updated_at','sh.delivery_status','v.name as vendor_name','v.mobile_no as vendor_mobile_no','v.email as vendor_email','bi.first_name','bi.last_name','sh.service_type');
                if(!empty(Input::get('start_date')) && !empty(Input::get('end_date')) || !empty(Input::get('filter_status')) || !empty(Input::get('filter_shipment')) || !empty(Input::get('bikers_id'))) {
                    if(!empty(Input::get('start_date')) && !empty(Input::get('end_date'))) {
                        $start_date = Input::get('start_date');
                        $end_date = Input::get('end_date');
                        
                        $start_time = '00:00:00';
                        $end_time = '23:59:59';

                        $date = new DateTime($start_date);
                        $start_date = $date->format('Y-m-d '. $start_time);
                        $date = new DateTime($end_date);
                        $end_date = $date->format('Y-m-d '. $end_time);
                        $query->whereBetween('sh.order_time', array($start_date,$end_date));
                    } 
                    if(!empty(Input::get('filter_status'))) {
                        $status = Input::get('filter_status');    
                        //$query->whereIn('sh.delivery_status',$status);
                        $status_output = $this->getStatus($status);
                        $status_output = call_user_func_array('array_merge', $status_output);
                        $query->whereIn('sh.delivery_status',$status_output);
                    }
                    if(!empty(Input::get('filter_shipment'))) {
                        $shipment_id = Input::get('filter_shipment');
                        $query->where('sh.awb_no','=',$shipment_id);               
                    }
                    
                    if(!empty(Input::get('bikers_id'))) {
                        $bikers_id = Input::get('bikers_id');
                        $biker_list = explode(',', $bikers_id);
                        $query->whereIn('sh.biker_id', $biker_list);
                    }
                    
                    
                } 
                //$query->whereBetween('sh.order_time',array($start_date,$end_date)); 
                
                $query->orderBy('sh.order_time', 'DESC');
				 //$deliveries = $query->get();
				//$query->get();
				//print_r($deliveries);die;
                if(Input::get('report') == 1) {
                    $orders = $query->get();
                } else {
                    $orders = $query->paginate(10);
                }
		
       // $statuses = ['Order Received','Order Cancelled','Assigned','At Sub Station','At Substation RTN','In Transit','Return In Transit','Delivered'];
        $statuses = ['New','In Progress','Awaiting Spares','Work Pending','Client Side','Completed','Closed','Cancelled'];  
        if(Input::get('report') == 1) {
            $csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
            $csv->insertOne(array('AWB No.','Date','Status','Customer Name','Customer Email','Customer Contact No','Employee Name','Type'));
            foreach ($orders as $line) { 
                $line = (array) $line;
                $order_time = new DateTime($line['order_time']);
                $line['order_time'] = $order_time->format('d/m/Y H:i:s');
                
                $data = array(
                    'awb_no' => $line['awb_no'],
                    'order_time' => $line['order_time'],
                    'delivery_status' => $line['delivery_status'],
                    'vendor_name' => $line['vendor_name'],
                    'vendor_email' => $line['vendor_email'],
                    'vendor_mobile_no' => $line['vendor_mobile_no'],
					 'employee_name' => $line['first_name']."".$line['last_name'],
					  'type' => $line['service_type']
					 
                    );
                $csv->insertOne($data);
            }
            $csv->output('shipment_report.csv');
            return;
        }

        return view('report.index')->withOrders($orders)->withBikers($bikers)->withStatuses($statuses);
    }

    public function getStatus($advance_filter_values) {
      $filter_status = array();
      foreach ($advance_filter_values as $key => $status) {
          if($status == 'New') {
            $filter_status[] = ['Order Received','New'];      
          }

          if($status == 'Cancelled') {
            $filter_status[] = ['Cancelled'];      
          }

          if($status == 'Assigned') {
            $filter_status[] = ['Order Assigned','Order Assigned not ready','Order Reassigned_1','Order Reassigned_2'];      
          }
         
          if($status == 'At Sub Station') {
            $filter_status[] = ['At Sub Station','At_substation','At_Substation_Reattempt1','At_Substation_Reattempt2'];
          }

          if($status == 'At Substation RTN') {
            $filter_status[] = ['At_substation_rtn','At_Substation_rtn_Reattempt1','At_Substation_rtn_Reattempt2'];
          }

          if($status == 'In Transit') {
            $filter_status[] = ['Order picked_in transit','Order picked_weight changed
','In transit','In transit_address changed','In transit_Business_or_house closed','In transit_COD amount not ready','In transit_Customer Refused_or_Rejected',' In transit_undelivered','In transit_Reattempt1',' In transit_Reattempt2','In transit_delay out of our control',' In Transit_Out for Delivery','In Transit_Out for Delivery1',' In Transit_Out for Delivery2',' In transit_Shipment Lost'];
          }

          if($status == 'Return In Transit') {
            $filter_status[] =['RTN Order picked_in transit','RTN Order picked_weight changed','RTN In transit','RTN In transit_address changed',' RTN In transit_Business_or_house closed','RTN In transit_COD amount not ready','RTN In transit_Customer Refused_or_Rejected','RTN In transit_undelivered','RTN In transit_Reattempt1','RTN In transit_Reattempt2','RTN In transit_delay out of our control','RTN In Transit_Out for Delivery','RTN In Transit_Out for Delivery1','RTN In Transit_Out for Delivery2','RTN In transit_Shipment Lost'];
          }
		  
		  if($status == 'In Progress') {
            $filter_status[] =['Order Assigned not ready','At Sub Station','At_substation','At_Substation_Reattempt1','At_Substation_Reattempt2','At_substation_rtn','At_Substation_rtn_Reattempt1','At_Substation_rtn_Reattempt2','Order picked_in transit','Order picked_weight changed
','In transit','In transit_address changed','In transit_Business_or_house closed','In transit_COD amount not ready','In transit_Customer Refused_or_Rejected',' In transit_undelivered','In transit_Reattempt1',' In transit_Reattempt2','In transit_delay out of our control',' In Transit_Out for Delivery','In Transit_Out for Delivery1',' In Transit_Out for Delivery2',' In transit_Shipment Lost','RTN Order picked_in transit','RTN Order picked_weight changed','RTN In transit','RTN In transit_address changed',' RTN In transit_Business_or_house closed','RTN In transit_COD amount not ready','RTN In transit_Customer Refused_or_Rejected','RTN In transit_undelivered','RTN In transit_Reattempt1','RTN In transit_Reattempt2','RTN In transit_delay out of our control','RTN In Transit_Out for Delivery','RTN In Transit_Out for Delivery1','RTN In Transit_Out for Delivery2','RTN In transit_Shipment Lost','In Progress'];
          }

          if($status == 'Completed') {
            $filter_status[] = ['Delivered','Delivered_Cash collected','Delivered_card on delivery','Delivered_Open box','RTN Delivered','Completed'];      
          }
			
			 if($status == 'Closed') {
            $filter_status[] = ['Closed'];      
          }
		  
		  	 if($status == 'Client Side') {
            $filter_status[] = ['Client Side'];      
          }
		  
		   if($status == 'Awaiting Spares') {
            $filter_status[] = ['Awaiting Spares'];      
          }
		  
		   if($status == 'Work Pending') {
            $filter_status[] = ['Work Pending'];      
          }       
      }
       return $filter_status;
    }

   /* public function billingAccountingReport() {
        $input =Input::all();
        $date = new DateTime();
        $date->sub(new DateInterval('P1M'));
        $lastmonth_date = $date->format('Y-m-d 00:00:00');
        $today_date = new DateTime('NOW');
        $query = DB::table('shipment')  ->join('shipment_packages as sp','shipment.id','=','sp.shipment_id')
                                        ->join('vendor as v','shipment.vendor_id','=','v.id')
                                        ->join('address as da','da.id','=','shipment.drop_address_id')
                                        ->join('address as pa','pa.id','=','shipment.pickup_address_id')
                                        ->join('buyer as b','b.id','=','shipment.buyer_id')
                                        ->select('shipment.order_time','shipment.awb_no','shipment.order_id','shipment.type','shipment.payment_mode','shipment.distance','shipment.invoice_amount','shipment.insurance','shipment.cost','shipment.insurance_fee','shipment.shipping_fee','shipment.payment_mode_charge','v.name as vendor_name','v.email as vendor_email','v.mobile_no as vendor_mobile','pa.address as pickup_address','pa.city as pickup_city','pa.pincode as pickup_pincode','da.address as drop_address','da.city as drop_city','da.pincode as drop_pincode','b.name as buyer_name','b.email as buyer_email','b.contact_no as buyer_contact_no',DB::Raw('(SELECT SUM(weight) FROM shipment_packages sp WHERE sp.shipment_id = shipment.id) as total_weight'), DB::Raw('(SELECT COUNT(*) FROM shipment_packages sp WHERE shipment.id = sp.shipment_id GROUP BY sp.shipment_id) AS total'));
                                        if(!empty($input['delivery_type']) || !empty($input['payment_mode']) || !empty($input['vendor_id']) || !empty($input['start_date']) && !empty($input['end_date']))
                                        {
                                            if(!empty($input['delivery_type'])) {
                                                //$query->where('shipment.type', $input['delivery_type']);
                                                $status = Input::get('delivery_type');    
                                                $query->whereIn('shipment.type',$status);
                                            }
                                            if(!empty($input['payment_mode'])) {
                                                //$query->where('shipment.payment_mode', $input['payment_mode']);
                                                $payment_mode = Input::get('payment_mode');
                                                $query->whereIn('shipment.payment_mode',$payment_mode);
                                            }
                                            if(!empty($input['vendor_id'])) {
                                                $vendor_id = Input::get('vendor_id');
                                                $vendor_list = explode(',', $vendor_id);
                                                $query->whereIn('v.id', $vendor_list);
                                            }

                                           if(!empty($input['start_date']) && !empty($input['end_date'])){
                                                $start_date = Input::get('start_date');
                                                $end_date = Input::get('end_date');
                                                $date = new DateTime($start_date);
                                                $start_date = $date->format('Y-m-d 00:00:00');
                                                $date = new DateTime($end_date);
                                                $end_date = $date->format('Y-m-d 23:59:59');
                                                $query->whereBetween('shipment.order_time', array($start_date,$end_date));
                                            }
                                            if(!empty(Input::get('delivery_status'))) {
                                                $status = Input::get('delivery_status');    
                                                $query->whereIn('shipment.delivery_status',$status);
                                            }
                                            // if(!empty($input['start_weight']) && !empty($input['end_weight'])){
                                            //     $query->havingRaw('total_weight BETWEEN ? AND ?', array($input['start_weight'],$input['end_weight']));
                                            // }
                                        } else {
                                            $query->whereBetween('shipment.order_time',array($lastmonth_date,$today_date)); 
                                        }
                                        $query->whereIn('shipment.delivery_status',['Delivered','Delivered_Cash collected','Delivered_card on delivery','Delivered_Open box','RTN Delivered']);
                                        $query->orderBy('shipment.order_time', 'DESC');
                                        $query->groupBy('sp.shipment_id');
                                       if(Input::get('report') == 1) {
                                            if(isset($_COOKIE['shipments'])) {
                                                $shipments = explode(',', $_COOKIE['shipments']);
                                                $query->whereIn('shipment.awb_no', $shipments);
                                            }
                                            $orders = $query->get();
                                        } else {
                                            $orders = $query->paginate(20);
                                        }
        $vendors = Vendor::all();
        if(Input::get('report') == 1) {
            $csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
            
            $csv->insertOne(array('Date','AWB No.','Order ID','Shipment Type','Payment Mode','Vendor Name','Vendor Email','Vendor Contact No','Pickup Address','Pickup City','Pickup Pincode','Buyer Name','Buyer Email','Buyer Contact','Drop Address','Drop City','Drop Pincode','Distance (Kms)','Insurance','Weight (Kg)','Invoice Amount','cost','Shipping Charges','Insurance Charges','Payment Mode Charges','No of Packs'));
            foreach ($orders as $line) { 
                $line = (array) $line;
                $order_time = new DateTime($line['order_time']);
                $line['order_time'] = $order_time->format('d/m/Y H:i:s');
                $line['type'] = ucwords(str_replace("_"," ", $line['type']));
                $line['payment_mode'] = strtoupper($line['payment_mode']);

                $data = array(
                    'order_time' => $line['order_time'],
                    'awb_no' => $line['awb_no'],
                    'order_id' => $line['order_id'],
                    'type' => ucwords(str_replace("_", " ", $line['type'])),
                    'payment_mode' => strtoupper($line['payment_mode']),
                    'vendor_name' => $line['vendor_name'],
                    'vendor_email' => $line['vendor_email'],
                    'vendor_mobile_no' => $line['vendor_mobile'],
                    'pickup_address' => $line['pickup_address'],
                    'pickup_city' => $line['pickup_city'],
                    'pickup_pincode' => $line['pickup_pincode'],
                    'buyer_name' => $line['buyer_name'],
                    'buyer_email' => $line['buyer_email'],
                    'buyer_contact_no' => $line['buyer_contact_no'],
                    'drop_address' => $line['drop_address'],
                    'drop_city' => $line['drop_city'],
                    'drop_pincode' => $line['drop_pincode'],
                    'distance' => $line['distance'],
                    'insurance' => $line['insurance'],
                    'weight' => $line['total_weight'],
                    'invoice_amount' => $line['invoice_amount'],
                    'cost' => $line['cost'],
                    'shipping_fee' => $line['shipping_fee'],
                    'insurance_fee' => $line['insurance_fee'],
                    'payment_mode_charge' => $line['payment_mode_charge'],
                    'no_of_packet' => $line['total']
                    );

                $csv->insertOne($data);
            }
            $csv->output('billing_n_acc_report.csv');
            return;
        }
        $statuses = ['Order Received',' Order Cancelled','Assigned','At Sub Station','At Substation RTN','In Transit','Return In Transit','Delivered'];
        $shipment_type = ['4_hours_delivery','same_day_delivery','next_day_delivery'];
        $payment_type = ['cod','online'];
        return view('report.billing_acc')->withOrders($orders)->withVendors($vendors)->withStatuses($statuses)->withShipmentType($shipment_type)->withPaymentType($payment_type);
    }
*/
    
    public function bikerReport() {
        $input =Input::all();
        $date = new DateTime();
        $date->sub(new DateInterval('P1M'));
        $start_date = $date->format('Y-m-d 00:00:00');
        $end_date = new DateTime('NOW');
        $bikers_list_query = Bikers::select();
        $bikers_list_query->where('bikers.status','=','Active');
        $bikers_list = $bikers_list_query->get();
        $query = DB::table('bikers as b')
                    ->select('b.id','b.first_name','b.last_name','b.mobile','b.email','b.status',DB::raw('(SELECT COUNT(*) FROM shipment as s WHERE s.biker_id = b.id AND s.delivery_status = "Completed") as total_shipment_delivered'))
                    ->whereNull('b.deleted_at');
                    if(!empty($input['bikers_id'])  || !empty($input['biker_type'])|| !empty($input['start_date']) && !empty($input['end_date'])) {
                        if(!empty($input['bikers_id'])) {
                            $bikers_id = Input::get('bikers_id');
                            $biker_list = explode(',', $bikers_id);
                            $query->whereIn('b.id', $biker_list);
                        }
                        if(!empty($input['biker_type'])) {
                            //$query->where('b.type','=',$input['biker_type']);
                            $biker_type = Input::get('biker_type');    
                            $query->whereIn('b.status',$biker_type);
                        }
                        if(!empty($input['start_date']) && !empty($input['end_date'])) {
                            $date = new DateTime($input['start_date']);
                            $start_date = $date->format('Y-m-d');
                            $date = new DateTime($input['end_date']);
                            $end_date = $date->format('Y-m-d');
							$query->whereBetween('b.joining_date', array($start_date,$end_date));
                        }
                    }
                    
                    
                    $query->orderBy('b.id','DESC');
                    if(Input::get('report') == 1) {
                        $bikers = $query->get();
                    } else {
                        $bikers = $query->paginate(20);
                    }
        if(Input::get('report') == 1) {
            $csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
            $csv->insertOne(array('Name', 'Email', 'Mobile', 'Status', 'Total Deliveries'));
            foreach ($bikers as $line) { 
                $data = array(
                    'name' => ucwords(strtolower($line->first_name)) . ' ' . ucwords(strtolower($line->last_name)),
                    'email' => $line->email,
                    'mobile' => $line->mobile,
                    'status' => $line->status,
                    'total_deliveries' => $line->total_shipment_delivered
                   
                );
                $line = (array) $data;
                $csv->insertOne($line);
            }
            $csv->output('employee_report.csv');
            return;
        }
        //echo '<pre>'; print_r($bikers); exit;
        $types = ['Active','Inactive'];
        return view('report.bikers_report')->withBikers($bikers)->withBikersList($bikers_list)->withTypes($types);
    }


public function amcReport() {
        $input =Input::all();
        $date = new DateTime();
        $date->sub(new DateInterval('P1M'));
        $start_date = $date->format('Y-m-d 00:00:00');
        $end_date = new DateTime('NOW');
        $bikers_list_query = Vendor::select();
        $bikers_list_query->where('status','=','Active');
        $bikers_list = $bikers_list_query->get();
        $query = Amcs::leftjoin('vendor as v','amcs.vendor_id','=','v.id')
                    ->leftjoin('products as p','amcs.product_id','=','p.id')
                        ->select('amcs.id','amcs.atype','amcs.terms','amcs.start_date','amcs.end_date','v.company_name','p.product_name','v.deleted_at');
                    if(!empty($input['bikers_id'])  || !empty($input['biker_type'])|| !empty($input['start_date']) && !empty($input['end_date'])) {
                        if(!empty($input['bikers_id'])) {
                            $bikers_id = Input::get('bikers_id');
                            $biker_list = explode(',', $bikers_id);
                            $query->whereIn('amcs.vendor_id', $biker_list);
                        }
                        if(!empty($input['biker_type'])) {
                            //$query->where('b.type','=',$input['biker_type']);
                            $biker_type = Input::get('biker_type');    
                            $query->whereIn('amcs.atype',$biker_type);
                        }
                        if(!empty($input['start_date']) && !empty($input['end_date'])) {
                            $date = new DateTime($input['start_date']);
                            $start_date = $date->format('Y-m-d');
                            $date = new DateTime($input['end_date']);
                            $end_date = $date->format('Y-m-d');
							//$query->whereBetween('amcs.start_date', array($start_date,$end_date));
							//$query->whereBetween('amcs.end_date', array($start_date,$end_date));
							$query->whereDate('amcs.start_date', '=', $start_date);
							$query->whereDate('amcs.end_date', '=', $end_date);
                        }
                    }
                   $today = Carbon::now();
                   //$query->whereDate('amcs.end_date', '>=', $today);
					$query->where('v.deleted_at','=',NULL);

                    $query->orderBy('amcs.id','DESC');
                    if(Input::get('report') == 1) {
                        $bikers = $query->get();
                    } else {
                        $bikers = $query->paginate(20);
                    }
        if(Input::get('report') == 1) {
            $csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
            $csv->insertOne(array('Client Name', 'Type', 'Terms&Condition', 'Start Date', 'End Date','Product'));
            foreach ($bikers as $line) { 
                $data = array(
                    'name' => $line->company_name,
                    'type' => $line->atype,
                    'terms' => $line->terms,
                    'sdate' => $line->start_date,
                    'edate' => $line->end_date,
					'products' => $line->product_name
                   
                );
                $line = (array) $data;
                $csv->insertOne($line);
            }
            $csv->output('amc_report.csv');
            return;
        }
        //echo '<pre>'; print_r($bikers); exit;
        $types = ['Comprehensive','Non-Comprehensive'];
        return view('report.amc_report')->withBikers($bikers)->withBikersList($bikers_list)->withTypes($types);
    }
	
	public function vendorReport() {
        $input =Input::all();
        $date = new DateTime();
        $date->sub(new DateInterval('P1M'));
        $start_date = $date->format('Y-m-d 00:00:00');
        $end_date = new DateTime('NOW');
        $bikers_list_query = Vendor::select();
        $bikers_list_query->where('status','=','Active');
        $bikers_list = $bikers_list_query->get();
        $query = DB::table('vendor')->select('*');
                    if(!empty($input['bikers_id'])  || !empty($input['biker_type']) || !empty(Input::get('filter_shipment'))) {
                        if(!empty($input['bikers_id'])) {
                            $bikers_id = Input::get('bikers_id');
                            $biker_list = explode(',', $bikers_id);
                            $query->whereIn('id', $biker_list);
                        }
                        if(!empty($input['biker_type'])) {
                            //$query->where('b.type','=',$input['biker_type']);
                            $biker_type = Input::get('biker_type');    
                            $query->whereIn('status',$biker_type);
                        }
						 if(!empty(Input::get('filter_shipment'))) {
                        $shipment_id = Input::get('filter_shipment');
                        $query->where('email','=',$shipment_id);               
                    }
                        
                    }
                   
                   //$query->whereDate('amcs.end_date', '>=', $today);
					$query->where('deleted_at','=',NULL);

                    $query->orderBy('id','DESC');
                    if(Input::get('report') == 1) {
                        $bikers = $query->get();
                    } else {
                        $bikers = $query->paginate(20);
                    }
        if(Input::get('report') == 1) {
            $csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
            $csv->insertOne(array('Client Name', 'Address','Name', 'Email', 'Mobile', 'Landline','Status'));
            foreach ($bikers as $line) { 
                $data = array(
                    'cname' => $line->company_name,
                    'address' => $line->primary_address,
                    'name' => $line->name,
                    'email' => $line->email,
                    'mobile' => $line->mobile_no,
					'landline' => $line->landline_no,
					'status' => $line->status
                   
                );
                $line = (array) $data;
                $csv->insertOne($line);
            }
            $csv->output('customer_report.csv');
            return;
        }
        //echo '<pre>'; print_r($bikers); exit;
        $types = ['Active','In Active'];
        return view('report.customer_report')->withBikers($bikers)->withBikersList($bikers_list)->withTypes($types);
    }

    public function bikercodreport() {
      
        $today_date = new DateTime('NOW');
        $end_date = $start_date = $today_date->format('Y-m-d');
        $bikers_list_query = Bikers::select();
                            if(Session::get('sub_station_id')) {
                                $bikers_list_query->where('substation_id',Session::get('sub_station_id'));
                            }
                            $bikers_list_query->where('bikers.status','=','Active');
        $bikers_list = $bikers_list_query->get();
        
        $query = DB::table('cod_collected as c')
                 ->join('shipment as sh','sh.id','=','c.shipment_id')
                 ->join('bikers as b','b.id','=','c.biker_id')
                 ->select('sh.awb_no','sh.id as shipment_table_id','c.date','b.id as biker_table_id','b.first_name','b.last_name','c.amount','c.payment_mode','c.biker_cod_paid_flag');
                 
                if(!empty(Input::get('bikers_id'))) {
                        $bikers_id = Input::get('bikers_id');
                        $biker_list = explode(',', $bikers_id);
                        $query->whereIn('b.id', $biker_list);
                }
                 if(!empty(Input::get('start_date')) && !empty(Input::get('end_date'))) {
                        $date = new DateTime(Input::get('start_date'));
                        $start_date = $date->format('Y-m-d');
                        $date = new DateTime(Input::get('end_date'));
                        $end_date = $date->format('Y-m-d');
                        //$query->whereBetween('c.date', array($start_date,$end_date));
                    } 
                if(Session::get('sub_station_id')) {
                    $query->where('sh.sub_station_id','=', Session::get('sub_station_id'));
                }
                $query->whereBetween('c.date', array($start_date,$end_date));
                $query->orderBy('c.date','desc');
                if(Input::get('report') == 1) {
                    $bikers = $query->get();
                } else {
                    $bikers = $query->paginate(20);
                }
        if(Input::get('report') == 1) {
            $csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
            $csv->insertOne(array('AWB No', 'Date', 'Biker', 'Amount','Collection Mode'));
            foreach ($bikers as $line) { 
                $date = new DateTime($line->date);
                $reading_date = $date->format('d-m-Y');
                $data = array(
                    'awb_no' => $line->awb_no,
                    'date' => $reading_date,
                    'name' => ucwords(strtolower($line->first_name)) . ' ' . ucwords(strtolower($line->last_name)),
                    'amount' => $line->amount,
                    'payment_mode' => ucwords($line->payment_mode),
                );
                $line = (array) $data;
                $csv->insertOne($line);
            }
            $csv->output('bikers_COD_report.csv');
            return;
        }
        
        return view('report.biker_cod')->withBikersList($bikers_list)->withBikers($bikers); 
    }


    // public function inventoryreconciliation() {
    //     $substation_id = Session::get('sub_station_id');
    //     $date = new DateTime();
    //     $date->sub(new DateInterval('P1M'));
    //     $start_date = $date->format('Y-m-d 00:00:00');
    //     $end_date = new DateTime('NOW');
    //     $substation_list = DB::table('sub_station')
    //                         ->select('id','name','deleted_at')
    //                         ->get();
    //     $query = DB::table('shipment as sh')
    //                     ->select('sh.order_time',DB::raw('COUNT(*) AS total_order'));
    //                     if(!empty($substation_id) || !empty(Input::get('substation_list'))|| !empty($input['start_date']) && !empty($input['end_date'])) {
    //                         if(!empty($substation_id)) {
    //                             $query->where('sh.sub_station_id','=',$substation_id);
    //                         }
    //                         if(!empty(Input::get('substation_list'))) {
    //                             $query->where('sh.sub_station_id','=',Input::get('substation_list'));
    //                         }
    //                         if(!empty($input['start_date']) && !empty($input['end_date'])) {
    //                             $date = new DateTime($input['start_date']);
    //                             $start_date = $date->format('Y-m-d');
    //                             $date = new DateTime($input['end_date']);
    //                             $end_date = $date->format('Y-m-d');
    //                         }
    //                     }
    //                     $query->whereBetween('sh.order_time', array($start_date,$end_date));
    //                     $query->whereIn('sh.delivery_status', ['At Sub Station', 'In Transit', 'Delivered']);
    //     $total_order = $query->first();

    //     $query_assign = DB::table('shipment as sh')
    //                     ->select(DB::raw('COUNT(*) AS total_assigned'))
    //                     ->where('sh.delivery_status','=','Assigned');
    //                     if(!empty($substation_id) || !empty(Input::get('substation_list')) || !empty($input['start_date']) && !empty($input['end_date'])) {
    //                         if(!empty($substation_id)) {
    //                             $query_assign->where('sh.sub_station_id','=',$substation_id);
    //                         }
    //                         if(!empty(Input::get('substation_list'))) {
    //                             $query_assign->where('sh.sub_station_id','=',Input::get('substation_list'));
    //                         }
    //                         if(!empty($input['start_date']) && !empty($input['end_date'])) {
    //                             $date = new DateTime($input['start_date']);
    //                             $start_date = $date->format('Y-m-d');
    //                             $date = new DateTime($input['end_date']);
    //                             $end_date = $date->format('Y-m-d');
    //                         }
    //                     }
    //                     $query_assign->whereBetween('sh.order_time', array($start_date,$end_date));
    //                     $query_assign->groupby(DB::raw('CAST(sh.order_time AS DATE)'));
    //                     $query_assign->orderby('sh.order_time','desc');
    //     $order_assigned = $query_assign->get();

    //     $query_delivered = DB::table('shipment as sh')
    //                     ->select(DB::raw('COUNT(*) AS total_delivered'))
    //                     ->where('sh.delivery_status','=','Delivered');
    //                     if(!empty($substation_id) || !empty(Input::get('substation_list')) || !empty($input['start_date']) && !empty($input['end_date'])) {
    //                         if(!empty($substation_id)) {
    //                             $query_delivered->where('sh.sub_station_id','=',$substation_id);
    //                         }
    //                         if(!empty(Input::get('substation_list'))) {
    //                             $query_delivered->where('sh.sub_station_id','=',Input::get('substation_list'));
    //                         }
    //                         if(!empty($input['start_date']) && !empty($input['end_date'])) {
    //                             $date = new DateTime($input['start_date']);
    //                             $start_date = $date->format('Y-m-d');
    //                             $date = new DateTime($input['end_date']);
    //                             $end_date = $date->format('Y-m-d');
    //                         }
    //                     }
    //                     $query_delivered->whereBetween('sh.order_time', array($start_date,$end_date));
    //     $order_delivered = $query_delivered->first();
    //     $query_in_substation = DB::table('shipment as sh')
    //                     ->select(DB::raw('COUNT(*) AS total_in_substation'))
    //                     ->where('sh.delivery_status','=','At Sub Station');
    //                     if(!empty($substation_id) || !empty(Input::get('substation_list')) || !empty($input['start_date']) && !empty($input['end_date'])) {
    //                         if(!empty($substation_id)) {
    //                             $query_in_substation->where('sh.sub_station_id','=',$substation_id);
    //                         }
    //                         if(!empty(Input::get('substation_list'))) {
    //                             $query_in_substation->where('sh.sub_station_id','=',Input::get('substation_list'));
    //                         }
    //                         if(!empty($input['start_date']) && !empty($input['end_date'])) {
    //                             $date = new DateTime($input['start_date']);
    //                             $start_date = $date->format('Y-m-d');
    //                             $date = new DateTime($input['end_date']);
    //                             $end_date = $date->format('Y-m-d');
    //                         }
    //                     }
    //                     $query_in_substation->whereBetween('sh.order_time', array($start_date,$end_date));
    //     $order_in_substation = $query_in_substation->first();

    //     $query_in_transit = DB::table('shipment as sh')
    //                     ->select(DB::raw('COUNT(*) AS total_in_transit'))
    //                     ->where('sh.delivery_status','=','In Transit');
    //                     if(!empty($substation_id) || !empty(Input::get('substation_list')) || !empty($input['start_date']) && !empty($input['end_date'])) {
    //                         if(!empty($substation_id)) {
    //                             $query_in_transit->where('sh.sub_station_id','=',$substation_id);
    //                         }
    //                         if(!empty(Input::get('substation_list'))) {
    //                             $query_in_transit->where('sh.sub_station_id','=',Input::get('substation_list'));
    //                         }
    //                         if(!empty($input['start_date']) && !empty($input['end_date'])) {
    //                             $date = new DateTime($input['start_date']);
    //                             $start_date = $date->format('Y-m-d');
    //                             $date = new DateTime($input['end_date']);
    //                             $end_date = $date->format('Y-m-d');
    //                         }
    //                     }
    //                     $query_in_transit->whereBetween('sh.order_time', array($start_date,$end_date));
    //      $order_in_transit = $query_in_transit->first();


    //     $query_cod_amount = DB::table('shipment as sh')
    //                     ->select('sh.order_time',DB::raw('SUM(invoice_amount) AS total_cod_amount'))
    //                     ->where('sh.payment_mode','=','cod');
    //                     if(!empty($substation_id) || !empty(Input::get('substation_list')) || !empty($input['start_date']) && !empty($input['end_date'])) {
    //                         if(!empty($substation_id)) {
    //                             $query_cod_amount->where('sh.sub_station_id','=',$substation_id);
    //                         }
    //                         if(!empty(Input::get('substation_list'))) {
    //                             $query_cod_amount->where('sh.sub_station_id','=',Input::get('substation_list'));
    //                         }
    //                         if(!empty($input['start_date']) && !empty($input['end_date'])) {
    //                             $date = new DateTime($input['start_date']);
    //                             $start_date = $date->format('Y-m-d');
    //                             $date = new DateTime($input['end_date']);
    //                             $end_date = $date->format('Y-m-d');
    //                         }
    //                     }
    //                     $query_cod_amount->whereBetween('sh.order_time', array($start_date,$end_date));
    //                     //->groupby(DB::raw('CAST(sh.order_time AS DATE)'))
    //                     //->orderby('sh.order_time','desc')
    //     $total_cod_amount = $query_cod_amount->first();
    //     //echo '<pre>'; print_r($total_cod_amount); exit;

    //     $query_cod_collected = DB::table('cod_collected as cc')
    //                     ->select('cc.date',DB::raw('SUM(cc.amount) AS cod_collected'))
    //                     ->join('shipment as sh','sh.id',' = ','cc.shipment_id');
    //                         if(!empty($substation_id) || !empty(Input::get('substation_list'))) {
    //                             if(!empty($substation_id)) {
    //                                 $query_cod_collected->where('sh.sub_station_id','=',$substation_id);
    //                             }
    //                             if(!empty(Input::get('substation_list'))) {
    //                                 $query_cod_collected->where('sh.sub_station_id','=',Input::get('substation_list'));
    //                             }
    //                             if(!empty($input['start_date']) && !empty($input['end_date'])) {
    //                                 $date = new DateTime($input['start_date']);
    //                                 $start_date = $date->format('Y-m-d');
    //                                 $date = new DateTime($input['end_date']);
    //                                 $end_date = $date->format('Y-m-d');
    //                             }
    //                         }
    //                     $query_cod_collected->whereBetween('sh.order_time', array($start_date,$end_date));
    //                     $query_cod_collected->where('cc.payment_mode','=','cash');
    //                     //->groupby('cc.date')
    //     $cod_collected = $query_cod_collected->first();
    //     return view('report.inventory_reconciliation')->withOrderDelivered($order_delivered)->withOrderInSubstation($order_in_substation)->withOrderInTransit($order_in_transit)->withTotalOrder($total_order)->withTotalCodAmount($total_cod_amount)->withCodCollected($cod_collected)->withSubstationList($substation_list);
    // }

}
