@extends('app')
@section('content')
<title>Manage Ratings</title>
<style type="text/css">
.form-group {
    min-height: 28px;
}
.modal-footer {
    clear: both;
}
.modal{
	z-index: 1000 !important;
}
/* For fixed table thead */
table {
        table-layout:fixed;
}

.div-table-content {
    max-height:350px;
    overflow-y:auto;
}
.scorll {
    width: 98.5%;
    margin-bottom: 0px;
    border-bottom: none !important;
}
.scorll1 {
    width: 1122px
}
</style>
<div class="content-wrapper">
    <div class="container">
        <div class="row">
                <div class="col-md-12">
                    
						<a href="ratings/create" data-toggle="tooltip" title="Add New" id="add" class="btn btn-primary display_button" style="float:right;margin-right:2%;margin-top:1%"><i class="fa fa-plus"></i></a>
                    
                    <form method="POST" id="amc_form" action="">
						<input type="hidden" name="_token" value="{{ csrf_token() }}">
						<input type="hidden" name="_method" value="DELETE">
						<button type="submit" id="delete" data-toggle="tooltip" title="Delete entry" class="btn btn-danger pull-right display_button" style="margin-right:0.5%;margin-top:1%" disabled onclick="return confirm('Are you sure to delete this rating?');"><i class="fa fa-trash-o"></i></button>
						<!--<a href="" id="edit" data-toggle="tooltip" title="Edit details" class="btn btn-info pull-right display_button" style="margin-right:0.5%;margin-top:1%"><i class="fa fa-pencil"></i></a>-->
						<a href="" id="view" data-toggle="tooltip" title="View details" class="btn btn-warning pull-right display_button" style="margin-right:0.5%;margin-top:1%"><i class="fa fa-street-view"></i></a>
					</form>
					<a href="/ratings/graph" data-toggle="tooltip" title="" class="btn btn-primary" data-original-title="View Graph" style="float:right;margin-right:5px;margin-top:11px;"><i class="fa fa-line-chart"></i></a>
					<?php 
							if( !count($_GET) ) { 
									$url_parameter = '?report=1';
							} else {
									$url_parameter = $_SERVER['REQUEST_URI'].'&report=1';
							}
					?>
					<a href="<?php echo $url_parameter; ?>" data-toggle="tooltip" title="" class="btn btn-primary" data-original-title="Download Exel" style="float:right;margin-right:5px;margin-top:11px;"><i class="fa fa-download"></i></a>
					<a href="" id="clear" data-toggle="tooltip" title="Clear details" class="btn btn-warning pull-right display_button" style="margin-right:0.5%;margin-top:1%" onclick="ClearFields();">Clear</a>
                    <form methd="get" action="/ratings<?php echo $filter['url']; ?>">
                        <div class="col-md-3 pull-right" style="margin-top: 1%;">
                             <input type="text" class="form-control" placeholder="Search By CompanyName,Technician name.." name="filter_name" value="<?php if(!empty($_GET['filter_name'])) { echo $_GET['filter_name']; } ?>"/>
                        </div>
                    </form>
					<h1 class="page-head-line">RATING MEMBERS LIST</h1>
                </div>
       	</div>
        <div class="row">
        	<div class="col-md-12">
                    	@if(Session::has('success'))
				            <div class="alert alert-success">
				                {{ Session::get('success') }}
				            </div>
						@endif
						@if($errors->any())
						    <div class="alert alert-danger">
						        @foreach($errors->all() as $error)
						            <p>{{ $error }}</p>
						        @endforeach
						    </div>
						@endif
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-hover scorll" id="content_table" style="margin-bottom: 0px;">
                            	<thead>
                                    <tr>
                                        <th style="width:3%"><input type="checkbox" onclick="$('input[name*=\'selected\']').prop('checked', this.checked).change();"/></th>
                                    	<th style="width: 15%;">
								        	<?php if ($filter['sort'] == 'v.company_name') { ?>
		                                        <a href="/ratings<?php echo $filter['url']; ?>&sort=v.company_name" class="<?php echo strtolower($filter['order']); ?>">Company Name/Client Name</a>
		                                    <?php } else { ?>
		                                        <a href="/ratings<?php echo $filter['url']; ?>&sort=v.company_name">Company Name/Client Name</a>
		                                    <?php } ?>
								        </th>
										<th style="width: 5%;">
								        	<?php if ($filter['sort'] == 'ratings.app') { ?>
		                                        <a href="/ratings<?php echo $filter['url']; ?>&sort=ratings.app" class="<?php echo strtolower($filter['order']); ?>">Company Rating(Out Of 5)</a>
		                                        <?php } else { ?>
		                                        <a href="/ratings<?php echo $filter['url']; ?>&sort=ratings.app">Company Rating(Out Of 5)</a>
		                                    <?php } ?>
								        </th>
										<th style="width: 5%;">
								        	<?php if ($filter['sort'] == 'ratings.technician') { ?>
		                                        <a href="/ratings<?php echo $filter['url']; ?>&sort=ratings.technician" class="<?php echo strtolower($filter['order']); ?>">Technician Rating(Out Of 5)</a>
		                                        <?php } else { ?>
		                                        <a href="/ratings<?php echo $filter['url']; ?>&sort=ratings.technician">Technician Rating(Out Of 5)</a>
		                                    <?php } ?>
								        </th>
<!--								        <th style="width: 20%;">
								        	<?php if ($filter['sort'] == 'ratings.desc') { ?>
		                                        <a href="/ratings<?php //echo $filter['url']; ?>&sort=ratings.desc" class="<?php //echo strtolower($filter['order']); ?>">Description</a>
		                                        <?php } else { ?>
		                                        <a href="/ratings<?php //echo $filter['url']; ?>&sort=ratings.desc">Description</a>
		                                    <?php } ?>
								        </th>-->
								        <th style="width: 15%;">
								        	<?php if ($filter['sort'] == 'b.first_name') { ?>
		                                        <a href="/ratings<?php echo $filter['url']; ?>&sort=ratings.first_name" class="<?php echo strtolower($filter['order']); ?>">Technician Name</a>
		                                    <?php } else { ?>
		                                        <a href="/ratings<?php echo $filter['url']; ?>&sort=ratings.first_name">Technician Name</a>
		                                    <?php } ?>
								        </th>
								        <th style="width: 15%;">
								        	<?php if ($filter['sort'] == 'ratings.awd') { ?>
		                                        <a href="/ratings<?php echo $filter['url']; ?>&sort=ratings.awd" class="<?php echo strtolower($filter['order']); ?>">Ticket No</a>
		                                    <?php } else { ?>
		                                        <a href="/ratings<?php echo $filter['url']; ?>&sort=ratings.awd">Ticket No</a>
		                                    <?php } ?>
								        </th>
										<th style="width: 15%;">
								        	<?php if ($filter['sort'] == 'ratings.created_by') { ?>
		                                        <a href="/ratings<?php echo $filter['url']; ?>&sort=ratings.created_by" class="<?php echo strtolower($filter['order']); ?>">Created By</a>
		                                    <?php } else { ?>
		                                        <a href="/ratings<?php echo $filter['url']; ?>&sort=ratings.created_by">Created By</a>
		                                    <?php } ?>
								        </th>
                                    </tr>
                                </thead>
                            </table>
                            <div class="div-table-content">
                            <table class="table table-striped table-bordered table-hover scorll1" id="header_table" >
                                <tbody>
								
								@foreach($ratings as $rating)
								
                                    <tr>
                                    	<td style="width:3%"><input type="checkbox" name="selected[]" class="selected" value="{{ $rating->id }}" data-amount=""/></td>
								        <td style="width: 15%;">{{ $rating->company_name }}</td>
									<td style="width: 5%;">{{ $rating->app }}</td>
								        <td style="width: 5%;">{{ $rating->technician }}</td>
										<!--<td style="width: 20%;">{{ $rating->desc }}</td>-->
										<td style="width: 15%;">{{ $rating->first_name }} {{$rating->last_name}}</td>

										<td style="width: 15%;">{{ $rating->awd }}</td>
										<td style="width: 15%;">{{ $rating->created_by }}</td>
								   </tr>
								@endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                  <?php echo $ratings->render(); ?>
        	</div>
    	</div>
    </div>
</div>


<link rel="stylesheet" href="/assets/jsdatepicker/datepicker.css">
<script src="/assets/jsdatepicker/datepicker.js"></script>
<script src="/assets/jsdatepicker/datepicker1.js"></script>

<script type="text/javascript">
	$(document).ready(function () {
        $('.display_button').bind('click', function(e){
            e.preventDefault();
        });
        $('#edit, #delete, #view').css({"opacity":"0.5","cursor":"default"});
        $('#add').unbind('click');
    });

    $(".selected").change(function() {
        $('.display_button').bind('click', function(e){
            e.preventDefault();
        });
        
        $('#add').unbind('click');
        total_selected = $('input.selected:checked').length;

        // No record checked enable Add and disabled Edit,View,Delete
        if(total_selected == 0) {
            $('#edit, #delete, #view').css({"opacity":"0.5","cursor":"default"});
            $('#delete').prop('disabled', true);
            $('#edit, #view').bind('click');
            $("#add").css({"opacity":"1.0","cursor":"pointer"});
            $("#add").unbind("click");
        }
        // End for no single record checked 

        ids = [];
        $("input:checkbox[class=selected]:checked").each(function (){  
            amc_name = $(this).parent().parent().find('.amc_name').text();
            //One record checked enable Edit,View,Delete and disabled Add
            if(total_selected == 1) {
                $('#delete').prop('disabled', false);
                $('#edit,#view,#delete').css({"opacity":"1.0","cursor":"pointer"});
                $('#add').css({"opacity":"0.5","cursor":"default"});
                id = $(this).val();
                
                // Create view URL
                var view_url = '{{ route("ratings.show", ":id") }}';
                view_url = view_url.replace(':id',id);
                $("#view").prop("href", view_url);
                
                // Create Edit URL
                var edit_url = '{{ route("ratings.edit", ":id") }}';
                edit_url = edit_url.replace(':id',id);
                $("#edit").prop("href", edit_url);

                // Create Delete URL for single record
                if(parseFloat($(this).attr('data-amount')) > 0.00){
                	$('#delete').prop('disabled', true);
	               	id="";
	               	alert('You can not delete rating.');
	               	var delete_url = '{{ route("ratings.destroy", "id") }}';
	                $('#delete').css({"opacity":"0.5","cursor":"default"});
	            } else {
	                $('#delete').prop('disabled', false);
	               var delete_url = '{{ route("ratings.destroy", ":id") }}';
	               delete_url = delete_url.replace(':id',id);
	               $('#delete').unbind('click');
               }
               
                $("#amc_form").prop("action", delete_url);

                $('.display_button').bind('click', function(e){
                        e.preventDefault();
                });
                $('#edit, #delete, #view').unbind('click');
            }
            // End Single checked

            // Multiple records checked enable - Delete and disabled Add,View,Edit
            if(total_selected > 1) {
                $('.display_button').bind('click', function(e){
                        e.preventDefault();
                });
                
                // Create URL for multiple delete
                if(parseFloat($(this).attr('data-amount')) > 0.00){
	               alert('You can not delete rating.');
	            } else {
	               ids.push($(this).val());
	            }
                //ids.push($(this).val());
                var delete_url = '{{ route("ratings.destroy", ":id") }}';
                delete_url = delete_url.replace(':id',ids);
                $("#amc_form").prop("action", delete_url);
                
                $("#delete").css({"opacity":"1.0","cursor":"pointer"});
                $('#delete').prop('disabled', false);
                $('#delete').unbind('click');
                $("#add,#edit,#view").css({"opacity":"0.5","cursor":"default"});
                $("#add,#edit,#view").bind("click");
            } 
            // End multiple checked
        });
    });
	</script>
	 <script type="text/javascript">
        $(document).ready(function(){
        $("#content_table").width($("#header_table").width());
        })
		function ClearFields() {
     document.getElementById("filter_name").value = "";
	 var url = "http://<?php echo $_SERVER['HTTP_HOST']?>/ratings/indexnew";
	 //http://serviceontest.mukesoft.com/serviceontest.mukesoft.com/bikers
	 //alert(url);
	 window.location = url;
}

    </script>
	<style type="text/css">
    input,
    input::-webkit-input-placeholder {
        font-size:12px;
        line-height: 2;
    }
 </style>

@endsection

