<script>
// Modern AI Chatbot Script with spinner, error handling, and UX improvements
const chatbotToggle = document.getElementById('chatbot-toggle');
const chatbotWindow = document.getElementById('chatbot-window');
const chatbotSend = document.getElementById('chatbot-send');
const chatbotInput = document.getElementById('chatbot-input');
const chatbotMessages = document.getElementById('chatbot-messages');
const API_ENDPOINT = '/chatbot-answer'; // Change this if your endpoint is different

let isLoading = false;
let chatInitialized = false;

// Show greeting when the page loads
document.addEventListener('DOMContentLoaded', () => {
  setTimeout(() => {
    if (!chatInitialized) {
      appendMessage('Bot', 'Hello! 👋 Welcome to Apni AMC! ', 'bot');
      chatInitialized = true;
    }
  }, 1000);
});

chatbotToggle.onclick = () => {
  const isOpening = chatbotWindow.style.display !== 'block';
  chatbotWindow.style.display = isOpening ? 'block' : 'none';
  if (isOpening) {
    chatbotInput.focus();
  }
};

chatbotSend.onclick = sendMessage;
chatbotInput.addEventListener('keydown', function(e) {
  if (e.key === 'Enter' && !e.shiftKey) {
    e.preventDefault();
    sendMessage();
  }
});

function getChatId() {
  let id = localStorage.getItem('chat_id');
  if (!id) {
    id = 'chat_' + Date.now() + '_' + Math.floor(Math.random() * 1000);
    localStorage.setItem('chat_id', id);
  }
  return id;
}

function sendMessage() {
  const msg = chatbotInput.value.trim();
  if (!msg || isLoading) return;
  appendMessage('You', msg, 'user');
  chatbotInput.value = '';
  setLoading(true);
  appendMessage('Bot', '<span class="chatbot-spinner"></span> Writing...', 'bot', true);
  fetch(API_ENDPOINT, {
    method: 'POST',
    headers: {'Content-Type': 'application/json'},
    body: JSON.stringify({chat_id: getChatId(),question: msg})
  })
  .then(res => res.json())
  .then(data => {
    chatbotMessages.removeChild(chatbotMessages.lastChild);
    if (data.answer) {
      appendMessage('Bot', data.answer, 'bot');
    } else if (data.choices && data.choices[0] && data.choices[0].text) {
      appendMessage('Bot', data.choices[0].text.trim(), 'bot');
    } else if (data.error) {
      appendMessage('Bot', `<span style='color:red'>${data.error}</span>`, 'bot');
    } else {
      appendMessage('Bot', 'No answer found.', 'bot');
    }
  })
  .catch(() => {
    chatbotMessages.removeChild(chatbotMessages.lastChild);
    appendMessage('Bot', '<span style="color:red">Sorry, there was an error getting the answer.</span>', 'bot');
  })
  .finally(() => setLoading(false));
}

function appendMessage(sender, message, type, isTemp = false) {
  const msgDiv = document.createElement('div');
  msgDiv.className = 'chatbot-msg' + (type === 'user' ? ' user' : '');
  msgDiv.innerHTML = `<strong>${sender}:</strong> ${message}`;
  if (isTemp) msgDiv.classList.add('temp-msg');
  chatbotMessages.appendChild(msgDiv);
  chatbotMessages.scrollTop = chatbotMessages.scrollHeight;
}

function setLoading(state) {
  isLoading = state;
  chatbotSend.disabled = state;
  chatbotInput.disabled = state;
}

// Handle pre-question button clicks
const preQuestionsDiv = document.getElementById('chatbot-prequestions');
if (preQuestionsDiv) {
  preQuestionsDiv.addEventListener('click', function(e) {
    if (e.target && e.target.classList.contains('pre-question-btn')) {
      const question = e.target.textContent;
      chatbotInput.value = question;
      sendMessage();
    }
  });
}
</script>
<style>
.chatbot-spinner {
  display: inline-block;
  width: 18px;
  height: 18px;
  border: 2px solid #2575fc;
  border-top: 2px solid #fff;
  border-radius: 50%;
  animation: chatbot-spin 1s linear infinite;
  vertical-align: middle;
  margin-right: 6px;
}
@keyframes chatbot-spin {
  0% { transform: rotate(0deg); }
  100% { transform: rotate(360deg); }
}
</style>