@extends('header')
@section('content')
<title>eRunnerz - Create Shipment</title>
<link rel="stylesheet" href="/assets/website_assets/css/servicetype.css">
<style type="text/css">
	.getbutton {
		margin-top: 0px;
		margin-bottom: 2%;
	}
	.span1 {
    	margin-left: 0px;
	}
	@media (min-width: 768px){
	.modal-dialog {
	    width: 750px;
	    margin: 30px auto;
	}
	}
	i{
		cursor: pointer;
	}
	label{
		color: #4a4a4a;
	}
	.shipment_text{
		margin-top: 1%;
	}
	.shipment_text h2{
		font-size: 20px;
	}
	.length, .breadth, .height, .weight{
		padding: 0px;
		text-align: center;
	}
	input{
		text-align: left;
	}
	#ui-datepicker-div{
		z-index: 10000 !important;
	}
	.delivery_details:hover{
		border: 2px solid #e35f2d;
	    color: #fff;
	    background-color: #252d64;
	    border-radius: 5px;
	}
	.delivery_details:hover h3 { 
		background-color: #252d64 !important;
	    border-bottom: 2px solid #e35f2d;
	    border-radius: 5px;
	    background-repeat: no-repeat;
	}
	.dropdown-menu > ul > li {
		text-decoration: underline;
	}
	.nopadding {
		padding: 0px 7px;
	}
	.nomargin {
		margin: 0px
	}
	.panel-body {
	    border-color: #ddd;
	    border: 1px solid #ddd;
	    border-radius: 8px;
	}
	.panel-heading {
		border: none;
		background-color: #fff !important;
		padding: 10px 0px 0px 0px;
		color: #252d64 !important;
	}
	.validate_error {
		margin-bottom: 0px;
		color: #f56b6b;
		font-size: 11px;
	}
	.package_validate_error {
		margin-bottom: 0px;
		color: #f56b6b;
		font-size: 11px;
	}
	.form-group {
    margin-bottom: 6px;
}
	.costbutton{
	background: none;
    border: 2px solid;
    color: #4a4a4a;
    font-weight: bold;
    margin-bottom: 2%;
	}
	.package_error {
		border-color: #f56b6b;
	}
	.cost_error_popover{
		color: red;
	}
	#error_span {
		color: red;
	}

</style>

<div class="content-wrapper shipment_top">
    <div class="container">
    	 @if (session('status') == 'Hold')
    	 <div class="col-sm-12" style="margin-top:7%">You do not have permission to create order.</div>
    	 @else
	 	<div class="row">
			<div class="row">
                <div class="col-md-6">
                	<h3 class="page-head-line">Create Shipment</h3>
                </div>
                <!-- <div class="col-md-6"><a href="/order" class="btn btn-default getbutton hvr-push" style="margin-right: 9%;">PAST ORDER</a></div> -->
           	</div>
			<form class="form-horizontal" role="form" method="POST" action="/shipment" id="shipment_form">
				<div class="col-md-12">
					<input type="hidden" name="_token" value="{{ csrf_token() }}" />
					<div class="col-md-12" id="address_1" style="display:block">
						<div class="row">
							<div class="col-md-6">
								<div class="panel panel-default" style="border: none">
									<div class="panel-heading"><label>Pick Up Address</label></div>
									<div class="panel-body">
										<div class="form-group">
											<div class="col-sm-12">          
												<input type="text" class="form-control validate onchange second" name="pick_up_name" autocomplete="off" style="text-transform:capitalize" value="{{ $vendor_details->name }}" id="pick_up_name" placeholder="Contact Name" required>
												<p id="pick_up_name_error" class="validate_error" style="display:none">Please Enter valid name</p>
											</div>
										</div>
										<div class="form-group">
											<div class="col-sm-12">          					
												<input type="text" class="form-control onchange validate second" name="pick_up_contact_no" id="pick_up_contact_no" value="{{ $vendor_details->mobile_no }}" maxlength="10" pattern="[0-9]{10,10}" placeholder="Contact No" required>
												<p id="pick_up_contact_no_error" class="validate_error" style="display:none">Please Enter valid contact no</p>
											</div>
										</div>
										<div class="form-group">
											<div class="col-sm-12">          
												<input type="email" class="form-control onchange validate second" name="pick_up_email" id="pick_up_email" value="{{ $vendor_details->email }}" placeholder="Email" required>
												<p id="pick_up_email_error" class="validate_error" style="display:none">Please Enter valid email</p>
											</div>
										</div>
										<div class="form-group">
											<div class="col-sm-12 second"> 
												<select class="form-control onchange" name="old_addresses" id="old_addresses">
													<option value="">Select Address</option>
													@foreach($addresses as $address)
														<option value="{{ $address -> id }}" >{{ $address -> address }} , {{ $address -> city }} ,{{$address -> pincode}} , {{$address -> state}}</option>
													@endforeach	
								               	</select>
											</div>
										</div>
										<div class="form-group">
											<div class="col-sm-12">
											 <textarea class="form-control pre_filled validate second onchange" name="pick_up_address" id="pick_up_address" rows="2" autocomplete="off" style="text-transform:capitalize" placeholder="Address Line 1" required></textarea>
											 <p id="pick_up_address_error" class="validate_error" style="display:none">Address is invalid</p>
											</div>
										</div>
										<div class="form-group">
											<div class="col-sm-12">
											 <textarea class="form-control pre_filled validate second onchange" name="pick_up_address_1" id="pick_up_address_1" rows="2" autocomplete="off" style="text-transform:capitalize" placeholder="Address Line 2" required></textarea>
											 <p id="pick_up_address_1_error" class="validate_error" style="display:none">Address is invalid</p>
											</div>
										</div>
										
										<div class="form-group">
											<div class="col-sm-12">
											<input type="text" class="form-control pre_filled validate second onchange" name="pick_up_landmark" id="start" placeholder="Pickup Landmark (Type initials and select from suggestions list.)" autocomplete="off">
											<input type="hidden" class="form-control validate_field" name="city" id="city" placeholder="Enter a Location/Pincode">
											<p id="start_error" class="validate_error" style="display:none">Landmark is invalid (Type initials and select from suggestions list.)</p>
											</div>
										</div>

										<div class="form-group">
											<div class="col-sm-12">
											<select name="pick_up_city" class="form-control pre_filled validate second onchange" id="pick_up_city" required>
												<option value="">Select City</option>
	                                            <option value="Mumbai">Mumbai</option>
	                                            <option value="Navi Mumbai">Navi Mumbai</option>
	                                            <option value="Thane">Thane</option>
	                                        </select>
	                                        <p id="pick_up_city_error" class="validate_error" style="display:none">Please select city</p>
											</div>
										</div>

										<div class="form-group">
											<div class="col-sm-12">          
											<input type="text" class="form-control pre_filled validate second onchange" name="pick_up_pin_code" id="pick_up_pin_code" pattern="[0-9]{6}" maxlength="6"  autocomplete="off" placeholder="Pin Code" required>
											<p id="pick_up_pin_code_error" class="validate_error" style="display:none">Please enter valid pincode</p>
											</div>
										</div>

										<div class="form-group">
		                                    <div class="col-md-12">
		                                        <select name="pick_up_state" class="form-control pre_filled validate second onchange" id="pick_up_state" required>
		                                            <option value="">Select State</option>
		                                            @foreach($states as $state)
			                                            @if($state->name == "Maharashtra")
			                                                <option value="{{ $state->name }}" selected="selected">{{ $state->name }}</option>
			                                            @else
			                                            	<option value="{{ $state->name }}">{{ $state->name }}</option>
			                                            @endif
		                                            @endforeach
		                                        </select>
												<input type="hidden" class="form-control second" name="pick_up_country" value="India" id="pick_up_country"  autocomplete="off">
												<p id="pick_up_state_error" class="validate_error" style="display:none">Please select state</p>
		                                    </div>
		                                </div>
									</div>
								</div>
							</div>
							<div class="col-md-6">
								<div class="panel panel-default" style="border: none">
									<div class="panel-heading"><label>Delivery Address</label></div>
									<div class="panel-body">
										<div class="form-group">
											<div class="col-sm-12">          
												<input type="text" class="form-control validate second onchange" name="delivery_name" id="delivery_name" autocomplete="off" style="text-transform:capitalize" placeholder="Contact Name" required>
												<p id="delivery_name_error" class="validate_error" style="display:none">Please Enter valid name</p>
											</div>
										</div>
										<div class="form-group">
											<div class="col-sm-12">          
												<input type="text" class="form-control validate second onchange" name="delivery_contact_no" id="delivery_contact_no" pattern="[0-9]{10,10}" maxlength="10" autocomplete="off" placeholder="Contact No" required>
												<p id="delivery_contact_no_error" class="validate_error" style="display:none">Please Enter valid contact no.</p>
											</div>
										</div>
										<div class="form-group">
											<div class="col-sm-12">          
												<input type="email" class="form-control validate second onchange" name="delivery_email" id="delivery_email" placeholder="Email" required>
												<p id="delivery_email_error" class="validate_error" style="display:none">Please Enter valid email</p>
											</div>
										</div>
										<div class="form-group">
											<div class="col-sm-12">
												 <textarea class="form-control validate second onchange delivery_address" name="delivery_address" id="delivery_address" rows="2" autocomplete="off" style="text-transform:capitalize" placeholder="Address Line 1" required></textarea>
												 <p id="delivery_address_error" class="validate_error" style="display:none">Address is invalid</p>
											</div>
										</div>
										<div class="form-group">
											<div class="col-sm-12">
												 <textarea class="form-control validate second onchange delivery_address" name="delivery_address_1" id="delivery_address_1" rows="2" autocomplete="off" style="text-transform:capitalize" placeholder="Address Line 2" required></textarea>
												 <p id="delivery_address_1_error" class="validate_error" style="display:none">Address is invalid</p>
											</div>
										</div>
										<div class="form-group">
											<div class="col-sm-12">
											<input type="text" class="form-control validate second onchange delivery_address" name="delivery_landmark" id="end" placeholder="Delivery Landmark (Type initials and select from suggestions list.)" autocomplete="off">
											<input type="hidden" class="form-control validate_field" name="city_to" id="city_to" placeholder="Enter a Location/Pincode" required="">
											<p id="end_error" class="validate_error" style="display:none">Landmark is invalid (Type initials and select from suggestions list.)</p>
											</div>
										</div>
										<div class="form-group">
											<div class="col-sm-12">
												<select name="delivery_city" class="form-control validate second onchange" id="delivery_city" required>
													<option value="">Please City</option>
		                                            <option value="Mumbai">Mumbai</option>
		                                            <option value="Navi Mumbai">Navi Mumbai</option>
		                                            <option value="Thane">Thane</option>
		                                        </select>
		                                        <p id="delivery_city_error" class="validate_error" style="display:none">Please select city</p>
											</div>
										</div>
										<div class="form-group">
											<div class="col-sm-12">          
												<input type="text" class="form-control validate second onchange delivery_address" name="delivery_pin_code" id="delivery_pin_code" pattern="[0-9]{6}" maxlength="6" autocomplete="off" placeholder="Pin Code" required>
												 <p id="delivery_pin_code_error" class="validate_error" style="display:none">Please enter valid pincode</p>
											</div>
										</div>
										<div class="form-group">
		                                    <div class="col-md-12">
		                                        <select name="delivery_state" class="form-control validate second onchange delivery_address" id="delivery_state" required>
		                                            <option value="">Select State</option>
		                                            @foreach($states as $state)
		                                            @if($state->name == "Maharashtra")
		                                                <option value="{{ $state->name }}" selected="selected">{{ $state->name }}</option>
		                                            @else
		                                            	<option value="{{ $state->name }}">{{ $state->name }}</option>
		                                            @endif
		                                            @endforeach
		                                        </select>
		                                        <p id="delivery_state_error" class="validate_error" style="display:none">Please select state</p>
												<input type="hidden" class="form-control" name="delivery_country" value="India" id="delivery_country" autocomplete="off" required>
		                                    </div>
			                            </div>
									</div>
								</div>
							</div>
						</div>
						<!-- <div class="col-md-12">
							<div class="col-md-9"></div>
							<div class="col-md-3">
								<input class="form-control total_cost" type="hidden" name="total_cost">
								<input class="form-control" type="hidden" name="distance" id="distance">
							</div>
							<!-- <input type="button" class="btn btn-default getbutton hvr-push" id="next_button" value="Next"/>
							<input type="button" class="btn btn-default getbutton hvr-push" id="validate" value="Next"/> --
						</div> -->
					</div>
					<div class="col-md-5" id="address_2" style="display:none">
						<div class="panel panel-default" style="border: none">
							<div class="panel-heading"><label>Create Shipment</label></div>
							<div class="panel-body">
								<div class="form-group">
									<div class="col-md-12" style="padding:0px">
										<div class="col-md-6">
											<input type="text" name="pickup_date" id="datepicker" class="form-control" placeholder="Pickup Date" readonly>
										</div>
										<div class="col-md-6">
											<input type="text" name="order_id" id="order_id" class="form-control validate_shipment_package onchange" placeholder="Your Website Order ID">
											<p id="order_id_error" class="package_validate_error" style="display:none">Order ID is invalid</p>
										</div>
									</div>
								</div>
								<div class="form-group">
									<div class="col-md-12" style="padding:0px">
										<div class="col-md-6">
											<select class="form-control validate_shipment_package onchange" name="payment_mode" id="delivery_payment_mode" required>
											   <option value="">Payment Mode</option>
											   <option value="cod">Cash On Delivery</option>
											   <option value="online">Prepaid</option>
											</select>
											<p id="delivery_payment_mode_error" class="package_validate_error" style="display:none">Payment mode is invalid</p>
											<!-- <input class="form-control" type="hidden" name="delivery_type" id="delivery_type"/> -->
										</div>
										<div class="col-md-6">
											<select class="form-control validate_shipment_package onchange" name="insurance" id="insurance" required>
												<option value="" selected="selected">Select Insurance</option>
												<option value="1">Yes</option>
												<option value="0">No</option>
											</select>
											<p id="insurance_error" class="package_validate_error" style="display:none">Please Select Insurance Option</p>
										</div>
									</div>
									<hr>
									<div class="col-md-12" style="margin-top: 1%">
										<p>No of Package</p>
										<select class="form-control onchange" name="package_count" id="package_count" required>
                							<!-- <option value="">Select No. of package</option> -->
                                            <option value="1">1</option>
                                            <option value="2">2</option>
                                            <option value="3">3</option>
                                            <option value="4">4</option>
                                            <option value="5">5</option>
                                            <option value="6">6</option>
                                            <option value="7">7</option>
                                            <option value="8">8</option>
                                            <option value="9">9</option>
                                            <option value="10">10</option>
                                            <option value="11">11</option>
                                            <option value="12">12</option>
                                            <option value="13">13</option>
                                            <option value="14">14</option>
                                            <option value="15">15</option>
                                            <option value="16">16</option>
                                            <option value="17">17</option>
                                            <option value="18">18</option>
                                            <option value="19">19</option>
                                            <option value="20">20</option>
                                		</select>
									</div>
									<div class="col-md-12" style="margin-top: 1%;padding:0px;">
										<!-- <div class="col-md-6" id="no_of_package" style="margin-top: 1%;">
											<p class="nomargin">Package</p>
												<label class="radio-inline"><input type="radio" class="package_validate" name="no_of_package" value="Single">Single</label>
										    	<label class="radio-inline"><input type="radio" name="no_of_package" class="package_validate" value="Multiple">Multiple</label>
										    	<p id="package_error" class="package_validate_error" style="display:none">Please select package option</p>
										</div> -->
										<div class="col-md-6" id="package_type" style="margin-top: 1%;">
											<p class="nomargin">Are Package Identical</p>
												<label class="radio-inline"><input type="radio" class="package_type onchange" name="package_type" value="identical">Yes</label>
										    	<label class="radio-inline"><input type="radio" class="package_type onchange" name="package_type" value="non_identical">No</label>
										</div>
										<div class="col-md-6">
											<button type="button" class="btn btn-default getbutton hvr-push" id="package_modal_button" data-toggle="modal" title="Edit Package" data-target="#package_modal" style="margin-top: 11%;margin-right: 2%;margin-bottom:0px;display:none"><i class="fa fa-pencil"></i></button>
										</div>
									</div>
								</div>
								<div class="col-md-12" id="package_content" style="padding:0px;display:none">
									<div class="form-group">
										<div class="col-md-12" style="padding:0px">
											<div class="col-md-6">
												<input class="form-control validate_shipment_package content is_disable onchange" id="content" type="text" name="shipment[content][]" style="text-transform:capitalize" placeholder="Content" maxlength="25">
												<p id="content_error" class="package_validate_error" style="display:none">Please Enter Content</p>
											</div>
											<div class="col-md-4">
												<input class="form-control invoice validate_shipment_package is_disable onchange" id="invoice" type="text" name="shipment[value][]" placeholder="Value">
												<p id="invoice_error" class="package_validate_error" style="display:none">Please Enter Value</p>
											</div>
											<!-- <div class="col-md-2">
												<button type="button" class="btn btn-default getbutton hvr-push" id="package_modal_button" data-toggle="modal" title="Add Package" data-target="#package_modal" style="margin-top: 3%;margin-right: 2%;margin-bottom:0px;display:none"><i class="fa fa-plus"></i></button>
											</div> -->
										</div>
									</div>
									<div class="form-group">
										<div class="col-sm-12 package" style="padding:0px">
											<div class="col-sm-3" style="text-align: center;">
											     <select class="form-control weight validate_shipment_package is_disable onchange"  id="weight" name="shipment[weight][]">
	                    							<option value="">Weight</option>
	                                                <option value="1">1</option>
	                                                <option value="2">2</option>
	                                                <option value="3">3</option>
	                                                <option value="4">4</option>
	                                                <option value="5">5</option>
	                                                <option value="6">6</option>
	                                                <option value="7">7</option>
	                                                <option value="8">8</option>
	                                                <option value="9">9</option>
	                                                <option value="10">10</option>
	                                                <option value="11">11</option>
	                                                <option value="12">12</option>
	                                                <option value="13">13</option>
	                                                <option value="14">14</option>
	                                                <option value="15">15</option>
	                                                <option value="16">16</option>
	                                                <option value="17">17</option>
	                                                <option value="18">18</option>
	                                                <option value="19">19</option>
	                                                <option value="20">20</option>
	                                			</select>
											</div>
											<div class="col-sm-2 nopadding" style="text-align: center;">
											    <input class="form-control length is_disable onchange validate_shipment_package" type="text" id="length" name="shipment[length][]" placeholder="L">
											</div>
											<div class="col-sm-2 nopadding" style="text-align: center;">
											    <input class="form-control breadth is_disable onchange validate_shipment_package" type="text" id="breadth" name="shipment[breadth][]" placeholder="B">
											</div>
											<div class="col-sm-2 nopadding" style="text-align: center;">
											    <input class="form-control height is_disable onchange validate_shipment_package" type="text" id="height" name="shipment[height][]" placeholder="H">
											</div>
											<div class="col-sm-1 nopadding" style="padding: 0px;width: 6%;text-align: center;">
												<p> = </p>
											</div>
											<div class="col-sm-2 nopadding" style="text-align: center;">
											    <input class="form-control VWT volumetric_weight is_disable onchange" type="number" id="vwt" min="0" name="shipment[vwt][]" placeholder="VWT" readonly>
											</div>
										</div>
									</div>
								</div>
								<div class="col-md-12" id="price_section" style="padding:0px;display:none">
									<div class="form-group">
										<div class="col-md-12">
											<div class="col-md-6">
												<p class="col-md-8 nomargin" style="padding: 0px;">Total Weight</p>
												<div class="col-md-4 nomargin" style="padding-right: 0px;padding-left: 0px;">
													<input type="text" id="total_weight" class="form-control" readonly>
												</div>
											</div>
											<div class="col-md-6" style="padding-right: 0px;">
												<p class="col-md-8 nomargin" style="padding: 0px;">Total Invoice Amt</p>
												<div class="col-md-4 nomargin" style="padding-right: 0px; padding-left: 0px;">
													<input type="text" id="total_invoice_amt" class="form-control" readonly>
												</div>
											</div>
										</div>
									</div>
									<div class="form-group">
										<!-- <div class="col-md-4" style="border:1px solid;">
											<p class="nomargin" style="border:1px solid;">Select Services: </p>
											<div class="radio">
												<label><input type="radio" class="delivery_type" name="delivery_type" id="fhd" value="fhd">4 hrs</label>
												
											</div>
											<div class="radio">
												<label><input type="radio" class="delivery_type" name="delivery_type" id="sdd" value="sdd">Same Day</label>
											</div>
											<div class="radio">
												<label><input type="radio" class="delivery_type" name="delivery_type" id='ndd' value="ndd">Next Day</label>
											</div>
										</div>

										<div class="col-md-4">
											<p></p>
											<p>Cost : </p>
											<p>Cost : </p>
											<p>Cost : </p>
										</div>
										<div class="col-md-4"></div> -->
										
										<!-- This is service main div start -->
										<div class="select-service-main-bg">
											
											<!-- This is title div start -->
											<div class="select-service-title-bg">
												<div class="select-service-title">
													Select Our Service Type:
												</div>
											</div>
											<!-- This is title div end -->


											<!-- This is content div start -->
											<div class="select-service-content-bg">
												<div class=" col-md-12 service-type-name-bg">
													<div class="4hd-title">
														<div class="radio">
														<label><input type="radio" class="delivery_type" name="delivery_type" id="fhd" value="fhd" required>4 Hrs</label>
														</div>
													</div>
													<div class="ssd-title">
														<div class="radio">
														<label><input type="radio" class="delivery_type" name="delivery_type" id="sdd" value="sdd" required>Same Day</label>
														</div>
													</div>
													<div class="nxd-title">
														<div class="radio">
														<label><input type="radio" class="delivery_type" name="delivery_type" id='ndd' value="ndd" required>Next Day</label>
														</div>
													</div>
												</div>

												<div class="service-cost-bg">
													<div>
														
													</div>
													<div class="fhd-cost">
														Cost: 
														<span id="fhd_cost" style="font-size:12px"></span>
														<i class="fa fa-info-circle cost_popover" style="padding-left: 5%;display:none" data-placement="right" id="fhd_info_button" rel='popover' data-popeerdiv="#fhd_popover" data-trigger="hover"></i>
														<i class="fa fa-info-circle cost_error_popover" style="padding-left: 5%;display:none" data-placement="right" id="fhd_info_error_button" rel='popover' data-popeerdiv="#fhd_error_popover" data-trigger="hover"></i>
													</div>
													<div class="ssd-cost">
														Cost: <span id="sdd_cost" style="font-size:12px"></span>
														<i class="fa fa-info-circle cost_popover" style="padding-left: 5%;display:none" data-placement="right" id="sdd_info_button" rel='popover' data-popeerdiv="#sdd_popover" data-trigger="hover"></i>
														<i class="fa fa-info-circle cost_error_popover" style="padding-left: 5%;display:none" data-placement="right" id="sdd_info_error_button" rel='popover' data-popeerdiv="#sdd_error_popover" data-trigger="hover"></i>
													</div>
													<div class="nxd-cost">
														Cost: <span id="ndd_cost" style="font-size:12px"></span>
														<i class="fa fa-info-circle cost_popover" style="padding-left: 5%;display:none" data-placement="right" id="ndd_info_button" rel='popover' data-popeerdiv="#ndd_popover" data-trigger="hover"></i>
														<i class="fa fa-info-circle cost_error_popover" style="padding-left: 5%;display:none" data-placement="right" id="ndd_info_error_button" rel='popover' data-popeerdiv="#ndd_error_popover" data-trigger="hover"></i>
													</div>
												</div>

												<div class="calculate-button-bg">
													<div class="calculate-button">
														<div class="pull-center" style="text-align:center;margin-top: 17%;padding: 0px;">
															<button type="button" class="btn costbutton" value="CALCULATE COST" id="calculate_cost">CALCULATE COST</button>
														</div>
													</div>
												</div>
												<p id="service_NA" style="display:none;clear:both;text-align: center;padding-top: 1%;"><span id="error_span"><i class="fa fa-info-circle"></i></span> Service N/A: Hover on above red 'i' icon.</p>

											</div>
											<!-- This is content div end -->
										</div>
									</div>
									<!-- <div class="form-group" style="margin-top: 1%;padding: 0px;border-top: 1px solid #d5d5d5;">
										<div class="pull-center" style="text-align:center;margin-top: 3%;padding: 0px;">
											<button type="button" class="btn costbutton" value="CALCULATE COST" id="calculate_cost">CALCULATE COST</button>
										</div>
									</div> -->
									<div class="form-group" style="margin-top: 1%;padding: 0px;border-top: 1px solid #d5d5d5">
										<div class="pull-center" style="text-align:center;margin-top: 3%;padding: 0px;display:none">
											<label style="font-weight:bold">Total Rs.<span id="price_span"></span> <!-- <i class="fa fa-info-circle" data-placement="bottom" id="info_popup" rel='popover' data-content="" data-trigger="hover"></i> --></label>
										</div>
									</div>
									<div class="col-md-12" id="submit_btn" style="padding-right:0px;margin-top:1%;">
										<div class="col-md-9"></div>
										<div class="col-md-3" style="padding-right:0px">
											<input class="form-control total_cost" type="hidden" name="total_cost">
											<input class="form-control" type="hidden" name="distance" id="distance">
											<input class="form-control total_invoice" type="hidden" name="total_invoice">
											<input type="hidden" name="shipping_fee" id="shipping_fee">
											<input type="hidden" name="insurance_fee" id="insurance_fee">
											<input type="hidden" name="payment_mode_charge" id="payment_mode_charge">
											<!-- <p style="clear:both">Total Invoice Amount: <span class="total_invoice amount"></span> </p> -->
											<button type="submit" id="validate1" class="btn btn-default getbutton hvr-push" style="margin-top:2%;margin-bottom:4%;">Submit</button>
										</div>
									</div>
								</div>
							</div>
							
						</div>
					</div>
				</div>

				<!-- Modal to add multiple package-->
				<div id="package_modal" class="modal fade" role="dialog">
				  <div class="modal-dialog" style="z-index: 1100;">
				    <!-- Modal content-->
				    <div class="modal-content">
				      <div class="modal-header" style="padding-bottom: 5px;">
				        <button type="button" class="close" data-dismiss="modal">&times;</button>
				      	<h3 class="modal-title">Multiple Package Details</h3>
				      </div>
				      <div class="modal-body" style="text-align: right;">
				        <div id="package_container" class="optionBox"></div>
				        <button type="button" id="validate2" class="btn btn-default hvr-push">SAVE</button>
						<!-- <button type="button" id="add_new_package" class="btn btn-default hvr-push" style="margin-right: 28px;"><i class="fa fa-plus"></i></button> -->

				      </div>
				    </div>
				  </div>
				</div>
				<!-- Modal For Calculation Information -->
					<div id="cost" class="modal fade" role="dialog">
						 <div class="modal-dialog" style="z-index: 1100;">
					  <div class="modal-dialog">
						    <!-- Modal content-->
						    <div class="modal-content">
						    <div class="modal-header" style="border-bottom: none;">
						        <button type="button" class="close" data-dismiss="modal">&times;</button>
						        <h4 class="modal-title">Cost Formula</h4>
						    </div>
						    <div class="modal-body">
						        <p></p>
						    </div>
						    <div class="modal-footer" style="border-top: none;">
						        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
						    </div>
					    </div>
					  </div>
					</div>
				  </div>

				  <!-- price popover -->
				  	<div class="col-md-6 col-sm-6 delivery delivery_details" id="fhd_popover" style="display:none">
                        <h3 class="popupheading">4 Hours Delivery</h3>
                        <div class="col-md-8 col-sm-8 price_inner_1">
                            <span  class="span1">Shipping Fee : </span><br>
                            <span  class="span1">Insurance Charges : </span><br>
                            <span  class="span1">Payment Mode Charges : </span><br>
                            <span  class="span1">Total Charges : </span><br>
                            <span  class="span1">Distance in Kms : </span><br>
                            <span  class="span1">Weight in Kgs : </span><br>
                            <span  class="span1">Service TAX : </span>
                        </div>
                        <div class="col-md-4 col-sm-4 price_inner_2">
                            <span><i class="fa fa-inr"></i> <span id="shipping_fees_1"></span></span><br>
                            <span><i class="fa fa-inr"></i> <span id="p_4_hour_insurance"></span></span><br>
                            <span><i class="fa fa-inr"></i> <span id="p_4_hour_payment_mode"></span></span><br> 
                            <span><i class="fa fa-inr"></i> <span id="span_4_hour" class="total_charges"></span></span><br>
                            <span id="p_4_hour"></span><br>
                            <span id="weight_1"></span></br>
                            <span><i class="fa fa-inr"></i> <span id="fhd_tax"></span></span>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-6 delivery delivery_details" id="sdd_popover" style="display:none">
                        <h3 class="popupheading">Same Day Delivery</h3>
                        <div class="col-md-8 col-sm-8 price_inner_1">
                            <span  class="span1">Shipping Fee : </span><br>
                            <span  class="span1">Insurance Charges : </span><br>
                            <span  class="span1">Payment Mode Charges : </span><br>
                            <span  class="span1">Total Charges : </span><br>
                            <span  class="span1">Distance in Kms : </span><br>
                            <span  class="span1">Weight in Kgs : </span><br>
                            <span  class="span1">Service TAX : </span>
                        </div>
                        <div class="col-md-4 col-sm-4 price_inner_2">
                            <i class="fa fa-inr"></i> <span id="shipping_fees_2"></span><br>
                            <i class="fa fa-inr"></i> <span id="p_same_day_insurance"></span><br>
                            <i class="fa fa-inr"></i> <span id="p_4_hour_payment_mode"></span><br> 
                            <i class="fa fa-inr"></i> <span id="span_same_day" class="total_charges"></span> <br>
                            <span id="p_same_day"></span> <br>
                            <span id="weight_2"></span></br>
                            <span><i class="fa fa-inr"></i> <span id="sdd_tax"></span></span>           
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-6 delivery delivery_details" id="ndd_popover" style="display:none">
                        <h3 class="popupheading">Next Day Delivery</h3>
                        <div class="col-md-8 col-sm-8 price_inner_1">
                            <span  class="span1">Shipping Fee : </span><br>
                            <span  class="span1">Insurance Charges : </span><br>
                            <span  class="span1">Payment Mode Charges : </span><br>
                            <span  class="span1">Total Charges : </span><br>
                            <span  class="span1">Distance in Kms : </span><br>
                            <span  class="span1">Weight in Kgs : </span><br>
                            <span  class="span1">Service TAX : </span>
                        </div>
                        <div class="col-md-4 col-sm-4 price_inner_2">
                            <i class="fa fa-inr"></i> <span id="shipping_fees_3"></span><br>
                            <i class="fa fa-inr"></i> <span id="p_next_day_insurance"></span><br>
                            <i class="fa fa-inr"></i> <span id="p_4_hour_payment_mode"></span><br>
                            <i class="fa fa-inr"></i> <span id="span_next_day" class="total_charges"></span> <br>
                            <span id="p_next_day"></span><br>
                            <span id="weight_3"></span></br>
                            <span><i class="fa fa-inr"></i> <span id="ndd_tax"></span></span>
                        </div>
                    </div>

                    <!-- price error popover -->

                    <div class="col-md-6 col-sm-6" id="fhd_error_popover" style="display:none;clear: both;">
                    	<p>Distance is more than 15Kms and/or weight more than 10Kgs.</p>
                    </div>
                    <div class="col-md-6 col-sm-6" id="sdd_error_popover" style="display:none;clear: both;">
                    	<p>
                    	<!-- Distance is more than 50Kms. -->
                    	Distance is more than 50Kms and/or weight more than 20Kgs.
                    	</p>
                    </div>

				</div>
			</form>
		</div>
    	 @endif
    </div>
</div>
<footer id="footer" class="customfooter">
@include('footer')
<script type="text/javascript">
//Distance/Wt./invoice value Calculation
	var Shipment = function(){
		this.invoiceAmt = 0;
		this.weight = 0;
		this.updateInvoiceAmt = function() {
			this.invoiceAmt = 0;
			that = this;
			$('.invoice').each(function(){
				$this = $(this);
				that.invoiceAmt += Number($this.val());
			});
			if($('input[name=package_type]:checked', '#shipment_form').val() == 'identical') {
				that.invoiceAmt = that.invoiceAmt * $("#package_count").val();
			} else {
				that.invoiceAmt = that.invoiceAmt;
			}
			$('.total_invoice').val(this.invoiceAmt);
			$('.total_invoice').text(this.invoiceAmt);
			$('#total_invoice_amt').val(this.invoiceAmt);
		};
		this.updateWeight = function() {
			this.weight = 0;
			that = this;
			$('.package').each(function(){
				$this = $(this);
				var length = Number($this.find('.length').val());
				var height = Number($this.find('.height').val());
				var breadth = Number($this.find('.breadth').val());
				var weight = Number($this.find('.weight').val());
				that.weight += Math.max(Math.ceil((length*breadth*height)/5000),weight);
			});
			if($('input[name=package_type]:checked', '#shipment_form').val() == 'identical') {
				that.weight = that.weight * $("#package_count").val();
			} else {
				that.weight = that.weight;
			}
			$("#total_weight").val(that.weight);
		};
		this.updateVolumetricWeight = function() {
			this.weight = 0;
			that = this;
			this.total_weight = 0;
			$('.package').each(function(){
				$this = $(this);
				var length = Number($this.find('.length').val());
				var height = Number($this.find('.height').val());
				var breadth = Number($this.find('.breadth').val());
				var weight = Number($this.find('.weight').val());
				var volumetric_weight = Math.ceil(length*breadth*height/5000);
				var total = Math.max(volumetric_weight,weight);
				$(this).find('.volumetric_weight').val(volumetric_weight);
				// console.log("hiii",total_weight);
				// //that.total_weight += that.weight*$("#package_count").val();
				// $("#total_weight").val(total_weight);
			});
		};
		this.getWeight = function() {
			this.updateWeight();
			return this.weight;
		};
		this.getInvoiceAmt = function() {
			this.updateInvoiceAmt();
			return this.invoiceAmt;
		};
	};
	$(document).ready(function(){
		// for disabling submit button 
		$("#validate1").prop('disabled',true);
		//For preventing form cancellation
		window.onbeforeunload = function(e) {
			return 'Are you sure?';
		};

		$('[data-toggle="popover"]').popover();
		$('.cost_popover').popover({
		    container: 'body',
		    html: true,
		    content: function () {
		        return $($(this).attr('data-popeerdiv')).html();
		    }
		});
		$('.cost_error_popover').popover({
		    container: 'body',
		    html: true,
		    content: function () {
		        return $($(this).attr('data-popeerdiv')).html();
		    }
		});
		

		$(".package_type").change(function() {
			var package_type = $('input[name=package_type]:checked', '#shipment_form').val();
			if(package_type == "identical") {
				$("#package_content, #submit_btn, #price_section").show();
				$('#package_modal_button').hide();
				$(".is_disable").prop('disabled', false);
				$(".length,.breadth,.height,.weight,.content,.invoice").val('');
				$( "#package_container" ).empty();
			}

			if(package_type == "non_identical") {
				$("#package_content").hide();
				$('#package_modal_button,#submit_btn,#price_section').show();
				$(".is_disable").prop('disabled', true);
				$(".length,.breadth,.height,.weight,.content,.invoice").val('');
				var count = $('#package_count').val();
                $('#package_container').html('');
            	for(var i=1;i<=count;i++) {
            		$('#package_container').append('<div class="form-group"><div class="col-sm-12 package popup_package"><div class="col-sm-2" style="text-align: center;"><select class="form-control weight weight_popup validate_field package_validate"  name="shipment[weight][]"><option value="">Weight</option><option value="1">1</option><option value="2">2</option><option value="3">3</option><option value="4">4</option><option value="5">5</option><option value="6">6</option><option value="7">7</option><option value="8">8</option><option value="9">9</option><option value="10">10</option><option value="11">11</option><option value="12">12</option><option value="13">13</option><option value="14">14</option><option value="15">15</option><option value="16">16</option><option value="17">17</option><option value="18">18</option><option value="19">19</option><option value="20">20</option></select></div><div class="col-sm-1 nopadding" style="text-align: center"><input class="form-control length length_popup package_validate" type="text" name="shipment[length][]" placeholder="L"></div><div class="col-sm-1 nopadding" style="text-align: center"><input class="form-control breadth breadth_popup package_validate" type="text" name="shipment[breadth][]" placeholder="B"></div><div class="col-sm-1 nopadding" style="text-align: center"><input class="form-control height height_popup package_validate" type="text" name="shipment[height][]" placeholder="H"></div><div class="col-sm-1 nopadding" style="padding: 0px;width: 6%;text-align: center;"><p> = </p></div><div class="col-sm-1 nopadding" style="text-align: center"><input class="form-control volumetric_weight" type="text" name="shipment[vwt][]" placeholder="VWT" readonly></div><div class="col-sm-2 nopadding"><input class="form-control content content_popup package_validate" type="text" name="shipment[content][]" style="text-transform:capitalize" placeholder="Content" maxlength="25"><p class="package_validate_error" style="display:none">Please Enter Content</p></div><div class="col-sm-2 nopadding"><input class="form-control invoice invoice_popup package_validate" id="invoice" type="text" name="shipment[value][]" placeholder="Value"></div></div></div>');
            	}	
				$('#package_modal').modal() 
				//$("#package_modal").modal('show');
			}
		});
		
	//Add/Remove New row for multiple package
		// $( "#add_new_package" ).on( "click", function() {
		// 	$('#package_container').append('<div class="form-group"><div class="col-sm-12 package"><div class="col-sm-2" style="text-align: center;"><select class="form-control weight validate_field package_validate"  name="shipment[weight][]" required><option value="">Weight</option><option value="1">1</option><option value="2">2</option><option value="3">3</option><option value="4">4</option><option value="5">5</option><option value="6">6</option><option value="7">7</option><option value="8">8</option><option value="9">9</option><option value="10">10</option><option value="11">11</option><option value="12">12</option><option value="13">13</option><option value="14">14</option><option value="15">15</option><option value="16">16</option><option value="17">17</option><option value="18">18</option><option value="19">19</option><option value="20">20</option></select></div><div class="col-sm-1 nopadding" style="text-align: center"><input class="form-control length package_validate" type="number" min="0" name="shipment[length][]" placeholder="L"></div><div class="col-sm-1 nopadding" style="text-align: center"><input class="form-control breadth package_validate" type="number" min="0" name="shipment[breadth][]" placeholder="B"></div><div class="col-sm-1 nopadding" style="text-align: center"><input class="form-control height package_validate" type="number" min="0" name="shipment[height][]" placeholder="H"></div><div class="col-sm-1 nopadding" style="padding: 0px;width: 6%;text-align: center;"><p> = </p></div><div class="col-sm-1 nopadding" style="text-align: center"><input class="form-control VWT" type="text" min="0" name="shipment[height][]" placeholder="VWT" readonly></div><div class="col-sm-2 nopadding"><input class="form-control content package_validate" type="text" name="shipment[content][]" style="text-transform:capitalize" placeholder="Content" required><p class="package_validate_error" style="display:none">Please Enter Content</p></div><div class="col-sm-2 nopadding"><input class="form-control invoice package_validate" id="invoice" type="number" name="shipment[value][]" min="0" placeholder="Value" required=""></div><div class="col-sm-1 nopadding" style="padding: 0px;text-align: center;"><span class="remove"><button type="button" class="btn btn-danger"><i class="fa fa-times"></i></button></span></div></div></div>');
		// });
		$('.optionBox').on('click','.remove',function() {
		 	$(this).parent().parent().parent().remove();
		 	shipment.updateInvoiceAmt();
		 	shipment.updateWeight();
		});

	//Distance/Wt./invoice value Calculation	
		var shipment = new Shipment();
		shipment.updateInvoiceAmt();
		var $form = $('#shipment_form');
		$form.on('blur', '.invoice' ,function(){
			shipment.updateInvoiceAmt();
		});

		$form.on('blur','.length, .breadth, .height' ,function(){
			shipment.updateVolumetricWeight();
			shipment.updateWeight();
		});

		$form.on('change','.weight , #package_count' ,function(){
			shipment.updateVolumetricWeight();
			shipment.updateInvoiceAmt();
			shipment.updateWeight();
		});

		updateCost = function(callback) {
			// if($('#old_addresses').val()) {
			// 	pickup_address = $('#old_addresses option:selected').text();
			// } else {
			// 	pickup_address = $('#pick_up_address').val() + ' ' + ' ' + $('#pick_up_city').val() + ' ' + $('#pick_up_state').val() + ' ' + $('#pick_up_country').val() + ' ' + $('#pick_up_pin_code').val();
			// }
			// drop_address = $('#delivery_address').val() + ' ' + $('#delivery_landmark').val() + ' ' + $('#delivery_city').val() + ' ' + $('#delivery_state').val() + ' ' + $('#delivery_country').val() + ' ' + $('#delivery_pin_code').val();
			// cc = new CalculateCost(shipment.getWeight(), $("#type").val(), $("#delivery_payment_mode").val(), shipment.getInvoiceAmt(), $("#insurance").val(), pickup_address, drop_address);
			cc = new CalculateCost(shipment.getWeight(), $("#delivery_payment_mode").val(), shipment.getInvoiceAmt(), $("#insurance").val(), $('input[name=delivery_type]:checked', '#shipment_form').val(), $("#start").val(), $("#end").val());
			total_cost_value = cc.getCost(callback);
			//console.log(total_cost_value);
		};

	//For selection of old address
		$( "#old_addresses" ).change(function() {
			var value = $('#old_addresses').val();
			if(value != ""){
				<?php foreach ($addresses as $key => $address) { ?>
				if(value == <?php echo $address->id ?>){
					$('#pick_up_address').val(`<?php echo ($address->address) ?>`);
					$('#pick_up_address_1').val(`<?php echo ($address->address_1) ?>`);
					$('#start').val("<?php echo $address->landmark ?>");
					$('#pick_up_city').val("<?php echo $address->city ?>");
					$('#pick_up_pin_code').val("<?php echo $address->pincode ?>");
					$('#pick_up_state').val("<?php echo $address->state ?>");
				}
				<?php } ?>
				$(".pre_filled").attr("required", false);
				$(".old_addresses").attr("required", true);
				$(".pre_filled").prop('disabled',true);
				$('#pick_up_city').prop('disabled',true);
				//geolocate();
			} else {
				$('#pick_up_address, #pick_up_address_1,#start').val('');
				$('#pick_up_city').val('');
				$('#pick_up_pin_code').val('');
				$('#pick_up_state').val('Maharashtra');
				$(".pre_filled").attr("required", true);
		  		$(".old_addresses").attr("required", false);
		  		$(".pre_filled").prop('disabled',false);
		  		$('#pick_up_city').prop('disabled',false)
			}
		});

	//For Pick Date restriction
		$(function() {
			$( "#datepicker" ).datepicker({ minDate: 0, maxDate: "+1D", dateFormat: 'dd-mm-yy' });
			$( "#datepicker" ).datepicker('setDate', new Date());
		});
	//cookies code to assiged prefilled value 
		function getCookie(name) {
			var re = new RegExp(name + "=([^;]+)");
			var value = re.exec(document.cookie);
			return (value != null) ? unescape(value[1]) : null;
		}
		var a =  document.cookie.split(';');
		var c = '';
		for(var i=1;i<=a.length;i++) {
			c += a[i-1] + "\n";
		}
		sp_invoice = getCookie('invoice');
		sp_height = getCookie('height');
		sp_breadth = getCookie('breadth');
		sp_length = getCookie('length');
		sp_weight = getCookie('weight');
		sp_pay_mode = getCookie('payment_mode');
		sp_start = getCookie('start');
		sp_end = getCookie('end');
		sp_insurance = getCookie('insurance');
		// if (sp_insurance == "1") {
		// 	insurance = '1';
		// } else {
		// 	insurance = '0';
		// }
		$('#invoice').val(sp_invoice);
		$('#breadth').val(sp_breadth);
		$('#length').val(sp_length);
		$('#weight').val(sp_weight);
		$('#height').val(sp_height);
		$('#insurance').val(sp_insurance);
		$('#start').val(sp_start);
		$('#end').val(sp_end);
		$('#delivery_payment_mode').val(sp_pay_mode);

		// FOR SET FLAG LANDMARK CHANGE 
		pickup_flag = false;
		$("#start").change(function(){
			pickup_flag = false;
		})
		delivery_flag  = false;
		$("#end").change(function(){
			delivery_flag = false;
		});
		//console.log(pickup_flag,delivery_flag)
		//VALIDATION OF FORM
		var Validate = function() {
			var anyerror = false;
			$('.validate_error').hide();
			$('.validate').each(function() {
				var servicable_pincode = '<?php echo json_encode($servicable_pincodes); ?>';
				var $this = $(this);
				var id = $this.attr('id');
				var error = false;
				switch(id) {
					case 'pick_up_name' :
						var pattern = /^[A-Za-z ]+$/;
						if(!pattern.test($this.val())) {
							error = true;
						}
						break;
					case 'pick_up_contact_no' :
						var pattern = /^[0-9]{10}$/;
						if(!pattern.test($this.val())) {
							error = true;
						}
						break;

					case 'pick_up_email' :
						var pattern = /^([a-z0-9][a-z0-9_\.]+)@([a-z0-9][a-z0-9\-]+)\.([a-z]{2,})(\.[a-z]{2,})?$/;
						if(!pattern.test($this.val().toLowerCase())) {
							error = true;
						}
						break;
					case 'pick_up_address' :
						//var pattern = /[\'^£$%&*()}{@#~?><>|=_+¬-]/;
						if(!$this.val() && !$('#old_addresses').val()) {
							error = true;
						}
						break;
					case 'pick_up_address_1' :
						//var pattern = /[\'^£$%&*()}{@#~?><>|=_+¬-]/;
						if(!$this.val() && !$('#old_addresses').val()) {
							error = true;
						}
						break;

					case 'start' :
            			var arr = ["Mumbai", "Navi Mumbai", "Thane"];
						//var pattern = /[\'^£$%&*()}{@#~?><>|=_+¬-]/;
						if(!$this.val() && !$('#old_addresses').val() || $.inArray($('#city').val(), arr) < 0 && !$('#old_addresses').val() || !pickup_flag && !$('#old_addresses').val()) {
							error = true;
						}
						break;

					case 'pick_up_city' :
						if(!$this.val() && !$('#old_addresses').val()) {
							error = true;
						}
						break;	

					case 'pick_up_pin_code' :
						var pattern = /^\d{3}\s?\d{3}$/;
						if(servicable_pincode.indexOf($this.val()) <= 0 || !pattern.test($this.val())) {
							error = true;
						}
						break;	
					
					case 'pick_up_state' :
						if(!$this.val() && !$('#old_addresses').val()) {
							error = true;
						}
						break;

					case 'delivery_name' :
						var pattern = /^[A-Za-z ]+$/;
						if(!pattern.test($this.val())) {
							error = true;
						}
						break;
					case 'delivery_contact_no' :
						var pattern = /^[0-9]{10}$/;
						if(!pattern.test($this.val())) {
							error = true;
						}
						break;

					case 'delivery_email' :
						var pattern = /^([a-z0-9][a-z0-9_\.]+)@([a-z0-9][a-z0-9\-]+)\.([a-z]{2,})(\.[a-z]{2,})?$/;
						if(!pattern.test($this.val().toLowerCase())) {
							error = true;
						}
						break;

					case 'delivery_address' :
						//var pattern = /[\'^£$%&*()}{@#~?><>|=_+¬-]/;
						if(!$this.val()) {
							error = true;
						}
						break;

					case 'delivery_address_1' :
						//var pattern = /[\'^£$%&*()}{@#~?><>|=_+¬-]/;
						if(!$this.val()) {
							error = true;
						}
						break;
					case 'end' :
						var arr = ["Mumbai", "Navi Mumbai", "Thane"];
						//var pattern = /[\'^£$%&*()}{@#~?><>|=_+¬-]/;
						if(!$this.val() || !delivery_flag || $.inArray($('#city_to').val(), arr) < 0) {
							error = true;
						}
						break;
					case 'delivery_city' :
						if(!$this.val()) {
							error = true;
						}
						break;	

					case 'delivery_pin_code' :
						var pattern = /^\d{3}\s?\d{3}$/;
						if(servicable_pincode.indexOf($this.val()) <= 0 || !pattern.test($this.val())) {
							error = true;
						}
						break;	
					
					case 'delivery_state' :
						if(!$this.val()) {
							error = true;
						}
						break;
				}
				
				if(error) {
					$('#' + id + '_error').show();
					anyerror = true;
				} else {
					error = false;
				}
			});
			return anyerror;
		};
		var PackageValidate = function(){
			anypackageerror = false;
			$('.package_validate_error').hide();
			$('#length,#breadth,#height,#weight').removeClass('package_error');
			$('.validate_shipment_package').each(function() {
				var $this = $(this);
				var id = $this.attr('id');
				var package_error = false;
				var numreg = /^[0-9.]+$/;
				switch(id) {
					case 'order_id' :
						if($this.val() == '') {
							package_error = true;
						}
						break;
					case 'delivery_payment_mode' :
						if(!$this.val()) {
							package_error = true;
						}
						break;
					case 'insurance' :
						if(!$this.val()) {
							package_error = true;
						}
						break;
					case 'content' :
						if($this.val() == '' && $('input[name=package_type]:checked', '#shipment_form').val() == 'identical') {
							package_error = true;
						}
						break;
					case 'invoice' :
						//var pattern = /^[0-9\.]+$/;
						if($this.val() == 0 || numreg.test($this.val()) === false && $('input[name=package_type]:checked', '#shipment_form').val() == 'identical') {
							package_error = true;
						}
						break;
					case 'weight' :
						if(!$this.val() && $('input[name=package_type]:checked', '#shipment_form').val() == 'identical') {
							$('#weight').addClass('package_error');
							package_error = true;
						}
						break;
					case 'length' :
						if($('input[name=package_type]:checked', '#shipment_form').val() == 'identical') {
							if($('#length').val() || $('#breadth').val() || $('#height').val()) {
								if(numreg.test($this.val()) === false) {
									$('#length').addClass('package_error');
									package_error = true;
								}
							}
						}
						break;
					case 'breadth' :
						if($('input[name=package_type]:checked', '#shipment_form').val() == 'identical') {
							if($('#length').val() || $('#breadth').val() || $('#height').val()) {
								if(numreg.test($this.val()) === false) {
									$('#breadth').addClass('package_error');
									package_error = true;
								}
							}
						}
						break;
					case 'height' :
						if($('input[name=package_type]:checked', '#shipment_form').val() == 'identical') {
							if($('#length').val() || $('#breadth').val() || $('#height').val()) {
								if(numreg.test($this.val()) === false) {
									$('#height').addClass('package_error');
									package_error = true;
								}
							}
						}
						break;

				};
				if(package_error) {
					$('#' + id + '_error').show();
					anypackageerror = true;
				} else {
					package_error = false;
				}
			});
			return anypackageerror;
		};
		var PackageValidatePopup = function(){
			$('.package_validate').removeClass('package_error');
			var error = false;
			$('.content_popup').each(function(){
				if($(this).val() == '' && $('input[name=package_type]:checked', '#shipment_form').val() == 'non_identical') {
					$(this).addClass('package_error');
					error = true;
				}
			});

			if($('input[name=package_type]:checked', '#shipment_form').val() == 'non_identical') {
				$('.popup_package').each(function() {
					var numreg = /^[0-9.]+$/;
					var $this = $(this);
					var $weight = $($this.find('.weight_popup')[0]);
					var $length = $($this.find('.length_popup')[0]);
					var $breadth = $($this.find('.breadth_popup')[0]);
					var $height = $($this.find('.height_popup')[0]);
					$weight.removeClass('package_error');
					$length.removeClass('package_error');
					$breadth.removeClass('package_error');
					$height.removeClass('package_error');
					if($weight.val() == '') {
						$weight.addClass('package_error');
						error = true;
					}

					if($length.val() || $breadth.val() || $height.val()) {
						if(numreg.test($length.val()) === false) {
							$length.addClass('package_error');
							error = true;
						}
						
						if(numreg.test($breadth.val()) === false) {
							$breadth.addClass('package_error');
							error = true;
						}

						if(numreg.test($height.val()) === false) {
							$height.addClass('package_error');
							error = true;
						}
					}
				});
				
			}

			$('.invoice_popup').each(function(){
				var numreg = /^[0-9.]+$/;
				if(numreg.test($(this).val()) === false && $('input[name=package_type]:checked', '#shipment_form').val() == 'non_identical') {
					$(this).addClass('package_error');
					error = true;
				}
			});
			if(!error) {
				$('#package_modal').modal('hide');
				//$('#package_modal_button').show();
				$('#price_section').show();
			}
			return error;
		};

		$("#validate2").click(function(){
			var package_validate_popup = new PackageValidatePopup();
		});
		//For Animation
		animate_second_time = 1;
		$(".second").blur(function() {
			var id = $(this).attr('id');
			if(id == 'delivery_pin_code' || animate_second_time > 1) {
				var validate = Validate();
				animate_second_time++;
				if(!validate) {
				   	$('#address_1').animate({
				       width:"58.33%"
				     },1500, function() {
				       $("#address_1").removeClass('col-md-12');
				       $("#address_1").addClass('col-md-7');
				       $('#address_2').fadeIn();
				     });
				}
			}
		});

		$(".second").click(function() {
			if(animate_second_time > 1) {
				$('#address_2').hide();
			   	$('#address_1').animate({
			       width:"100%"
			     },700, function() {
			       $("#address_2").addClass('col-md-7');
			       $("#address_2").removeClass('col-md-12');
			       $('#address_1').fadeIn();
			     });
			}
		});
		//End Animation

		//For calculating Cost
		$('#calculate_cost').click(function () {
			var validate = Validate();
			var package_validate = PackageValidate();
			var package_validate_popup = PackageValidatePopup();
			if(package_validate_popup && $('input[name=package_type]:checked', '#shipment_form').val() == 'non_identical') {
				$('#package_modal').modal();
			}
			if(!package_validate && (!package_validate_popup || jQuery.isEmptyObject(package_validate_popup)) && !validate) {
				values_change_flag = false;
				//console.log(values_change_flag,'oncost');
				//For enabling Submit Button
				$("#validate1").prop('disabled',false);
				//For Delivery Type
				delivery_type = $('input[name=delivery_type]:checked', '#shipment_form').val();
				updateCost(function(total_cost_value, distance) {
					//totalCost = total_cost_value;
					cost_object = total_cost_value;
					$('#fhd').prop('disabled',false);
					$('#sdd').prop('disabled',false);
					$('#ndd').prop('disabled',false);
					var deliveryTypes = ['fhd', 'sdd', 'ndd'];
					var error_msg_flag = false;
					for(index in deliveryTypes) {
						deliveryType = deliveryTypes[index];
						if(total_cost_value[deliveryType]) {
							$('#'+deliveryType).prop('disabled',false);
			        		$('#'+deliveryType+'_cost').text('Rs. '+total_cost_value[deliveryType].toFixed()+ '.00');
			        		$('#'+deliveryType+'_info_error_button').hide();
			        		$('#'+deliveryType+'_info_button').show();
						} else {
							$('#'+deliveryType).prop('disabled',true);
			        		$('#'+deliveryType).prop('checked', false);
			        		$('#'+deliveryType+'_cost').text('N/A');
			        		$('#'+deliveryType+'_info_error_button').show();
			        		$('#'+deliveryType+'_info_button').hide();
			        		error_msg_flag = true;
						}
					}
					if(error_msg_flag) {
						$('#service_NA').show();
					} else {
						$('#service_NA').hide();
					}
	        		$('#price_span').text(total_cost_value[delivery_type]);
				    // Submit Button show and hide
					if($("#price_span").is(':empty') || $("#price_span").text()== 0) {
						//$("#validate1").show();
						//$("#validate1").prop('disabled',true);
					} else {
						//$("#validate1").show();
						//$("#validate1").prop('disabled',false);
					}
				});
			} 
		});
		
		$(".delivery_type").change(function() {
			if(cost_object) {
				$('.total_cost').val((cost_object[$(this).val()]).toFixed());
				$('#shipping_fee').val(eval(cost_object[$(this).val()+'_shipping_fees']));
				$('#insurance_fee').val(cost_object.insurance_cost);
				$('#payment_mode_charge').val(cost_object.payment_mode_charge);
				$('#distance').val(cost_object.total_distance);
				//console.log(cost_object);
			}
		});
		//For Detecting OnChange event
		values_change_flag = false;
		$(".onchange").change( function() {
			values_change_flag = true;
			//console.log(values_change_flag,'change');
		});
		
		//Form Submition
		$( "#shipment_form" ).submit(function() {
			//For preventing form cancellation
			window.onbeforeunload = function(e) {};
			//For Detecting change in field
			if(values_change_flag) {
				alert('You have altered some values. So Please click on Calculate cost Button.');
				return false;
			} else {
				var invoiceAmt = $('.total_invoice').val();
				if(invoiceAmt > 20000) {
					alert("Invoice amount is more than 20k. Any invoice amount above 20k will be accepted by Card on Delivery. Kindly confirm with Buyer to keep his card ready.");		
				}
				//$('#shipment_form').submit();
				return true;
			}
		});

});
$(document).ready(function(){
    $('[data-toggle="tooltip"]').tooltip();
});
</script>
@endsection