@extends('app')

@section('content')
<div class="container-fluid">
	<div class="row">
		@if (session('status'))
			<div class="alert alert-success">
				{{ session('status') }}
			</div>
		@endif

		@if (count($errors) > 0)
			<div class="alert alert-danger">
				<strong>Whoops!</strong> There were some problems with your input.<br><br>
				<ul>
					@foreach ($errors->all() as $error)
						<li>{{ $error }}</li>
					@endforeach
				</ul>
			</div>
		@endif
		@if(Session::has('error'))
            <div class="alert alert-danger">
                {{ Session::get('error') }}
            </div>
		@endif
		<!-- Gaurav new file for making forgot password for email -->
		<div class="col-md-4 col-md-offset-4 col-sm-8 col-sm-offset-2">
			<div class="panel panel-default" style="border-color: #337ab7;">
				<div class="panel-heading" style="background:#337ab7;font-weight: bold;">RESET PASSWORD</div>
				<div class="panel-body">

					<form class="form-horizontal" role="form" method="POST" action="forgotpassword">
						<input type="hidden" name="_token" value="{{ csrf_token() }}">

						<div class="form-group">
							<label class="col-md-4 control-label">E-Mail Address</label>
							<div class="col-md-6">
								<input type="email" class="form-control" name="email" value="{{ old('email') }}">
							</div>
						</div>

						<div class="form-group">
							<div class="col-md-6 col-md-offset-4">
								<button type="submit" class="btn btn-primary" style="background-color:#ff6600;border-color:#ff6600;">
									Submit
								</button>&nbsp;&nbsp;
								<a href="{{ url('client/loginpage') }}">Sign In</a>
								<!-- <a href="client/loginpage">Sign In</a> --> 
							</div>
						</div>
					</form>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection