@extends('app')

@section('content')
<div class="container">
    <h1 class="page-head-line">MANAGE STATUS</h1>

    @if(session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
    @endif

    <a href="{{ route('statuses.create') }}" class="btn btn-primary mb-3">Add New Status</a>
    <br>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>ID</th>
                <th>Status Name</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($statuses as $status)
            <tr>
                <td>{{ $status->id }}</td>
                <td>{{ $status->NAME }}</td>



                <td>
                    <form action="{{ route('statuses.toggle', $status->id) }}" method="POST" style="display:inline;">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}" />

                        <input type="hidden" name="_method" value="PATCH" />

                        @if ($status->STATUS)
                        <button class="btn btn-sm btn-success" title="Click to disable">Active</button>
                        @else
                        <button class="btn btn-sm btn-secondary" title="Click to enable">Inactive</button>
                        @endif
                    </form>
                </td>
                <!-- <td>
                    <a href="{{ route('statuses.edit', $status->id) }}" class="btn btn-sm btn-info">Edit</a>

                    <form action="{{ route('statuses.destroy', $status->id) }}" method="POST" style="display:inline-block;">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                        <input name="_method" value="DELETE" type="hidden">
                        <button class="btn btn-sm btn-danger" onclick="return confirm('Delete this status?')">Delete</button>
                    </form>
                </td> -->

             <td>
    <?php
        $protectedStatuses = ['New', 'Completed', 'Closed'];
    ?>

    @if (!in_array($status->NAME, $protectedStatuses))
        <a href="{{ route('statuses.edit', $status->id) }}" class="btn btn-sm btn-info">Edit</a>

        <form action="{{ route('statuses.destroy', $status->id) }}" method="POST" style="display:inline-block;">
            <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                        <input name="_method" value="DELETE" type="hidden">
            <button class="btn btn-sm btn-danger" onclick="return confirm('Delete this status?')">Delete</button>
        </form>
    @else
        <span class="text-muted">Primary Status</span>
    @endif
</td>
            </tr>
            @endforeach

            @if($statuses->isEmpty())
            <tr>
                <td colspan="4" class="text-center">No statuses found.</td>
            </tr>
            @endif
        </tbody>
    </table>
</div>
@endsection