@extends('app')

@section('content')
    <div class="container">
        {{-- <h4>Service Type List</h4> --}}
        <h1 class="page-head-line">Manage Service Type</h1>

        @if (session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        <a href="{{ route('service-types.create') }}" class="btn btn-primary mb-3">Add New Service Type</a>

        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Service Type</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @forelse ($serviceTypes as $type)
                    <tr>
                        <td>{{ $type->serial }}</td> {{-- Shows 1, 2, 3... instead of DB ID --}}
                        <td>{{ $type->service_type }}</td>
                        <td>
                            <form action="{{ route('service-types.toggle', $type->id) }}" method="POST">
                                <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                                <input type="hidden" name="_method" value="PATCH" />
                                <button class="btn btn-sm {{ $type->status ? 'btn-success' : 'btn-secondary' }}">
                                    {{ $type->status ? 'Active' : 'Inactive' }}
                                </button>
                            </form>
                        </td>

                        <td>
                            <?php
                            $protectedStatuses = ['AMC Visiting', 'New Installation',];
                            ?>

                            @if (!in_array($type->service_type, $protectedStatuses))
                                <a href="{{ route('service-types.edit', $type->id) }}" class="btn btn-sm btn-info">Edit</a>

                            <form action="{{ route('service-types.destroy', $type->id) }}" method="POST"
                                style="display:inline-block;">
                                <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                                <input name="_method" value="DELETE" type="hidden">
                                <button class="btn btn-sm btn-danger"
                                    onclick="return confirm('Delete this item?')">Delete</button>
                            </form>
                            @else
                                <span class="text-muted">Primary Status</span>
                            @endif
                        </td>
                        {{-- <td>
                            <a href="{{ route('service-types.edit', $type->id) }}" class="btn btn-sm btn-info">Edit</a>

                            <form action="{{ route('service-types.destroy', $type->id) }}" method="POST"
                                style="display:inline-block;">
                                <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                                <input name="_method" value="DELETE" type="hidden">
                                <button class="btn btn-sm btn-danger"
                                    onclick="return confirm('Delete this item?')">Delete</button>
                            </form>
                        </td> --}}
                    </tr>
                @empty
                    <tr>
                        <td colspan="4" class="text-center">No service types found.</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>
@endsection
