@extends('app')

@section('content')
<title>Service Status Report</title>

<div class="content-wrapper">
  <div class="container-fluid">
    <!-- <div class="row">
      <div class="col-md-12">
        <h1 class="page-head-line">Service Status Report</h1>
      </div>
     -->

    <div style="display: flex; justify-content: space-between; align-items: center; width: 100%; margin-bottom: 10px; border-bottom: 2px solid orange; padding-bottom: 10px; margin-top: 20px;">
      <h1 style="margin: 0; font-size: 20px; font-weight: bold;">Service Status Report</h1>

      <a href="{{ request()->url() }}?{{ http_build_query(array_merge(request()->query(), ['export' => 'csv'])) }}" class="btn" style="margin-left: auto; color: #fff; background-color: #337ab7 !important ; border-color: #2e6da4;">
        DOWNLOAD EXCEL <i class="fa fa-download" style="margin-left: 5px;"></i>
      </a>
    </div>
    <div class="row">
      <div class="col-md-12">
        <div class="div-table-content">
          <table class="table table-striped table-bordered" id="content_table">
            <thead>
              <tr>
                <th style="width: 100px;">Date</th>
                <th style="width: 200px;">Ticket Raised By</th>
                <th style="width: 150px;">Ticket Type</th>
                <th>Client</th>
                <th>Product</th>
                <th style="width: 200px;">Assignee</th>
                <th>Status</th>
                <th style="width: 100px;">Dates</th>
                <th style="width: 200px;">Remarks</th>
                <th style="width: 100px;">Target Date</th>
              </tr>
            </thead>
<tbody>
    @forelse($data as $row)
        <?php
            $statuses = $row->status ?? [];
            $dates = $row->dates ?? [];
            $remarks = $row->remark ?? [];
            $targets = $row->target_date ?? [];
            $count = max(count($statuses), count($dates), count($remarks), count($targets));
        ?>

        @for ($i = 0; $i < $count; $i++)
            <tr>
                <?php if ($i === 0): ?>
                    <td>{{ \Carbon\Carbon::parse($row->date)->format('d-m-Y') }}</td>
                    <td>{{ $row->raised_by }}</td>
                    <td>{{ $row->ticket_type }}</td>
                    <td>{{ $row->client }}</td>
                    <td>{{ $row->product ?: '(empty)' }}</td>
                    <td>{{ $row->assignee ?? '-' }}</td>
                <?php else: ?>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                <?php endif; ?>

<td>{{ $statuses[$i] ?? '-' }}</td>
<td>{{ $dates[$i] ?? '-' }}</td>

                <td>{{ $remarks[$i] ?? '-' }}</td>
                <td>{{ $targets[$i] ?? '-' }}</td>
            </tr>
        @endfor
    @empty
        <tr>
            <td colspan="10" class="text-center">No data available</td>
        </tr>
    @endforelse
</tbody>

          </table>

 {!! $data !!}

          
        </div>
      </div>
    </div>
  </div>
</div>
<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">

<style>
  #content_table td:nth-child(9),
  #content_table th:nth-child(9),
  #content_table td:nth-child(10),
  #content_table th:nth-child(10) {
    white-space: pre-wrap;
    word-wrap: break-word;
  }
</style>

@endsection