@extends('app')
@section('content')
<title><?php echo $technicianname;?> Rating Chart</title>
<script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/1.8.2/jquery.min.js"></script>
<script type="text/javascript">
$(function () {
    Highcharts.chart('container', {
        title: {
            text: 'Rating Chart',
            x: -20 //center
        },
        subtitle: {
            text: '',
            x: -20
        },
        xAxis: {
            categories: [<?php echo $string; ?>]
        },
        yAxis: {
		    min: 0,
            max: 5,
            title: {
                text: ''
            },
            plotLines: [{
                value: 0,
                width: 1,
                color: '#808080'
            }]
        },
        tooltip: {
            valueSuffix: ''
        },
        legend: {
            layout: 'vertical',
            align: 'right',
            verticalAlign: 'middle',
            borderWidth: 0
        },
        series: [{
            name: 'Company Rating',
            data: [<?php echo $stringy; ?>]
        }, {
            name: 'Technician Rating',
            data: [<?php echo $stringz; ?>]
        }]
    });
});
		</script>
	</head>
	<body>
<script src="https://code.highcharts.com/highcharts.js"></script>
<script src="https://code.highcharts.com/modules/exporting.js"></script>

<div class="content-wrapper">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h1 class="page-head-line"><?php echo $technicianname;?> Rating Chart</h1>

                </div>
           	</div>
            <div class="row">
            	<div class="col-md-12">
            		<div class="panel panel-default">
                        <div class="panel-body">
						
						<div id="container" style="min-width: 310px; height: 400px; margin: 0 auto"></div>

						</div>
					</div>
				</div>
			</div>
		</div>
</div>
@endsection