<head>
<meta name="csrf-token" content="{{ csrf_token() }}">
</head>
<!-- Attractive Chatbot Widget HTML & CSS -->
<style>
#chatbot-widget {
  position: fixed;
  bottom: 32px;
  right: 32px;
  z-index: 9999;
  font-family: 'Segoe UI', 'Arial', sans-serif;
}
#chatbot-toggle {
  background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
  color: #fff;
  border: none;
  border-radius: 50%;
  width: 64px;
  height: 64px;
  font-size: 32px;
  cursor: pointer;
  box-shadow: 0 8px 24px rgba(80,60,200,0.25);
  display: flex;
  align-items: center;
  justify-content: center;
  transition: box-shadow 0.2s, transform 0.2s;
}
#chatbot-toggle:hover {
  box-shadow: 0 12px 32px rgba(80,60,200,0.30);
  transform: scale(1.08);
}
#chatbot-window {
  display: none;
  position: absolute;
  bottom: 80px;
  right: 0;
  width: 350px;
  max-height: 500px;
  background: #fff;
  border-radius: 18px 18px 8px 18px;
  box-shadow: 0 12px 36px rgba(80,60,200,0.20);
  overflow: hidden;
  flex-direction: column;
  border: 1.5px solid #e3e6f0;
  animation: chatbot-pop 0.3s;
}
@keyframes chatbot-pop {
  0% { transform: scale(0.8); opacity: 0; }
  100% { transform: scale(1); opacity: 1; }
}
#chatbot-header {
  background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
  color: #fff;
  padding: 16px 20px;
  font-weight: bold;
  text-align: left;
  font-size: 20px;
  letter-spacing: 1px;
  display: flex;
  align-items: center;
  justify-content: space-between;
}
#chatbot-header .close-btn {
  background: none;
  border: none;
  color: #fff;
  font-size: 20px;
  cursor: pointer;
  opacity: 0.7;
  transition: opacity 0.2s;
}
#chatbot-header .close-btn:hover {
  opacity: 1;
}
#chatbot-messages {
  padding: 16px 14px 12px 14px;
  height: 270px;
  overflow-y: auto;
  background: #f5f7fa;
  font-size: 15px;
  display: flex;
  flex-direction: column;
  gap: 10px;
}
.chatbot-msg {
  max-width: 80%;
  padding: 10px 16px;
  border-radius: 18px 18px 18px 4px;
  margin-bottom: 2px;
  background: #e3e6f0;
  color: #333;
  align-self: flex-start;
  box-shadow: 0 2px 8px rgba(80,60,200,0.05);
}
.chatbot-msg.user {
  background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
  color: #fff;
  align-self: flex-end;
  border-radius: 18px 18px 4px 18px;
}
#chatbot-input-area {
  display: flex;
  border-top: 1px solid #e3e6f0;
  background: #f5f7fa;
  padding: 10px 12px;
}
#chatbot-input {
  flex: 1;
  border: none;
  padding: 10px 16px;
  font-size: 15px;
  border-radius: 20px;
  outline: none;
  background: #fff;
  margin-right: 8px;
  box-shadow: 0 1px 2px rgba(80,60,200,0.06);
}
#chatbot-send {
  background: linear-gradient(135deg, #6a11cb 0%, #2575fc 100%);
  color: #fff;
  border: none;
  padding: 0 20px;
  border-radius: 20px;
  cursor: pointer;
  font-size: 16px;
  box-shadow: 0 2px 6px rgba(80,60,200,0.08);
  transition: background 0.2s;
}
#chatbot-send:hover {
  background: linear-gradient(135deg, #2575fc 0%, #6a11cb 100%);
}
</style>
<div id="chatbot-widget">
  <button id="chatbot-toggle">💬</button>
  <div id="chatbot-window">
    <div id="chatbot-header">
      <span>AI ChatBot</span>
      <button class="close-btn" onclick="document.getElementById('chatbot-window').style.display='none'">×</button>
    </div>
    <div id="chatbot-messages"></div>
    <div id="chatbot-prequestions" style="padding: 0 14px 10px 14px; display: flex; flex-wrap: wrap; gap: 8px 8px;">
      <!-- <button class="pre-question-btn">How many technicians are there?</button>
      <button class="pre-question-btn">How many services are there for today?</button>
      <button class="pre-question-btn">What is services?</button>
      <button class="pre-question-btn">What is technician?</button> -->
    </div>
    <div id="chatbot-input-area">
      <input type="text" id="chatbot-input" placeholder="Type a message..." autocomplete="off"/>
      <button id="chatbot-send">Send</button>
    </div>
  </div>
</div>
