@extends('app')

@section('content')
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #f2f4f7;
      /* padding: 30px; */
    }

    h2 {
      text-align: center;
      color: #2c3e50;
    }

    .form-container {
      background: #ffffff;
      padding: 25px;
      border-radius: 10px;
      max-width: 1000px;
      margin: auto;
      box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }

    .form-row {
      display: flex;
      flex-wrap: wrap;
      gap: 20px;
      margin-bottom: 20px;
    }

    .form-group {
      flex: 1 1 200px;
    }

    label {
      display: block;
      font-weight: bold;
      margin-bottom: 5px;
      color: #333;
    }

    select, input {
      width: 100%;
      padding: 10px;
      border: 1px solid #ccc;
      border-radius: 6px;
    }

    button {
      padding: 10px 20px;
      margin-top: 10px;
      background-color: #007bff;
      color: white;
      border: none;
      border-radius: 6px;
      font-weight: bold;
      cursor: pointer;
    }

    button:hover {
      background-color: #0056b3;
    }

    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 25px;
    }

    th, td {
      border: 1px solid #ddd;
      padding: 10px 12px;
      text-align: center;
    }

    th {
      background-color: #34495e;
      color: white;
    }

    tr:nth-child(even) {
      background-color: #f9f9f9;
    }

    .btn-row {
      text-align: center;
      margin-top: 20px;
    }
  </style>

  <h2>Generate Serial NO.</h2>

  <div class="form-container">
<form id="generateForm" method="POST" action="{{ route('product.serialStore') }}">
  

                      <input type="hidden" name="_token" value="{{ csrf_token() }}" />

      <div class="form-row">
        <div class="form-group">
          <label for="brand">Brand</label>
          <select id="brand" name="brand">
            <option value="">Select Brand</option>
            <option>Samsung</option>
            <option>Apple</option>
            <option>Realme</option>
          </select>
        </div>

               <div class="form-group">
          <label for="product">Product</label>
          <select id="product" name="product" required>
            <option value="">Select Product</option>
            @foreach($products as $product)
              <option value="{{ $product->product_name }}">{{ $product->product_name }} / {{ $product->product_code }}</option>
            @endforeach
          </select>
        </div>

        <div class="form-group">
          <label for="startSerial">Start Serial No</label>
          <input type="number" id="startSerial" name="startSerial" placeholder="e.g. 1001">
        </div>

        <div class="form-group">
          <label for="endSerial">End Serial No</label>
          <input type="number" id="endSerial" name="endSerial" placeholder="e.g. 1010">
        </div>
      </div>

      <div class="btn-row">
        <button type="button" onclick="generateTable()">Generate Table</button>
        <button type="submit">Save</button>
      </div>

      <div id="tableContainer"></div>
    </form>
  </div>

  <script>
    function generateTable() {
      const brand = document.getElementById("brand").value;
      const product = document.getElementById("product").value;
      const startSerial = parseInt(document.getElementById("startSerial").value);
      const endSerial = parseInt(document.getElementById("endSerial").value);
      const tableContainer = document.getElementById("tableContainer");

      if (!brand || !product || isNaN(startSerial) || isNaN(endSerial) || startSerial > endSerial) {
        alert("Please fill all fields correctly.");
        return;
      }

      let tableHTML = `
        <table>
          <thead>
            <tr>
              <th>Brand</th>
              <th>Product</th>
              <th>Serial No</th>
              <th>IMEI No</th>
              <th>Location</th>
            </tr>
          </thead>
          <tbody>
      `;

      for (let sn = startSerial; sn <= endSerial; sn++) {
        tableHTML += `
 <tr>
            <td>${brand}<input type="hidden" name="entries[${sn}][brand]" value="${brand}"></td>
            <td>${product}<input type="hidden" name="entries[${sn}][product]" value="${product}"></td>
            <td>${sn}<input type="hidden" name="entries[${sn}][serial]" value="${sn}"></td>
            <td><input type="text" name="entries[${sn}][imei]" placeholder="Enter IMEI No"  /></td>
            <td>
              <select name="entries[${sn}][location]" >
                <option value="">Select Location</option>
                <option>Dahisar </option>
                <option>Borivali </option> 
                <option>Kandivali </option>
                <option>Malad </option>
                <option>Goregaon </option>
                <option>Jogeshwari </option>
                <option>Andheri </option>
                <option>Bandra </option>
                <option>Dadar </option>
                <option>Churchgate  </option>
              </select>
            </td>
          </tr>

        `;
      }

      tableHTML += `</tbody></table>`;
      tableContainer.innerHTML = tableHTML;
    }

    // document.getElementById('generateForm').addEventListener('submit', function(e) {
    //   e.preventDefault();

    //   fetch("{{ route('product.serialStore') }}", {
    //     method: "POST",
    //     headers: {
    //       'Content-Type': 'application/json',
    //       'X-CSRF-TOKEN': '{{ csrf_token() }}'
    //     },
    //     body: JSON.stringify(Object.fromEntries(new FormData(this)))
    //   })
    //   .then(response => response.json())
    //   .then(data => alert(data.message))
    //   .catch(err => alert("Error saving data!"));
    // });
  </script>
@endsection
