@extends('app')

@section('content')
<div class="container mt-4">
    <h1 class="page-head-line">Edit Serial Entries </h1> 

  <form method="POST" action="{{ url('/product/serial-entry/update/' . $entry->id) }}">
 <input type="hidden" name="_token" value="{{ csrf_token() }}" />
    <div class="row" style="margin: 20px;">
      <div class="col-md-4">
        <label for="brand">Brand</label>
        <select name="brand" class="form-control" required>
          <option value="">Select Brand</option>
          <option value="Samsung" {{ $entry->brand == 'Samsung' ? 'selected' : '' }}>Samsung</option>
          <option value="Apple" {{ $entry->brand == 'Apple' ? 'selected' : '' }}>Apple</option>
          <option value="Realme" {{ $entry->brand == 'Realme' ? 'selected' : '' }}>Realme</option>
        </select>
      </div>

    <div class="col-md-4">
        <label for="product">Product</label>
        <select name="product" class="form-control" required>
            <option value="">Select Product</option>
            @foreach($products as $product)
                <option value="{{ $product->product_name }}"
                    {{ $entry->product == $product->product_name ? 'selected' : '' }}>
                    {{ $product->product_name }} / {{ $product->product_code }}
                </option>
            @endforeach
        </select>
    </div>


      <div class="col-md-4">
        <label for="serial_no">Serial No</label>
        <input type="text" name="serial_no" class="form-control" value="{{ $entry->serial_no }}" required>
      </div>
    </div>

    <div class="row" style="margin: 20px;">
      <div class="col-md-4 p-2">
        <label for="imei_no">IMEI No</label>
        <input type="text" name="imei_no" class="form-control" value="{{ $entry->imei_no }}" required>
      </div>

      <div class="col-md-4 p-2" >
        <label for="location">Location</label>
        <select name="location" class="form-control" required>
          <option value="">Select Location</option>
          <option value="Dahisar" {{ $entry->location == 'Dahisar' ? 'selected' : '' }}>Dahisar</option>
          <option value="Borivali" {{ $entry->location == 'Borivali' ? 'selected' : '' }}>Borivali</option>
          <option value="Kandivali" {{ $entry->location == 'Kandivali' ? 'selected' : '' }}>Kandivali</option>
          <option value="Malad" {{ $entry->location == 'Malad' ? 'selected' : '' }}>Malad</option>
          <option value="Goregaon" {{ $entry->location == 'Goregaon' ? 'selected' : '' }}>Goregaon</option>
          <option value="Jogeshwari" {{ $entry->location == 'Jogeshwari' ? 'selected' : '' }}>Jogeshwari</option>
          <option value="Andheri" {{ $entry->location == 'Andheri' ? 'selected' : '' }}>Andheri</option>
          <option value="Bandra" {{ $entry->location == 'Bandra' ? 'selected' : '' }}>Bandra</option>
          <option value="Dadar" {{ $entry->location == 'Dadar' ? 'selected' : '' }}>Dadar</option>
          <option value="Churchgate" {{ $entry->location == 'Churchgate' ? 'selected' : '' }}>Churchgate</option>
          
        </select>
      </div>
      
    </div>


                                    <div class = "col-md-12">
                                    <div class="form-group">
                                        <div class="col-md-6 col-sm-6 col-xs-12 col-md-offset-5">
                                            <button type="submit" class="btn btn-success">Update</button>                     
                                            <a href="{{ route('product.serialEntryList') }} " class="btn btn-primary">Cancel</a>
                                        </div>  
                                    </div>
                                </div>
  </form>
</div>
@endsection

