@extends('app')
@section('content')
    <div class="container">
        <h1 class="page-head-line">MANAGE WARRANTY</h1>


        <a href="{{ route('warranties.create') }}" class="btn btn-success">Add Warranty</a>


        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Client</th>
                    <th>Product</th>
                    <th>Warranty Period</th>
                    <th>Part Replacement Period</th>
                    <th>Notes</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($warranties as $warranty)
                    <tr>
                        {{-- <td>{{ $warranty->client->company_name ?? '--' }}</td> --}}
                        <td>
                            @if ($warranty->client_name)
                                {{-- {{ $warranty->client_name }} --}}
                                {{ $warranty->vname }} / {{ $warranty->client_name }}
                            @else
                                <span class="text-danger">Client Not Found (ID: {{ $warranty->client_id }})</span>
                            @endif
                        </td>

                        
                        <td>{{ $warranty->product_name ?? '--' }}</td>
                        <td>{{ $warranty->warranty_start_date }} → {{ $warranty->warranty_end_date }}</td>
                        <td>{{ $warranty->part_replacement_start_date ?? '-' }} →
                            {{ $warranty->part_replacement_end_date ?? '-' }}</td>
                        <td>{{ $warranty->notes }}</td>
                        <td>
                            <a href="{{ route('warranties.edit', $warranty->id) }}" class="btn btn-sm btn-primary">Edit</a>
                            <form action="{{ route('warranties.destroy', $warranty->id) }}" method="POST"
                                style="display:inline-block;"
                                onsubmit="return confirm('Are you sure you want to delete this warranty?');">
                                <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                                <input name="_method" value="DELETE" type="hidden">
                                <button type="submit" class="btn btn-sm btn-danger">Delete</button>
                            </form>
                        </td>

                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

@endsection
