@extends('app')

@section('content')
<div class="container">
    <h4 class="page-head-line">Edit Warranty</h4>

    <form method="POST" action="{{ route('warranties.update', $warranty->id) }}">
       <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                   <input type="hidden" name="_method" value="PUT" />

        {{-- Client Dropdown --}}

        
                                <div class="col-md-6">
        <div class="form-group">
            <label for="client_id">Client</label>
            <select name="client_id" class="form-control" required>
                @foreach($clients as $client)
                    <option value="{{ $client->id }}" {{ $warranty->client_id == $client->id ? 'selected' : '' }}>
                        {{ $client->company_name }}
                    </option>
                @endforeach
            </select>
        </div>
        </div>
                                <div class="col-md-6">

        {{-- Product Dropdown --}}
        <div class="form-group">
            <label for="product_id">Product</label>
            <select name="product_id" class="form-control" required>
                @foreach($products as $product)
                    <option value="{{ $product->id }}" {{ $warranty->product_id == $product->id ? 'selected' : '' }}>
                        {{ $product->product_name }}
                    </option>
                @endforeach
            </select>
        </div>
        </div>
                                <div class="col-md-6">

        {{-- Warranty Dates --}}
        <div class="form-group">
            <label for="warranty_start_date">Warranty Start Date</label>
            <input type="date" name="warranty_start_date" class="form-control" required
                   value="{{ old('warranty_start_date', $warranty->warranty_start_date) }}">
        </div>
        </div>
                                <div class="col-md-6">

        <div class="form-group">
            <label for="warranty_end_date">Warranty End Date</label>
            <input type="date" name="warranty_end_date" class="form-control" required
                   value="{{ old('warranty_end_date', $warranty->warranty_end_date) }}">
        </div>
        </div>
                                <div class="col-md-6">

        {{-- Part Replacement Dates --}}
        <div class="form-group">
            <label for="part_replacement_start_date">Part Replacement Start Date</label>
            <input type="date" name="part_replacement_start_date" class="form-control"
                   value="{{ old('part_replacement_start_date', $warranty->part_replacement_start_date) }}">
        </div>
        </div>
                                <div class="col-md-6">

        <div class="form-group">
            <label for="part_replacement_end_date">Part Replacement End Date</label>
            <input type="date" name="part_replacement_end_date" class="form-control"
                   value="{{ old('part_replacement_end_date', $warranty->part_replacement_end_date) }}">
        </div>
        </div>
                                <div class="col-md-6">

        {{-- Notes --}}
        <div class="form-group">
            <label for="notes">Notes</label>
            <textarea name="notes" class="form-control">{{ old('notes', $warranty->notes) }}</textarea>
        </div>
        </div>
                               

        {{-- Submit --}}
        <button type="submit" class="btn btn-primary">Update Warranty</button>
    </form>
</div>
@endsection
