@extends('app')
@section('content')
    <title>Create warranties</title>
    <style type="text/css">
        .control-label {
            text-align: left !important;
        }

        .imagePreview {
            width: 50px;
            height: 50px;
            background-position: center center;
            background-size: cover;
            -webkit-box-shadow: 0 0 1px 1px rgba(0, 0, 0, .3);
            display: inline-block;
        }
    </style>
    <div class="content-wrapper">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h1 class="page-head-line">ADD warranties</h1>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="panel panel-default">
                        <div class="panel-body">
                            @if ($errors->any())
                                <div class="alert alert-danger">
                                    @foreach ($errors->all() as $error)
                                        <p>{{ $error == 'Please Select Vendor.' ? 'Please Select Client' : $error }}</p>
                                    @endforeach
                                </div>
                            @endif
                            <form method="POST"
                                action="{{ isset($warranty) ? route('warranties.update', $warranty->id) : route('warranties.store') }}">
                                <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                                @if (isset($warranty))
                                    @method('PUT')
                                @endif





                                <div class="col-md-6">

                                    <div class="form-group">
                                        <label class="control-label col-md-4 col-sm-3 col-xs-12">Select Client <span
                                                style="color:#FF0000"> *</span>
                                        </label>
                                        <select name="client_id" class="form-control" required>
                                            @foreach ($clients as $client)
                                                <option value="{{ $client->id }}"
                                                    {{ isset($warranty) && $warranty->client_id == $client->id ? 'selected' : '' }}>
                                                    {{ $client->name }} / {{ $client->company_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Product</label>
                                        <select name="product_id" class="form-control" required>
                                            @foreach ($products as $product)
                                                <option value="{{ $product->id }}"
                                                    {{ isset($warranty) && $warranty->product_id == $product->id ? 'selected' : '' }}>
                                                    {{ $product->product_name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">

                                    <div class="form-group">
                                        <label>Warranty Start Date</label>
                                        <input type="date" name="warranty_start_date"
                                            value="{{ old('warranty_start_date', $warranty->warranty_start_date ?? '') }}"
                                            class="form-control" required>
                                    </div>
                                </div>
                                <div class="col-md-6">

                                    <div class="form-group">
                                        <label>Warranty End Date</label>
                                        <input type="date" name="warranty_end_date"
                                            value="{{ old('warranty_end_date', $warranty->warranty_end_date ?? '') }}"
                                            class="form-control" required>
                                    </div>
                                </div>
                                <div class="col-md-6">

                                    <div class="form-group">
                                        <label>Part Replacement Start Date</label>
                                        <input type="date" name="part_replacement_start_date"
                                            value="{{ old('part_replacement_start_date', $warranty->part_replacement_start_date ?? '') }}"
                                            class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-6">

                                    <div class="form-group">
                                        <label>Part Replacement End Date</label>
                                        <input type="date" name="part_replacement_end_date"
                                            value="{{ old('part_replacement_end_date', $warranty->part_replacement_end_date ?? '') }}"
                                            class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-6">

                                    <div class="form-group">
                                        <label>Notes</label>
                                        <textarea name="notes" class="form-control">{{ old('notes', $warranty->notes ?? '') }}</textarea>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-success">{{ isset($warranty) ? 'Update' : 'Add' }}
                                    Warranty</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script type="text/javascript">
        function formsubmit() {
            $("#submit").submit();
            document.getElementById("save_reading").disabled = true;

        }
    </script>
    <!--
            <script>
                $(document).ready(function() {
                    $('#joining_date').datetimepicker({

                        //changeYear: true,
                        defaultDate: new Date(),
                        pickTime: false
                    });
                    $('#end_date').datetimepicker({
                        defaultDate: new Date(),
                        pickTime: false
                    });
                });
            </script>
            -->
    <script>
        $(document).ready(function() {
            $('#joining_date').datepicker({
                changeYear: true
            });
        });
    </script>
@endsection
