@extends('app')
@section('content')
<title>Create Client</title>
<style type="text/css">
	.control-label {
	    text-align: left !important;
	}
</style>
<div class="content-wrapper">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h1 class="page-head-line">BULK IMPORT CLIENT</h1>
            </div>
        </div>
        @if(Session::has('flash_message'))
    		<div class="alert alert-success">
        		{{ Session::get('flash_message') }}
    		</div>
		@endif
        <div class="row">
           	<div class="col-md-12">
            	<div class="panel panel-default">
                    <div class="panel-body">
						@if($errors->any())
							<div class="alert alert-danger">
							    @foreach($errors->all() as $error)
							        <p>{{ $error }}</p>
							    @endforeach
							</div>
						@endif

						<form class="form-horizontal" id="submit" role="form" method="POST" action="{{ route('vendormultipleaddresses.import') }}"  enctype="multipart/form-data">
							<input type="hidden" name="_token" value="{{ csrf_token() }}">
							<div class="col-md-6">
								<div class="form-group">
									<div class="col-md-8">
                <input type='file' name='csv_file' required>
									
					<div id="csv-info-message" style="margin-top: 10px; color: #c0392b; font-size: 14px;"></div>


									</div>
								</div>
							</div>
							<div class="col-md-6">
								<div class="form-group">
                    <a href="{{ route('vendormultipleaddresses.import.sample') }}" download>Download Sample CSV</a>

								</div>
							</div>	
							<div class="col-md-6">
								<div class="form-group">
										
								</div>
							</div>
							<div class="form-group">
		                        <div class="col-md-6 col-sm-6 col-xs-12 col-md-offset-5">
		                            <button type="submit" class="btn btn-success" id="client_submit_import"  onclick="formsubmit()">Submit</button>
		                            <a href="{{ route('vendormultipleaddresses.index')}}" class="btn btn-primary">Cancel</a>
		                        </div>
				            </div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<script type="text/javascript">
function formsubmit()
{
	$("#submit").submit();
	document.getElementById("client_submit_import").disabled = true;
}
</script>
<script type="text/javascript">
document.addEventListener("DOMContentLoaded", function() {
    const message = `
        <strong>Important:</strong> Please ensure your CSV file follows the required format:<br>
        <ul style="padding-left: 16px; margin-top: 5px;">
            <li><strong>client_type</strong> must be one of the following: <em>Supplier, Normal Client, Warranty client, Out of warranty client, AMC Client, Call basis client</em>.</li>
            <li><strong>status</strong> must be one of: <em>Active, Inactive, Hold</em>.</li>
            <li><strong>service_provider</strong> must match an existing company name listed under <em>Manage Company</em>.</li>
        </ul>
    `;
    document.getElementById("csv-info-message").innerHTML = message;
});
</script>
{{-- <script type="text/javascript">
document.addEventListener("DOMContentLoaded", function () {
    const message = `
        <strong>Important:</strong> Please ensure your CSV file follows the required format:<br>
        <ul style="padding-left: 16px; margin-top: 5px;">
            <li><strong>client_type</strong> must be one of the following: <em>Supplier, Normal Client, Warranty client, Out of warranty client, AMC Client, Call basis client</em>.</li>
            <li><strong>status</strong> must be one of: <em>Active, Inactive, Hold</em>.</li>
            <li>
                <strong>service_provider</strong> must match an existing company name listed under 
                <em>Manage Company</em> — 
                <a href="{{ route('serviceprovider.index') }}" target="_blank">Go to Company Name List</a>.
            </li>
        </ul>
    `;
    document.getElementById("csv-info-message").innerHTML = message;
});
</script> --}}

@endsection
{{-- resources/views/vendor/bulkimport.blade.php --}}