@extends('app')
@section('content')
<title>Edit Client</title>
<style type="text/css">
	.control-label {
	    text-align: left !important;
	}
</style>
<div class="content-wrapper">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h1 class="page-head-line">EDIT CLIENT</h1>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-default">
                    <div class="panel-body">
                        @if($errors->any())
                            <div class="alert alert-danger">
                                @foreach($errors->all() as $error)
                                    <p>{{ $error }}</p>
                                @endforeach
                            </div>
                        @endif

                        <form class="form-horizontal" role="form" id="submit" method="POST" action="{{ route('vendormultiplevendors.update', $vendor->id) }}" enctype="multipart/form-data">
                            <input type="hidden" name="_token" value="{{ csrf_token() }}">
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-4 control-label">Company Name</label>
                                    <div class="col-md-8">
                                        <input type="text" class="form-control" name="company_name" id="company_name" value="{{ old('company_name', $vendor->company_name) }}" style="text-transform:capitalize" placeholder="Enter Company Name">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-4 control-label">Name <span style="color:#FF0000"> *</span></label>
                                    <div class="col-md-8">
                                        <input type="text" class="form-control" id="i_name" name="name" value="{{ old('name', $vendor->name) }}" style="text-transform:capitalize" placeholder="Enter Name">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-4 control-label">Email <span style="color:#FF0000"> *</span></label>
                                    <div class="col-md-8">
                                        <input type="text" class="form-control" id="id_email" name="email" value="{{ old('email', $vendor->email) }}" placeholder="Enter Email">
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-4 control-label">Project</label>
                                    <div class="col-md-8">
                                        <input type="text" class="form-control" name="project" id="project" value="{{ old('project', $vendor->project ?? '') }}" placeholder="Enter Project Name">
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-4 control-label">Website URL</label>
                                    <div class="col-md-8">
                                        <input type="text" class="form-control" id="id_url" name="url" value="{{ old('url', $vendor->url) }}" placeholder="Enter Website URL">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-4 control-label">Mobile No 1 <span style="color:#FF0000"> *</span></label>
                                    <div class="col-md-8">
                                        <input type="text" class="form-control" id="mobile_no" name="mobile_no" value="{{ old('mobile_no', $vendor->mobile_no) }}" maxlength="10" placeholder="Enter Mobile Number">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-4 control-label">Mobile No 2</label>
                                    <div class="col-md-8">
                                        <input type="text" class="form-control" id="mobile_no2" name="mobile_no2" value="{{ old('mobile_no2', $vendor->mobile_no2) }}" maxlength="10" placeholder="Enter Mobile Number">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-4 control-label">Land-line No</label>
                                    <div class="col-md-8">
                                        <input type="text" class="form-control" name="landline_no" id="landline_no" value="{{ old('landline_no', $vendor->landline_no) }}" placeholder="Enter Landline Number">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-4 control-label">Client Type <span style="color:#FF0000"> *</span></label>
                                    <div class="col-md-8">
                                        <select name="client_type" id="client_type" class="form-control">
                                            <option value="" disabled>Please Select</option>
                                            <option value="S" {{ old('client_type', $vendor->client_type) == "S" ? 'selected' : '' }}>Supplier</option>
                                            <option value="C" {{ old('client_type', $vendor->client_type) == "C" ? 'selected' : '' }}>Normal Client</option>
                                            <option value="W" {{ old('client_type', $vendor->client_type) == "W" ? 'selected' : '' }}>Warranty client</option>
                                            <option value="O" {{ old('client_type', $vendor->client_type) == "O" ? 'selected' : '' }}>Out of warranty client</option>
                                            <option value="A" {{ old('client_type', $vendor->client_type) == "A" ? 'selected' : '' }}>AMC Client</option>
                                            <option value="B" {{ old('client_type', $vendor->client_type) == "B" ? 'selected' : '' }}>Call basis clientnow</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="col-md-4 control-label">Status <span style="color:#FF0000"> *</span></label>
                                    <div class="col-md-8">
                                        <select name="status" id="status" class="form-control">
                                            <option value="">Please Select</option>
                                            <option value="Active" {{ old('status', $vendor->status) == "Active" ? 'selected' : '' }}>Active</option>
                                            <option value="Hold" {{ old('status', $vendor->status) == "Hold" ? 'selected' : '' }}>Hold</option>
                                            <option value="In Active" {{ old('status', $vendor->status) == "In Active" ? 'selected' : '' }}>Inactive</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            @if($serviceenable_value == 1)
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="col-md-4 control-label">Select Service Provider <span style="color:#FF0000"> *</span></label>
                                        <div class="col-md-8">
                                            <select class="form-control" name="service_provider_id" id="service_id">
                                                <option value="">Please Select</option>
                                                @foreach($service_pros as $service_pro)
                                                    <option value="{{ $service_pro->id }}" {{ old('service_provider_id', $vendor->service_provider_id) == $service_pro->id ? 'selected' : '' }}>{{ $service_pro->company_name }}</option>
                                                @endforeach
                                            </select>
                                            @if($errors->first('service_provider_id'))
                                                <div class="error alert alert-danger">{{ $errors->first('service_provider_id') }}</div>
                                            @endif
                                        </div>
                                        <div><br><label id="show_in_amc"></label></div>
                                    </div>
                                </div>
                            @endif
                            <div class="form-group">
                                <div class="col-md-6 col-sm-6 col-xs-12 col-md-offset-5">
                                    <button type="submit" class="btn btn-success" id="client_submit" onclick="formsubmit()">Update</button>
                                    <a href="{{ route('vendormultipleaddresses.index') }}" class="btn btn-primary">Cancel</a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
function formsubmit() {
    $("#submit").submit();
    document.getElementById("client_submit").disabled = true;
}
</script>
@endsection