@extends('app')
@section('content')
<title>Edit Substation</title>
<style type="text/css">
    .control-label {
        text-align: left !important;
    }
</style>
<div class="content-wrapper">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h1 class="page-head-line">EDIT SUBSTATION</h1>
                </div>
           	</div>
            <div class="row">
            	<div class="col-md-12">
            		<div class="panel panel-default">
                        <div class="panel-body">
					@if($errors->any())
					    <div class="alert alert-danger">
					        @foreach($errors->all() as $error)
					            <p>{{ $error }}</p>
					        @endforeach
					    </div>
					@endif
					<form class="form-horizontal" role="form" method="POST" action="{{ route('substation.update', $substation->id) }}" enctype="multipart/form-data">
						<input type="hidden" name="_token" value="{{ csrf_token() }}" />
						<input type="hidden" name="_method" value="PUT" />
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4 col-sm-3 col-xs-12">Name <span style="color:#FF0000"> *</span></label>
                                <div class="col-md-8 col-sm-6 col-xs-12">
                                   <input type="text" class="form-control" name="name" value="{{ $substation->name }}" style="text-transform:capitalize">
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4 col-sm-3 col-xs-12">Mobile <span style="color:#FF0000"> *</span></label>
                                <div class="col-md-8 col-sm-6 col-xs-12">
                                   <input type="text" class="form-control" name="mobile" value="{{ $substation->mobile }}" maxlength="10">
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4 col-sm-3 col-xs-12">Address Line 1 <span style="color:#FF0000"> *</span></label>
                                <div class="col-md-8 col-sm-6 col-xs-12">
                                    <!-- <input type="text" class="form-control" name="address" value="{{ $substation->address }}" style="text-transform:capitalize"> -->
                                    <textarea class="form-control" name="address" rows="2" style="text-transform:capitalize" maxlength="35"> {{$substation->address}} </textarea>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4 col-sm-3 col-xs-12">Address Line 2 </label>
                                <div class="col-md-8 col-sm-6 col-xs-12">
                                    <!-- <input type="text" class="form-control" name="address" value="{{ old('address') }}"> -->
                                    <textarea class="form-control" name="address1" rows="2" style="text-transform:capitalize" maxlength="35">{{$substation->address1}}</textarea>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="col-md-4 control-label">Landmark <span style="color:#FF0000"> *</span></label>
                                <div class="col-md-8">
                                    <input type="text" class="form-control" name="landmark" value="{{ $substation->landmark }}" style="text-transform:capitalize" id="start" onfocus="geolocate()" autocomplete="off">
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4 col-sm-3 col-xs-12">City <span style="color:#FF0000"> *</span></label>
                                <div class="col-md-8 col-sm-6 col-xs-12">
                                    <!-- <input type="text" class="form-control" name="city" value="{{ $substation->city }}" style="text-transform:capitalize"> -->
                                    <select value="" name="city" class="form-control">
                                        <option value="Mumbai" <?php if($substation == 'Mumbai'){ echo ' selected="selected"'; } ?>>Mumbai</option>
                                        <option value="Navi Mumbai" <?php if($substation == 'Navi Mumbai'){ echo ' selected="selected"'; } ?>>Navi Mumbai</option>
                                        <option value="Thane" <?php if($substation == 'Thane'){ echo ' selected="selected"'; } ?>>Thane</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                       <!--  <div class="form-group">
                            <label class="control-label col-md-4 col-sm-3 col-xs-12">State</label>
                            <div class="col-md-8 col-sm-6 col-xs-12">
                                <input type="text" class="form-control" name="state" value="{{ $substation->state }}" style="text-transform:capitalize">
                            </div>
                        </div> -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4 col-sm-3 col-xs-12">State <span style="color:#FF0000"> *</span></label>
                                <div class="col-md-8 col-sm-6 col-xs-12">
                                    <select name="state" class="form-control">
                                        <option value="">Please Select</option>
                                        @foreach($states as $state)
                                           @if($state->name == $substation->state)
                                                <option value="{{ $state->name }}" selected="selected">{{ $state->name }}</option>
                                            @else
                                                <option value="{{ $state->name }}">{{ $state->name }}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4 col-sm-3 col-xs-12">Pin code <span style="color:#FF0000"> *</span></label>
                                <div class="col-md-8 col-sm-6 col-xs-12">
                                    <input type="text" maxlength="6" class="form-control" name="pincode" value="{{ $substation->pincode }}">
                                </div>
                            </div>
                        </div>
                        <!-- <div class="form-group">
                            <label class="control-label col-md-4 col-sm-3 col-xs-12">Sector</label>
                            <div class="col-md-8 col-sm-6 col-xs-12">
                                <input type="text" class="form-control" name="sector" value="{{ $substation->sector }}" style="text-transform:capitalize">
                            </div>
                        </div> -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4 col-sm-3 col-xs-12">SubStation Manager <span style="color:#FF0000"> *</span></label>
                                <div class="col-md-8 col-sm-6 col-xs-12">
                                    <select name="substation_manager" class="form-control">
                                       <option value="">Select</option>
                                       <?php //echo '<pre>'; print_r($substation); exit; ?>
                                       @foreach ($users as $user)
                                        @if ($user->id == $substation->user_id)
                                            <option value="{{ $user->id }}" selected='selected'>{{ $user->first_name }} {{ $user->last_name }}</option>
                                        @else
                                            <option value="{{ $user->id }}">{{ $user->first_name }} {{ $user->last_name }}</option>
                                        @endif
                                       @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label col-md-4 col-sm-3 col-xs-12">Substation Pin code <span style="color:#FF0000"> *</span></label>
                                <div class="col-md-8 col-sm-6 col-xs-12">
                                    <textarea class="form-control" id="txtdesc" title="please use comma after 6 digit" name="substation_pincode">{{ $substation->substation_pincode }}</textarea>
                                    <span class="text-muted">Multiple Pin code can be added in comma separated format.</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <div class="col-md-6 col-sm-6 col-xs-12 col-md-offset-5">
                                    <button type="submit" id="btnValidate" class="btn btn-success">Submit</button>
                                    <a href="{{ route('substation.index')}}" class="btn btn-primary">Cancel</a>
                                </div>
                            </div>
                        </div>
                    </form>
				</div>
			</div>
		</div>
	</div>
</div>
</div>
<script type="text/javascript">
// $(function() {
// $('#btnValidate').click(function() {
// var txt = $('#txtdesc').val();
// var re = /^([,]*\d{6})+[,]*$/
// if (re.test(txt)) {
// }
// else {
// alert('Please enter valid pin code and use comma after for pin code separation');
// return false;
// }
// })
// })
</script>
@endsection