@extends('app')
@section('content')
<title>Add Substation</title>
<style type="text/css">
	.control-label {
	    text-align: left !important;
	}
</style>
<div class="content-wrapper">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h2 class="page-head-line">ADD SUBSTATION</h2>
                </div>
           	</div>
            <div class="row">
            	<div class="col-md-12">
            		<div class="panel panel-default">
                        <div class="panel-body">
                        	<?php //echo '<pre>'; print_r($errors); exit; ?>
							@if($errors->any())
							    <div class="alert alert-danger">
							        @foreach($errors->all() as $error)
							            <p>{{ $error }}</p>
							        @endforeach
							    </div>
							@endif
									<form class="form-horizontal" role="form" method="POST" action="/substation">
										<input type="hidden" name="_token" value="{{{ csrf_token() }}}" />
										<div class="col-md-6">				    
											<div class="form-group">
					                            <label class="control-label col-md-4 col-sm-3 col-xs-12">Name <span style="color:#FF0000"> *</span></label>
					                            <div class="col-md-8 col-sm-6 col-xs-12" >
					                               <input type="text" class="form-control" name="name"  value="{{ old('name') }}" style="text-transform:capitalize">
					                            </div>
					                        </div>
					                    </div>

					                    <div class="col-md-6">
					                        <div class="form-group">
					                            <label class="control-label col-md-4 col-sm-3 col-xs-12">Mobile <span style="color:#FF0000"> *</span></label>
					                            <div class="col-md-8 col-sm-6 col-xs-12">
					                               <input type="text" class="form-control" name="mobile" value="{{ old('mobile') }}" maxlength="10">
					                            </div>
					                        </div>
					                    </div>

					                    <div class="col-md-6">
					                        <div class="form-group">
					                            <label class="control-label col-md-4 col-sm-3 col-xs-12">Address Line 1 <span style="color:#FF0000"> *</span></label>
					                            <div class="col-md-8 col-sm-6 col-xs-12">
					                                <!-- <input type="text" class="form-control" name="address" value="{{ old('address') }}"> -->
					                                <textarea class="form-control" name="address" rows="2" style="text-transform:capitalize" maxlength="35">{{  old('address') }}</textarea>
					                            </div>
					                        </div>
					                    </div>

					                    <div class="col-md-6">
					                        <div class="form-group">
					                            <label class="control-label col-md-4 col-sm-3 col-xs-12">Address Line 2 </label>
					                            <div class="col-md-8 col-sm-6 col-xs-12">
					                                <!-- <input type="text" class="form-control" name="address" value="{{ old('address') }}"> -->
					                                <textarea class="form-control" name="address1" rows="2" style="text-transform:capitalize" maxlength="35">{{  old('address1') }}</textarea>
					                            </div>
					                        </div>
					                    </div>

					                    <div class="col-md-6">
											<div class="form-group">
												<label class="col-md-4 control-label">Landmark <span style="color:#FF0000"> *</span></label>
												<div class="col-md-8">
													<input type="text" class="form-control" name="landmark" value="{{ old('landmark') }}" style="text-transform:capitalize" id="start" onfocus="geolocate()" autocomplete="off">
												</div>
											</div>
										</div>

					                    <div class="col-md-6">
					                        <div class="form-group">
					                            <label class="control-label col-md-4 col-sm-3 col-xs-12">City <span style="color:#FF0000"> *</span></label>
					                            <div class="col-md-8 col-sm-6 col-xs-12">
					                                
					                            	<select name="city" class="form-control">
					                            		<option value="">Please Select</option>
					                            		<option value="Mumbai" {{ old('city') == "Mumbai" ? 'selected="selected"' : '' }}>Mumbai</option>
					                            		<option value="Navi Mumbai" {{ old('city') == "Navi Mumbai" ? 'selected="selected"' : '' }}>Navi Mumbai</option>
					                            		<option value="Thane" {{ old('city') == "Thane" ? 'selected="selected"' : '' }}>Thane</option>
					                            	</select>
					                            </div>
					                        </div>
					                    </div>
				                        <!-- <div class="form-group">
				                            <label class="control-label col-md-4 col-sm-3 col-xs-12">State</label>
				                            <div class="col-md-8 col-sm-6 col-xs-12">
				                                <input type="text" class="form-control" name="state" style="text-transform:capitalize">
				                            </div>
				                        </div> -->
				                        <div class="col-md-6">
					                        <div class="form-group">
			                                    <label class="control-label col-md-4 col-sm-3 col-xs-12">State <span style="color:#FF0000"> *</span></label>
			                                    <div class="col-md-8 col-sm-6 col-xs-12">
			                                        <select name="state" class="form-control">
			                                            <option value="">Please Select</option>
			                                            @foreach($states as $state)
			                                                <!-- <option value="{{ $state->name }}" {{ old('state') == "$state->name" ? 'selected="selected"' : '' }}>{{ $state->name }}</option> -->
			                                                @if($state->name == "Maharashtra")
				                                                <option value="{{ $state->name }}" selected="selected">{{ $state->name }}</option>
				                                            @else
				                                            	<option value="{{ $state->name }}">{{ $state->name }}</option>
				                                            @endif
			                                            @endforeach
			                                        </select>
			                                    </div>
			                                </div>
			                            </div>

			                            <div class="col-md-6">
					                        <div class="form-group">
					                            <label class="control-label col-md-4 col-sm-3 col-xs-12">Pin code <span style="color:#FF0000"> *</span></label>
					                            <div class="col-md-8 col-sm-6 col-xs-12">
					                                <input type="text" class="form-control" value="{{ old('pincode') }}" name="pincode" maxlength="6">
					                            </div>
					                        </div>
					                    </div>
				                        <!-- <div class="form-group">
				                            <label class="control-label col-md-4 col-sm-3 col-xs-12">Sector <span style="color:#FF0000"> *</span></label>
				                            <div class="col-md-8 col-sm-6 col-xs-12">
				                                <input type="text" class="form-control" name="sector"  value="{{ old('sector') }}" style="text-transform:capitalize">
				                            </div>
				                        </div> -->
				                        <div class="col-md-6">
				                        	<div class="form-group">
					                            <label class="control-label col-md-4 col-sm-3 col-xs-12" style="padding-right: 0px;">SubStation Manager <span style="color:#FF0000"> *</span></label>
					                            <div class="col-md-8 col-sm-6 col-xs-12">
					                            	<select name="substation_manager" class="form-control">
					                            	   <option value="">Select</option>
						                               @foreach ($users as $user)
						                               		<option value="{{ $user->id }}" {{ ($user->id == old('substation_manager')) ? 'selected="selected"' : '' }}>{{ $user->first_name }} {{ $user->last_name }}</option>
						                               @endforeach
						                            </select>
					                            </div>
				                        	</div>
				                        </div>
				                        <div class="col-md-6">
				                        	<div class="form-group">
					                            <label class="control-label col-md-4 col-sm-3 col-xs-12">Substation Pin code <span style="color:#FF0000"> *</span></label>
					                            <div class="col-md-8 col-sm-6 col-xs-12">
					                                <textarea class="form-control" id="txtdesc" title="please use comma after 6 digit" name="substation_pincode">{{ old('substation_pincode') }}</textarea>
					                                <span class="text-muted">Multiple Pin code can be added in comma separated format.</span>
					                            </div>
				                        	</div>
				                        </div>

				                        <div class="col-md-12">
					                        <div class="form-group">
					                            <div class="col-md-6 col-sm-6 col-xs-12 col-md-offset-5">
					                                <button type="submit"  id="btnValidate" class="btn btn-success">Submit</button>
					                                <a href="{{ route('substation.index')}}" class="btn btn-primary">Cancel</a>
					                            </div>
					                        </div>
					                    </div>
									</form>
					</div>
			</div>
		</div>
	</div>
</div>
</div>
<script type="text/javascript">
// $(function() {
// $('#btnValidate').click(function() {
// var txt = $('#txtdesc').val();
// var re = /^([,]*\d{6})+[,]*$/;
// if (re.test(txt)) {
// }
// else {
// alert('Please enter correct pincode and use comma after for pincode separation');
// return false;
// }
// })
// })
</script>
@endsection