@extends('app')
@section('content')
<title>Bank Deposit</title>
<style type="text/css">
label {
	text-align: left !important;
}
/* For fixed table thead */
table {
    table-layout:fixed;
}

.div-table-content {
  max-height: 310px;
  overflow-y:auto;
}
.scorll {
  width: 98.5%;
  margin-bottom: 0px;
  border-bottom: none !important;
}
</style>

<div class="content-wrapper">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                	<?php 
			              if( !count($_GET) ) { 
			                  $url_parameter = '?report=1';
			              } else {
			                  $url_parameter = $_SERVER['REQUEST_URI'].'&report=1';
			              }
			        ?>
			        <a href="<?php echo $url_parameter; ?>" data-toggle="tooltip" title="" class="btn btn-primary" data-original-title="Download Exel" style="float:right;margin-right:2%;margin-top:1%"><i class="fa fa-download"></i></a>
                    <h2 class="page-head-line">Bank Deposit</h2>
                </div>
           	</div>
            <div class="row">
				<div class="col-md-2" style="background-color: #7DBDD2;border-radius: 5px;">
				 <form class="form-horizontal" role="form" method="GET" action="/bankdeposit">
					<div class="col-md-12" style="padding:0px;margin-top: 15px;">
						<label class="col-md-12 control-label" style="padding:0px;">Collection Start Date: </label>
						<div class="input-group date">
							<input type="text" id="report_start_date" name="start_date" value="<?php if(isset($_GET['start_date'])) { echo $_GET['start_date']; } ?>" data-format="DD-MM-YYYY" class="form-control">
							<span class="input-group-btn">
							<button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
							</span>
						</div>
					</div>
					<div class="col-md-12" style="padding:0px;margin-top: 15px;">
						<label class="col-md-12 control-label" style="padding:0px;">Collection End Date: </label>
						<div class="input-group date">
							<input type="text" id="report_end_date" name="end_date" value="<?php if(isset($_GET['end_date'])) { echo $_GET['end_date']; } ?>" data-format="DD-MM-YYYY" class="form-control">
							<span class="input-group-btn">
							<button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
							</span>
						</div>
					</div>
					<label class="col-md-12 control-label" style="padding:0px; margin-top: 15px;">Biker : </label>
					<div class="col-md-12" style="padding:0px">
					    <p><span id="tags-input" class="selectivity-input" name="bikers_list" id="bikers_list" style="width:100%;font-size: 11px;"></span></p>
					    <textarea name="bikers_id" id="bikers_id" style="display:none;"></textarea>
					</div>

					<label class="col-md-12 control-label" style="padding:0px;margin-top: 0px;">Bank Ref No. : </label>
		               <?php 
		                  if(isset($_GET['bank_ref_no'])) { 
		                      $bank_ref_no = $_GET['bank_ref_no'];
		                  } else {
		                     $bank_ref_no ="";
		                  } 
		              ?>
		              <div class="col-md-12" style="padding:0px">
		                <input type="text" class="form-control" name="bank_ref_no" value="<?php echo $bank_ref_no; ?>">
		              </div>

		              <label class="col-md-12 control-label" style="padding:0px;margin-top: 15px;">Collection Mode : </label>
		              	<div class="col-md-12" style="padding:0px">
		              	<select name="collection_mode" class="form-control">
		              		<option value="">Please Select</option>
		              		<option value="cash" <?php if(!empty($_GET['collection_mode'])) if($_GET['collection_mode'] == 'cash') echo "selected = 'selected'" ?>>Cash</option>
		              		<option value="card" <?php if(!empty($_GET['collection_mode'])) if($_GET['collection_mode'] == 'card') echo "selected = 'selected'" ?>>Card</option>
		              	</select>
		              	</div>
		              @if(empty(Session::has('sub_station_id')))
			              <label class="col-md-12 control-label" style="padding:0px;margin-top: 15px;">Choose Substation: </label>
			              <div class="col-md-12" style="padding:0px">
				                <select name="substation_list" id="substation_list" class="form-control">
		                            <option value="">Please Select</option>
		                            @foreach($substation_list as $substation)
		                                <option value="{{ $substation->id }}" <?php if(!empty($_GET['substation_list'])) if($_GET['substation_list'] == $substation->id) echo "selected = 'selected'" ?>>{{ $substation->name }} {{ ($substation->deleted_at == NULL) ? '' : '(deleted)' }}</option>
		                            @endforeach
		                        </select>
			              </div>
			           @endif

					<div class="col-md-12" style="margin-top: 5%;text-align: center;margin-bottom: 5%;">
						<button type="submit" class="btn btn-success" id="bank_cod_form_submit"><i class="fa fa-search"></i>Search</button>
					</div>
				 </form>
				</div>
				<form class="form-horizontal" role="form" method="POST" action="bank_cod_deposit">
					<input type="hidden" name="_token" value="{{{ csrf_token() }}}" />
			    	<div class="col-md-10">
			    		@if(Session::has('success'))
						    <div class="alert alert-success">
						        {{ Session::get('success') }}
						    </div>
						@endif
						@if(Session::has('sub_station_id'))
				    		<div class="col-md-12">
				    			<div class="col-md-3" style="padding-left:0px">
				    				<div class="form-group">
				    					<div class="col-md-12" style="padding-left:0px">
		                                	<input type="text" class="form-control" name="amount" id="amount" readonly required placeholder="amount">
				    					</div>
		                            </div>
				    			</div>
				    			<div class="col-md-3">
				    				<div class="form-group">
				    					<div class="col-md-12">
		                                	<input type="text" class="form-control" name="bank_transaction_no" id="bank_transaction_no" placeholder="Enter Bank Transaction No." required>
				    					</div>
		                            </div>
				    			</div>
				    			<div class="col-md-3">
				    				<div class="form-group">
				    					<div class="col-md-12">
			                                <div class="input-group date_cod">
			                                  <input type="text" name="datetime" data-format="DD-MM-YYYY HH:mm:ss" class="form-control" readonly="" required>
			                                  <span class="input-group-btn">
			                                  <button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
			                                  </span>
			                                </div>
				    					</div>
		                            </div>
				    			</div>
				    			<div class="col-md-3">
				    				<input type="submit" class="btn btn-success" id="bank_cod_amt" value="Save COD Amount"/>
				    			</div>
				    			<p style="font-size:12px;clear:both;margin-left: -1%;">Please select the checkbox to update Amount box.</p>
			    			</div>
				    	@endif
							<table class="table table-striped table-bordered scorll" id="header_table" >
									<thead>
										<tr>
											<th style="width:3%;"><input type="checkbox" onclick="$('input[name*=\'selected\']').prop('checked', this.checked).change();"/> </th>
											<th style="width:22%;">AWB No.</th>
											<th>Shipment Date</th>
											<th>Collection Date</th>
											<th>Biker</th>
											<th>Amount</th>
											<th>Collection Mode</th>
											<th>Bank Ref No.</th>
											<th>Deposited Date</th>
										</tr>
									</thead>
							</table>
							<div class="div-table-content">
							<table  class="table table-striped table-bordered" id="content_table">
								<tbody>
									<?php $total_amount = 0;?>
									@if($collected)
										@foreach($collected as $collection)
										<?php $total_amount = $total_amount + $collection->amount;?>
											<tr>
												<td style="width:3%;">
													<?php 
														if(!$collection->bank_ref_id && $collection->payment_mode == 'cash') {
															echo '<input type="checkbox" name="selected[]" class="selected" value="'.$collection->shipment_table_id.'" data-amount="'.$collection->amount.'" /></td>';
														}
													 ?>
												<td style="width:22%;">{{ $collection->awb_no }}</td>
												<td>{{ (new DateTime($collection->order_time))->format('d-m-Y') }}</td>
												<td>{{ (new DateTime($collection->date))->format('d-m-Y') }}</td>
												<td>{{ $collection->first_name }} {{ $collection->last_name }}</td>
												<td>{{ ($collection->amount == NULL) ? number_format('0',2) : number_format($collection->amount,2) }}</td>
												<td>{{ ucwords($collection->payment_mode) }}</td>
												<td>{{ ($collection->bank_ref_id) ? $collection->bank_ref_id : '-' }}</td>
												<td>{{ ($collection->deposited_date == NULL) ? '-' : (new DateTime($collection->deposited_date))->format('d-m-Y') }}</td>
											</tr>
										@endforeach
										<tr>
											<td colspan="4"></td>
											<td style="text-align:right;font-weight:bold">Total: </td>
											<td>{{ number_format($total_amount,2) }}</td>
									@else 
										<tr>
											<td colspan="7" style="text-align:center;">No records found</td>
										</tr>
									@endif

								</tbody>
							</table>
						</div>
						<?php echo $collected->appends($_GET)->render(); ?>
			    	</div>
			    </form>
            </div>
        </div>
</div>
<!-- Bikers Auto list js -->
<link href="/assets/autocomplete/selectivity-full.css" rel="stylesheet">
<script src="/assets/autocomplete/zepto.js"></script>
<script src="/assets/autocomplete/selectivity-full.js"></script>
<script type="text/javascript">
    $(document).ready(function(){
    	//for hiding check for super admin
    	<?php if(Session::has('sub_station_id')) { ?>
    		$('.selected').show();
    	<?php } else { ?>
    		$('.selected').hide();
    	<?php } ?>
    	//For Pre selected Date
    	$("#report_start_date").datetimepicker({
	      <?php if(!isset($_GET['start_date'])) { ?>
	        defaultDate: new Date()
	      <?php } ?>
	     });
	     $("#report_end_date").datetimepicker({
	      <?php if(!isset($_GET['end_date'])) { ?>
	        defaultDate: new Date()
	      <?php } ?>
	      });
		// Bikers Auto List 
		$('#tags-input').selectivity({
		  items: [<?php foreach ($bikers as $key => $biker) { ?>{id: <?php echo $biker->id; ?>, text:"<?php echo $biker->first_name.' '.$biker->last_name ?>"}, <?php } ?>],
		  multiple: true,
		});
		<?php
	      if(!empty($_GET['bikers_id'])){
	        $selected = explode(',', $_GET['bikers_id']);
	        foreach ($selected as $value) { ?>
	          $('#tags-input').selectivity('add', <?php echo $value; ?>);
	      <?php } } ?>
		$('#bank_cod_amt').click(function () {
			var total= $('input.selected:checked').length;
			if(total <= 0) {
				alert("Please select at least one shipment.");
				return false;
			}
		});
		$('#bank_cod_form_submit').click(function () {
			var data = $('.selectivity-input').selectivity('data');
			var bikers_id = [];
			for (var i = 0; i < data.length; i++) {
			 	bikers_id[i] = data[i].id;
			};
			$('#bikers_id').val(bikers_id.toString());
		});
		$(".selected").change(function() {
			total_amount = 0.0;
			$('.selected').each(function () {
			       val = (this.checked ? $(this).attr('data-amount') : "");
			       total_amount = (+total_amount) + (+val);
			  });
			$('#amount').val(total_amount);
		});
 		 $("#content_table").width($("#header_table").width());
    });
</script>

@endsection