@extends('app')

@section('content')
<div class="container">
    <h4 class="page-head-line">Edit Status</h4>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('statuses.update', $status->id) }}" method="POST">
       <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                   <input type="hidden" name="_method" value="PUT" />

        <div class="form-group">
            <label>Status Name</label>
            <input type="text" name="name" class="form-control" value="{{ old('name', $status->NAME) }}" required>
        </div>

        {{-- <div class="form-group">
            <label>Status</label>
            <select name="status" class="form-control" required>
                <option value="1" {{ old('status', $status->status) == 1 ? 'selected' : '' }}>Active</option>
                <option value="0" {{ old('status', $status->status) == 0 ? 'selected' : '' }}>Inactive</option>
            </select>
        </div> --}}

        <button type="submit" class="btn btn-primary">Update</button>
        <a href="{{ route('statuses.index') }}" class="btn btn-secondary">Cancel</a>
    </form>
</div>
@endsection
