@extends('app')
@section('content')
<title>Create Service</title>

<link rel="stylesheet" href="//code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">
<link rel="stylesheet" href="/resources/demos/style.css">
<script src="https://code.jquery.com/jquery-1.12.4.js"></script>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>

<link rel="stylesheet" type="text/css"
    href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.37/css/bootstrap-datetimepicker.min.css">

<script type="text/javascript"
    src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datetimepicker/4.17.37/js/bootstrap-datetimepicker.min.js">
</script>

</script>
{{-- <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< / add for Expiray AMC CLIENT ACCOUNT \>>>>>>>>>>>>>>>>>>>>>>>>> --}}
@if (!empty($amc_expiry_messages))
<style>
    #amc-expiry-alert {
        position: relative;
        /* for positioning the close button */
        max-width: 600px;
        margin: 0.1px auto;
        padding: 15px 20px;
        margin-left: 200px;
        border: 1px solid #ffc107;
        border-radius: 8px;
        font-size: 16px;
        line-height: 1.5;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        background-color: #fff3cd;
        color: #856404;
    }

    #amc-expiry-alert ul {
        margin: 10px 0 0 20px;
        padding-left: 0;
    }

    #amc-expiry-alert li {
        list-style-type: disc;
    }

    /* Close button styles */
    #amc-expiry-alert .close-btn {
        position: absolute;
        top: 8px;
        right: 12px;
        color: red;
        font-weight: bold;
        font-size: 22px;
        cursor: pointer;
        user-select: none;
    }

    #amc-expiry-alert .close-btn:hover {
        color: darkred;
    }

    /* For admin: flat "Create Service" tab */
    .admin-tab {
        background: none !important;
        border: none !important;
        box-shadow: none !important;
        padding: 0 !important;
        margin: 0 10px 10px 0 !important;
    }

    .admin-tab a {
        font-size: 18px;
        font-weight: bold;
        color: #333 !important;
        text-decoration: none;
        padding: 0;
    }
</style>

<div class="alert alert-warning" id="amc-expiry-alert">
    <span class="close-btn" onclick="document.getElementById('amc-expiry-alert').style.display='none'">&times;</span>
    <strong>⚠️ Upcoming AMC Expiry:</strong>
    <ul>
        @foreach ($amc_expiry_messages as $msg)
        <li>{{ $msg }}</li>
        @endforeach
    </ul>

</div>
@endif

<style type="text/css">
    .alert-danger {
        margin-top: 1%;
        padding: 0;
        margin-bottom: 0px !important;
        background-color: transparent !important;
        border: none !important;
        color: #f33a12;
    }

    #scrollbars {
        scrollbar-base-color: #9999cc;
        scrollbar-arrow-color: white;
        scrollbar-track-color: #ccccff;

        scrollbar-shadow-color: black;
        scrollbar-lightshadow-color: black;
        scrollbar-darkshadow-color: gray;

        scrollbar-highlight-color: white;
        scrollbar-3dlight-color: black;
    }

    /*added by brijesh on 13-12-2019*/
    /**
                                 * Variables
                                 */
    /**
                                 * Wrapper
                                 */
    .combo-select {
        position: relative;
        border: 1px solid #ccc;
        border-radius: 2px;
        max-width: 500px;
        line-height: 1.42857143;
        font: 100% Helvetica, Arial, Sans-serif;
        font-size: 14px;
        color: #555;

    }

    .combo-select .combo-input {
        margin-bottom: 0;
    }

    /**
                                 * Input field
                                 */
    .combo-input {
        -webkit-appearance: none;
        -moz-appearance: none;
        appearance: none;
        margin-left: 0px;
        text-overflow: ellipsis;
        white-space: nowrap;
        border: none;
        width: 100%;
        box-sizing: border-box;
        padding-left: 15px;
        height: 34px;
        line-height: 34px;
        padding-right: 34px;
        border-radius: 0px;
        font-size: 14px;
    }

    .combo-input:focus {
        outline: none;
    }

    /**
                                 * Arrow
                                 */
    .combo-arrow {
        position: absolute;
        right: 0;
        top: 0;
        height: 100%;
        cursor: pointer;
        text-align: center;
        font-size: 22px;
        width: 40px;
        color: #999999;
    }

    .combo-arrow:before {
        content: "\f107";
        font-family: 'FontAwesome';
        font-size: 22px;
        top: -25px;
        display: block;
        width: 0;
        height: 0;
        right: 25px;
        bottom: 0;
        position: absolute;
        margin: auto 0;
    }

    /**
                                 * When opened
                                 */
    .combo-open .combo-arrow {
        border-color: #51A7E8;
    }

    .combo-open .combo-arrow:before {
        content: "\f106";
    }

    /**
                                 * When focused
                                 */
    .combo-focus {
        box-shadow: 0 2px 5px 0 rgba(0, 0, 0, 0.26);
        border-color: #51A7E8;
    }

    .combo-focus input {
        border-color: #51A7E8;
    }

    /**
                                 * Hide native select
                                 */
    .combo-select select {
        position: absolute;
        z-index: 1;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        -webkit-appearance: none;
        opacity: 0;
    }

    @media only screen and (min-width: 960px) {
        .combo-select select {
            left: -1px;
            top: -1px;
            width: 0;
            height: 0;
            margin: 0;
        }
    }

    /**
                                 * Selected option
                                 */
    .option-selected {
        background-color: #eee;
    }

    /**
                                 * Hovered option
                                 */
    .option-hover {
        background-color: #dfdfdf;
        color: #454545;
    }

    /**
                                 * Option item
                                 */
    .option-item {
        cursor: pointer;
        /*border-bottom: 1px #e3e3e3 solid;*/
    }

    .option-item:hover {
        background-color: #efefef;
        color: #454545;
    }

    .option-item:last-child {
        border-bottom: none;
    }

    /**
                                 * Disabled and optgroups
                                 */
    /*.option-group {
                                  cursor: text;
                                  font-weight: 600;
                                  background: #e1e1e1;
                                  border: 1px #ccc solid;
                                  border-width: 1px 0; }*/

    /**
                                 * Disabled
                                 */
    .option-disabled {
        opacity: 0.5;
    }

    /**
                                 * Dropdown
                                 */
    .combo-dropdown {
        position: absolute;
        z-index: 999;
        top: 100%;
        left: 0;
        min-width: 100%;
        max-width: 300px;
        max-height: 270px;
        margin: 0;
        padding: 0;
        opacity: 0;
        visibility: hidden;
        /*display: none;*/
        overflow-y: auto;
        background: #fff;
        box-shadow: 0 1px 6px rgba(0, 0, 0, 0.12), 0 1px 6px rgba(0, 0, 0, 0.12);
        -webkit-transition: all 0.2s ease-out;
        -ms-transition: all 0.2s ease-out;
        transition: all 0.2s ease-out;
        border-radius: 0;
        box-sizing: border-box;
        -webkit-transform: scale(0);
        -ms-transform: scale(0);
        transform: scale(0);
        -webkit-transform-origin: top left;
        -ms-transform-origin: top left;
        transform-origin: top left;
    }

    .combo-dropdown li {
        list-style: none;
        padding: 10px 15px;
        margin: 0 !important;
    }

    /**
                                 * On Active
                                 */
    .combo-open .combo-dropdown {
        /*display: block; */
        -webkit-transform: scale(1);
        -ms-transform: scale(1);
        transform: scale(1);
        opacity: 1;
        visibility: visible;
    }

    /**
                                 * Search marker
                                 */
    .combo-marker {
        text-decoration: underline;
    }

    .alert-danger1 {
        background-color: #E1F1FE;
        border-color: #E1F1FE;
        font-weight: bold;
        color: red;
    }


    /* Remove border/box-shadow/padding for admin */
    .admin-tab-wrapper {
        border: none !important;
        padding: 0 !important;
        box-shadow: none !important;
        background: none !important;
    }


    /*end added by brijesh*/
</style>
<script type="text/javascript">
    // Added by gaurav on 27-feb-20
    function showamc(option) {
        if (option == 'AMC Service') {
            $("#Amcoptions").show();
            return false;
        } else {
            var pm = document.getElementById("Amcpm");
            var cm = document.getElementById("Amccm");
            pm.checked = false;
            cm.checked = false;
            $("#Amcoptions").hide();
            return false;
        }
    } // Ended here

    // added by brijesh on 25-07-2020

    function showhiderma(selval) {
        if (selval == '1') {
            $("#ctktrmarefpnl").show();
            return false;
        } else {
            $("#ctktrmarefpnl").hide();
            $("#rmarefticketno").val("");
            return false;
        }
    }
    // end brijesh
</script>

<div class="content-wrapper" onload="document.refresh();">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h1 class="page-head-line">SERVICE</h1>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-default">
                    <div class="panel-body">
                        @if (Session::has('flash_message'))
                        <div class="alert alert-success">
                            {{ Session::get('flash_message') }}
                        </div>
                        @endif

                        <!-- if basic plan user used 50 services of limit error -->
                        @if (Session::has('unable_create_serv_mesg'))
                        <div class="alert alert-success" style="text-align: center;">
                            {{ Session::get('unable_create_serv_mesg') }}
                        </div>
                        @endif

                        <input type="hidden" name="activetab" id="activetab" value="tab1" />
                        <div class="col-md-12" id="tabs" style="padding-right: 0px;padding-left: 0px;">
                            {{-- Tabs --}}
                            @if (!$isAdmin)
                            <ul class="nav nav-tabs ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-corner-all">
                                {{-- Create Service Tab --}}
                                <li id="tab_li1" class="ui-state-default ui-corner-top" role="tab"
                                    tabindex="-1" aria-selected="false" aria-expanded="false">
                                    <a data-toggle="tab" href="#createservice"
                                        onclick="changetabval('tab1','tab_li1');">
                                        Create Service
                                    </a>
                                </li>

                                {{-- Request Service Tab --}}
                                @if (Session::get('custid') != '')
                                <li id="tab_li2" class="ui-state-default ui-corner-top" role="tab"
                                    tabindex="-1" aria-selected="false" aria-expanded="false">
                                    <a data-toggle="tab" href="#requestservice"
                                        onclick="changetabval('tab2','tab_li2');">
                                        Request Service
                                    </a>
                                </li>
                                @endif
                            </ul>


                            <br>

                            @if (session('error') && request()->old('form_id') == 'tab1')
                            <script>
                                alert("{{ session('error') }}");
                            </script>
                            @endif

                            @if (session('error') && request()->old('form_id') == 'tab2')
                            <script>
                                alert("{{ session('error') }}");
                            </script>
                            @endif


                            @if (session('success'))
                            <div class="alert alert-success">
                                {{ session('success') }}
                            </div>
                            @endif

                            <div class="tab-content" style="margin-top: 15px;">
                                {{-- Create Service Tab --}}
                                <div id="createservice" class="tab-pane fade in active">
                                    <br>
                                    <form name="form1" class="form-horizontal" id="submit" role="form"
                                        method="POST" action="/service/store" enctype="multipart/form-data"
                                        autocomplete="off">

                                        <input type="hidden" name="form_id" value="tab1">
                                        <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                                        <input type="hidden" name="service_requested_id" id="service_requested_id" value="">

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label
                                                            class="control-label1 col-md-2 col-sm-3 col-xs-12">Client
                                                            Ticket
                                                            No
                                                        </label>
                                                        <div class="col-md-5 col-sm-6 col-xs-12">
                                                            <input type="text" name="clientticketno"
                                                                id="clientticketno" class="form-control"
                                                                maxlength="10"
                                                                value="{{ old('clientticketno', $clientticketno) }}"
                                                                readonly>
                                                            @if ($errors->first('clientticketno'))
                                                            <div class="error alert alert-danger">
                                                                {{ $errors->first('clientticketno') }}
                                                            </div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                                @if (Session::get('custid'))
                                                <div class="col-md-5 col-sm-6 col-xs-12">
                                                    <!-- <select class="form-control" name="vendor_id" id="scrollbars"> -->

                                                    <input type="hidden" name="vendor_id" id="vendor_id"
                                                        value="<?php echo Session::get('custid'); ?>">
                                                    @else
                                                    <label
                                                        class="control-label1 col-md-2 col-sm-3 col-xs-12">Select
                                                        Client<span style="color:#FF0000"> *</span>
                                                    </label>
                                                    <div class="col-md-5 col-sm-6 col-xs-12">

                                                        <select class="form-control search-select"
                                                            name="vendor_id" id="scrollbars">
                                                            <!-- <select class="form-control" name="vendor_id" id="scrollbars"> -->
                                                            <option value="">Please Select Client
                                                            </option>
                                                            @foreach ($vendors as $vendor)
                                                            <?php if (!empty($vendor->name)) { ?>
                                                                <option value="{{ $vendor->id }}"
                                                                    {{ old('vendor_id') == "$vendor->id" ? 'selected="selected"' : '' }}>
                                                                    {{ $vendor->name }}{{ empty($vendor->company_name) ? '' : ' / ' . $vendor->company_name }}
                                                                </option>
                                                            <?php } ?>
                                                            @endforeach
                                                        </select>
                                                        @endif
                                                        @if ($errors->first('vendor_id'))
                                                        <div class="error alert alert-danger">Please Select Client
                                                        </div>
                                                        @endif
                                                    </div>
                                                </div>

                                            </div>
                                            <!-- //added by sundaram on 14-06-2021 for service provider start -->

                                            @if ($serviceenable_value == 1)
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label1 col-md-2 col-sm-3 col-xs-12">Select
                                                        Service
                                                        Provider
                                                        <span style="color:#FF0000"> *</span>
                                                    </label>
                                                    <div class="col-md-5 col-sm-6 col-xs-12">
                                                        <select class="form-control" name="service_id" id="service_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($service_pros as $service_pro)
                                                            <option value="{{ $service_pro->id }}"
                                                                {{ old('service_provider_id') == "$service_pro->id" ? 'selected="selected"' : '' }}>
                                                                {{ $service_pro->company_name }}
                                                            </option>
                                                            @endforeach
                                                        </select>
                                                        @if ($errors->first('service_id'))
                                                        <div class="error alert alert-danger">
                                                            {{ $errors->first('service_id') }}
                                                        </div>
                                                        @endif
                                                    </div>
                                                    <div> <br><label id="show_in_amc"></label></div>
                                                </div>
                                            </div>
                                            @endif
                                            <!-- //added by sundaram on 14-06-2021 for service provider end -->
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label1 col-md-2 col-sm-3 col-xs-12">Select Product /
                                                        Domain <span style="color:#FF0000"> *</span>
                                                    </label>
                                                    <div class="col-md-5 col-sm-6 col-xs-12">
                                                        <select class="form-control" name="product_id" id="product_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($products as $product)
                                                            <option value="{{ $product->id }}"
                                                                data-status="{{ $product->amc_status }}"
                                                                data-service_requested_id=" {{ $product->service_requested_id }} "
                                                                data-allowed="{{ $product->is_allowed }}"
                                                                {{ old('product_id') == "$product->id" ? 'selected="selected"' : '' }}>
                                                                {{ $product->product_name }} /
                                                                {{ $product->product_code }}
                                                            </option>
                                                            @endforeach
                                                        </select>
                                                        @if ($errors->first('product_id'))
                                                        <div class="error alert alert-danger">
                                                            {{ $errors->first('product_id') }}
                                                        </div>
                                                        @endif
                                                    </div>

                                                    <div> <br><label id="show_in_amc"></label></div>
                                                </div>
                                            </div>
                                            @if (!empty($settings['location']) && $settings['location'] == 1)
                                            <div class="col-md-12">
                                                <div class="form-group row" id="locationDropdowndiv">
                                                    <label for="locationDropdown" class="control-label1 col-md-2 col-sm-3 col-form-label">
                                                        Select Location
                                                    </label>
                                                    <div class="col-md-5 col-sm-6">
                                                        <select class="form-control" name="vendor_location" id="locationDropdown">
                                                            <option value="">Please Select Location</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>


                                            <script>
                                                $(document).ready(function() {
                                                    $('select[name="vendor_id"]').on('change', function() {
                                                        var vendorId = $(this).val();
                                                        const $locationWrapper = $('#locationDropdowndiv');
                                                        let selectedProductId = "{{ old('product_id', $service->product_id ?? '') }}";

                                                        let selectedLocationId = "{{ old('vendor_location', $service->vendor_location ?? '') }}";
                                                        if (vendorId) {
                                                            $.ajax({
                                                                url: "{{ url('/admin/vendor/locations') }}/" + vendorId,
                                                                type: "GET",
                                                                xhrFields: {
                                                                    withCredentials: true // Important!
                                                                },
                                                                dataType: "json",
                                                                success: function(data) {
                                                                    console.log(data);

                                                                    $('#locationDropdown').empty().append(
                                                                        '<option value="">Please Select Location</option>');
                                                                    $.each(data.locations, function(key, value) {
                                                                        let selected = (value.id == selectedLocationId) ? 'selected' : '';
                                                                        $('#locationDropdown').append(
                                                                            '<option value="' + value.id + '">' + value
                                                                            .address_line1 + ', ' + value.city + '</option>'
                                                                        );
                                                                    });
                                                                    console.log("On 1");

                                                                    // Optional: use the vendor_address_status somewhere (e.g., show a message)
                                                                    if (data.vendor_address_status == 0) {
                                                                        $locationWrapper.css('display', 'none');
                                                                    } else {
                                                                        $locationWrapper.css('display', 'block');
                                                                    }
                                                                    // Populate Products
                                                                    $('#product_id').empty().append('<option value="">Please Select</option>');
                                                                    $.each(data.products, function(index, product) {
                                                                        let selected = (product.id == selectedProductId) ? 'selected' : '';
                                                                         $('#product_id').append(
                                                                            `<option value="${product.id}" ${selected}
                                                                                data-status="${product.amc_status}"
                                                                                data-service_requested_id="${product.service_requested_id}"
                                                                                data-allowed="${product.is_allowed}">
                                                                                ${product.product_name} / ${product.product_code}
                                                                            </option>`
                                                                        );
                                                                    });
                                                                }
                                                            });
                                                        } else {
                                                            $('#locationDropdown').empty().append(
                                                                '<option value="">Please Select Location</option>');
                                                        }
                                                    });
                                                    var vendorId = $('#vendor_id').val();
                                                    const $locationWrapper = $('#locationDropdowndiv');

                                                    let selectedLocationId = "{{ old('vendor_location', $service->vendor_location ?? '') }}";
                                                    if (vendorId) {

                                                        $.ajax({
                                                            url: "{{ url('/admin/vendor/locations') }}/" + vendorId,
                                                            type: "GET",
                                                            xhrFields: {
                                                                withCredentials: true // Important!
                                                            },
                                                            crossDomain: true,
                                                            dataType: "json",
                                                            headers: {
                                                                'Accept': 'application/json'
                                                            },
                                                            success: function(data) {
                                                                console.log("here I m new");

                                                                console.log(data);

                                                                $('#locationDropdown').empty().append(
                                                                    '<option value="">Please Select Location</option>');
                                                                $.each(data.locations, function(key, value) {
                                                                    let selected = (value.id == selectedLocationId) ? 'selected' : '';
                                                                    $('#locationDropdown').append(
                                                                        '<option value="' + value.id + '">' + value
                                                                        .address_line1 + ', ' + value.city + '</option>'
                                                                    );
                                                                });
                                                                console.log("On 1");

                                                                // Optional: use the vendor_address_status somewhere (e.g., show a message)
                                                                if (data.vendor_address_status == 0) {
                                                                    $locationWrapper.css('display', 'none');
                                                                } else {
                                                                    $locationWrapper.css('display', 'block');
                                                                }
                                                            }
                                                        });
                                                    } else {
                                                        $('#locationDropdown').empty().append(
                                                            '<option value="">Please Select Location</option>');
                                                    }
                                                });
                                            </script>
                                            @endif

                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label1 col-md-2 col-sm-3 col-xs-12">Description<span
                                                            style="color:#FF0000"> *</span>
                                                    </label>
                                                    <div class="col-md-5 col-sm-6 col-xs-12">
                                                        <textarea class="form-control" name="service_description" id="service_description" style="text-transform:capitalize"
                                                            maxlength="255" onkeyup="desccharsleft(this.value.length);" onblur="desccharsleft(this.value.length);">{{ old('service_description') }}</textarea><br>
                                                        <span id='remainingC' style="font-style: italic;">Remaining characters
                                                            :
                                                            255</span>
                                                        @if ($errors->first('service_description'))
                                                        <div class="error alert alert-danger">
                                                            {{ $errors->first('service_description') }}
                                                        </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label1 col-md-2 col-sm-3 col-xs-12">
                                                        Target Date <span style="color:#FF0000"> *</span>
                                                    </label>
                                                    <div class="col-md-5 col-sm-6 col-xs-12">
                                                        <input type="date" class="form-control" name="target_date" id="target_date"
                                                            value="{{ old('target_date') }}" required>
                                                        @if ($errors->first('target_date'))
                                                        <div class="error alert alert-danger mt-2">
                                                            {{ $errors->first('target_date') }}
                                                        </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>


                                            <!-- Added by gaurav on 28-feb-2020 -->
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label
                                                        class="control-label1 col-md-2 col-sm-3 col-xs-12">Instructions</label>
                                                    <div class="col-md-5 col-sm-6 col-xs-12">
                                                        <textarea class="form-control" placeholder="Instructions for Technician" name="instructions" id="instructions"
                                                            maxlength="255" onkeyup="charsleft(this.value.length);" onblur="charsleft(this.value.length);">{{ old('instructions') }}</textarea><br>
                                                        <span id='remaininginstruct' style="font-style: italic;">Remaining
                                                            characters :
                                                            255</span>
                                                        @if ($errors->first('instructions'))
                                                        <div class="error alert alert-danger">
                                                            {{ $errors->first('instructions') }}
                                                        </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div><!-- Ended here -->

                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label1 col-md-2 col-sm-3 col-xs-12">Type<span
                                                            style="color:#FF0000">
                                                            *</span>
                                                    </label>
                                                    <div class="col-md-5 col-sm-6 col-xs-12">
                                                        <label class="radio-inline"><input type="radio"
                                                                id="new_installation" name="service_type"
                                                                value="New Installation" onclick="showamc(this.value)">New
                                                            Installation</label>
                                                        <label class="radio-inline"><input type="radio" id="complain"
                                                                name="service_type" value="Complain"
                                                                onclick="showamc(this.value)">Complain</label>
                                                        <!-- Added by gaurav on 27-feb-20 -->
                                                        <label class="radio-inline"><input type="radio" id="call_basis"
                                                                name="service_type" value="Call Basis"
                                                                onclick="showamc(this.value)">Call
                                                            Basis</label>
                                                        <label class="radio-inline"><input type="radio" id="amc_pm"
                                                                name="service_type" value="AMC PM"
                                                                onclick="showamc(this.value)">PM</label>
                                                        <label class="radio-inline"><input type="radio" id="amc_cm"
                                                                name="service_type" value="AMC CM"
                                                                onclick="showamc(this.value)">CM</label>
                                                        <label class="radio-inline"><input type="radio" id="amc_warranty"
                                                                name="service_type" value="warranty"
                                                                onclick="showamc(this.value)">Warranty</label>
                                                        <label class="radio-inline"><input type="radio" id="amc_one_time"
                                                                name="service_type" value="one_time"
                                                                onclick="showamc(this.value)">One
                                                            time</label>
                                                        <label class="radio-inline"><input type="radio" id="amc_visiting"
                                                                name="service_type" value="AMC visiting"
                                                                onclick="showamc(this.value)">AMC
                                                            Visiting</label>
                                                        <!-- Ended here -->

                                                        @if ($errors->first('service_type'))
                                                        <div class="error alert alert-danger">
                                                            {{ $errors->first('service_type') }}
                                                        </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label1 col-md-2 col-sm-3 col-xs-12">Mobile No <span
                                                            style="color:#FF0000"> *</span>
                                                    </label>
                                                    <div class="col-md-5 col-sm-6 col-xs-12">
                                                        <input type="text" name="mobileno" id="mobno"
                                                            class="form-control" maxlength="10"
                                                            value="{{ old('mobileno') }}">
                                                        @if ($errors->first('mobileno'))
                                                        <div class="error alert alert-danger">
                                                            {{ $errors->first('mobileno') }}
                                                        </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- For Priority Dropdown -->
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label1 col-md-2 col-sm-3 col-xs-12">Priority<span
                                                            style="color:#FF0000"> *</span>
                                                    </label>
                                                    <div class="col-md-5 col-sm-6 col-xs-12">

                                                        <select class="form-control" id="new_priority" name="new_priority">
                                                            <option value="">Please Select</option>
                                                            <?php
                                                            /*$mysqli = new mysqli("139.59.41.76","mukesoft","jeR4s#2@eD","apni_amc_UAT");
											 $query = "select * from priority where deleted_at = 'N'"; 
											 $results = mysqli_query($mysqli,$query);
										
											while ($rows = mysqli_fetch_assoc(@$results)){ */
                                                            ?>
                                                            <!-- <option value="<?php //echo $rows['id'];
                                                                                ?>"><?php //echo $rows['name'];
                                                                                    ?></option> -->

                                                            <?php
                                                            // }
                                                            ?>
                                                        </select>
                                                        {{-- <label class="radio-inline"><input type="radio" name="set_priority" value="1" >Yes</label>
									   <label class="radio-inline"><input type="radio"   name="set_priority" value="0" checked="checked">No</label>
									    @if ($errors->first('set_priority')) <div class="error alert alert-danger">{{ $errors->first('set_priority') }}
                                                    </div> @endif --}}
                                                </div>
                                            </div>
                                        </div>


                                        <!--  added by brijesh on 17-03-2020 for future -->


                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="control-label1 col-md-2 col-sm-3 col-xs-12">Service Date<span
                                                        style="color:#FF0000"> *</span>
                                                </label>
                                                <div class="col-md-5 col-sm-6 col-xs-12">
                                                    <div class="col-md-5 col-sm-6 col-xs-12" style="padding-left:0px;">
                                                        <label class="radio-inline"><input type="radio"
                                                                id="redio_today" name="service_date" value="0"
                                                                checked="checked"
                                                                onclick="showhideother(this.value);">Today</label>
                                                        <label class="radio-inline"><input type="radio"
                                                                id="redio_other" name="service_date" value="1"
                                                                onclick="showhideother(this.value);">Other</label>
                                                    </div>
                                                    <div class="col-md-6 col-sm-6 col-xs-12" id="service_date_div">
                                                        <input type="text" name="future_date" id="future_date"
                                                            class="form-control" placeholder="Choose Date(01-01-2000)"
                                                            data-format="YYYY-MM-DD H:mm:ss" data-date-end-date="0d">
                                                        <br />
                                                    </div>
                                                    <br>


                                                </div>
                                                @if ($errors->first('future_date'))
                                                <div class="error alert alert-danger">
                                                    {{ $errors->first('future_date') }}
                                                </div>
                                                @endif
                                            </div>

                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="control-label1 col-md-2 col-sm-3 col-xs-12">Target Date <span style="color:#FF0000"> *</span></label>
                                                <div class="col-md-5 col-sm-6 col-xs-12">
                                                    <input type="text" name="target_date" id="target_date" class="form-control"
                                                        placeholder="Choose Target Date (YYYY-MM-DD)"
                                                        data-format="YYYY-MM-DD"
                                                        autocomplete="off">
                                                </div>
                                            </div>

                                            @if ($errors->first('target_date'))
                                            <div class="error alert alert-danger">
                                                {{ $errors->first('target_date') }}
                                            </div>
                                            @endif
                                        </div>
                                        <div class="form-group">
                                            <div class="col-md-5 col-sm-6 col-xs-12">

                                                <a onclick="show_module_fun()" class="btn">See More <i
                                                        class="fa fa-chevron-down"></i></a>
                                            </div>
                                        </div>

                                        <div id="show_module">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label1 col-md-2 col-sm-3 col-xs-12">RMA Ref
                                                    </label>
                                                    <div class="col-md-5 col-sm-6 col-xs-12">
                                                        <label class="radio-inline"><input type="radio" name="rmaref"
                                                                value="1" onclick="showhiderma(this.value);"
                                                                id="rmarefyes">Yes</label>
                                                        <label class="radio-inline"><input type="radio" name="rmaref"
                                                                value="0" checked="checked"
                                                                onclick="showhiderma(this.value);">No</label>
                                                        <br />
                                                        <div class="ctktrmarefpnl" id="ctktrmarefpnl"
                                                            style="display:none;">
                                                            Enter Service/Ticket No. :
                                                            <input type="text" name="rmarefticketno"
                                                                id="rmarefticketno" class="form-control ctktrmarefpnl"
                                                                value="">
                                                        </div>


                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label1 col-md-2 col-sm-3 col-xs-12">Check List
                                                    </label>
                                                    <div class="col-md-5 col-sm-6 col-xs-12">
                                                        <select class="form-control" name="checklist" id="checklist">
                                                            <option value="">Please Select</option>

                                                            @foreach ($checklists as $checklist)
                                                            <!-- <option value="{{ $checklist->id }}" {{ old('checklist') == "$checklist->id" ? 'selected="selected"' : '' }}>{{ $checklist->title }} </option> -->
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>

                                        <!-- end brijesh -->

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <div class="col-md-4 col-sm-6 col-xs-12 col-md-offset-5">
                                                    <button type="submit" class="btn btn-success" id="service_submit"
                                                        onclick="formsubmit()">Submit</button>
                                                    <a href="/home" class="btn btn-primary">Cancel</a>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                {{-- Request Service Tab --}}

                                {{-- only disply in client login  ,hari --}}
                                @if (Session::get('custid') != '')
                                <div id="requestservice" class="tab-pane fade">


                                    <h2>Requested Service</h2>

                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>ID</th>
                                                {{-- <th>Vendor</th> --}}
                                                {{-- <th>compony name</th> --}}
                                                {{-- <th>vendor name</th> --}}
                                                <th>Product / Domain</th>
                                                <th>Message</th>
                                                <th>Request Status</th>
                                                {{-- <th>Updated At</th> --}}
                                                {{-- <th>Action</th> --}}
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <div style="display:none"><?php echo Session::get('custid'); ?></div>
                                            @foreach ($requests as $request)
                                            <tr>
                                                <td>{{ $request->serial }}</td>
                                                {{-- <td>{{ $request->id }}</td> --}}
                                                {{-- <td>{{ $request->request_by_id }}</td> --}}
                                                {{-- <td>{{ $request->company_name }}</td> --}}
                                                {{-- <td>{{ $request->vendor_name }}</td> --}}
                                                <td>{{ $request->product_name }}</td>
                                                <td>{{ $request->message }}</td>
                                                <td>
                                                    @if ($request->status === 1)
                                                    <span class="text-success">Approved</span>
                                                    @elseif($request->status === 2)
                                                    <span class="text-danger">Disapproved</span>
                                                    @elseif($request->status === 0)
                                                    <span class="text-warning">Pending</span>
                                                    @endif
                                                </td>
                                                {{-- <td>{{ $request->updated_date }}</td> --}}

                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                    <br>
                                    <form name="requestform" class="form-horizontal" id="submit"
                                        role="form" method="POST"
                                        action="{{ route('submit.request.service') }}"
                                        enctype="multipart/form-data" autocomplete="off">
                                        <input type="hidden" name="form_id" value="tab2">

                                        <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="control-label1 col-md-2 col-sm-3 col-xs-12">
                                                    Select Product / Domain <span style="color:#FF0000"> *</span>
                                                </label>
                                                <div class="col-md-5 col-sm-6 col-xs-12">

                                                    <select name="product_id" id="product_id"
                                                        class="form-control" required>
                                                        <option value="">-- Please Select Expired Product --
                                                        </option>
                                                        @foreach ($expired_products as $product)
                                                        <option value="{{ $product->id }}"
                                                            {{ old('product_id') == $product->id ? 'selected' : '' }}>
                                                            {{ $product->product_name }}
                                                            ({{ $product->product_code ?? '' }})
                                                        </option>
                                                        @endforeach
                                                    </select>
                                                    @if ($errors->first('product_id'))
                                                    <div class="error alert alert-danger">
                                                        {{ $errors->first('product_id') }}
                                                    </div>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label
                                                    class="control-label1 col-md-2 col-sm-3 col-xs-12">Message<span
                                                        style="color:#FF0000"> *</span>
                                                </label>
                                                <div class="col-md-5 col-sm-6 col-xs-12">
                                                    <textarea class="form-control" name="message" id="message" style="text-transform:capitalize" maxlength="255"
                                                        onkeyup="desccharsleft(this.value.length);" onblur="desccharsleft(this.value.length);" required>{{ old('message') }}</textarea><br>
                                                    <span id='remainingC' style="font-style: italic;">Remaining
                                                        characters
                                                        :
                                                        255</span>
                                                    <br><br>
                                                    <p style="color: #F90606 !important;">* You can only request
                                                        this
                                                        service product once. </p>
                                                    @if ($errors->first('message'))
                                                    <div class="error alert alert-danger">
                                                        {{ $errors->first('message') }}
                                                    </div>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <div class="col-md-4 col-sm-6 col-xs-12 col-md-offset-5">
                                                    <button type="submit" class="btn btn-success"
                                                        id="service_request_submit"
                                                        onclick="formsubmit()">Submit</button>
                                                    <a href="/home" class="btn btn-primary">Cancel</a>
                                                </div>
                                            </div>
                                        </div>
                                    </form>

                                    <br>
                                </div>
                                @endif
                            </div> <!-- /.tab-content -->
                            @else
                             <input type="hidden" name="activetab" id="activetab" value="tab1" />
                        <div class="col-md-12" id="tabs" style="padding-right: 0px;padding-left: 0px;">
                            {{-- Tabs --}}
                            <ul class="nav nav-tabs ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-corner-all">
                                {{-- Create Service Tab --}}
                                <li id="tab_li1" class="ui-state-default ui-corner-top" role="tab"
                                    tabindex="-1" aria-selected="false" aria-expanded="false">
                                    <a data-toggle="tab" href="#createservice"
                                        onclick="changetabval('tab1','tab_li1');">
                                        Create Service
                                    </a>
                                </li>

                                {{-- Request Service Tab --}}
                                <li id="tab_li2" class="ui-state-default ui-corner-top" role="tab"
                                    tabindex="-1" aria-selected="false" aria-expanded="false">
                                    <a data-toggle="tab" href="#requestservice"
                                        onclick="changetabval('tab2','tab_li2');">
                                        Request Service
                                    </a>
                                </li>
                            </ul>


                            <br>

                            @if (session('error') && request()->old('form_id') == 'tab1')
                            <script>
                                alert("{{ session('error') }}");
                            </script>
                            @endif

                            @if (session('error') && request()->old('form_id') == 'tab2')
                            <script>
                                alert("{{ session('error') }}");
                            </script>
                            @endif


                            @if (session('success'))
                            <div class="alert alert-success">
                                {{ session('success') }}
                            </div>
                            @endif


                            {{-- Admin: Show Create Service form only, without tabs --}}
                            <div class="tab-content" style="margin-top: 15px;">
                                {{-- Create Service Tab --}}
                                <div id="createservice" class="tab-pane fade in active">
                                    <br>
                                    <form name="form1" class="form-horizontal" id="submit" role="form"
                                        method="POST" action="/service/store" enctype="multipart/form-data"
                                        autocomplete="off">

                                        <input type="hidden" name="form_id" value="tab1">
                                        <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                                        <input type="hidden" name="service_requested_id" id="service_requested_id" value="">

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <div class="col-md-12">
                                                    <div class="form-group">
                                                        <label class="control-label1 col-md-2 col-sm-3 col-xs-12">Client
                                                            Ticket
                                                            No
                                                        </label>
                                                        <div class="col-md-5 col-sm-6 col-xs-12">
                                                            <input type="text" name="clientticketno"
                                                                id="clientticketno" class="form-control" maxlength="10"
                                                                value="{{ old('clientticketno', $clientticketno) }}"
                                                                readonly>
                                                            @if ($errors->first('clientticketno'))
                                                            <div class="error alert alert-danger">
                                                                {{ $errors->first('clientticketno') }}
                                                            </div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                                @if (Session::get('custid'))
                                                <div class="col-md-5 col-sm-6 col-xs-12">
                                                    <!-- <select class="form-control" name="vendor_id" id="scrollbars"> -->

                                                    <input type="hidden" name="vendor_id" id="vendor_id"
                                                        value="<?php echo Session::get('custid'); ?>">
                                                    @else
                                                    <label class="control-label1 col-md-2 col-sm-3 col-xs-12">Select
                                                        Client<span style="color:#FF0000"> *</span>
                                                    </label>
                                                    <div class="col-md-5 col-sm-6 col-xs-12">

                                                        <select class="form-control search-select" name="vendor_id"
                                                            id="scrollbars">
                                                            <!-- <select class="form-control" name="vendor_id" id="scrollbars"> -->
                                                            <option value="">Please Select Client</option>
                                                            @foreach ($vendors as $vendor)
                                                            <?php if (!empty($vendor->name)) { ?>
                                                                <option value="{{ $vendor->id }}"
                                                                    {{ old('vendor_id') == "$vendor->id" ? 'selected="selected"' : '' }}>
                                                                    {{ $vendor->name }}{{ empty($vendor->company_name) ? '' : ' / ' . $vendor->company_name }}
                                                                </option>
                                                            <?php } ?>
                                                            @endforeach
                                                        </select>
                                                        @endif
                                                        @if ($errors->first('vendor_id'))
                                                        <div class="error alert alert-danger">Please Select Client</div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- //added by sundaram on 14-06-2021 for service provider start -->

                                            @if ($serviceenable_value == 1)
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label1 col-md-2 col-sm-3 col-xs-12">Select Service
                                                        Provider
                                                        <span style="color:#FF0000"> *</span>
                                                    </label>
                                                    <div class="col-md-5 col-sm-6 col-xs-12">
                                                        <select class="form-control" name="service_id" id="service_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($service_pros as $service_pro)
                                                            <option value="{{ $service_pro->id }}"
                                                                {{ old('service_provider_id') == "$service_pro->id" ? 'selected="selected"' : '' }}>
                                                                {{ $service_pro->company_name }}
                                                            </option>
                                                            @endforeach
                                                        </select>
                                                        @if ($errors->first('service_id'))
                                                        <div class="error alert alert-danger">
                                                            {{ $errors->first('service_id') }}
                                                        </div>
                                                        @endif
                                                    </div>
                                                    <div> <br><label id="show_in_amc"></label></div>
                                                </div>
                                            </div>
                                            @endif
                                            <!-- //added by sundaram on 14-06-2021 for service provider end -->
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label1 col-md-2 col-sm-3 col-xs-12">Select Product /
                                                        Domain <span style="color:#FF0000"> *</span>
                                                    </label>
                                                    <div class="col-md-5 col-sm-6 col-xs-12">
                                                        <select class="form-control" name="product_id" id="product_id">
                                                            <option value="">Please Select</option>
                                                            @foreach ($products as $product)
                                                            <option value="{{ $product->id }}"
                                                                data-status="{{ $product->amc_status }}"
                                                                data-service_requested_id=" {{ $product->service_requested_id }} "
                                                                data-allowed="{{ $product->is_allowed }}"
                                                                {{ old('product_id') == "$product->id" ? 'selected="selected"' : '' }}>
                                                                {{ $product->product_name }} / {{ $product->product_code }}
                                                            </option>
                                                            @endforeach
                                                        </select>
                                                        @if ($errors->first('product_id'))
                                                        <div class="error alert alert-danger">
                                                            {{ $errors->first('product_id') }}
                                                        </div>
                                                        @endif
                                                    </div>

                                                    <div> <br><label id="show_in_amc"></label></div>
                                                </div>
                                            </div>
                                            @if (!empty($settings['location']) && $settings['location'] == 1)
                                            <div class="col-md-12">
                                                <div class="form-group row" id="locationDropdowndiv">
                                                    <label for="locationDropdown" class="control-label1 col-md-2 col-sm-3 col-form-label">
                                                        Select Location
                                                    </label>
                                                    <div class="col-md-5 col-sm-6">
                                                        <select class="form-control" name="vendor_location" id="locationDropdown">
                                                            <option value="">Please Select Location</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>



                                            <script>
                                                $(document).ready(function() {
                                                    $('select[name="vendor_id"]').on('change', function() {
                                                        var vendorId = $(this).val();
                                                        const $locationWrapper = $('#locationDropdowndiv');
                                                        let selectedProductId = "{{ old('product_id', $service->product_id ?? '') }}";
                                                        let selectedLocationId = "{{ old('vendor_location', $service->vendor_location ?? '') }}";
                                                        if (vendorId) {
                                                            $.ajax({
                                                                url: "{{ url('/admin/vendor/locations') }}/" + vendorId,
                                                                type: "GET",
                                                                xhrFields: {
                                                                    withCredentials: true // Important!
                                                                },
                                                                dataType: "json",
                                                                success: function(data) {
                                                                    console.log(data);
                                                                    $('#locationDropdown').empty().append(
                                                                        '<option value="">Please Select Location</option>');
                                                                    $.each(data.locations, function(key, value) {
                                                                        let selected = (value.id == selectedLocationId) ? 'selected' : '';
                                                                        $('#locationDropdown').append(
                                                                            '<option value="' + value.id + '">' + value
                                                                            .address_line1 + ', ' + value.city + '</option>'
                                                                        );
                                                                    });
                                                                    if (data.vendor_address_status == 0) {
                                                                        $locationWrapper.css('display', 'none');
                                                                    } else {
                                                                        $locationWrapper.css('display', 'block');
                                                                    }
                                                                    // Populate Products
                                                                    $('#product_id').empty().append('<option value="">Please Select</option>');
                                                                    $.each(data.products, function(index, product) {
                                                                        let selected = (product.id == selectedProductId) ? 'selected' : '';
                                                                        $('#product_id').append(
                                                                            `<option value="${product.id}" ${selected}
                                                                                data-status="${product.amc_status}"
                                                                                data-service_requested_id="${product.service_requested_id}"
                                                                                data-allowed="${product.is_allowed}">
                                                                                ${product.product_name} / ${product.product_code}
                                                                            </option>`
                                                                        );
                                                                    });
                                                                }
                                                            });
                                                        } else {
                                                            $('#locationDropdown').empty().append(
                                                                '<option value="">Please Select Location</option>');
                                                        }
                                                    });
                                                    console.log("here Im");
                                                    var vendorId = $('#vendor_id').val();
                                                    const $locationWrapper = $('#locationDropdowndiv');

                                                    let selectedLocationId = "{{ old('vendor_location', $service->vendor_location ?? '') }}";
                                                    if (vendorId) {
                                                        $.ajax({
                                                            url: "{{ url('/admin/vendor/locations') }}/" + vendorId,
                                                            type: "GET",
                                                            xhrFields: {
                                                                withCredentials: true // Important!
                                                            },
                                                            dataType: "json",
                                                            headers: {
                                                                'Accept': 'application/json'
                                                            },
                                                            crossDomain: true,
                                                            success: function(data) {
                                                                console.log(data);

                                                                $('#locationDropdown').empty().append(
                                                                    '<option value="">Please Select Location</option>');
                                                                $.each(data.locations, function(key, value) {
                                                                    let selected = (value.id == selectedLocationId) ? 'selected' : '';
                                                                    $('#locationDropdown').append(
                                                                        '<option value="' + value.id + '">' + value
                                                                        .address_line1 + ', ' + value.city + '</option>'
                                                                    );
                                                                });
                                                                console.log("On 1");

                                                                // Optional: use the vendor_address_status somewhere (e.g., show a message)
                                                                if (data.vendor_address_status == 0) {
                                                                    $locationWrapper.css('display', 'none');
                                                                } else {
                                                                    $locationWrapper.css('display', 'block');
                                                                }
                                                            }
                                                        });
                                                    } else {
                                                        $('#locationDropdown').empty().append(
                                                            '<option value="">Please Select Location</option>');
                                                    }
                                                });
                                            </script>
                                            @endif

                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label1 col-md-2 col-sm-3 col-xs-12">Description<span
                                                            style="color:#FF0000"> *</span>
                                                    </label>
                                                    <div class="col-md-5 col-sm-6 col-xs-12">
                                                        <textarea class="form-control" name="service_description" id="service_description" style="text-transform:capitalize"
                                                            maxlength="255" onkeyup="desccharsleft(this.value.length);" onblur="desccharsleft(this.value.length);">{{ old('service_description') }}</textarea><br>
                                                        <span id='remainingC' style="font-style: italic;">Remaining characters :
                                                            255</span>
                                                        @if ($errors->first('service_description'))
                                                        <div class="error alert alert-danger">
                                                            {{ $errors->first('service_description') }}
                                                        </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>

                                            <!-- Added by gaurav on 28-feb-2020 -->
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label1 col-md-2 col-sm-3 col-xs-12">Instructions</label>
                                                    <div class="col-md-5 col-sm-6 col-xs-12">
                                                        <textarea class="form-control" placeholder="Instructions for Technician" name="instructions" id="instructions"
                                                            maxlength="255" onkeyup="charsleft(this.value.length);" onblur="charsleft(this.value.length);">{{ old('instructions') }}</textarea><br>
                                                        <span id='remaininginstruct' style="font-style: italic;">Remaining
                                                            characters :
                                                            255</span>
                                                        @if ($errors->first('instructions'))
                                                        <div class="error alert alert-danger">
                                                            {{ $errors->first('instructions') }}
                                                        </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div><!-- Ended here -->

                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label1 col-md-2 col-sm-3 col-xs-12">Type<span
                                                            style="color:#FF0000">
                                                            *</span>
                                                    </label>
                                                    <div class="col-md-5 col-sm-6 col-xs-12">
                                                        <label class="radio-inline"><input type="radio" id="new_installation"
                                                                name="service_type" value="New Installation"
                                                                onclick="showamc(this.value)">New Installation</label>
                                                        <label class="radio-inline"><input type="radio" id="complain"
                                                                name="service_type" value="Complain"
                                                                onclick="showamc(this.value)">Complain</label>
                                                        <!-- Added by gaurav on 27-feb-20 -->
                                                        <label class="radio-inline"><input type="radio" id="call_basis"
                                                                name="service_type" value="Call Basis"
                                                                onclick="showamc(this.value)">Call
                                                            Basis</label>
                                                        <label class="radio-inline"><input type="radio" id="amc_pm"
                                                                name="service_type" value="AMC PM"
                                                                onclick="showamc(this.value)">PM</label>
                                                        <label class="radio-inline"><input type="radio" id="amc_cm"
                                                                name="service_type" value="AMC CM"
                                                                onclick="showamc(this.value)">CM</label>
                                                        <label class="radio-inline"><input type="radio" id="amc_warranty"
                                                                name="service_type" value="warranty"
                                                                onclick="showamc(this.value)">Warranty</label>
                                                        <label class="radio-inline"><input type="radio" id="amc_one_time"
                                                                name="service_type" value="one_time"
                                                                onclick="showamc(this.value)">One
                                                            time</label>
                                                        <label class="radio-inline"><input type="radio" id="amc_visiting"
                                                                name="service_type" value="AMC visiting"
                                                                onclick="showamc(this.value)">AMC
                                                            Visiting</label>
                                                        <!-- Ended here -->

                                                        @if ($errors->first('service_type'))
                                                        <div class="error alert alert-danger">
                                                            {{ $errors->first('service_type') }}
                                                        </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label1 col-md-2 col-sm-3 col-xs-12">Mobile No <span
                                                            style="color:#FF0000"> *</span>
                                                    </label>
                                                    <div class="col-md-5 col-sm-6 col-xs-12">
                                                        <input type="text" name="mobileno" id="mobno" class="form-control"
                                                            maxlength="10" value="{{ old('mobileno') }}">
                                                        @if ($errors->first('mobileno'))
                                                        <div class="error alert alert-danger">{{ $errors->first('mobileno') }}
                                                        </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- For Priority Dropdown -->
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label1 col-md-2 col-sm-3 col-xs-12">Priority<span
                                                            style="color:#FF0000"> *</span>
                                                    </label>
                                                    <div class="col-md-5 col-sm-6 col-xs-12">

                                                        <select class="form-control" id="new_priority" name="new_priority">
                                                            <option value="">Please Select</option>
                                                            <?php
                                                            /*$mysqli = new mysqli("139.59.41.76","mukesoft","jeR4s#2@eD","apni_amc_UAT");
											 $query = "select * from priority where deleted_at = 'N'"; 
											 $results = mysqli_query($mysqli,$query);
										
											while ($rows = mysqli_fetch_assoc(@$results)){ */
                                                            ?>
                                                            <!-- <option value="<?php //echo $rows['id'];
                                                                                ?>"><?php //echo $rows['name'];
                                                                                    ?></option> -->

                                                            <?php
                                                            // }
                                                            ?>
                                                        </select>
                                                     <!--   {{-- <label class="radio-inline"><input type="radio" name="set_priority" value="1" >Yes</label>
									   <label class="radio-inline"><input type="radio"   name="set_priority" value="0" checked="checked">No</label>
									    @if ($errors->first('set_priority')) <div class="error alert alert-danger">{{ $errors->first('set_priority') }}
                                                    </div> @endif --}} -->
                                                </div>
                                            </div>
                                        </div>


                                        <!--  added by brijesh on 17-03-2020 for future -->


                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="control-label1 col-md-2 col-sm-3 col-xs-12">Service Date<span
                                                        style="color:#FF0000"> *</span>
                                                </label>
                                                <div class="col-md-5 col-sm-6 col-xs-12">
                                                    <div class="col-md-5 col-sm-6 col-xs-12" style="padding-left:0px;">
                                                        <label class="radio-inline"><input type="radio" id="redio_today"
                                                                name="service_date" value="0" checked="checked"
                                                                onclick="showhideother(this.value);">Today</label>
                                                        <label class="radio-inline"><input type="radio" id="redio_other"
                                                                name="service_date" value="1"
                                                                onclick="showhideother(this.value);">Other</label>
                                                    </div>
                                                    <div class="col-md-6 col-sm-6 col-xs-12" id="service_date_div">
                                                        <input type="text" name="future_date" id="future_date"
                                                            class="form-control" placeholder="Choose Date(01-01-2000)"
                                                            data-format="YYYY-MM-DD H:mm:ss" data-date-end-date="0d"> <br />
                                                    </div>
                                                    <br>


                                                </div>
                                                @if ($errors->first('future_date'))
                                                <div class="error alert alert-danger">{{ $errors->first('future_date') }}
                                                </div>
                                                @endif
                                            </div>

                                        </div>

                                          <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="control-label1 col-md-2 col-sm-3 col-xs-12">Target Date <span style="color:#FF0000"> *</span></label>
                                                <div class="col-md-5 col-sm-6 col-xs-12">
                                                    <input type="text" name="target_date" id="target_date" class="form-control"
                                                        placeholder="Choose Target Date (YYYY-MM-DD)"
                                                        data-format="YYYY-MM-DD H:mm:ss"
                                                        autocomplete="off">
                                                </div>
                                            </div>
                                            <script>
                                                $(document).ready(function () {
                                                    $('#target_date').datepicker({
                                                        format: 'yyyy-mm-dd',
                                                        autoclose: true,
                                                        todayHighlight: true,
                                                        startDate: '0d' // optional: disables past dates
                                                    });
                                                });
                                            </script>

                                            @if ($errors->first('target_date'))
                                            <div class="error alert alert-danger">
                                                {{ $errors->first('target_date') }}
                                            </div>
                                            @endif
                                        </div>
                                       
                                        <div class="form-group">
                                            <div class="col-md-5 col-sm-6 col-xs-12">

                                                <a onclick="show_module_fun()" class="btn">See More <i
                                                        class="fa fa-chevron-down"></i></a>
                                            </div>
                                        </div>

                                        <div id="show_module">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label1 col-md-2 col-sm-3 col-xs-12">RMA Ref
                                                    </label>
                                                    <div class="col-md-5 col-sm-6 col-xs-12">
                                                        <label class="radio-inline"><input type="radio" name="rmaref"
                                                                value="1" onclick="showhiderma(this.value);"
                                                                id="rmarefyes">Yes</label>
                                                        <label class="radio-inline"><input type="radio" name="rmaref"
                                                                value="0" checked="checked"
                                                                onclick="showhiderma(this.value);">No</label>
                                                        <br />
                                                        <div class="ctktrmarefpnl" id="ctktrmarefpnl" style="display:none;">
                                                            Enter Service/Ticket No. :
                                                            <input type="text" name="rmarefticketno" id="rmarefticketno"
                                                                class="form-control ctktrmarefpnl" value="">
                                                        </div>


                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="control-label1 col-md-2 col-sm-3 col-xs-12">Check List
                                                    </label>
                                                    <div class="col-md-5 col-sm-6 col-xs-12">
                                                        <select class="form-control" name="checklist" id="checklist">
                                                            <option value="">Please Select</option>

                                                            @foreach ($checklists as $checklist)
                                                            <!-- <option value="{{ $checklist->id }}" {{ old('checklist') == "$checklist->id" ? 'selected="selected"' : '' }}>{{ $checklist->title }} </option> -->
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>

                                        <!-- end brijesh -->

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <div class="col-md-4 col-sm-6 col-xs-12 col-md-offset-5">
                                                    <button type="submit" class="btn btn-success" id="service_submit"
                                                        onclick="formsubmit()">Submit</button>
                                                    <a href="/home" class="btn btn-primary">Cancel</a>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div id="requestservice" class="tab-pane fade">


                                    <h2>Requested Service</h2>

                                    <table class="table table-bordered">
                                        <thead>
                                            <tr>
                                                <th>ID</th>
                                                <th>Product / Domain</th>
                                                <th>Message</th>
                                                <th>Request Status</th>
                                            </tr>
                                        </thead>
                                        <tbody id="RequestTable">
                                            
                                        </tbody>
                                    </table>
                                    <br>
                                    <form name="requestform" class="form-horizontal" id="submit"
                                        role="form" method="POST"
                                        action="{{ route('submit.request.service') }}"
                                        enctype="multipart/form-data" autocomplete="off">
                                        <input type="hidden" name="form_id" value="tab2">
                                        
                                        <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="control-label1 col-md-2 col-sm-3 col-xs-12">
                                                    Select Client <span style="color:#FF0000"> *</span>
                                                </label>
                                                <div class="col-md-5 col-sm-6 col-xs-12">
                                                    <select class="form-control search-select"
                                                        name="vendor_ids" id="vendor_ids">
                                                        <!-- <select class="form-control" name="vendor_id" id="scrollbars"> -->
                                                        <option value="">Please Select Client
                                                        </option>
                                                        @foreach ($vendors as $vendor)
                                                        <?php if (!empty($vendor->name)) { ?>
                                                            <option value="{{ $vendor->id }}"
                                                                {{ old('vendor_id') == "$vendor->id" ? 'selected="selected"' : '' }}>
                                                                {{ $vendor->name }}{{ empty($vendor->company_name) ? '' : ' / ' . $vendor->company_name }}
                                                            </option>
                                                        <?php } ?>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <script type="text/javascript">
                                         $(document).ready(function() {
                                            $('select[name="vendor_ids"]').on('change', function() {
                                                console.log("in");
                                                let vendorId = $(this).val();
                                                if (vendorId !== '') {
                                                    $.ajax({
                                                        url: '/admin/vendor/getRequestDetails/' + vendorId,  // define this route in web.php
                                                        type: 'GET',
                                                        success: function(response) {
                                                            updateRequestTable(response.requests);
                                                            updateExpiredProducts(response.expired_products);
                                                        },
                                                        error: function(xhr) {
                                                            console.log("Error fetching data");
                                                        }
                                                    });
                                                }
                                            });

                                            function updateRequestTable(requests) {
                                                console.log("update table");

                                                let tbody = '';
                                                $.each(requests, function(index, request) {
                                                    let statusText = '';
                                                    if (request.status === 1) {
                                                        statusText = '<span class="text-success">Approved</span>';
                                                    } else if (request.status === 2) {
                                                        statusText = '<span class="text-danger">Disapproved</span>';
                                                    } else {
                                                        statusText = '<span class="text-warning">Pending</span>';
                                                    }

                                                    tbody += `
                                                        <tr>
                                                            <td>${index + 1}</td>
                                                            <td>${request.product_name}</td>
                                                            <td>${request.message}</td>
                                                            <td>${statusText}</td>
                                                        </tr>
                                                    `;
                                                });
                                                $('#RequestTable').html(tbody);
                                            }

                                            function updateExpiredProducts(products) {
                                                console.log("update expired");
                                                let options = '<option value="">-- Please Select Expired Product --</option>';
                                                $.each(products, function(index, product) {
                                                    options += `<option value="${product.id}">
                                                                    ${product.product_name} (${product.product_code || ''})
                                                                </option>`;
                                                });
                                                $('#product_id_expired').html(options);
                                            }
                                        });

                                    </script>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="control-label1 col-md-2 col-sm-3 col-xs-12">
                                                    Select Product / Domain <span style="color:#FF0000"> *</span>
                                                </label>
                                                <div class="col-md-5 col-sm-6 col-xs-12">

                                                    <select name="product_id" id="product_id_expired"
                                                        class="form-control" required>
                                                        <option value="">-- Please Select Expired Product --
                                                        </option>
                                                    </select>
                                                    @if ($errors->first('product_id'))
                                                    <div class="error alert alert-danger">
                                                        {{ $errors->first('product_id') }}
                                                    </div>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label
                                                    class="control-label1 col-md-2 col-sm-3 col-xs-12">Message<span
                                                        style="color:#FF0000"> *</span>
                                                </label>
                                                <div class="col-md-5 col-sm-6 col-xs-12">
                                                    <textarea class="form-control" name="message" id="message" style="text-transform:capitalize" maxlength="255"
                                                        onkeyup="desccharsleft(this.value.length);" onblur="desccharsleft(this.value.length);" required>{{ old('message') }}</textarea><br>
                                                    <span id='remainingC' style="font-style: italic;">Remaining
                                                        characters
                                                        :
                                                        255</span>
                                                    <br><br>
                                                    <p style="color: #F90606 !important;">* You can only request
                                                        this
                                                        service product once. </p>
                                                    @if ($errors->first('message'))
                                                    <div class="error alert alert-danger">
                                                        {{ $errors->first('message') }}
                                                    </div>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <div class="col-md-4 col-sm-6 col-xs-12 col-md-offset-5">
                                                    <button type="submit" class="btn btn-success"
                                                        id="service_request_submit"
                                                        onclick="formsubmit()">Submit</button>
                                                    <a href="/home" class="btn btn-primary">Cancel</a>
                                                </div>
                                            </div>
                                        </div>
                                    </form>

                                    <br>
                                </div>
                                @endif
                            </div> <!-- /.ui-tabs -->

                        </div> <!-- /.panel-body -->
                    </div> <!-- /.panel -->

                </div> <!-- /.col-md-12 -->
            </div> <!-- /.row -->
        </div> <!-- /.container -->
    </div> <!-- /.content-wrapper -->


    <!-- Reset Password Modal added by gaurav on 25-feb-20 for client login -->
    <div class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" id="resetpassword">
        <div class="modal-dialog" style="z-index: 1050;margin-top: 8%;">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title" id="myModalLabel">Change Password</h4>
                </div>
                <form class="form-horizontal" role="form" method="POST" action="/changePassword">
                    <div class="modal-body">
                        <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                        <div class="form-group">
                            <label class="col-md-4 control-label">Password <span style="color:#FF0000">
                                    *</span></label>
                            <div class="col-md-6">
                                <input type="password" class="form-control" name="password" id="password"
                                    style="text-align:left" required>
                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-md-4 control-label">Confirm Password <span style="color:#FF0000">
                                    *</span></label>
                            <div class="col-md-6">
                                <input type="password" class="form-control" name="conform_password"
                                    id="conform_password" style="text-align:left" required>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-success" id="reset_password_form">Submit</button>
                        <button type="button" class="btn btn-primary" data-dismiss="modal">Cancel</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        $("#show_module").hide();

        function show_module_fun() {
            // body...
            // document.getElementById('#show_module').style.display = 'block';
            $("#show_module").show();

        }

        function formsubmit() {
            $("#submit").submit();
            document.getElementById("service_submit").disabled = true;

        }
    </script>
    <script type="text/javascript">
        function desccharsleft(charleng) {
            if (charleng > 255) {
                return false;
            }
            $("#remainingC").html("Remaining characters : " + (255 - charleng));
        }

        //Added by gaurav on 26-feb-20 for reset password on client login page..
        $('#reset_password_form').click(function() {
            if ($('#password').val() == '' || $('#conform_password').val() == '') {
                alert('please fill up * mark filled.');
                return false;
            } else if ($('#password').val() != $('#conform_password').val()) {
                alert('Password does not match the confirm password.');
                return false;
            } else if (($('#password').val().length < 6) || ($('#conform_password').val().length < 6)) {
                alert("The password must be at least 6 characters.");
                return false;
            } else {
                return true;
            }
        }); //Ending of command

        // function phonenumber(inputtxt)
        // {
        //   var phoneno = /^\d{10}$/;
        //   if(inputtxt.value.match(phoneno))
        //   {
        //       return true;
        //   }
        //   else
        //   {
        //      alert("Not a valid Phone Number");
        //      return false;
        //   }
        //   }
    </script>


    <!-- added by brijesh on 11-12-2019 -->

    <script type="text/javascript">
        $(document).ready(function() {
            $.ajax({
                type: "GET",
                url: "/service/getpriorities",
                crossDomain: true,
                dataType: "json",
                headers: {
                    'Accept': 'application/json'
                },
                xhrFields: {
                    withCredentials: true // Important!
                },
                success: function(response) {
                    var count_ch = response.priorities.length;

                    if (count_ch != 0) {

                        for (var i = 0; i < count_ch; i++) {
                            var name = (response.priorities[i].name) ? response.priorities[i].name : "";
                            var id = (response.priorities[i].id) ? response.priorities[i].id : "";
                            $('#new_priority').append($("<option></option>").attr("value", id).text(
                                name));
                        }

                    } else {
                        $('#new_priority').empty();
                        // alert('dd');
                        $("#new_priority").append($("<option></option>").text('Please Select'));
                    }

                }
            });

            $('#product_id').on('change', function() {
                $('#checklist').empty();
                $("#checklist").append($("<option></option>").text("Please Select"));

                var vendor = document.getElementById("scrollbars").value;
                var product_id = document.getElementById("product_id").value;
                var _token = $('input[name="token1"]').val();
                $('#checklist').empty();
                $("#checklist").append($("<option></option>").text('Please Select'));
                $.ajax({
                    type: "GET",
                    url: "/service/getcheklistdata",
                    data: {
                        product_id: product_id
                    },
                    success: function(response) {
                        var count_ch = response.checklist.length;
                        if (count_ch != 0) {

                            for (var i = 0; i < count_ch; i++) {
                                var title = (response.checklist[i].title) ? response.checklist[
                                    i].title : "";
                                var id = (response.checklist[i].id) ? response.checklist[i].id :
                                    "";
                                $('#checklist').append($("<option></option>").attr("value", id)
                                    .text(title));
                            }

                        } else {
                            $('#checklist').empty();
                            // alert('dd');
                            $("#checklist").append($("<option></option>").text(
                                'Please Select'));
                        }

                    }
                });
                $.ajax({
                    type: "GET",
                    url: "/service/create",
                    data: {
                        vendor: vendor,
                        product_id: product_id,
                        _token: _token
                    },
                    success: function(response) {

                        var dateOne = new Date(response.end_date); //Year, Month, Date  

                        // alert(dateOne);
                        var dateTwo = new Date(); //Year, Month, Date  
                        if (dateOne > dateTwo) {

                            $('#show_in_amc').show();
                            $('#show_in_amc').text("In AMC");
                        } else {

                            $('#show_in_amc').hide();

                        }

                    }
                });


            });

        });
    </script>

    <!-- end by brijesh -->

    <!-- added by brijesh on 13-12-2019 -->

    <script type="text/javascript">
        $(function() {

            var date = new Date();
            date.setDate(date.getDate() + 0);

            $('#future_date').datetimepicker({
                autoclose: true,
                //showOn: "none",
                timepicker: true,
                language: 'en',
                pick12HourFormat: true,
                weekStart: 0,
                calendarWeeks: true,
                autoclose: true,
                todayHighlight: true,
                rtl: true,
                minDate: 0,
                startDate: date,
                orientation: "auto"
            });
        });
    </script>

    <script type="text/javascript">
        // added by brijesh on 17-03-2020 future

        $("#service_date2").datepicker({
            format: "YY/mm/dd",
            weekStart: 0,
            calendarWeeks: true,
            autoclose: true,
            todayHighlight: true,
            rtl: true,
            minDate: +1,
            orientation: "auto"
        });

        $(document).ready(function() {
            $('#service_date_div').hide();
        });

        function showhideother(selval) {
            if (selval == '1') {
                $('#service_date_div').show();
            } else {
                $('#service_date_div').hide();
            }
        }

        // end 


        $(function() {
            $('.search-select').comboSelect()
        });


        (function(factory) {
            'use strict';
            if (typeof define === 'function' && define.amd) {
                // AMD. Register as an anonymous module.
                define(['jquery'], factory);
            } else if (typeof exports === 'object' && typeof require === 'function') {
                // Browserify
                factory(require('jquery'));
            } else {
                // Browser globals
                factory(jQuery);
            }
        }(function($, undefined) {

            var pluginName = "comboSelect",
                dataKey = 'comboselect';
            var defaults = {
                comboClass: 'combo-select',
                comboArrowClass: 'combo-arrow',
                comboDropDownClass: 'combo-dropdown',
                inputClass: 'combo-input text-input',
                disabledClass: 'option-disabled',
                hoverClass: 'option-hover',
                selectedClass: 'option-selected',
                markerClass: 'combo-marker',
                themeClass: '',
                maxHeight: 200,
                extendStyle: true,
                focusInput: true
            };

            /**
             * Utility functions
             */

            var keys = {
                    ESC: 27,
                    TAB: 9,
                    RETURN: 13,
                    LEFT: 37,
                    UP: 38,
                    RIGHT: 39,
                    DOWN: 40,
                    ENTER: 13,
                    SHIFT: 16
                },
                isMobile = (/android|webos|iphone|ipad|ipod|blackberry|iemobile|opera mini/i.test(navigator
                    .userAgent.toLowerCase()));

            /**
             * Constructor
             * @param {[Node]} element [Select element]
             * @param {[Object]} options [Option object]
             */
            function Plugin(element, options) {

                /* Name of the plugin */

                this._name = pluginName;

                /* Reverse lookup */

                this.el = element

                /* Element */

                this.$el = $(element)

                /* If multiple select: stop */

                if (this.$el.prop('multiple')) return;

                /* Settings */

                this.settings = $.extend({}, defaults, options, this.$el.data());

                /* Defaults */

                this._defaults = defaults;

                /* Options */

                this.$options = this.$el.find('option, optgroup')

                /* Initialize */

                this.init();

                /* Instances */

                $.fn[pluginName].instances.push(this);

            }

            $.extend(Plugin.prototype, {
                init: function() {

                    /* Construct the comboselect */

                    this._construct();


                    /* Add event bindings */

                    this._events();


                },
                _construct: function() {

                    var self = this

                    /**
                     * Add negative TabIndex to `select`
                     * Preserves previous tabindex
                     */

                    this.$el.data('plugin_' + dataKey + '_tabindex', this.$el.prop('tabindex'))

                        /* Add a tab index for desktop browsers */

                        !isMobile && this.$el.prop("tabIndex", -1)

                    /**
                     * Wrap the Select
                     */

                    this.$container = this.$el.wrapAll('<div class="' + this.settings.comboClass + ' ' +
                        this.settings.themeClass + '" />').parent();

                    /**
                     * Check if select has a width attribute
                     */
                    if (this.settings.extendStyle && this.$el.attr('style')) {

                        this.$container.attr('style', this.$el.attr("style"))

                    }


                    /**
                     * Append dropdown arrow
                     */

                    this.$arrow = $('<div class="' + this.settings.comboArrowClass + '" />').appendTo(
                        this.$container)


                    /**
                     * Append dropdown
                     */

                    this.$dropdown = $('<ul class="' + this.settings.comboDropDownClass + '" />')
                        .appendTo(this.$container)


                    /**
                     * Create dropdown options
                     */

                    this._build();

                    /**
                     * Append Input
                     */

                    this.$input = $('<input type="text"' + (isMobile ? 'tabindex="-1"' : '') +
                        ' placeholder="' + this.getPlaceholder() + '" class="' + this.settings
                        .inputClass + '">').appendTo(this.$container)

                    /* Update input text */

                    this._updateInput()

                },
                getPlaceholder: function() {

                    var p = '';

                    this.$options.filter(function(idx, opt) {

                        return opt.nodeName == 'OPTION'
                    }).each(function(idx, e) {

                        if (e.value == '') p = e.innerHTML
                    });

                    return p
                },
                _build: function() {

                    var self = this;

                    var o = '',
                        k = 0;

                    this.$options.each(function(i, e) {

                        if (e.nodeName.toLowerCase() == 'optgroup') {

                            return o += '<li class="option-group">' + this.label + '</li>'
                        }

                        o += '<li class="' + (this.disabled ? self.settings.disabledClass :
                                "option-item") + ' ' + (k == self.$el.prop('selectedIndex') ?
                                self.settings.selectedClass : '') + '" data-index="' + (k) +
                            '" data-value="' + this.value + '">' + (this.innerHTML) + '</li>'

                        k++;
                    })

                    this.$dropdown.html(o)

                    /**
                     * Items
                     */

                    this.$items = this.$dropdown.children();
                },

                _events: function() {

                    /* Input: focus */

                    this.$container.on('focus.input', 'input', $.proxy(this._focus, this))

                    /**
                     * Input: mouseup
                     * For input select() event to function correctly
                     */
                    this.$container.on('mouseup.input', 'input', function(e) {
                        e.preventDefault()
                    })

                    /* Input: blur */

                    this.$container.on('blur.input', 'input', $.proxy(this._blur, this))

                    /* Select: change */

                    this.$el.on('change.select', $.proxy(this._change, this))

                    /* Select: focus */

                    this.$el.on('focus.select', $.proxy(this._focus, this))

                    /* Select: blur */

                    this.$el.on('blur.select', $.proxy(this._blurSelect, this))

                    /* Dropdown Arrow: click */

                    this.$container.on('click.arrow', '.' + this.settings.comboArrowClass, $.proxy(this
                        ._toggle, this))

                    /* Dropdown: close */

                    this.$container.on('comboselect:close', $.proxy(this._close, this))

                    /* Dropdown: open */

                    this.$container.on('comboselect:open', $.proxy(this._open, this))

                    /* Dropdown: update */

                    this.$container.on('comboselect:update', $.proxy(this._update, this));


                    /* HTML Click */

                    $('html').off('click.comboselect').on('click.comboselect', function() {

                        $.each($.fn[pluginName].instances, function(i, plugin) {

                            plugin.$container.trigger('comboselect:close')

                        })
                    });

                    /* Stop `event:click` bubbling */

                    this.$container.on('click.comboselect', function(e) {
                        e.stopPropagation();
                    })


                    /* Input: keydown */

                    this.$container.on('keydown', 'input', $.proxy(this._keydown, this))

                    /* Input: keyup */

                    this.$container.on('keyup', 'input', $.proxy(this._keyup, this))

                    /* Dropdown item: click */

                    this.$container.on('click.item', '.option-item', $.proxy(this._select, this))

                },

                _keydown: function(event) {



                    switch (event.which) {

                        case keys.UP:
                            this._move('up', event)
                            break;

                        case keys.DOWN:
                            this._move('down', event)
                            break;

                        case keys.TAB:
                            this._enter(event)
                            break;

                        case keys.RIGHT:
                            this._autofill(event);
                            break;

                        case keys.ENTER:
                            this._enter(event);
                            break;

                        default:
                            break;


                    }

                },


                _keyup: function(event) {

                    switch (event.which) {
                        case keys.ESC:
                            this.$container.trigger('comboselect:close')
                            break;

                        case keys.ENTER:
                        case keys.UP:
                        case keys.DOWN:
                        case keys.LEFT:
                        case keys.RIGHT:
                        case keys.TAB:
                        case keys.SHIFT:
                            break;

                        default:
                            this._filter(event.target.value)
                            break;
                    }
                },

                _enter: function(event) {

                    var item = this._getHovered()

                    item.length && this._select(item);

                    /* Check if it enter key */
                    if (event && event.which == keys.ENTER) {

                        if (!item.length) {

                            /* Check if its illegal value */

                            this._blur();

                            return true;
                        }

                        event.preventDefault();
                    }


                },
                _move: function(dir) {

                    var items = this._getVisible(),
                        current = this._getHovered(),
                        index = current.prevAll('.option-item').filter(':visible').length,
                        total = items.length


                    switch (dir) {
                        case 'up':
                            index--;
                            (index < 0) && (index = (total - 1));
                            break;

                        case 'down':
                            index++;
                            (index >= total) && (index = 0);
                            break;
                    }


                    items
                        .removeClass(this.settings.hoverClass)
                        .eq(index)
                        .addClass(this.settings.hoverClass)


                    if (!this.opened) this.$container.trigger('comboselect:open');

                    this._fixScroll()
                },

                _select: function(event) {

                    var item = event.currentTarget ? $(event.currentTarget) : $(event);

                    if (!item.length) return;

                    /**
                     * 1. get Index
                     */

                    var index = item.data('index');

                    this._selectByIndex(index);

                    //this.$container.trigger('comboselect:close')

                    this.$input.focus();

                    this.$container.trigger('comboselect:close');

                },

                _selectByIndex: function(index) {

                    /**
                     * Set selected index and trigger change
                     * @type {[type]}
                     */
                    if (typeof index == 'undefined') {

                        index = 0

                    }

                    if (this.$el.prop('selectedIndex') != index) {

                        this.$el.prop('selectedIndex', index).trigger('change');
                    }

                },

                _autofill: function() {

                    var item = this._getHovered();

                    if (item.length) {

                        var index = item.data('index')

                        this._selectByIndex(index)

                    }

                },


                _filter: function(search) {

                    var self = this,
                        items = this._getAll();
                    needle = $.trim(search).toLowerCase(),
                        reEscape = new RegExp('(\\' + ['/', '.', '*', '+', '?', '|', '(', ')', '[', ']',
                            '{', '}', '\\'
                        ].join('|\\') + ')', 'g'),
                        pattern = '(' + search.replace(reEscape, '\\$1') + ')';


                    /**
                     * Unwrap all markers
                     */

                    $('.' + self.settings.markerClass, items).contents().unwrap();

                    /* Search */

                    if (needle) {

                        /* Hide Disabled and optgroups */

                        this.$items.filter('.option-group, .option-disabled').hide();


                        items
                            .hide()
                            .filter(function() {

                                var $this = $(this),
                                    text = $.trim($this.text()).toLowerCase();

                                /* Found */
                                if (text.toString().indexOf(needle) != -1) {

                                    /**
                                     * Wrap the selection
                                     */

                                    $this
                                        .html(function(index, oldhtml) {
                                            return oldhtml.replace(new RegExp(pattern, 'gi'),
                                                '<span class="' + self.settings
                                                .markerClass + '">$1</span>')
                                        })

                                    return true
                                }

                            })
                            .show()
                    } else {


                        this.$items.show();
                    }

                    /* Open the comboselect */

                    this.$container.trigger('comboselect:open')


                },

                _highlight: function() {

                    /*
                    1. Check if there is a selected item
                    2. Add hover class to it
                    3. If not add hover class to first item
                    */

                    var visible = this._getVisible().removeClass(this.settings.hoverClass),
                        $selected = visible.filter('.' + this.settings.selectedClass)

                    if ($selected.length) {

                        $selected.addClass(this.settings.hoverClass);

                    } else {

                        visible
                            .removeClass(this.settings.hoverClass)
                            .first()
                            .addClass(this.settings.hoverClass)
                    }

                },

                _updateInput: function() {

                    var selected = this.$el.prop('selectedIndex')

                    if (this.$el.val()) {

                        text = this.$el.find('option').eq(selected).text()

                        this.$input.val(text)

                    } else {

                        this.$input.val('')

                    }

                    return this._getAll()
                        .removeClass(this.settings.selectedClass)
                        .filter(function() {

                            return $(this).data('index') == selected
                        })
                        .addClass(this.settings.selectedClass)

                },
                _blurSelect: function() {

                    this.$container.removeClass('combo-focus');

                },
                _focus: function(event) {

                    /* Toggle focus class */

                    this.$container.toggleClass('combo-focus', !this.opened);

                    /* If mobile: stop */

                    if (isMobile) return;

                    /* Open combo */

                    if (!this.opened) this.$container.trigger('comboselect:open');

                    /* Select the input */

                    this.settings.focusInput && event && event.currentTarget && event.currentTarget
                        .nodeName == 'INPUT' && event.currentTarget.select()
                },

                _blur: function() {

                    /**
                     * 1. Get hovered item
                     * 2. If not check if input value == select option
                     * 3. If none
                     */

                    var val = $.trim(this.$input.val().toLowerCase()),
                        isNumber = !isNaN(val);

                    var index = this.$options.filter(function() {
                        return this.nodeName == 'OPTION'
                    }).filter(function() {
                        var _text = this.innerText || this.textContent
                        if (isNumber) {
                            return parseInt($.trim(_text).toLowerCase()) == val
                        }

                        return $.trim(_text).toLowerCase() == val

                    }).prop('index')

                    /* Select by Index */

                    this._selectByIndex(index)

                },

                _change: function() {


                    this._updateInput();

                },

                _getAll: function() {

                    return this.$items.filter('.option-item')

                },
                _getVisible: function() {

                    return this.$items.filter('.option-item').filter(':visible')

                },

                _getHovered: function() {

                    return this._getVisible().filter('.' + this.settings.hoverClass);

                },

                _open: function() {

                    var self = this

                    this.$container.addClass('combo-open')

                    this.opened = true

                    /* Focus input field */

                    this.settings.focusInput && setTimeout(function() {
                        !self.$input.is(':focus') && self.$input.focus();
                    });

                    /* Highligh the items */

                    this._highlight()

                    /* Fix scroll */

                    this._fixScroll()

                    /* Close all others */


                    $.each($.fn[pluginName].instances, function(i, plugin) {

                        if (plugin != self && plugin.opened) plugin.$container.trigger(
                            'comboselect:close')
                    })

                },

                _toggle: function() {

                    this.opened ? this._close.call(this) : this._open.call(this)
                },

                _close: function() {

                    this.$container.removeClass('combo-open combo-focus')

                    this.$container.trigger('comboselect:closed')

                    this.opened = false

                    /* Show all items */

                    this.$items.show();

                },
                _fixScroll: function() {

                    /**
                     * If dropdown is hidden
                     */
                    if (this.$dropdown.is(':hidden')) return;


                    /**
                     * Else
                     */
                    var item = this._getHovered();

                    if (!item.length) return;

                    /**
                     * Scroll
                     */

                    var offsetTop,
                        upperBound,
                        lowerBound,
                        heightDelta = item.outerHeight()

                    offsetTop = item[0].offsetTop;

                    upperBound = this.$dropdown.scrollTop();

                    lowerBound = upperBound + this.settings.maxHeight - heightDelta;

                    if (offsetTop < upperBound) {

                        this.$dropdown.scrollTop(offsetTop);

                    } else if (offsetTop > lowerBound) {

                        this.$dropdown.scrollTop(offsetTop - this.settings.maxHeight + heightDelta);
                    }

                },
                /**
                 * Update API
                 */

                _update: function() {

                    this.$options = this.$el.find('option, optgroup')

                    this.$dropdown.empty();

                    this._build();
                },

                /**
                 * Destroy API
                 */

                dispose: function() {

                    /* Remove combo arrow, input, dropdown */

                    this.$arrow.remove()

                    this.$input.remove()

                    this.$dropdown.remove()

                    /* Remove tabindex property */
                    this.$el
                        .removeAttr("tabindex")

                    /* Check if there is a tabindex set before */

                    if (!!this.$el.data('plugin_' + dataKey + '_tabindex')) {
                        this.$el.prop('tabindex', this.$el.data('plugin_' + dataKey + '_tabindex'))
                    }

                    /* Unwrap */

                    this.$el.unwrap()

                    /* Remove data */

                    this.$el.removeData('plugin_' + dataKey)

                    /* Remove tabindex data */

                    this.$el.removeData('plugin_' + dataKey + '_tabindex')

                    /* Remove change event on select */

                    this.$el.off('change.select focus.select blur.select');

                }
            });



            // A really lightweight plugin wrapper around the constructor,
            // preventing against multiple instantiations
            $.fn[pluginName] = function(options, args) {

                this.each(function() {

                    var $e = $(this),
                        instance = $e.data('plugin_' + dataKey)

                    if (typeof options === 'string') {

                        if (instance && typeof instance[options] === 'function') {
                            instance[options](args);
                        }

                    } else {

                        if (instance && instance.dispose) {
                            instance.dispose();
                        }

                        $.data(this, "plugin_" + dataKey, new Plugin(this, options));

                    }

                });

                // chain jQuery functions
                return this;
            };

            $.fn[pluginName].instances = [];

        }));
    </script>
    <!-- end added by brijesh on 12-12-2019 -->
    <!-- //added by sundaram on 14-06-2021 for service provider start -->
    <script type="text/javascript">
        $('#scrollbars').change(function() {
            var clientsec_id = $(this).val();
            //alert(clientsec_id);

            $.ajax({
                type: "POST",
                dataType: "json",
                url: "spclient",
                data: {
                    '_token': '{{ csrf_token() }}',
                    'clientsec_id': clientsec_id
                },
                success: function(data) {
                    // alert(data[0].id);
                    $('#service_id').val(data[0].id);
                }

            });

        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const productSelect = document.getElementById('product_id');
            const label = document.getElementById('show_in_amc');
            const submitBtn = document.getElementById('service_submit');
            let timeoutId = null;

            function checkExpiryMessage() {
                clearTimeout(timeoutId);

                const selectedOption = productSelect.options[productSelect.selectedIndex];
                const status = selectedOption.getAttribute('data-status');
                const allowed = selectedOption.getAttribute('data-allowed');
                const service_requested_id  = selectedOption.getAttribute('data-service_requested_id');
                const selectedText = selectedOption.text;

                console.log("in", allowed);
                console.log("OUT", status);
                const radios = document.getElementsByName('service_type');
                radios.forEach(radio => {
                    radio.disabled = false;
                    radio.checked = false;
                });
                $('#service_requested_id').val(0);


                if (status === 'expired' && allowed === 'true') {
                    alert(`⚠️ The AMC of product '${selectedText}' is expired And this is your last Service for this AMC please Renew Your AMC`);
                    // submitBtn.disabled = true;
                    const radios = document.getElementsByName('service_type');
                    radios.forEach(radio => {
                        if (radio.value === 'AMC visiting') {
                            radio.disabled = false;
                            radio.checked = true;
                        } else {
                            radio.disabled = true;
                            radio.checked = false;
                        }
                    });
                    $('#service_requested_id').val(service_requested_id);

                    timeoutId = setTimeout(() => {
                        label.innerText = '';
                    }, 8000);
                } else if (status === 'not_created') {
                    // alert(`⚠️ Your product '${selectedText}' is expired. And this is your last Service for this AMC please Renew Your AMC`);
                    const radios = document.getElementsByName('service_type');
                    radios.forEach(radio => {
                        console.log(radio.value);
                        if (radio.value === 'AMC visiting') {
                            radio.disabled = true;
                            radio.checked = false;
                        } else {
                            radio.disabled = false;
                            radio.checked = true;
                        }
                    });
                    $('#service_requested_id').val(0);
                    
                    label.innerText = '';
                    submitBtn.disabled = false;
                } else if (status === 'expired' && allowed !== 'true') {
                    alert(`⚠️ The AMC of product '${selectedText}' is expired.`);
                    const radios = document.getElementsByName('service_type');
                    radios.forEach(radio => {
                        console.log(radio.value);
                        if (radio.value === 'AMC visiting') {
                            radio.disabled = true;
                            radio.checked = false;
                        } else {
                            radio.disabled = false;
                            radio.checked = true;
                        }
                    });
                    $('#service_requested_id').val(0);
                    label.innerText = '';
                    submitBtn.disabled = false;
                } else if (status === 'active') {
                    const radios = document.getElementsByName('service_type');
                    console.log("hello");
                    radios.forEach(radio => {
                        console.log(radio.value);
                        if (radio.value === 'AMC visiting') {
                            radio.disabled = false;
                            radio.checked = true;
                        } else {
                            radio.disabled = true;
                            radio.checked = false;
                        }
                    });
                    $('#service_requested_id').val(0);
                    label.innerText = '';
                    submitBtn.disabled = false;
                } else {
                    label.innerText = '';
                    submitBtn.disabled = false;
                    $('#service_requested_id').val(0);
                }
            }

            productSelect.addEventListener('change', checkExpiryMessage);
            checkExpiryMessage(); // Run once on page load
        });

        $(document).ready(function() {
            var activeTab = localStorage.getItem('activeTab');

            if (activeTab) {
                // Convert tab ID to href (#createservice / #requestservice)
                var tabHref = (activeTab === 'tab1') ? '#createservice' : '#requestservice';

                $('.nav-tabs a[href="' + tabHref + '"]').tab('show');
            } else {
                // Default to tab1 if nothing is stored
                $('.nav-tabs a[href="#createservice"]').tab('show');
            }
        });


        // added by hari for reload same form after submit 
        function changetabval(tabId, tabLiId) {
            localStorage.setItem('activeTab', tabId); // Save to localStorage
        }
    </script>

    <script>
        // Wait until the DOM is fully loaded
        document.addEventListener('DOMContentLoaded', function() {
            // Select success and error alerts
            const successAlert = document.querySelector('.alert-success');
            const errorAlert = document.querySelector('.alert-danger1');

            // Auto-hide success alert
            if (successAlert) {
                setTimeout(() => {
                    successAlert.style.display = 'none';
                }, 6000); // 4 seconds
            }

            // Auto-hide error alert
            if (errorAlert) {
                setTimeout(() => {
                    errorAlert.style.display = 'none';
                }, 6000); // 4 seconds
            }
        });
    </script>

    @endsection