@extends('app')

@section('content')
<div class="container">
    <h1 class="page-head-line">Edit Service Type</h1>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">@foreach ($errors->all() as $error) <li>{{ $error }}</li> @endforeach</ul>
        </div>
    @endif

    <form action="{{ route('service-types.update', $serviceType->id) }}" method="POST">
        <input type="hidden" name="_token" value="{{ csrf_token() }}" />
         <input type="hidden" name="_method" value="PUT" />

        <div class="form-group">
            <label>Service Type</label>
            <input type="text" name="service_type" class="form-control" value="{{ old('service_type', $serviceType->service_type) }}" required>
        </div>
        <div class="form-group">
            <label>Status</label>
            <select name="status" class="form-control">
                <option value="1" {{ $serviceType->status ? 'selected' : '' }}>Active</option>
                <option value="0" {{ !$serviceType->status ? 'selected' : '' }}>Inactive</option>
            </select>
        </div>

        <button class="btn btn-primary">Update</button>
        <a href="{{ route('service-types.index') }}" class="btn btn-secondary">Cancel</a>
    </form>
</div>
@endsection
