@extends('app')

@section('content')
<div class="container">
  
    <h1 class="page-head-line">Add Service Type</h1>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">@foreach ($errors->all() as $error) <li>{{ $error }}</li> @endforeach</ul>
        </div>
    @endif

    <form action="{{ route('service-types.store') }}" method="POST">
        <input type="hidden" name="_token" value="{{ csrf_token() }}" />
 
        <div class="form-group">
            <label>Service Type</label>
            <input type="text" name="service_type" class="form-control" value="{{ old('service_type') }}" required>
        </div>
        <div class="form-group">
            <label>Status</label>
            <select name="status" class="form-control">
                <option value="1" selected>Active</option>
                <option value="0">Inactive</option>
            </select>
        </div>
        <button class="btn btn-success">Create</button>
        <a href="{{ route('service-types.index') }}" class="btn btn-secondary">Cancel</a>
    </form>
</div>
@endsection
