﻿@extends('app')
@section('content')
<title>Client Report</title>
<style type="text/css">
.text_font{
    font-size: 11px;
    text-align: left !important;
}
.padding_filter{
    padding-top: 5px !important;
}
td, th {
    /*font-size: 12px;*/
}

/* For fixed table thead */
table {
    /*table-layout:fixed;*/
}

.div-table-content {
  max-height: 100%;
  overflow-y:auto;
}
.scorll {
  width: 98.5%;
  margin-bottom: 0px;
  border-bottom: none !important;
}
</style>

<div class="content-wrapper">
    <div class="container-fluid">
      <div class="row">
        <div class="col-md-12">
          <?php 
              if( !count($_GET) ) { 
                  $url_parameter = '?report=1';
              } else {
                  $url_parameter = $_SERVER['REQUEST_URI'].'&report=1';
              }
          ?>
            <a href="<?php echo $url_parameter; ?>" data-toggle="tooltip" title="" class="btn btn-primary" data-original-title="Download Excel" style="float:right;margin-right:2%;margin-top:1%">DOWNLOAD EXCEL <i class="fa fa-download"></i></a>
            <h1 class="page-head-line">Client Report</h1>
        </div>
      </div>
    <div class="row">
        <div class="col-md-2 report_leftpanel">
            <form class="form-horizontal" role="form" method="GET" action="/customer_report" id="report-frm" name="report-frm">
                <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}" />
                <!-- Changes by gaurav on 4-march-2020 to make date filter in client report -->
                <label style="padding: 0px;margin-top: 2%;">Start Date :</lable>
                <div class="col-md-12 padding_filter" style="padding:0px">
                    <div class="input-group date">
                      <input type="text" id="report_start_date" name="start_date" data-format="DD-MM-YYYY" class="form-control" placeholder="dd-mm-yy" value =  "<?php if(isset($_GET['start_date'])) echo $_GET['start_date']; ?>" >
                      <span class="input-group-btn">
                      <button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
                      </span>
                    </div>
                </div>

                <label style="padding: 0px;margin-top: 2%;">End Date :</lable>
                <div class="col-md-12 padding_filter" style="padding:0px">
                    <div class="input-group date">
                      <input type="text" id="report_end_date" name="end_date" data-format="DD-MM-YYYY" class="form-control" placeholder="dd-mm-yy" value = "<?php if(!empty($_GET['end_date'])) echo $_GET['end_date']; ?>" >
                      <span class="input-group-btn">
                      <button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
                      </span>
                    </div>
                </div>
                <label class="col-md-12 control-label" style="padding:0px;margin-top: 2%;text-align:left;">Status:</label>
                <div class="col-md-12" style="padding-left: 0px;">
                 @foreach($types as $type)
                    <label class="checkbox-inline" style="margin-left: 0px;"><input type="checkbox" class="biker_list_sort" name="biker_type[]" value="<?php echo $type; ?>" style="margin-top: 0%;" <?php if(isset($_GET['biker_type'])) {  if(in_array($type, $_GET['biker_type'])) { echo "checked";}} ?>><?php if($type == 'Runner'){ echo "Biker"; } else { echo $type; } ?></label>  
                  @endforeach
                </div>
                <label class="col-md-12 control-label" style="padding:0px;margin-top: 2%;text-align:left;">Client Name: </label>
                  <div class="col-md-12 padding_filter" style="padding:0px">
                    <p><span id="tags-input" class="selectivity-input" name="bikers_list" id="bikers_list" style="width:100%;font-size: 11px;"></span></p>
                    <textarea name="bikers_id" id="bikers_id" style="display:none;"></textarea>
                  </div>
				  <label class="col-md-12 control-label" style="padding:0px;margin-top: 2%;text-align:left;">Email: </label>
               <?php 
                  if(isset($_GET['filter_shipment'])) { 
                      $filter_shipment = $_GET['filter_shipment'];
                  } else {
                     $filter_shipment ="";
                  } 
              ?>
              <div class="col-md-12" style="padding:0px">
                <input type="text" class="form-control" name="filter_shipment" value="<?php echo $filter_shipment; ?>">
              </div>

              

                <!-- <label class="col-md-12 control-label" style="padding:0px;margin-top: 2%;text-align:left;">Biker Type: </label>
                  <div class="col-md-12 padding_filter" style="padding:0px">
                    <select name="biker_type" id="biker_type" class="form-control">
                        <option value="">Select Biker Type</option>
                        <option value="Tempo" <?php if(!empty($_GET['biker_type']) && $_GET['biker_type'] == 'Tempo') echo "selected='selected'" ?>>Tempo</option>
                        <option value="Train" <?php if(!empty($_GET['biker_type']) && $_GET['biker_type'] == 'Train') echo "selected='selected'" ?>>Train</option>
                        <option value="Runner" <?php if(!empty($_GET['biker_type']) && $_GET['biker_type'] == 'Runner') echo "selected='selected'" ?>>Biker</option>
                    </select>
                  </div> -->
            
                <p style="clear: both;text-align: center;padding-top: 3%;"><input type="submit" class="btn btn-success" id="biker_form_submit" value="Search" style="margin-right: 5px;"/>
                  <button onclick="reset_tags_box();return false;" class="btn btn-success" id="shipment_form_reset">Clear</button>
                </p>
            </form>
    	</div>
    	<div class="col-md-9">
    		<!-- <table class="table table-striped table-bordered scorll" id="header_table">
    			<thead>
    				<tr>
                <th>Company Name</th>
                <th>Address</th>
                <th>Name</th>
                <th>Email</th>
                <th>Mobile No</th>
				<th>Landline No</th>
				<th>Status</th>
    			</tr>
    			</thead>
    			<tbody>
        </table> -->
        <?php //echo "<pre>"; print_r($bikers);die; ?>
        <div class="div-table-content">
            <table class="table table-striped table-bordered" id="content_table">
              <tbody>
                <thead>
            <tr>
              
               
                <th>Name</th>
                  <th>Company Name</th>
                <th>Email</th>
                <th>Contact No</th>
        <th>Client Type</th>
         <th>State</th>
       <!--  <th>Start Date</th> -->
    <!--    <th>Leaving Date</th>   -->
    <th>Services Assigned</th>
        <th>Status</th>
          </tr>
          </thead>
  <?php if(count($bikers) == 0){
                ?>
                <tr><td colspan="8">Sorry No Data Available in Client Report...</td></tr>
                <?php } ?>
                                    <?php $i=1; ?>             
                  @foreach($bikers as $biker)
                  <?php
                  $joining_date = $leaving_date = '-';
                    if(!is_null($biker->created_at) && !($biker->created_at=='')) { $joining_date = date('d-m-Y',strtotime($biker->created_at)); }
                    if(!is_null($biker->deleted_at) && !($biker->deleted_at=='')) { $leaving_date = date('d-m-Y',strtotime($biker->deleted_at)); }
                  ?>
                		<tr>
                       
                       <td><a href="managevendor/{{ $biker->id }}?sort=vendor.name&order=ASC&filter_name=&page=1">{{ $biker->name }}</a></td>
                        <td>{{ $biker->company_name}}</td>
                      
                        
                        <td>{{ $biker->email }}</td>
                        <td>Mob: {{ $biker->mobile_no }} / Ph: {{ $biker->landline_no }}</td>
						<td>{{  (($biker->client_type=="C")?"Normal Client":'Supplier') }}</td>
              <td>{{ $biker->state }}</td>
            <!-- <td><?php echo $joining_date;?></td> -->
      <!--      <td><?php echo $leaving_date;?></td>    -->

                          <td>
                                <a href="/report?_token=&substation_id=&start_date=&end_date=&biker_id=&vendor_id=<?php echo $biker->id; ?>&filter_shipment=">View Services</a>
                        </td>
						 <td>{{ $biker->status }}</td>
          					</tr>
          				@endforeach
                    
    			    </tbody>
    		    </table>
    	</div>
      <?php echo $bikers->appends($_GET)->render(); ?>
    </div>
  </div>
</div>
<!-- Bikers Auto list js -->
<link href="/assets/autocomplete/selectivity-full.css" rel="stylesheet">
<script src="/assets/autocomplete/zepto.js"></script>
<script src="/assets/autocomplete/selectivity-full.js"></script>

<script type="text/javascript">
$(document).ready(function(){
      $("#report_end_date").datetimepicker({
        <?php if(!isset($_GET['end_date'])) { ?>
            defaultDate: new Date()
        <?php } ?>
      });
      var currentDate = new Date();
      var currentMonth = currentDate.getMonth() - 1;
      var currentYear = currentDate.getFullYear();
      var currentDay = currentDate.getDate();
      $("#report_start_date").datetimepicker({
            <?php if(!isset($_GET['start_date'])) { ?>
              defaultDate: new Date(currentYear, currentMonth, currentDay)
            <?php } ?>
      });
      $('#tags-input').selectivity({
          items: [<?php foreach ($bikers_list as $key => $biker) { ?>{id: <?php echo $biker->id; ?>, text:"<?php echo $biker->name.(empty($biker->company_name)?:' / '.$biker->company_name) ?>"}, <?php } ?>],
          multiple: true,
      });

      $('#biker_form_submit').click(function() {
            var data = $('.selectivity-input').selectivity('data');
            var bikers_id = [];
            for (var i = 0; i < data.length; i++) {
                bikers_id[i] = data[i].id;
            };
            $('#bikers_id').val(bikers_id.toString());
      });
      <?php
      if(!empty($_GET['bikers_id'])){
        $selected = explode(',', $_GET['bikers_id']);
        foreach ($selected as $value) { ?>
          $('#tags-input').selectivity('add', <?php echo $value; ?>);
      <?php } } ?>

  $("#content_table").width($("#header_table").width());
});

function reset_tags_box()
    {
      //$('#report-frm')[0].reset();
      $('#report-frm').find(':input').not(':button, :submit, :reset, :hidden, :checkbox, :radio').val('');
      $('#report-frm').find(':checkbox, :radio').prop('checked', false);
      $("#tags-input .selectivity-multiple-selected-item").remove();
      var blankarr = new Array();
      $('.selectivity-input').selectivity('data',blankarr);
      $('#report-frm').submit();
    }

</script>
@endsection
