@extends('app')
@section('content')
<title>Technician Report</title>
<style type="text/css">
.text_font{
    font-size: 11px;
    text-align: left !important;
}
.padding_filter{
    padding-top: 5px !important;
}
td, th {
   /* font-size: 12px;*/
}

/* For fixed table thead */
table {
    /*table-layout:fixed;*/
}

.div-table-content {
  max-height: 370px;
  overflow-y:auto;
}
.scorll {
  width: 98.5%;
  margin-bottom: 0px;
  border-bottom: none !important;
}
</style>

<div class="content-wrapper">
    <div class="container-fluid">
      <div class="row">
        <div class="col-md-12">
          <?php 
              if( !count($_GET) ) { 
                  $url_parameter = '?report=1';
              } else {
                  $url_parameter = $_SERVER['REQUEST_URI'].'&report=1';
              }
          ?>

            <a href="<?php echo $url_parameter; ?>" data-toggle="tooltip" title="" class="btn btn-primary" data-original-title="Download Excel" style="float:right;margin-right:2%;margin-top:1%">DOWNLOAD EXCEL <i class="fa fa-download"></i></a>
            <h1 class="page-head-line">Technician Report</h1>
        </div>
      </div>
    <div class="row">
       <div class="col-md-2 report_leftpanel">
            <form role="form" method="GET" action="/bikers_report" id="report-frm" name="report-frm">
                <input type="hidden" name="_token" id="token" value="{{ csrf_token() }}" />
              <label style="padding: 0px;margin-top: 2%;">Start Date :</lable>
                <div class="col-md-12 padding_filter" style="padding:0px">
                    <div class="input-group date">
                      <input type="text" id="report_start_date" name="start_date" data-format="DD-MM-YYYY" class="form-control" placeholder="dd-mm-yy" value =  "<?php if(isset($_GET['start_date'])) echo $_GET['start_date']; ?>" >
                      <span class="input-group-btn">
                      <button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
                      </span>
                    </div>
                </div>

              <label style="padding: 0px;margin-top: 2%;">End Date :</lable>
                <div class="col-md-12 padding_filter" style="padding:0px">
                    <div class="input-group date">
                      <input type="text" id="report_end_date" name="end_date" data-format="DD-MM-YYYY" class="form-control" placeholder="dd-mm-yy" value = "<?php if(!empty($_GET['end_date'])) echo $_GET['end_date']; ?>" >
                      <span class="input-group-btn">
                      <button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
                      </span>
                    </div>
                </div>
                <!-- Added by gaurav to make date filter in technician report on 4-march-2020 -->
                <!--<label class="col-md-12 control-label" style="padding:0px;margin-top: 2%;">Start Date: </label>
                <div class="col-md-12" style="padding:0px">
                  <div class="input-group date">
                      <input  type="text" id="report_start_date" name="start_date" value="<?php if(isset($_GET['start_date'])) { echo $_GET['start_date']; } ?>" data-format="DD-MM-YYYY" class="form-control" placeholder="DD-MM-YYYY" onChange="chPy()" >
                      <span class="input-group-btn">
                      <button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
                      </span>
                    </div>
                </div>
                <label class="col-md-12 control-label" style="padding:0px;margin-top: 2%;">End Date: </label>
                <div class="col-md-12" style="padding:0px">
                  <div class="input-group date">
                      <input type="text" id="report_end_date" name="end_date" value="<?php if(isset($_GET['end_date'])) { echo $_GET['end_date']; }   ?>" data-format="DD-MM-YYYY" class="form-control" placeholder="DD-MM-YYYY"  >
                      <span class="input-group-btn">
                      <button type="button" class="btn btn-default" ><i class="fa fa-calendar" readonly></i></button>
                      </span>
                    </div>
                </div>--> <!-- ended here code for filter -->

                <label class="col-md-12 control-label" style="padding:0px;margin-top: 2%;text-align:left;">Status:</label>
                <div class="col-md-12" style="padding-left: 0px;">
                 @foreach($types as $type)
                    <label class="checkbox-inline" style="margin-left: 0px;"><input type="checkbox" class="biker_list_sort" name="biker_type[]" value="<?php echo $type; ?>" style="margin-top: 0%;" <?php if(isset($_GET['biker_type'])) {  if(in_array($type, $_GET['biker_type'])) { echo "checked";}} ?>><?php if($type == 'Runner'){ echo "Biker"; } else { echo $type; } ?></label>  
                  @endforeach
                </div>
                <label class="col-md-12 control-label" style="padding:0px;margin-top: 2%;text-align:left;">Technician Name: </label>
                  <div class="col-md-12 padding_filter" style="padding:0px">
                    <p><span id="tags-input" class="selectivity-input" name="bikers_list" id="bikers_list" style="width:100%;font-size: 11px;"></span></p>
                    <textarea name="bikers_id" id="bikers_id" style="display:none;"></textarea>
                  </div>

                <!-- <label class="col-md-12 control-label" style="padding:0px;margin-top: 2%;text-align:left;">Biker Type: </label>
                  <div class="col-md-12 padding_filter" style="padding:0px">
                    <select name="biker_type" id="biker_type" class="form-control">
                        <option value="">Select Biker Type</option>
                        <option value="Tempo" <?php if(!empty($_GET['biker_type']) && $_GET['biker_type'] == 'Tempo') echo "selected='selected'" ?>>Tempo</option>
                        <option value="Train" <?php if(!empty($_GET['biker_type']) && $_GET['biker_type'] == 'Train') echo "selected='selected'" ?>>Train</option>
                        <option value="Runner" <?php if(!empty($_GET['biker_type']) && $_GET['biker_type'] == 'Runner') echo "selected='selected'" ?>>Biker</option>
                    </select>
                  </div> -->
            
                <p style="clear: both;text-align: center;padding-top: 3%;"><input type="submit" class="btn btn-success" id="biker_form_submit" value="Search" style="margin-right: 5px;"/>
                  <button onclick="reset_tags_box();return false;" class="btn btn-success" id="shipment_form_reset" >Clear</button>
                </p>
            </form>
    	</div>
    	<div class="col-md-9">
    <!-- 		<table class="table table-striped table-bordered scorll" id="header_table">
    			<thead>
    				<tr>
                <th>Name</th>
                <th>Email</th>
                <th>Mobile</th>
                <th>Status</th>
                <th>Total Deliveries</th>
    			</tr>
    			</thead>
    			<tbody>
        </table> -->
        <div class="div-table-content">
            <table class="table table-striped table-bordered" id="content_table">
            <thead>
            <tr>
                <th>Name</th>
                <th>Email</th>
                <th>Mobile</th>
                <th>Start Date</th>
                <th>Leaving Date</th>
                <th>Status</th>
                <th>Avg. Rating</th>
                <th>Total Services Completed</th>
          </tr>
          </thead>
          <tbody>
              <tbody>
              <?php if(count($bikers) == 0){
                ?>
                <tr><td colspan="7">Sorry No Data Available in Technician Report...</td></tr>
                <?php } ?>
                                    <?php $i=1; ?>              
                  <?php $total_cod = 0;
                        $total_diff_reading = 0;
                        $total_M_to_E_dist = 0;
                        $total_shipment_delivered = 0;
                  ?>
                  @foreach($bikers as $biker)
                  <?php 
                   
                    $total_shipment_delivered = $biker->total_shipment_delivered + $total_shipment_delivered; 
                    $joining_date = $leaving_date = '-';
                    if(!is_null($biker->joining_date) && !($biker->joining_date=='')) { $joining_date = date('d-m-Y',strtotime($biker->joining_date)); }
                    if(!is_null($biker->leaving_date) && !($biker->leaving_date=='')) { $leaving_date = date('d-m-Y',strtotime($biker->leaving_date)); }
                  ?>
          					<tr>
                       
                        <td><a href="bikers/{{ $biker->id }}?sort=&filter_name=&page=1&order=&filter_membertype=3">{{ $biker->first_name }} {{ $biker->last_name }}</a></td>
                        <td>{{ $biker->email }}</td>
                        <td>{{ $biker->mobile }}</td>
                        
                        <td><?php echo $joining_date;?></td>
                        <td><?php echo $leaving_date;?></td>
                        <td>{{ $biker->status }}</td>
                        <td>{{ $biker->avgrating }}</td>
                        <td>{{ $biker->total_shipment_delivered }}</td>
          					</tr>
          				@endforeach
                    
    			    </tbody>
    		    </table>
    	</div>
      <?php echo $bikers->appends($_GET)->render(); ?>
    </div>
  </div>
</div>
<!-- Bikers Auto list js -->
<link href="/assets/autocomplete/selectivity-full.css" rel="stylesheet">
<script src="/assets/autocomplete/zepto.js"></script>
<script src="/assets/autocomplete/selectivity-full.js"></script>

<script type="text/javascript">
$(document).ready(function(){
      $("#report_end_date").datetimepicker({
        <?php if(!isset($_GET['end_date'])) { ?>
            defaultDate: new Date()
        <?php } ?>
      });
      var currentDate = new Date();
      var currentMonth = currentDate.getMonth() - 1;
      var currentYear = currentDate.getFullYear();
      var currentDay = currentDate.getDate();
      $("#report_start_date").datetimepicker({
            <?php if(!isset($_GET['start_date'])) { ?>
              defaultDate: new Date(currentYear, currentMonth, currentDay)
            <?php } ?>
      });
      $('#tags-input').selectivity({
          items: [<?php foreach ($bikers_list as $key => $biker) { ?>{id: <?php echo $biker->id; ?>, text:"<?php echo $biker->first_name.' '.$biker->last_name ?>"}, <?php } ?>],
          multiple: true,
      });

      $('#biker_form_submit').click(function() {
            var data = $('.selectivity-input').selectivity('data');
            var bikers_id = [];
            for (var i = 0; i < data.length; i++) {
                bikers_id[i] = data[i].id;
            };
            $('#bikers_id').val(bikers_id.toString());
      });
      <?php
      if(!empty($_GET['bikers_id'])){
        $selected = explode(',', $_GET['bikers_id']);
        foreach ($selected as $value) { ?>
          $('#tags-input').selectivity('add', <?php echo $value; ?>);
      <?php } } ?>

  $("#content_table").width($("#header_table").width());
});

function reset_tags_box()
    {
      //$('#report-frm')[0].reset();
      $('#report-frm').find(':input').not(':button, :submit, :reset, :hidden, :checkbox, :radio').val('');
      $('#report-frm').find(':checkbox, :radio').prop('checked', false);
      $("#tags-input .selectivity-multiple-selected-item").remove();
      var blankarr = new Array();
      $('.selectivity-input').selectivity('data',blankarr);
      $('#report-frm').submit();
    }

</script>
@endsection