@extends('app')
@section('content')
<title>Bikers COD Collected Report</title>
<style type="text/css">
	/* For fixed table thead */
table {
		table-layout:fixed;
}

.div-table-content {
	max-height: 370px;
	overflow-y:auto;
}
.scorll {
	width: 98.5%;
	margin-bottom: 0px;
	border-bottom: none !important;
}
</style>
<div class="content-wrapper">
		<div class="container-fluid">
			<div class="row">
				<div class="col-md-12">
					<?php 
							if( !count($_GET) ) { 
									$url_parameter = '?report=1';
							} else {
									$url_parameter = $_SERVER['REQUEST_URI'].'&report=1';
							}
					?>
					<a href="<?php echo $url_parameter; ?>" data-toggle="tooltip" title="" class="btn btn-primary" data-original-title="Download Exel" style="float:right;margin-right:2%;margin-top:1%"><i class="fa fa-download"></i></a>
					<h1 class="page-head-line">Bikers COD Report</h1>
				</div>
			</div>

			<div class="row">
					  <div class="col-md-2 report_leftpanel">
						<form class="form-horizontal" role="form" method="GET" action="/bikercodreport">
								<input type="hidden" name="_token" id="token" value="{{ csrf_token() }}" />
								<label style="padding: 0px;margin-top: 2%;">Start Date :</lable>
								<div class="col-md-12 padding_filter" style="padding:0px">
										<div class="input-group date">
											<input type="text" id="report_start_date" name="start_date" data-format="DD-MM-YYYY" class="form-control" placeholder="dd-mm-yy" value =  "<?php if(isset($_GET['start_date']))  echo $_GET['start_date']; ?>" >
											<span class="input-group-btn">
											<button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
											</span>
										</div>
								</div>

								<label style="padding: 0px;margin-top: 2%;">End Date :</lable>
								<div class="col-md-12 padding_filter" style="padding:0px">
										<div class="input-group date">
											<input type="text" id="report_end_date" name="end_date" data-format="DD-MM-YYYY" class="form-control" placeholder="dd-mm-yy" value = "<?php if(isset($_GET['end_date'])) echo $_GET['end_date']; ?>" >
											<span class="input-group-btn">
											<button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
											</span>
										</div>
								</div>
								<label class="col-md-12 control-label" style="padding:0px;margin-top: 2%;text-align:left;">Biker: </label>
								<div class="col-md-12 padding_filter" style="padding:0px">
									<p><span id="tags-input" class="selectivity-input" name="bikers_list" id="bikers_list" style="width:100%;font-size: 11px;"></span></p>
									<textarea name="bikers_id" id="bikers_id" style="display:none;"></textarea>
								</div>
								<p style="clear: both;text-align: center;padding-top: 3%;"><input type="submit" class="btn btn-success" id="biker_form_submit" value="Search"/></i></p>
						</form>
				</div>
				<form class="form-horizontal" role="form" method="POST" action="add_cod_details">
					<input type="hidden" name="_token" value="{{{ csrf_token() }}}" />
					<div class="col-md-9">
						@if(Session::has('sub_station_id'))
				    		<div class="col-md-12">
				    			<div class="col-md-4" style="padding-left:0px">
				    				<div class="form-group">
				    					<div class="col-md-12" style="padding-left:0px">
		                                	<input type="text" class="form-control" name="amount" id="amount" readonly required placeholder="amount">
				    					</div>
		                            </div>
				    			</div>
				    			<div class="col-md-4">
				    				<div class="form-group">
				    					<div class="col-md-12">
			                                <div class="input-group date_cod">
			                                  <input type="text" name="datetime" data-format="DD-MM-YYYY HH:mm:ss" class="form-control" readonly="" required>
			                                  <span class="input-group-btn">
			                                  <button type="button" class="btn btn-default"><i class="fa fa-calendar"></i></button>
			                                  </span>
			                                </div>
				    					</div>
		                            </div>
				    			</div>
				    			<div class="col-md-4">
				    				<input type="submit" class="btn btn-success" id="bank_cod_amt" value="Save COD Amount"/>
				    			</div>
				    			<p style="font-size:12px;clear:both;margin-left: -1%;">Please select the checkbox to update Amount box.</p>
			    			</div>
				    	@endif
						<table class="table table-striped table-bordered scorll" id="content_table">
							<thead>
								<tr>
									<th style="width:3%;"><input type="checkbox" onclick="$('input[name*=\'selected\']').prop('checked', this.checked).change();"/> </th>
									<th>Date</th>
									<th>Biker</th>
									<th>AWB No</th>
									<th>Amount</th>
									<th>Collection Mode</th>
								</tr>
							</thead>
						</table>
						<div class="div-table-content">
							<table class="table table-striped table-bordered" id="header_table">
								<tbody>
									<?php 
										$total_cod = 0;
										$card_cod_total = 0;
										$cash_cod_total = 0;
									?>
										@foreach($bikers as $biker)
											<?php 
												$total_cod = $biker->amount + $total_cod;
												if($biker->payment_mode == 'card') {
													$card_cod_total = $card_cod_total + $biker->amount;
												}
												if($biker->payment_mode == 'cash') {
													$cash_cod_total = $cash_cod_total + $biker->amount;
												}
											?>
											<tr>
												<td style="width:3%;">
													<?php 
														if(!$biker->biker_cod_paid_flag && $biker->payment_mode == 'cash') {
															echo '<input type="checkbox" name="selected[]" class="selected" value="'.$biker->shipment_table_id.'" data-amount="'.$biker->amount.'" /></td>';
														}
													?>
												</td>
												<td><?php echo ((new DateTime($biker->date))->format('d-m-Y')); ?></td>
												<td>
													{{ $biker->first_name }} {{ $biker->last_name }}
													<input type="hidden" name="biker_id[]" value="{{ $biker->biker_table_id }}">
												</td>
												<td>{{ $biker->awb_no }}</td>
												<td>{{ number_format($biker->amount,2) }}</td>
												<td>{{ ucwords($biker->payment_mode) }}</td>
											</tr>
										@endforeach
										<tr>
											<td colspan="4" style="text-align:right"><b>
												Cash Total Amount:<br/>
												Card Total Amount:<br/>
												Total: </b></td>
											<td>
												{{ ($cash_cod_total == 0) ? number_format('0',2) : number_format($cash_cod_total,2) }}<br/>
												{{ ($card_cod_total == 0) ? number_format('0',2) : number_format($card_cod_total,2) }}<br/>
												{{ ($total_cod == 0) ? number_format('0',2) : number_format($total_cod,2) }}</td>
										</tr>
								</tbody>
							</table>
						</div>
						<?php echo $bikers->appends($_GET)->render(); ?>
					</div>
				</form>
			</div>
		</div>
</div>
<link href="/assets/autocomplete/selectivity-full.css" rel="stylesheet">
<script src="/assets/autocomplete/zepto.js"></script>
<script src="/assets/autocomplete/selectivity-full.js"></script>
<script type="text/javascript">
	$(document).ready(function(){
		//for hiding check for super admin
    	<?php if(Session::has('sub_station_id')) { ?>
    		$('.selected').show();
    	<?php } else { ?>
    		$('.selected').hide();
    	<?php } ?>
    	//Amount calculation of selected boxes
    	$(".selected").change(function() {
			total_amount = 0.0;
			$('.selected').each(function () {
			       val = (this.checked ? $(this).attr('data-amount') : "");
			       total_amount = (+total_amount) + (+val);
			  });
			$('#amount').val(total_amount);
		});

    	//to show preselected date
		 $("#report_start_date").datetimepicker({
			<?php if(!isset($_GET['start_date'])) { ?>
				defaultDate: new Date()
			<?php } ?>
		 });
		 $("#report_end_date").datetimepicker({
			<?php if(!isset($_GET['end_date'])) { ?>
				defaultDate: new Date()
			<?php } ?>
			});

		$('#tags-input').selectivity({
					items: [<?php foreach ($bikers_list as $key => $biker) { ?>{id: <?php echo $biker->id; ?>, text:"<?php echo $biker->first_name.' '.$biker->last_name ?>"}, <?php } ?>],
					multiple: true,
			});

			$('#biker_form_submit').click(function() {
						var data = $('.selectivity-input').selectivity('data');
						var bikers_id = [];
						for (var i = 0; i < data.length; i++) {
								bikers_id[i] = data[i].id;
						};
						$('#bikers_id').val(bikers_id.toString());
			});
			<?php
			if(!empty($_GET['bikers_id'])){
				$selected = explode(',', $_GET['bikers_id']);
				foreach ($selected as $value) { ?>
					$('#tags-input').selectivity('add', <?php echo $value; ?>);
			<?php } } ?>
$("#content_table").width($("#header_table").width());
});
</script>
@endsection