<!DOCTYPE html>
<html>
<head>
    <title>Serial Entries</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-4">
    <h2>Serial Entries Table</h2>
    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>ID</th>
                <th>Brand</th>
                <th>Product</th>
                <th>Serial No</th>
                <th>IMEI No</th>
                <th>Location</th>
                <th>Created At</th>
                <th>Updated At</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($entries as $entry)
                <tr>
                    <td>{{ $entry->id }}</td>
                    <td>{{ $entry->brand }}</td>
                    <td>{{ $entry->product }}</td>
                    <td>{{ $entry->serial_no }}</td>
                    <td>{{ $entry->imei_no }}</td>
                    <td>{{ $entry->location }}</td>
                    <td>{{ $entry->created_at }}</td>
                    <td>{{ $entry->updated_at }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="8" class="text-center">No records found</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</div>
</body>
</html>
