@extends('app')
@section('content')

<title>Manage Skills</title>

<meta name="csrf-token" content="{{ csrf_token() }}">

<div class="content-wrapper">
    <div class="container">
        <div class="row">
            <div class="col-md-12"> 
                <h1 class="page-head-line">Skill List</h1>

                @if(session('success'))
                    <div class="alert alert-success mt-3">{{ session('success') }}</div>
                @endif

                @if($skills->count() > 0)
                <form method="POST" id="bulkDeleteForm">
                    <div class="mb-3 d-flex gap-2 align-items-center">
                        <div style="float: left;padding:10px 5px;">
                        <a id="delete" class="btn btn-danger pull-right display_button" data-toggle="tooltip" title="Delete entry" href="javascript:void(0);" onclick="submitdelfrm();" style="margin-right:0.5%;margin-top:1%" ><i class="fa fa-trash-o"></i>
                        </a> 
                        </div>
                        <div style="float: left;padding:10px 5px;"> 
<a href="javascript:void(0);" onclick="editSelectedSkill()" id="edit" class="btn btn-info pull-right display_button" data-toggle="tooltip" title="Edit details" style="margin-right:0.5%;margin-top:1%">
    <i class="fa fa-pencil"></i>
</a>

                        </div>
                        <div class="col-lg-1.5 col-md-1.5 col-sm-1.5 col-xs-1.5" style="float: left;padding:10px 2px;">
                            <a href="manageskill/create" id="add" data-toggle="tooltip" title="Add New Skill" class="btn btn-primary display_button">
                                <i class="fa fa-plus"></i>
                            </a> 
                        </div>
                    </div>

                    <table class="table table-bordered mt-4">
                        <thead>
                            <tr>
                                <th><input type="checkbox" id="select-all"></th>

                                <th>Skill Name</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($skills as $skill)
                            <tr>
                                <td><input type="checkbox" name="skill_ids[]" value="{{ $skill->id }}"></td>

                                <td>{{ $skill->name }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </form>
                @else
                    <p>No skills found.</p>
                @endif
            </div>
        </div>
    </div>
</div>
<script>
document.addEventListener('DOMContentLoaded', () => {
    const checkboxes = document.querySelectorAll('input[name="skill_ids[]"]');
    const selectAll = document.getElementById('select-all');
    const deleteBtn = document.getElementById('delete');
    const editBtn = document.getElementById('edit');

    function toggleActionButtons() {
        const selected = document.querySelectorAll('input[name="skill_ids[]"]:checked');
        deleteBtn.classList.toggle('disabled', selected.length === 0);
        editBtn.classList.toggle('disabled', selected.length !== 1);
        deleteBtn.style.pointerEvents = selected.length === 0 ? 'none' : 'auto';
        editBtn.style.pointerEvents = selected.length === 1 ? 'auto' : 'none';
    }

    checkboxes.forEach(checkbox => {
        checkbox.addEventListener('change', toggleActionButtons);
    });

    if (selectAll) {
        selectAll.addEventListener('change', function (e) {
            checkboxes.forEach(cb => cb.checked = e.target.checked);
            toggleActionButtons();
        });
    }

    toggleActionButtons(); // Initial state

    deleteBtn.addEventListener('click', function(e) {
        const selectedCheckboxes = document.querySelectorAll('input[name="skill_ids[]"]:checked');
        if (selectedCheckboxes.length === 0) {
            alert('Please select at least one skill to delete.');
            return;
        }

        if (!confirm('Are you sure to delete selected skills?')) {
            return;
        }

        const skillIds = Array.from(selectedCheckboxes).map(cb => cb.value);
        const formData = new FormData();
        skillIds.forEach(id => formData.append('skill_ids[]', id));

        fetch("{{ route('manageskill.bulkDelete') }}", {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: formData
        })
        .then(async response => {
            if (!response.ok) {
                const errorText = await response.text();
                console.error('Server error response:', errorText);
                throw new Error('Network response was not ok.');
            }
            return response.json();
        })
        .then(data => {
            alert(data.message || 'Selected skills deleted successfully.');
            window.location.reload();
        })
        .catch(error => {
            alert('An error occurred while deleting skills. Check console for details.');
            console.error('Fetch error:', error);
        });
    });

    window.editSelectedSkill = function () {
        const selected = document.querySelectorAll('input[name="skill_ids[]"]:checked');
        if (selected.length === 1) {
            const skillId = selected[0].value;
            // Laravel route() helper output for JS
            let editUrl = "{{ route('manageskill.edit', ':id') }}";
            window.location.href = editUrl.replace(':id', skillId);
        } else {
            alert("Please select exactly one skill to edit.");
        }
    };


});
</script>


@endsection
