@extends('app')

@section('content')
<title>Add Skill</title>

{{-- CSRF Meta for AJAX --}}
<meta name="csrf-token" content="{{ csrf_token() }}">

<div class="content-wrapper">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h1 class="page-head-line">ADD SKILL</h1>
            </div>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-default">
                    <div class="panel-body">

                        {{-- Display Validation Errors --}}
                        @if($errors->any())
                            <div class="alert alert-danger">
                                @foreach($errors->all() as $error)
                                    <p>{{ $error }}</p>
                                @endforeach
                            </div>
                        @endif

                        {{-- Skill Form --}}
                        <form class="form-horizontal" id="skillForm" method="POST" action="{{ route('manageskill.store') }}">
                            {{-- Replace @csrf with this hidden input --}}
                            <input type="hidden" name="_token" value="{{ csrf_token() }}" />

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-4">Skill Name <span style="color:#FF0000"> *</span></label>
                                    <div class="col-md-8">
                                        <input type="text" class="form-control" name="name" value="{{ old('name') }}" style="text-transform:capitalize" required>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <div class="col-md-6 col-md-offset-5">
                                        <button type="submit" class="btn btn-success" id="skill_submit">Submit</button>
                                        <a href="{{ route('manageskill.index') }}" class="btn btn-primary">Cancel</a>
                                    </div>
                                </div>
                            </div>
                        </form>

                        {{-- Optional JS to prevent double submit --}}
                        <script type="text/javascript">
                            document.addEventListener("DOMContentLoaded", function () {
                                const form = document.getElementById("skillForm");
                                form.addEventListener("submit", function () {
                                    document.getElementById("skill_submit").disabled = true;
                                });

                                // Setup AJAX CSRF token
                                if (typeof $ !== 'undefined') {
                                    $.ajaxSetup({
                                        headers: {
                                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                                        }
                                    });
                                }
                            });
                        </script>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
