<!DOCTYPE html>
<html>
<head>
    <title>Company Information</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            padding: 40px;
            background-color: #f9f9f9;
            color: black;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
        }
        .header img {
            width: 150px;
            height: auto;
        }
        h1, h2, h3 {
            color: #8B4513;
            margin: 10px 0;
        }
        p {
            font-size: 16px;
            line-height: 1.6;
            margin: 5px 0;
        }
        .bold-black {
            font-weight: bold;
            color: black;
        }
        .info-black {
            color: black;
            font-size: 16px;
            margin-top: 10px;
        }
        .center-heading {
            text-align: center;
            font-size: 20px;
            font-weight: bold;
            margin: 30px 0 10px;
            text-decoration: underline;
        }
        .client-info-box {
            border: 1px solid #ccc;
            padding: 1px;
            margin-top: 30px;
            width: 100%;
            max-width: 900px;
            margin-left: auto;
            margin-right: auto;
            background-color: #fff;
        }
        .print-button {
            margin-bottom: 20px;
            text-align: right;
        }
        .print-button button {
            padding: 8px 16px;
            background-color: #8B4513;
            color: white;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 14px;
        }
        .print-button button:hover {
            background-color: #5e2f0e;
        }
        @media print {
    .print-button {
        display: none;
    }
}

        
    </style>
</head>
<body>

    <!-- Print Button -->
    <div class="print-button">
        <button onclick="window.print()">🖨️ Print</button>
    </div>

   <div align="center" style="font-size: 12px;">
    <table style="font-size: 12px; width: 100%;">
        <tr>
            <td>
<h1 style="font-size: 40px;">{{ config('app.companyname') }}</h1>

                <hr />
                <strong>{{ config('app.companytagline') }}</strong><br />
                <hr />
               <div style="font-size: 17px;">
    <strong>Regd. Office:</strong> {{ config('app.companyaddress') }}<br />
    <strong>Support:</strong> {{ config('app.companyphone') }} | 
    <strong>W:</strong> {{ config('app.companyurl') }}<br />
    <strong>E:</strong> {{ config('app.companyemail') }}
</div>

            </td>
            <td style="width: 30px;">&nbsp;</td>
            <td align="right">
                <img src="{{ asset(config('app.companylogo')) }}" alt="Company Logo" style="width: 220px; height: auto;" />
            </td>
        </tr>
    </table>
</div>

    <p class="info-black"><strong>SR No:</strong> 2024-25</p>
    <p class="info-black"><strong>Date:</strong> <span id="current-date"></span></p>

    <div class="center-heading">PPM Check List</div>

    <div class="client-info-box">
  <h3 style="text-align: center;">Client Information</h3>

        <!-- Add more fields as needed -->
    </div>
<p><strong>Name of the client:</strong> {{ $vendor->name ?? 'N/A' }}</p>
<p><strong>Contact Person’s name:</strong> _____________________________________________</p>
 <p><strong>Site’s Address:</strong> {{ $fullAddress ?? 'N/A' }}</p>



 <div style="text-align: right; margin-top: 100px; margin-right: 40px;">
    @if(!empty($receiverSign))
        <img src="{{ asset($receiverSign) }}" alt="Receiver Signature" style="width: 200px; height: auto;">
    @endif
    <p><strong>Signature</strong></p>
</div>

</p>
<p><strong >Site Handed Over To –</strong> ____________________________________________</p>

<p><strong>Site Handed Over By –</strong> ____________________________________________</p>

<!-- Centered Product Name Box -->
<!-- Force this box to start at the top of the next page -->
<div style="page-break-before: always; border: 2px solid #000; padding: 20px; margin-top: 50px; font-size: 16px; text-align: center;">
    <strong>Product Name:</strong> {{ $productName ?? 'N/A' }}
</div>
<table border="1" cellpadding="5" style="margin-top: 80px; width: 100%; border-collapse: collapse;">
    <thead>
        <tr>
            <th style="width: 70%;">Checklist Item</th>
            <th style="width: 15%;">Yes</th>
            <th style="width: 15%;">No</th>
        </tr>
    </thead>
    <tbody>
        @forelse ($checklistItems as $check)
            <tr>
                <td style="padding: 8px;">{{ $check['item'] }}</td>
                <td style="text-align: center;">{!! $check['selected'] ? '✓' : '' !!}</td>
                <td style="text-align: center;">{!! !$check['selected'] ? '✓' : '' !!}</td>
            </tr>
        @empty
            <tr>
                <td colspan="3">No checklist items found.</td>
            </tr>
        @endforelse
    </tbody>
</table>



<!-- Post-Checklist Site Confirmation -->
<div style="margin-top: 50px; font-size: 16px; line-height: 1.8;">
    <p>Here we are declaring that all the cameras are working properly on site and checked everything with the senior person as of now.</p>
    <p><strong>Name of the Site Supervisor:-</strong> </p>
</div>

    <div style="margin-top: 40px; display: flex; justify-content: space-between;">
        <div><strong>Signature:</strong> ________________________</div>
        <div><strong>Date:</strong> ____________________</div>
    </div>
<!-- Force next content to print on a new page -->
<div style="page-break-after: always;"></div>

</table>

<!-- Declaration Section -->
<div style="margin-top: 50px; font-size: 16px; line-height: 1.8; padding: 20px; border: 1px solid #ccc; background-color: #fff;">
    <h3 style="text-align: center; text-decoration: underline; color: #8B4513;">DECLARATION</h3>
    <p>Here we are declaring that Vallabh Enterprises has successfully completed the installation.</p>
    <p>Based on this report and testing, we Vallabh Enterprises conclude that the overall systems are working properly as of now.</p>
    <p>After submission of this report, we Vallabh Enterprises will provide you the service every quarter.</p>
    <p>We are really thankful that we have got an opportunity to work on such a great project with nice people.</p>
    <p style="margin-top: 30px;"><strong>Vallabh Enterprises</strong></p>
</div>
<div style="margin-top: 80px; display: flex; justify-content: space-between;">
    <div style="font-weight: bold;">
        Authorized Signatory
    </div>
    <div style="font-weight: bold;">
        Authorized Signatory
    </div>
</div>


    <script>
        // Insert today's date dynamically
        const today = new Date();
        const formattedDate = today.toLocaleDateString('en-GB');
        document.getElementById("current-date").textContent = formattedDate;
    </script>

</body>
</html>
