{{-- resources/views/bikers/partials/status-modal.blade.php --}}

<style>

  .label-with-symbol {
  position: relative;
  padding-left: 30px; /* leave space for symbol */
  font-weight: 700;
  font-size: 1.25rem;
  color: #495057;
  display: inline-block;
  margin-bottom: 0.75rem;
}

.label-tech-name::before {
  content: "👤";
  position: absolute;
  left: 0;
  top: 50%;
  transform: translateY(-50%);
  font-size: 1.3rem;
}

.label-skill::before {
  content: "🛠️";
  position: absolute;
  left: 0;
  top: 50%;
  transform: translateY(-50%);
  font-size: 1.3rem;
}

.label-service-desc::before {
  content: "ℹ️";
  position: absolute;
  left: 0;
  top: 50%;
  transform: translateY(-50%);
  font-size: 1.3rem;
}

  #statusModal .modal-dialog {
  max-width: 800px; /* or any width you want */
  width: 90%; /* optional, for responsiveness */
}

  #tech-services table {
  font-size: 1.6rem;
  color: #212529;
}
#tech-services th {
  background-color: #dee2e6;
  font-weight: bold;
  text-align: center;
}
#tech-services td {
  vertical-align: top;
}

  /* Modal dialog animation */
  .modal.fade .modal-dialog {
    transform: translateY(-50px);
    transition: transform 0.3s ease-out;
  }
  .modal.show .modal-dialog {
    transform: translateY(0);
  }

  /* Modal content styling */
  #statusModal .modal-content {
    border: 2px solid #6c757d; /* Changed to Bootstrap secondary gray */
    box-shadow: 0 0.5rem 1rem rgba(108, 117, 125, 0.25); /* softer shadow with gray */
  }

  /* Modal header styling */
  #statusModal .modal-header {
    background-color: #02060a; /* dark gray */
    color: #f8f9fa; /* light gray text */
    border-bottom: none;
  }

  /* Close button */
  #statusModal .btn-close {
    filter: brightness(0) invert(1);
  }

  /* Modal body text */
  #statusModal .modal-body p {
    font-size: 1.25rem; /* increased font size */
    margin-bottom: 1.25rem;
  }

  #statusModal .modal-body strong {
    font-weight: 700;
    font-size: 1.8rem; /* increased font size */
    color: #495057; /* dark gray */
  }

  /* Highlight dynamic content */
#tech-name, #tech-skill, #tech-services {
  color: #0d99f0; /* Bootstrap info color */
  font-size: 1.8rem;
  font-weight: 600;
}
#statusModal .modal-header {
  position: relative; /* enable positioning context */
  background-color: #02060a; /* dark gray */
  color: #f8f9fa; /* light gray text */
  border-bottom: none;
}

#statusModal .modal-header {
  position: relative; /* positioning context */
  background-color: #02060a; /* dark gray */
  color: #f8f9fa; /* light gray text */
  border-bottom: none;
}

#statusModal .btn-close-red {
  position: absolute;
  top: 1.7rem;
  right: 1rem;
  width: 35px;
  height: 35px;
  background-color: red;
  border: none;
  border-radius: 4px; /* slightly rounded corners */
  color: white;
  font-size: 1.8rem;
  font-weight: bold;
  line-height: 1;
  text-align: center;
  cursor: pointer;
  padding: 0;
  display: flex;
  align-items: center;
  justify-content: center;
  opacity: 1;
  filter: none;
  user-select: none;
  transition: background-color 0.2s ease;
}

#statusModal .btn-close-red:hover {
  background-color: darkred;
}


</style>
<div class="modal fade" id="statusModal" tabindex="-1" aria-labelledby="statusModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h3 class="modal-title" id="statusModalLabel">Technician Status</h3>
  <button type="button" class="btn-close-red" data-bs-dismiss="modal" aria-label="Close">&times;</button>

      </div>
      <div class="modal-body">

<p><strong class="label-with-symbol label-tech-name">Technician Name:</strong> <span id="tech-name"></span></p>
<p><strong class="label-with-symbol label-skill">Skill:</strong> <span id="tech-skill"></span></p>
<p><strong class="label-with-symbol label-service-desc">Service Descriptions:</strong></p>

        <div id="tech-services" style="max-height: 200px; overflow-y: auto;"></div>
      </div>
    </div>
  </div>
</div>
