@extends('app')
@section('content')
<title>Auto Generate Quotation</title>
<style type="text/css">
    .control-label {
        text-align: left !important;
    }
    .imagePreview {
        width: 50px;
        height: 50px;
        background-position: center center;
        background-size: cover;
        -webkit-box-shadow: 0 0 1px 1px rgba(0, 0, 0, .3);
        display: inline-block;
    }
</style>

<div class="content-wrapper">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h1 class="page-head-line">Auto Generate Quotation</h1>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="panel panel-default">
                    <div class="panel-body">
                        @if($errors->any())
                            <div class="alert alert-danger">
                                @foreach($errors->all() as $error)
                                    <p>{{ $error }}</p>
                                @endforeach
                            </div>
                        @endif
<form class="form-horizontal" role="form" id="submit" method="POST" action="{{ route('amcs.autoQuotation.store', $amc->id) }}">
    


                            <input type="hidden" name="_token" value="{{ csrf_token() }}" />

                            {{-- Select Client --}}
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-4">Select Client <span style="color:#FF0000">*</span></label>
                                    <div class="col-md-8">
                                        <select class="form-control" name="vendor_id" disabled>
                                            @foreach($vendors as $vendor)
                                                <option value="{{ $vendor->id }}" {{ $vendor->id == $amc->vendor_id ? 'selected' : '' }}>
                                                    {{ $vendor->name }}{{ $vendor->company_name ? ' / ' . $vendor->company_name : '' }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>

                            {{-- Select Product --}}
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-4">Select Product <span style="color:#FF0000">*</span></label>
                                    <div class="col-md-8">
                                        <select class="form-control" name="product_id" disabled>
                                            @foreach($products as $product)
                                                <option value="{{ $product->id }}" {{ $product->id == $amc->product_id ? 'selected' : '' }}>
                                                    {{ $product->product_name }} / {{ $product->product_code }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>

                            {{-- AMC Price  resources/views/amcs/send_quotation_auto.blade.php--}}
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-4">AMC Price</label>
                                    <div class="col-md-8">
                                        <input type="number" class="form-control" name="amc_price" value="{{ $amc->amc_price }}" readonly>
                                    </div>
                                </div>
                            </div>

                            {{-- Terms & Conditions --}}
                            <div class="col-md-6" style="clear:both;">
                                <div class="form-group">
                                    <label class="control-label col-md-4">Terms & Conditions</label>
                                    <div class="col-md-8">
                                        <textarea class="form-control" name="terms" rows="2" readonly>{{ $amc->terms }}</textarea>
                                    </div>
                                </div>
                            </div>

                            {{-- Type --}}
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-4">Type <span style="color:#FF0000">*</span></label>
                                    <div class="col-md-8">
                                        <label class="radio-inline">
                                            <input type="radio" name="atype" value="Comprehensive" {{ $amc->atype == 'Comprehensive' ? 'checked' : '' }} disabled> Comprehensive
                                        </label>
                                        <label class="radio-inline">
                                            <input type="radio" name="atype" value="Non-Comprehensive" {{ $amc->atype == 'Non-Comprehensive' ? 'checked' : '' }} disabled> Non-Comprehensive
                                        </label>
                                    </div>
                                </div>
                            </div>

                            {{-- Service Time Frame --}}
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="control-label col-md-4">Service Time Frame <span style="color:#FF0000">*</span></label>
                                    <div class="col-md-8">
                                        <select name="service_timeframe" class="form-control" disabled>
                                            <option value="">Select Time Frame</option>
                                            @foreach(['15 Days', 'Monthly', 'Quaterly', 'Yearly'] as $timeframe)
                                                <option value="{{ $timeframe }}" {{ $amc->service_timeframe == $timeframe ? 'selected' : '' }}>
                                                    {{ $timeframe }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                            </div>

{{-- Start Date --}}
<div class="col-md-6">
    <div class="form-group">
        <label class="control-label col-md-4">Start Date</label>
        <div class="col-md-8">
            <input type="text" class="form-control" value="{{ isset($newStart) ? $newStart->format('d-m-Y') : '' }}" readonly>
        </div>
    </div>
</div>

{{-- End Date --}}
<div class="col-md-6">
    <div class="form-group">
        <label class="control-label col-md-4">End Date</label>
        <div class="col-md-8">
            <input type="text" class="form-control" value="{{ isset($newEnd) ? $newEnd->format('d-m-Y') : '' }}" readonly>
        </div>
    </div>
</div>

                            {{-- Submit & Back Buttons resources/views/amcs/send_quotation_auto.blade.php --}}
<div class="col-md-12">
    <div class="form-group">
        <div class="col-md-8 col-sm-6 col-xs-12 col-md-offset-5">
            <button type="submit" class="btn btn-success">
                Generate & Store Quotation
            </button>
            <a href="/amcs/indexnew" class="btn btn-primary">Back</a>
        </div>
    </div>
</div>

                        </form>

                    </div> {{-- panel-body --}}
                </div> {{-- panel --}}
            </div> {{-- col --}}
        </div> {{-- row --}}
    </div> {{-- container --}}
</div> {{-- content-wrapper --}}
@endsection
