<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>AMC Quotation</title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            font-size: 14px;
            line-height: 1.6;
            color: #333;
            margin: 40px;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
        }

        .header h1 {
            font-size: 26px;
            margin: 0;
            text-transform: uppercase;
            color: #2F4F4F;
        }

        .section-title {
            font-size: 18px;
            margin-top: 30px;
            margin-bottom: 10px;
            border-bottom: 2px solid #2F4F4F;
            display: inline-block;
            padding-bottom: 4px;
            color: #2F4F4F;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }

        th, td {
            border: 1px solid #999;
            padding: 10px;
            text-align: left;
        }

        th {
            background-color: #f4f4f4;
            font-weight: bold;
        }

        .terms {
            margin-top: 25px;
            border: 1px solid #ccc;
            padding: 15px;
            background: #f9f9f9;
        }

        .footer {
            margin-top: 50px;
            text-align: center;
            font-size: 13px;
            color: #666;
        }
    </style>
</head>
<body>

    <div class="header">
        <h1>AMC Quotation</h1>
    </div>

    <div>
        <p><strong>Vendor Name:</strong> {{ $vendor->name ?? 'N/A' }}</p>
        <p><strong>Company:</strong> {{ $vendor->company_name ?? 'N/A' }}</p>
    </div>

    <div class="section-title">Quotation Details</div>

    <table>
        <tr>
            <th>Product</th>
            <td>{{ $quotation->product->product_name ?? 'N/A' }} ({{ $quotation->product->product_code ?? 'N/A' }})</td>
        </tr>
<tr>
    <th>AMC Price (without GST)</th>
    <td>₹{{ number_format($basePrice, 2) }}</td>
</tr>
<tr>
    <th>GST ({{($gst_persentage)}}%)</th>
    <td>₹{{ number_format($gst, 2) }}</td>
</tr>
<tr>
    <th>Total Price (with GST)</th>
    <td>₹{{ number_format($totalPrice, 2) }}</td>
</tr>

        <tr>
            <th>Type</th>
            <td>{{ $quotation->atype }}</td>
        </tr>
        <tr>
            <th>Service Time Frame</th>
            <td>{{ $quotation->service_timeframe }}</td>
        </tr>
        <tr>
            <th>Start Date</th>
            <td>{{ \Carbon\Carbon::parse($quotation->start_date)->format('d-m-Y') }}</td>
        </tr>
        <tr>
            <th>End Date</th>
            <td>{{ \Carbon\Carbon::parse($quotation->end_date)->format('d-m-Y') }}</td>
        </tr>
    </table>

    <div class="section-title">Terms & Conditions</div>
    <div class="terms">
        {!! nl2br(e($quotation->terms)) !!}
    </div>

    <div class="footer">
        <p>Thank you for choosing Apni AMC. For any queries, feel free to contact us.</p>
    </div>

</body>
</html>
{{-- resources/views/amcs/quotations_pdf.blade.php --}}