@extends('app')
@section('content')
    <title>Manage AMC</title>
    <div class="container">
        <h2>Service Requests</h2>

        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Vendor</th>
                    <th>compony name</th>
                    <th>vendor name</th>
                    <th>Product</th>
                    <th>Request Status</th>
                    <th>Request Message</th>
                    <th>Updated At</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($requests as $request)
                    <tr>
                        {{-- <td>{{ $request->id }}</td>
                        <td>{{ $request->vendor_id }}</td>
                        <td>{{ $request->company_name }}</td>
                        <td>{{ $request->vendor_name }}</td>
                        <td>{{ $request->product_name }}</td>
                        <td>{{ $request->request_status }}</td>
                        <td>{{ $request->request_message }}</td>
                        <td>{{ $request->updated_at }}</td> --}}


                        {{-- <td>{{ $request->id }}</td> --}}
                        <td>{{ $request->serial }}</td>
                        <td>{{ $request->request_by_id }}</td>
                        <td>{{ $request->company_name }}</td>
                        <td>{{ $request->vendor_name }}</td>
                        <td>{{ $request->product_name }}</td>
                        <td>
                            @if ($request->status === 1)
                                <span class="text-success">Approved</span>
                            @elseif($request->status === 2)
                                <span class="text-danger">Disapproved</span>
                            @elseif($request->status === 0)
                                <span class="text-warning">Pending</span>
                            @endif
                        </td>
                        <td>{{ $request->message }}</td>
                        <td>{{ $request->updated_date }}</td>
                        {{-- <td>
                            <form action="{{ route('admin.request.update') }}" method="POST">
                                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                <input type="hidden" name="amc_id" value="{{ $request->id }}">
                                <select name="request_status" class="form-control form-control-sm"
                                    onchange="this.form.submit()">
                                    <option value="">--Select--</option>
                                    <option value="1" {{ $request->status === 1 ? 'selected' : '' }}>Approve
                                    </option>
                                    <option value="0" {{ $request->status === 0 ? 'selected' : '' }}>
                                        Disapprove</option>
                                </select>
                            </form>
                        </td> --}}
                        <td>
                             <form action="{{ route('admin.request.update') }}" method="POST" onsubmit="disableDropdown(this)">
                                <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                <input type="hidden" name="request_id" value="{{ $request->id }}">
                                <select name="status" class="form-control form-control-sm" onchange="this.form.submit()"
                                    id="statusSelect{{ $request->id }}"
                                    {{ in_array($request->status, [1, 2]) ? 'disabled' : '' }}>
                                    <option value="">--Select--</option>
                                    <option value="1" {{ $request->status === 1 ? 'selected' : '' }}>Approve</option>
                                    <option value="2" {{ $request->status === 2 ? 'selected' : '' }}>Disapprove
                                    </option>
                                    <option value="0" {{ $request->status === 0 ? 'selected' : '' }}>Pending</option>
                                </select>
                            </form>
                             <script>
                                function disableDropdown(form) {
                                    const select = form.querySelector('select[name="status"]');
                                    select.disabled = true;
                                }
                            </script>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@endsection
