@extends('app')

@section('content')
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #f2f4f7;
    }

    h2 {
      text-align: center;
      color: #2c3e50;
    }

    .form-container {
      background: #ffffff;
      padding: 25px;
      border-radius: 10px;
      max-width: 1000px;
      margin: auto;
      box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }

    .form-row {
      display: flex;
      flex-wrap: wrap;
      gap: 20px;
      margin-bottom: 20px;
    }

    .form-group {
      flex: 1 1 200px;
    }

    label {
      display: block;
      font-weight: bold;
      margin-bottom: 5px;
      color: #333;
    }

    select, input {
      width: 100%;
      padding: 10px;
      border: 1px solid #ccc;
      border-radius: 6px;
    }

        .btn-row .button {
        background-color: #007bff; /* same as button color */
        color: white;
        padding: 8px 16px;
        border: none;
        text-decoration: none; /* removes underline */
        border-radius: 4px;
        display: inline-block;
        text-align: center;
        cursor: pointer;
    }

    .btn-row .button:hover {
        background-color: #0056b3; /* optional: hover effect */
    }

    .btn-row button {
        background-color: #007bff;
        color: white;
        padding: 8px 16px;
        border: none;
        border-radius: 4px;
        cursor: pointer;
    }

    /* .btn-row {
        display: flex;
        gap: 10px;
    }

    button {
      padding: 10px 20px;
      margin-top: 10px;
      background-color: #007bff;
      color: white;
      border: none;
      border-radius: 6px;
      font-weight: bold;
      cursor: pointer;
    }

    button:hover {
      background-color: #0056b3;
    } */

    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 25px;
    }

    th, td {
      border: 1px solid #ddd;
      padding: 10px 12px;
      text-align: center;
    }

    th {
      background-color: #34495e;
      color: white;
    }

    tr:nth-child(even) {
      background-color: #f9f9f9;
    }

    .btn-row {
      text-align: center;
      margin-top: 20px;
    }
  </style>

  <h2>Generate Serial NO.</h2>
  @if(session('success'))
  <div style="background-color: #d4edda; color: #155724; padding: 15px; margin-bottom: 20px; border: 1px solid #c3e6cb; border-radius: 5px; text-align: center;">
    {{ session('success') }}
  </div>
@endif


  <div class="form-container">
    <form id="generateForm" method="POST" action="{{ route('product.serialStore') }}">
      <input type="hidden" name="_token" value="{{ csrf_token() }}" />

      <div class="form-row">
        <div class="form-group">
          <label for="brand">Brand</label>
          <select id="brand" name="brand" required>
            <option value="">Select Brand</option>
            <option>Samsung</option>
            <option>Apple</option>
            <option>Realme</option>
          </select>
        </div>

        <div class="form-group">
          <label for="product">Product</label>
          <select id="product" name="product" required>
            <option value="">Select Product</option>
            @foreach($products as $product)
              <option value="{{ $product->product_name }}">{{ $product->product_name }} / {{ $product->product_code }}</option>
            @endforeach
          </select>
        </div>

        <div class="form-group">
          <label for="totalSerials">No of Serial Numbers</label>
          <input type="number" id="totalSerials" name="totalSerials" placeholder="e.g. 10" min="1" required>
        </div>

        <div class="form-group">
          <label for="location">Location</label>
          <select id="location" name="globalLocation" required>
            <option value="">Select Location</option>
            <option>Dahisar</option>
            <option>Borivali</option>
            <option>Kandivali</option>
            <option>Malad</option>
            <option>Goregaon</option>
            <option>Jogeshwari</option>
            <option>Andheri</option>
            <option>Bandra</option>
            <option>Dadar</option>
            <option>Churchgate</option>
          </select>
        </div>
      </div>

    <div class="btn-row">
    <button type="button" onclick="generateAndSubmit()">Generate & Save</button>
        <a href="{{ route('product.serialEntryList') }}" class="button">Go to List</a> 
    </div>

     <div id="tableContainer" style="display: none;"></div>

    </form>
  </div>

 <script>
  function generateAndSubmit() {
    const brand = document.getElementById("brand").value;
    const product = document.getElementById("product").value;
    const totalSerials = parseInt(document.getElementById("totalSerials").value);
    const location = document.getElementById("location").value;
    const tableContainer = document.getElementById("tableContainer");

    if (!brand || !product || isNaN(totalSerials) || totalSerials < 1 || !location) {
      alert("Please fill all fields correctly.");
      return;
    }

    let tableHTML = `
      <table>
        <thead>
          <tr>
            <th>Brand</th>
            <th>Product</th>
            <th>Serial No</th>
            <th>IMEI No</th>
            <th>Location</th>
          </tr>
        </thead>
        <tbody>
    `;

    for (let i = 1; i <= totalSerials; i++) {
      const sn = i;
      tableHTML += `
        <tr>
          <td>${brand}<input type="hidden" name="entries[${sn}][brand]" value="${brand}"></td>
          <td>${product}<input type="hidden" name="entries[${sn}][product]" value="${product}"></td>
          <td>${sn}<input type="hidden" name="entries[${sn}][serial]" value="${sn}"></td>
          <td><input type="text" name="entries[${sn}][imei]" placeholder="Enter IMEI No" required /></td>
          <td>${location}<input type="hidden" name="entries[${sn}][location]" value="${location}"></td>
        </tr>
      `;
    }

    tableHTML += `</tbody></table>`;
    tableContainer.innerHTML = tableHTML;

    // Wait for DOM update, then submit
    setTimeout(() => {
      document.getElementById("generateForm").submit();
    }, 1); // Slight delay to ensure inputs are attached
  }
</script>


@endsection