@extends('app')

@section('content')
<div class="container mt-4">
    <h1 class="page-head-line">Serial Entries LIST</h1> 

    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="align-items: center;display: flex;justify-content: space-between;">

        <a href="{{ route('product.serialEntry') }}" class="btn btn-info">Generate Serial Entry</a>
        <form method="GET" action="{{ url('/product/serial-entry/list') }}"  id="search-form" style="margin-right: 0 !important; display: flex; justify-content: flex-end; ">
            <!-- <div class="col-lg-1.5 col-md-1.5 col-sm-1.5 col-xs-1.5" > -->
                <div class="col-lg-7 col-md-7 col-sm-12 col-xs-12" style="float: left;padding:10px 3px;"> 
                    <input type="text" name="search" class="form-control me-2" placeholder="Search" value="{{ request('search') }}">
                </div>              

                <div class="col-lg-1.5 col-md-1.5 col-sm-1.5 col-xs-1.5" style="float: left;padding:10px 3px;">
                    <button type="submit" class="btn btn-info" title="Search">
                        <i class="glyphicon glyphicon-search"></i>
                    </button>
                </div> 
            <!-- </div> -->
        </form>

    </div>



    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>ID</th>
                <th>Brand</th>
                <th>Product</th>
                <th>Serial No</th>
                <th>IMEI No</th>
                <th>Location</th>
                <th>Edit</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($entries as $entry)
                <tr>
                    <td>{{ $entry->id }}</td>
                    <td>{{ $entry->brand }}</td>
                    <td>{{ $entry->product }}</td>
                    <td>{{ $entry->serial_no }}</td>
                    <td>{{ $entry->imei_no }}</td>
                    <td>{{ $entry->location }}</td>
                    <td style="width:50px;">
                        <a href="{{ url('/product/serial-entry/edit/'.$entry->id) }}" class="btn btn-info pull-right" style="margin-right:0.5%;margin-top:1%"><i class="fa fa-pencil"></i></a>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="7" class="text-center">No records found</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    {!! $entries !!}
   
</div>

@endsection
