{{-- resources/views/ManageVendorAddress/index.blade.php --}}
@extends('app')

@section('content')

<title>Manage Vendor Address</title>

<div class="content-wrapper">
    <div class="container">
        <h1 class="page-head-line">
            Address List : {{ isset($vendor) && !empty($vendor->name) ? $vendor->name : 'Unknown Vendor' }}
        </h1>

        <!-- Filter + Buttons  resources/views/ManageVendorAddress/index.blade.php -->
        <div class="row">
            <div class="col-md-12 text-right">
                <form method="GET" action="/vendormultipleaddresses/vendor/{{ $vendor->id }}" id="filterfrm" name="filterfrm" class="form-inline justify-content-end">
                    <div class="form-group" style="margin-right: 5px;">
                        <input type="text" class="form-control" placeholder="Search Address" name="filter_name" id="filter_name" value="{{ request('filter_name') }}" />
                    </div>
                    <button type="submit" class="btn btn-info" style="margin-right: 5px;" title="Search">
                        <i class="glyphicon glyphicon-search"></i>
                    </button>
                    <a href="/vendormultipleaddresses/vendor/{{ $vendor->id }}" class="btn btn-warning" style="margin-right: 5px;" title="Clear Filters">
                        Clear
                    </a>
                    <a href="{{ route('vendormultipleaddresses.create', $vendor->id) }}" class="btn btn-primary" style="margin-right: 5px;" title="Add New Address">
                        <i class="fa fa-plus"></i>
                    </a>

                      <a href="{{ route('vendormultipleaddresses.importPage', $vendor->id) }}" 
                        id="csvcreate"
                        data-toggle="tooltip" 
                        title="Bulk Import Addresses" 
                        class="btn btn-primary display_button">
                        <i class="fa fa-upload"></i>
                    </a>


                </form>
            </div>
        </div>

        <br>

        <!-- Address Table + Bulk Action Form -->
        @if(count($addresses) > 0)
        <form method="POST" action="{{ route('vendormultipleaddresses.bulkAction') }}" id="bulkActionForm">
            
            <div class="table-responsive">
                <table class="table table-bordered table-striped table-hover">
                    <thead>
                        <tr>
                            <th><input type="checkbox" id="select_all"></th>
                            <th>No.</th>
                            <th>Title</th>
                            <th>Address Line 1</th>
                            <th>Address Line 2</th>
                            <th>Landmark</th>
                            <th>City</th>
                            <th>State</th>
                            <th>Country</th>
                            <th>Pin Code</th>
                            <th>Contact Number</th>
                            <th>Action</th> <!-- Edit Column -->

                        </tr>
                    </thead>
                    <tbody>
                        @foreach($addresses as $index => $address)
                        <tr>
                            <td>
                                <input type="checkbox" name="address_ids[]" value="{{ $address->id }}" class="select_box">
                            </td>
                            <td>{{ $index + 1 }}</td>
                            <td>{{ $address->title_address ?? '-' }}</td>
                            <td>{{ $address->address_line1 }}</td>
                            <td>{{ $address->address_line2 }}</td>
                            <td>{{ $address->landmark }}</td>
                            <td>{{ $address->city }}</td>
                            <td>{{ $address->state }}</td>
                            <td>{{ $address->country }}</td>
                            <td>{{ $address->pin_code }}</td>
                            <td>{{ $address->contact_number }}</td>
                            <td>

<a href="{{ route('vendormultipleaddresses.edit', ['vendor_id' => $vendor->id, 'address_id' => $address->id]) }}"
   class="btn btn-sm btn-info"
   title="Edit Address">
   <i class="fa fa-pencil"></i> Edit
</a>






                        </td>

                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </form>
        @else
            <div class="alert alert-warning">No address records found for this vendor.</div>
        @endif

        <a href="/vendormultipleaddresses" class="btn btn-default mt-3">← Back to Vendor List</a>
    </div>
</div>

<!-- Select All Checkbox Script -->
<script>
    document.getElementById('select_all').addEventListener('change', function () {
        let checkboxes = document.querySelectorAll('.select_box');
        checkboxes.forEach(cb => cb.checked = this.checked);
    });
</script>
<script>
function redirectToSingleEdit(vendorId) {
    const selected = document.querySelector('input[name="address_ids[]"]:checked');

    if (!selected) {
        alert("Please select one address to edit.");
        return;
    }

    const id = selected.value;
    const url = `/vendormultipleaddresses/vendor/${vendorId}/edit/${id}`;
    window.location.href = url;
}

</script>

@endsection





{{-- <a href="{{ route('vendormultipleaddresses.edit', ['vendor_id' => $vendor->id, 'id' => $address->id]) }}"
   class="btn btn-sm btn-info" title="Edit Address">
   <i class="fa fa-pencil"></i> Edit
</a>
 --}}