@extends('app')

@section('content')
<title>Import Vendor Address</title>

<div class="content-wrapper">
    <div class="container">
        <h1 class="page-head-line">Bulk Import Addresses for: {{ $vendor->name }}</h1>

        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif

        @if($errors->any())
            <div class="alert alert-danger">
                @foreach($errors->all() as $error)
                    <p>{{ $error }}</p>
                @endforeach
            </div>
        @endif

        <form class="form-horizontal" id="import_form" method="POST" action="{{ route('vendormultipleaddresses.importCsv', $vendor->id) }}" enctype="multipart/form-data">
            
                <input type="hidden" name="_token" value="{{ csrf_token() }}" />
            <input type="hidden" name="vendor_id" value="{{ $vendor->id }}">


            <div class="form-group">
                <label class="col-md-2 control-label">Choose CSV File:</label>
                <div class="col-md-6">
                    <input type="file" name="import_file" class="form-control" required>
                </div>
            </div>

            <div class="form-group">
                <label class="col-md-2 control-label">Sample:</label>
                <div class="col-md-6">
                    <a href="{{ route('vendoraddress.sampledownload') }}" download>Download Sample CSV</a>
                </div>
            </div>

            <div class="form-group">
                <div class="col-md-6 col-md-offset-2">
                    <button type="submit" class="btn btn-success">Submit</button>
                    <a href="{{ route('vendormultipleaddresses.byvendor', $vendor->id) }}" class="btn btn-primary">Cancel</a>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection
{{-- resources/views/ManageVendorAddress/import.blade.php --}}