@extends('app')

@section('content')

<title>Add New Vendor Address</title>

{{-- Include Select2 CSS --}}
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<div class="content-wrapper">
    <div class="container">
        <h1 class="page-head-line">Add New Address for {{ $vendor->name ?? 'Vendor' }}</h1>

        @if ($errors->any())
            <div class="alert alert-danger">
                <strong>Whoops!</strong> Please fix the following errors:<br><br>
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form method="POST" action="{{ route('vendormultipleaddresses.store') }}">
            {{-- CSRF protection --}}
            <input type="hidden" name="_token" value="{{ csrf_token() }}" />
            <input type="hidden" name="vendor_id" value="{{ $vendor->id }}">

            <div class="row">

                            <!-- Title Address -->
<div class="col-md-6">
    <div class="form-group row">
        <label class="col-md-4 control-label">Title Address <span style="color:#FF0000">*</span></label>
        <div class="col-md-8">
            <input type="text" class="form-control" name="title_address" style="text-transform:capitalize;" value="{{ old('title_address') }}" required>
        </div>
    </div>
</div>
                <!-- Address Line 1 -->
                <div class="col-md-6">
                    <div class="form-group row">
                        <label class="col-md-4 control-label">Address Line 1 <span style="color:#FF0000">*</span></label>
                        <div class="col-md-8">
                            <textarea class="form-control" name="address_line1" rows="2" style="text-transform:capitalize;" required>{{ old('address_line1') }}</textarea>
                        </div>
                    </div>
                </div>

                <!-- Address Line 2 -->
                <div class="col-md-6">
                    <div class="form-group row">
                        <label class="col-md-4 control-label">Address Line 2</label>
                        <div class="col-md-8">
                            <textarea class="form-control" name="address_line2" rows="2" style="text-transform:capitalize;">{{ old('address_line2') }}</textarea>
                        </div>
                    </div>
                </div>

                <!-- Landmark -->
                <div class="col-md-6">
                    <div class="form-group row">
                        <label class="col-md-4 control-label">Landmark</label>
                        <div class="col-md-8">
                            <input type="text" class="form-control" name="landmark" style="text-transform:capitalize;" value="{{ old('landmark') }}">
                        </div>
                    </div>
                </div>

                <!-- City -->
                <div class="col-md-6">
                    <div class="form-group row">
                        <label class="col-md-4 control-label">City <span style="color:#FF0000">*</span></label>
                        <div class="col-md-8">
                            <input type="text" class="form-control" name="city" style="text-transform:capitalize;" value="{{ old('city', 'Mumbai') }}" required>
                        </div>
                    </div>
                </div>

                <!-- State -->
                <div class="col-md-6">
                    <div class="form-group row">
                        <label class="col-md-4 control-label">State <span style="color:#FF0000">*</span></label>
                        <div class="col-md-8">
                            <select id="state" name="state" class="form-control select2" required>
                                <option value="">Please Select</option>
                                @foreach($states as $state)
                                    <option value="{{ $state->name }}" {{ old('state', 'Maharashtra') == $state->name ? 'selected' : '' }}>
                                        {{ $state->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>

                <!-- Pin Code -->
                <div class="col-md-6">
                    <div class="form-group row">
                        <label class="col-md-4 control-label">Pin Code</label>
                        <div class="col-md-8">
                            <input type="text" class="form-control" name="pin_code" maxlength="6" placeholder="Enter Pin Code" value="{{ old('pin_code') }}">
                        </div>
                    </div>
                </div>

                <!-- Country -->
                <div class="col-md-6">
                    <div class="form-group row">
                        <label class="col-md-4 control-label">Country</label>
                        <div class="col-md-8">
                            <input type="text" class="form-control" name="country" value="{{ old('country', 'India') }}" readonly>
                        </div>
                    </div>
                </div>

                <!-- Contact Number -->
                <div class="col-md-6">
                    <div class="form-group row">
                        <label class="col-md-4 control-label">Contact Number <span style="color:#FF0000">*</span></label>
                        <div class="col-md-8">
                            <input type="text" class="form-control" name="contact_number" maxlength="15" placeholder="Enter Contact Number" value="{{ old('contact_number') }}" required>
                        </div>
                    </div>
                </div>
            </div>

            <br>

            <div class="form-group text-center">
                <button type="submit" class="btn btn-success">Save</button>
                <a href="{{ route('vendormultipleaddresses.byvendor', $vendor->id) }}" class="btn btn-default">Cancel</a>
            </div>
        </form>
    </div>
</div>

{{-- Select2 JS --}}
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function () {
        $('.select2').select2({
            placeholder: "Select a state",
            allowClear: true
        });
    });
</script>

@endsection
