<?php

namespace App\Http\Controllers\chat;

use App\User;
use Validator;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\ThrottlesLogins;
use Illuminate\Foundation\Auth\AuthenticatesAndRegistersUsers;
use Illuminate\Http\Request;
use App\Http\Requests;
use Illuminate\Support\Facades\Http; // << Add this line


use Input;
use DB;
use DateTime;
use Session;
use Mail;
use Carbon\Carbon;
use Config;
use Auth;


class chatbotcontroller extends Controller
{
    private $googleApiKey = 'AIzaSyBLW4S5bdXLXaxesf0vh6SiakDfhxkvuu4';

    public function index(){
        return view('chat.indexnew');
        
    }
    public function askAI($question, $defaultAnswer)
    {
        if (!$question) {
            return $defaultAnswer;
        }

        $schema = $this->getDatabaseSchema();
        $prompt = $this->buildPrompt($schema, $question);
        $sqlQuery = $this->getSqlFromGemini($prompt);
        if (!$sqlQuery) {
            return $defaultAnswer;
        }

        $results = $this->executeSqlSafely($sqlQuery);
        
        $answer = $this->formatResults($results, $sqlQuery);
        $answer = $this->generateNaturalAnswer($question, $sqlQuery, $answer);
        return  $answer;
    }

    private function getDatabaseSchema()
    {
        if (session()->has('database_schema')) {
            return session('database_schema');
        }
        $schema = '';
        
        $database = Config::get('app.DB_DATABASE'); // Consider making this configurable or dynamic if needed
        $tables = DB::select("SHOW TABLES");
        $tableKey = "Tables_in_{$database}";
        
        foreach ($tables as $tableObj) {
            // Check if the property exists to avoid errors with different DB drivers or versions
            if (isset($tableObj->$tableKey)) {
                $table = $tableObj->$tableKey;
                $columns = DB::select("SHOW COLUMNS FROM `{$table}`");

                $columnNames = array_map(function($col) {
                    return $col->Field;
                }, $columns);

                $schema .= "- {$table}(" . implode(', ', $columnNames) . ")\n";
            }
        }
        $schema = trim($schema);
        session(['database_schema' => $schema]);
        return $schema;
    }

    private function buildPrompt_backup($schema, $question)
    {
        return "You are an AI that converts natural language questions into SQL queries based on the following database schema:\n"
            . "\nhere some notes: if user says services is shipment, if user say technician & engineer is biker\n"
            . $schema
            . "\n\nUser question: {$question}\n"
            . "Return only the MYSQL query without any explanation.";
    }

    private function buildPrompt($schema, $question)
    {
        // return "You are an expert AI that translates user questions into MySQL queries using the following database schema.\n"
        //     . "Use MySQL syntax. Return only the SQL query without explanation.\n"
        //     . "\n"
        //     . "Vocabulary notes:\n"
        //     . "- If the user says 'technicians' or 'engineers', they mean data from the 'bikers' table.\n"
        //     . "- If the user says 'services' or 'deliveries', they mean data from the 'shipment' table.\n"
        //     . "- If the user says 'client' or 'clients', they mean data from the 'vendor' table.\n"
        //     . "- Map the user's natural terms to appropriate table and column names.\n"
        //     . "\n"
        //     . "Here rating is based on column technician and app.\n"
        //     . "Database Schema:\n"
        //     . $schema
        //     . "\n"
        //     . "User Question: {$question}\n"
        //     . "Only return the SQL query.";
        // return "You are an expert AI that converts natural language questions into MySQL queries using the database schema provided below.

        // Instructions:
        // - Use correct MySQL syntax.
        // - Do **not** include any explanation or commentary — only return the SQL query.
        // - Understand and map common user terms to the appropriate tables and columns as follows:
        // • 'technicians' or 'engineers' → `bikers` table  
        // • 'services' or 'deliveries' → `shipment` table  
        // • 'client' or 'clients' → `vendor` table  
        // • 'rating' → based on the `rating` table with `technician` and `app` columns  
        // (For example: `SELECT * FROM rating WHERE app >= 3 AND technician >= 3`)
        
        // - Make intelligent assumptions when mapping user intent to schema.

        // Database Schema:
        // $schema

        // User Question:
        // $question

        // Only return the MySQL query.";

        // return "You are an expert AI that converts natural language questions into MySQL queries using the database schema provided below.

        //     Instructions:
        //     - Use valid MySQL syntax.
        //     - Do **not** include any explanation or commentary — only return the SQL query.
        //     - Translate common user terms to the appropriate tables and columns:
        //     • 'technicians' or 'engineers' → `bikers` table  
        //     • 'services' or 'deliveries' → `shipment` table  
        //     • 'client' or 'clients' → `vendor` table  
        //     • 'rating' → based on the `rating` table with `technician` and `app` columns  
        //         (Example: `SELECT * FROM rating WHERE app >= 3 AND technician >= 3`)

        //     - When selecting data:
        //     • Prefer **readable fields** like `name`, `email`, `title`, `status`, `technician`, `vendor`, `shipment`, `biker`, `app`, `rating`, `type`, `terms` etc. instead of just `id`s.
        //     • Use `JOIN`s to pull names or details instead of showing foreign keys.
        //     • When encountering `vendor_id`, `product_id`, `biker_id`, `amc_id`, or `inventory_id`, use `JOIN` clauses with relatable tables to include meaningful like `name`, `email`, `title`, `status`, `technician`, `vendor`, `shipment`, `biker`, `app`, `rating`, `type`, `terms` etc.
        //     • `vendor_id` is realated to vendor table, `biker_id` related to biker, `prodct_id` related to products, `amc_id` is related to amcs, `inventory_id` is related to inventory table.
        //     • For 'most recent' records, use `ORDER BY ... DESC LIMIT 1`.
        //     • If dates are involved (e.g., AMC start or end), use them to determine recency.

        //     - Make intelligent assumptions when interpreting user intent and mapping it to the schema.

        //     Database Schema:
        //     $schema

        //     User Question:
        //     $question

        //     Only return the MySQL query.";

        //         return "You are an expert AI that converts natural language questions into MySQL queries using the database schema provided below.

        // Instructions:
        // - Use valid MySQL syntax.
        // - Do **not** include any explanation or commentary — only return the SQL query.

        // Vocabulary Mapping:
        // - 'technicians' or 'engineers' → `bikers` table  
        // - 'services' or 'deliveries' → `shipment` table  
        // - 'client' or 'clients' → `vendor` table  
        // - 'rating' → `rating` table using `technician` and `app` columns  
        //   (Example: SELECT * FROM rating WHERE app >= 3 AND technician >= 3)

        // Query Guidelines:
        // - Prefer **descriptive fields** like `name`, `email`, `title`, `status`, `technician`, `vendor`, `biker`, `app`, `rating`, `type`, `terms`, etc., rather than raw `id`s.
        // - If you encounter any of these foreign key columns:
        //   • `vendor_id` → JOIN with `vendor` table  
        //   • `biker_id` or `tech_id` → JOIN with `bikers` table  
        //   • `product_id` → JOIN with `products` table  
        //   • `amc_id` → JOIN with `amcs` table  
        //   • `inventory_id` → JOIN with `inventory` table
        // - When JOINing, select readable fields such as `name`, `type`, or `title` from the related tables to replace the IDs.
        // - Use `ORDER BY <date_column> DESC LIMIT 1` for queries about the 'most recent' records.
        // - Use date columns like `start_date` or `end_date` to determine recency where appropriate.
        // - Make intelligent assumptions when interpreting user intent and mapping it to the schema.

        // Database Schema:
        // $schema

        // User Question:
        // $question

        // Only return the MySQL query.";
        $user = Auth::user();           

        if(isset($user) && $user)
        {
            $user_type = 'admin';
            $username =  $user->first_name." ".$user->last_name; 
        }else{
            $username = Session::get('custname');
        }

        return "You are an expert AI that converts natural language questions into MySQL queries using the database schema provided below.

        Instructions:
        - Use correct MySQL syntax.
        - Do NOT include any explanations — only return the SQL query.
        - Always prefer descriptive fields like `name`, `email`, `title`, `status`, `type`, `terms`, etc. over showing raw numeric `id`s.
        - Always use JOINs to include meaningful information if any of these foreign key columns appear in the query:
            • `vendor_id` → JOIN with `vendor` table  
            • `biker_id`, `tech_id` → JOIN with `bikers` table  
            • `product_id` → JOIN with `products` table  
            • `amc_id` → JOIN with `amcs` table  
            • `inventory_id` → JOIN with `inventory` table
        
        - When selecting data:
            • For 'most recent' records, use `ORDER BY ... DESC LIMIT 1`.
            • For 'Latest' records, use `ORDER BY ... ASC LIMIT 1`.
            • And According to need change ORDER BY.

        - It is MANDATORY: if any column like `vendor_id`, `product_id`, `biker_id`, `amc_id`, or `inventory_id` is used, you must:
            1. Add an INNER JOIN or LEFT JOIN with the related table
            2. Select readable columns like `vendor.name`, `bikers.name`, `products.title`, etc.
            3. Do NOT show the raw ID in SELECT output.

        - For example, instead of:
            `SELECT vendor_id FROM amcs`
        Use:
            `SELECT vendor.name FROM amcs JOIN vendor ON amcs.vendor_id = vendor.id`

        - Understand that:
            • 'technicians' or 'engineers' → `bikers` table
            • 'services' or 'deliveries' → `shipment` table
            • 'client' or 'clients' → `vendor` table
            • 'rating' → use `rating` table with `technician` and `app` columns

        Special Condition:
        - If the question relates to the `shipment` table, apply this filter:  
        WHERE `created_by` LIKE '%$username%'
        
       - If \$user_type is 'admin':
            • And the question is about another user's data, apply a WHERE clause with  
                `created_by` LIKE '%[name]%' (infer the name from context — may exist in `vendor` or `users` table).
            
            • And the user is asking for services created by **customers**, even if twisted or phrased differently  
                (e.g., “show customer shipments”, “list all services from clients”, “deliveries made by customers”),  
                then apply:  
                `WHERE created_by LIKE '%customer%'`

        - Make intelligent assumptions when mapping user intent to tables and fields.

        Database Schema:
        $schema

        User Question:
        $question

        Only return the MySQL query.";
    }


    private function getSqlFromGemini($prompt) { 
        $apiKey = $this->googleApiKey; 
        $url = 'https://generativelanguage.googleapis.com/v1/models/gemini-1.5-flash:generateContent?key=' . $apiKey;

   
        $postData = [ 'contents' => [ [ 'role' => 'user', 'parts' => [ ['text' => $prompt] ] ] ] ]; 
        $jsonData = json_encode($postData); 
        $ch = curl_init(); 
        curl_setopt($ch, CURLOPT_URL, $url); 
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
        curl_setopt($ch, CURLOPT_POST, true); 
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData); 
        curl_setopt($ch, CURLOPT_HTTPHEADER, [ 'Content-Type: application/json', 'Content-Length: ' . strlen($jsonData) ]); 
        curl_setopt($ch, CURLOPT_TIMEOUT, 15); 
        $response = curl_exec($ch); 
        file_put_contents(storage_path('logs/gemini_response.log'), print_r($response, true));

        if ($response === false) { 
            curl_close($ch); 
            return null; 
        } 
        curl_close($ch); 
        $body = json_decode($response, true); 
        if (isset($body['candidates'][0]['content']['parts'][0]['text'])) { 
            return $this->cleanSql($body['candidates'][0]['content']['parts'][0]['text']); 
        } 
        return null; 
    }

    private function cleanSql($sql)
    {
        // remove ```sql or ``` fences if any
        $sql = preg_replace('/^```sql\s*/i', '', $sql);
        $sql = preg_replace('/^```\s*/i', '', $sql);
        $sql = preg_replace('/```$/', '', $sql);
        return trim($sql);
    }

    private function executeSqlSafely($sql)
    {

        if (stripos($sql, 'select') !== 0) {
            return ['error' => 'Only SELECT queries are allowed.'];
        }
        file_put_contents(storage_path('logs/sql_query.log'), "\n\nQuery: " . $sql . "\n", FILE_APPEND);
        
        try {
            $results = DB::select(DB::raw($sql));
            return $results;
        } catch (\Exception $e) {
            file_put_contents(storage_path('logs/sql_error.log'), "Error: " . $e->getMessage() . "\n", FILE_APPEND);
            return false;
        }
    }

    private function generateNaturalAnswer($question, $sqlQuery, $result)
    {
        $apiKey = $this->googleApiKey;
        $endpoint = 'https://generativelanguage.googleapis.com/v1/models/gemini-1.5-flash:generateContent?key=' . $apiKey;

        $text = "Original Question: \"$question\"\n";
        $text .= "SQL Query: $sqlQuery\n";
        $text .= "Result: " . json_encode($result) . "\n";
        $text .= "Generate a short natural language answer based on the result and if it is list then provide bulletins. 
        • Prefer **readable fields** like `name`, `email`, `title`, `status`, `technician`, `vendor`, `shipment`, `biker`, `app`, `rating`, `type`, `terms` etc. instead of just `id`s.
        • Use `JOIN`s to pull names or details instead of showing foreign keys.
        • When encountering `vendor_id`, `product_id`, `biker_id`, `amc_id`, or `inventory_id`, use `JOIN` clauses to include meaningful like `name`, `email`, `title`, `status`, `technician`, `vendor`, `shipment`, `biker`, `app`, `rating`, `type`, `terms` etc.";
        // $text .= "Generate a short, clear, and user-friendly natural language answer based on the result.";
        
        // $text .= "Guidelines:\n";
        // $text .= "• Prefer human-readable fields such as `name`, `email`, `title`, `status`, `technician`, `vendor`, `shipment`, `biker`, `app`, `rating`, `type`, `terms`, etc., instead of showing raw numeric `id`s.\n";
        // $text .= "• Use JOINs to include descriptive details instead of foreign key values.\n";
        // $text .= "• If the result includes columns like `vendor_id`, `product_id`, `biker_id`, `amc_id`, or `inventory_id`, assume that meaningful data (e.g., names, titles, statuses) has already been JOINed. Focus your response only on those readable fields.\n";
        
        $postData = [
            'contents' => [
                [
                    'role' => 'user',
                    'parts' => [
                        ['text' => $text]
                    ]
                ]
            ]
        ];

        $jsonData = json_encode($postData);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $endpoint);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Content-Length: ' . strlen($jsonData)
        ]);
        curl_setopt($ch, CURLOPT_TIMEOUT, 15);

        $response = curl_exec($ch);
        curl_close($ch);

        $body = json_decode($response, true);

        if (isset($body['candidates'][0]['content']['parts'][0]['text'])) {
            return trim($body['candidates'][0]['content']['parts'][0]['text']);
        }

        return "Here is your result.";
    }


    private function formatResults($results, $sql)
    {
        if (isset($results['error'])) {
            return $results['error'];
        }
        if (empty($results)) {
            return "No results found for the query.";
        }

        $text = "Query Results:\n";
        $count = 0;
        foreach ($results as $row) {
            $count++;
            $items = [];
            foreach ($row as $key => $value) {
                $items[] = "{$key}: {$value}";
            }
            $text .= implode(", ", $items) . "\n";
        }
        file_put_contents(storage_path('logs/sql_result.log'), "Result: " . $text . "\n", FILE_APPEND);
        return trim($text);
    }
   
    public function chatbot_answer(){
        $data = json_decode(file_get_contents('php://input'), true);

        // --- Chat Transcript Email Logic ---
        if (isset($data['action']) && $data['action'] === 'end_chat' && isset($data['transcript'])) {
            $dateToday = date('F j, Y'); // e.g., May 21, 2025
            $transcript = $data['transcript'];
            // Build HTML table for chat transcript
            $htmlBody = '
            <div style="font-family:Arial,sans-serif;background:#f4f8fb;padding:32px 0;">
            <div style="max-width:600px;margin:0 auto;background:#fff;border-radius:14px;overflow:hidden;box-shadow:0 4px 18px rgba(0,0,0,0.07);border:1px solid #e0e0e0;">
                <div style="background:linear-gradient(90deg,#1976d2 60%,#42a5f5 100%);color:#fff;padding:24px 32px;display:flex;align-items:center;justify-content:space-between;">
                <span style="font-size:22px;font-weight:700;letter-spacing:0.5px;">Apni AMC Chat Transcript - ' . $dateToday . '</span>
                </div>
                <table style="width:100%;border-collapse:collapse;font-size:15px;margin:0;">
                <thead>
                    <tr style="background:#f5f7fa;">
                    <th style="padding:16px 14px;border-bottom:2px solid #e3e3e3;text-align:left;">Sender</th>
                    <th style="padding:16px 14px;border-bottom:2px solid #e3e3e3;text-align:left;">Message</th>
                    </tr>
                </thead>
                <tbody">';
            foreach ($transcript as $msg) {
                $sender = htmlspecialchars(ucfirst($msg['sender']));
                $message =$msg['message'];
                // Sender initials avatar
                $initial = strtoupper(substr($sender,0,1));
                $avatar = '<span style="display:inline-block;width:32px;height:32px;background:#1976d2;color:#fff;border-radius:50%;text-align:center;line-height:32px;font-weight:bold;margin-right:10px;">'.$initial.'</span>';
                $htmlBody .= "<tr>
                <td style='padding:14px 12px;border-bottom:1px solid #f0f0f0;font-weight:600;color:#1976d2;vertical-align:top;'>
                    $avatar $sender
                </td>
                <td style='padding:14px 12px;border-bottom:1px solid #f0f0f0;vertical-align:top;'>$message</td>
                </tr>";
            }
            $htmlBody .= '
                </tbody>
                </table>
                <div style="background:#f5f5f5;padding:16px 28px;text-align:center;color:#888;font-size:13px;border-top:1px solid #e0e0e0;">
                End of transcript &mdash; Thank you for chatting with Apni AMC!
                </div>
                <div style="padding:18px 32px;text-align:center;color:#b0b0b0;font-size:12px;">
                &copy; 2025 Apni AMC. All rights reserved.<br>
                <a href="mailto:support@apniamc.com" style="color:#1976d2;text-decoration:none;">Contact Support</a>
                </div>
            </div>
            </div>';

            // Build plain text fallback
            $plainBody = "Apni AMC Chat Transcript:\n\n";
            foreach ($transcript as $msg) {
                $plainBody .= strtoupper($msg['sender']) . ": " . $msg['message'] . "\n";
            }
            // custommailsend('ami@mukesoft.com', 'Apni AMC Chat Transcript - ' . $dateToday, $htmlBody, $plainBody);
            exit;
        }

        $question = $data['question'] ?? '';
        // $question = $this->correctSpelling($question_old);

        if (empty($question)) {
            echo json_encode(['error' => 'No question provided.']);
            exit;
        }

        $path = public_path('uploads/apniamc.txt');

        // Read file content if it exists
        $manualText = file_exists($path) ? file_get_contents($path) : '';

        // $promptText = "Apni AMC Project:\n$manualText\n\nQuestion: $question\n\nPlease answer briefly and concisely in 1-2 sentences, focusing only on the most important information. in answer do not mention about this is referal from any document
        // \n if in answer mention that this is not in document or manual it should reply Kindly reach out to our support team at pankaj@mukesoft.com for any further details or assistance.";
        // $promptText = <<<EOT
        // Apni AMC Project Manual:
        // $manualText
        
        // Question:
        // $question
        
        // Instructions:
        // You are a classifier. Decide whether the user's message requires data from the Apni AMC database or not.
        // If the message is asking for specific records, counts, lists, or other information that must be fetched from a database table, answer only "DB".

        // - If the user message is a greeting (e.g., "hi", "hello", "hey", "good morning", "good afternoon", etc.), reply with the same greeting and follow it with: "How can I assist you with Apni AMC today?".
        // Example: if the message is "Hello", reply with "Hello! How can I assist you with Apni AMC today?"
        // -If the message is a thank you or acknowledgment (e.g., "thanks", "thank you", "okay", "great", "cheers", etc.), respond with:
        // "Thank you! Should you need any more information or assistance, please feel free to get in touch at your convenience."
        // - Otherwise, answer in 1-2 concise sentences based only on the manual above.
        // - Focus only on the most important information.
        // - Do NOT mention that this is based on a document or manual.
        // - If the answer cannot be found in the provided manual, respond exactly with:
        // "Kindly reach out to our support team at pankaj@mukesoft.com for any further details or assistance."
        // EOT;
        // $promptText = <<<EOT
        // Apni AMC Project Manual:
        // $manualText
        
        // User Message:
        // "$question"
        
        // Instructions:
        // 1. First, correct any spelling mistakes in the user message.
        // 2. Then, reply naturally based on the corrected message using the following rules:
        
        // - If the corrected message is a **greeting** (e.g., "hi", "hello", "hey", "good morning"), reply using the **same greeting**, followed by:  
        //   "How can I assist you with Apni AMC today?"
        
        // - If the message expresses **thanks or acknowledgment** (e.g., "thanks", "thank you", "okay", "cheers"), respond with:  
        //   "Thank you! Should you need any more information or assistance, please feel free to get in touch at your convenience."
        
        // - If the message is something friendly or polite like "nice to talk to you", reply with:  
        //   "It's nice to talk with you too. How can I assist you with Apni AMC today?"
        
        // - If the corrected message asks for **records, lists, counts**, or anything related to data stored in the AMC system database, respond only with:  
        //   DB
        
        // - If the message asks about something that can be answered using the manual, answer briefly (1-2 sentences), focusing only on the most important information.  
        //   Do **not** mention the manual in your response.
        
        // - If the information is **not available in the manual**, respond with:  
        //   "Kindly reach out to our support team at pankaj@mukesoft.com for any further details or assistance."
        
        // Also include:
        // - Corrected message: "<corrected_text_here>"
        // - Response: "<your final reply>"
        // EOT;
        $promptText = <<<EOT
        Apni AMC Project Manual:
        $manualText

        User Message:
        "$question"

        Instructions:
        - First, silently correct any spelling mistakes in the user's message.
        - Then respond naturally and appropriately using the corrected message, following these rules:

        1. If the corrected message is a greeting (e.g., "hi", "hello", "hey", "good morning"), reply using the **same greeting**, followed by:  
        "How can I assist you with Apni AMC today?"

        2. If the message expresses thanks or acknowledgment (e.g., "thanks", "thank you", "okay", "cheers"), reply with:  
        "Thank you! Should you need any more information or assistance, please feel free to get in touch at your convenience."

        3. If the message is something polite like "nice to talk to you", reply with:  
        "It's nice to talk with you too. How can I assist you with Apni AMC today?"

        4. If the message asks for any information from the AMC database (records, lists, etc.), respond only with:  
        DB

        5. If the message can be answered from the manual, reply briefly (1-2 sentences), focused only on key information.  
        Do not mention the manual.

        6. If the answer is not in the manual, respond with:  
        "Kindly reach out to our support team at pankaj@mukesoft.com for any further details or assistance."

        Only return the final response. Do not include the corrected message or any extra explanation.
        EOT;

        $answer = $this->getanserfromAI($promptText);

        if ($answer) {
            if(strstr($answer, 'DB'))
            {
                $answer = $this->askAI($question, $answer);
            }    
            echo json_encode(['answer' => $answer]);
        } else {
            echo json_encode(['error' => 'No valid answer returned.', 'raw_response' => $data]);
        }

    }
    public function custommailsend($to, $subject, $htmlbody=null, $plainBody=null,$clientName=null) {
        $mail = new PHPMailer(true);
        try {
            $mail->isSMTP();
            $mail->Host = 'smtp.gmail.com';
            $mail->SMTPAuth = true;
            $mail->Username = 'ami.mukesoft@gmail.com';
            $mail->Password = 'arkbzzeelptwazit';
            $mail->SMTPSecure = 'tls';
            $mail->Port = 587;

            $mail->setFrom('ami.mukesoft@gmail.com', 'Chatbot');
            $mail->addAddress($to);
            $mail->isHTML(true);
            $mail->Subject = $subject;
            $mail->Body = $htmlbody;
            $mail->AltBody = strip_tags($plainBody);
            $mail->send();
            return json_encode(['success' => true]);
        } catch (Exception $e) {
            return json_encode(['success' => false, 'error' => $mail->ErrorInfo]);
        }

    }
    private function getanserfromAI($promptText)
    {
        // Gemini API call setup
        $apiKey = $this->googleApiKey;
        // $endpoint = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=' . $apiKey;
        $endpoint = 'https://generativelanguage.googleapis.com/v1/models/gemini-1.5-flash:generateContent?key=' . $apiKey;

        $postData = [
            'contents' => [
                [
                    'role' => 'user',
                    'parts' => [
                        ['text' => $promptText]
                    ]
                ]
            ]
        ];

        $ch = curl_init($endpoint);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json'
        ]);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        // Handle response
        if ($httpCode >= 400) {
            echo json_encode(['error' => "API error (HTTP $httpCode).", 'response' => $response]);
            exit;
        }

        $data = json_decode($response, true);
        $answer = $data['candidates'][0]['content']['parts'][0]['text'] ?? null;

        return $answer;
    }
    
    public function correctSpelling($input) {
        $data = [
            'text' => $input,
            'language' => 'en-US'
        ];
        $ch = curl_init('https://api.languagetoolplus.com/v2/check');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        $result = curl_exec($ch);
        curl_close($ch);
        $response = json_decode($result, true);

        $corrections = [];
        if (!empty($response['matches'])) {
            foreach ($response['matches'] as $match) {
                if (!empty($match['replacements'])) {
                    $corrections[$match['offset']] = [
                        'length' => $match['length'],
                        'replacement' => $match['replacements'][0]['value']
                    ];
                }
            }
        }

        if (empty($corrections)) {
            return $input;
        }

        // Apply corrections from the end to avoid messing up offsets
        krsort($corrections);
        foreach ($corrections as $offset => $correction) {
            $input = substr_replace($input, $correction['replacement'], $offset, $correction['length']);
        }
        return $input;
    }

}
