<?php

namespace App\Http\Controllers\chat;

use App\User;
use Validator;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\ThrottlesLogins;
use Illuminate\Foundation\Auth\AuthenticatesAndRegistersUsers;
use Illuminate\Http\Request;
use App\Http\Requests;
use Illuminate\Support\Facades\Http; // << Add this line


use Input;
use DB;
use DateTime;
use Session;
use Mail;
use Carbon\Carbon;
use Config;
use Auth;


class chatbotcontroller extends Controller
{
    private $googleApiKey = 'AIzaSyBLW4S5bdXLXaxesf0vh6SiakDfhxkvuu4';
    private $modelName = 'gemini-1.5-turbo';  // change if needed

    public function askAI($question, $defaultAnswer)
    {
        if (!$question) {
            return $defaultAnswer;
        }

        $schema = $this->getDatabaseSchema();
        $prompt = $this->buildPrompt($schema, $question);
        $sqlQuery = $this->getSqlFromGemini($prompt);
        if (!$sqlQuery) {
            return $defaultAnswer;
        }

        $results = $this->executeSqlSafely($sqlQuery);

        // if ($results === false || empty($results)) {
        //     return $defaultAnswer;
        // }
        $answer = $this->formatResults($results, $sqlQuery);
        $answer = $this->generateNaturalAnswer($question, $sqlQuery, $answer);
        return  $answer;
    }

    private function getDatabaseSchema()
    {
        $schema = '';
        $database = 'apni_amc_uat';
        $tables = DB::select("SHOW TABLES");
        $tableKey = "Tables_in_{$database}";
        
        foreach ($tables as $tableObj) {
            $table = $tableObj->$tableKey;
            $columns = DB::select("SHOW COLUMNS FROM `{$table}`");

            $columnNames = array_map(function($col) {
                return $col->Field;
            }, $columns);

            $schema .= "- {$table}(" . implode(', ', $columnNames) . ")\n";
        }
        return trim($schema);
    }

    private function buildPrompt_backup($schema, $question)
    {
        return "You are an AI that converts natural language questions into SQL queries based on the following database schema:\n"
            . "\nhere some notes: if user says services is shipment, if user say technician & engineer is biker\n"
            . $schema
            . "\n\nUser question: {$question}\n"
            . "Return only the MYSQL query without any explanation.";
    }
    private function buildPrompt($schema, $question)
    {
        return "You are an expert AI that translates user questions into MySQL queries using the following database schema.\n"
            . "Use MySQL syntax. Return only the SQL query without explanation.\n"
            . "\n"
            . "Vocabulary notes:\n"
            . "- If the user says 'technicians' or 'engineers', they mean data from the 'bikers' table.\n"
            . "- If the user says 'services' or 'deliveries', they mean data from the 'shipment' table.\n"
            . "- If the user says 'client' or 'clients', they mean data from the 'vendor' table.\n"
            . "- Map the user's natural terms to appropriate table and column names.\n"
            . "\n"
            . "Database Schema:\n"
            . $schema
            . "\n"
            . "User Question: {$question}\n"
            . "Only return the SQL query.";
    }


    private function getSqlFromGemini($prompt) { 
        $apiKey = $this->googleApiKey; 
        $url = 'https://generativelanguage.googleapis.com/v1/models/gemini-1.5-flash:generateContent?key=' . $apiKey;

   
        $postData = [ 'contents' => [ [ 'role' => 'user', 'parts' => [ ['text' => $prompt] ] ] ] ]; 
        $jsonData = json_encode($postData); 
        $ch = curl_init(); 
        curl_setopt($ch, CURLOPT_URL, $url); 
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
        curl_setopt($ch, CURLOPT_POST, true); 
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData); 
        curl_setopt($ch, CURLOPT_HTTPHEADER, [ 'Content-Type: application/json', 'Content-Length: ' . strlen($jsonData) ]); 
        curl_setopt($ch, CURLOPT_TIMEOUT, 15); 
        $response = curl_exec($ch); 
        file_put_contents(storage_path('logs/gemini_response.log'), print_r($response, true));

        if ($response === false) { 
            curl_close($ch); 
            return null; 
        } 
        curl_close($ch); 
        $body = json_decode($response, true); 
        if (isset($body['candidates'][0]['content']['parts'][0]['text'])) { 
            return $this->cleanSql($body['candidates'][0]['content']['parts'][0]['text']); 
        } 
        return null; 
    } 


    private function cleanSql($sql)
    {
        // remove ```sql or ``` fences if any
        $sql = preg_replace('/^```sql\s*/i', '', $sql);
        $sql = preg_replace('/^```\s*/i', '', $sql);
        $sql = preg_replace('/```$/', '', $sql);
        return trim($sql);
    }

    private function executeSqlSafely($sql)
    {

        if (stripos($sql, 'select') !== 0) {
            return ['error' => 'Only SELECT queries are allowed.'];
        }
        file_put_contents(storage_path('logs/sql_query.log'), "\n\nQuery: " . $sql . "\n", FILE_APPEND);
        // if (stripos($sql, 'limit') === false) {
        //     $sql .= " LIMIT 100";
        // }

        try {
            $results = DB::select(DB::raw($sql));
            return $results;
        } catch (\Exception $e) {
            file_put_contents(storage_path('logs/sql_error.log'), "Error: " . $e->getMessage() . "\n", FILE_APPEND);
            return false;
        }
    }
    private function generateNaturalAnswer($question, $sqlQuery, $result)
    {
        $apiKey = $this->googleApiKey;
        $endpoint = 'https://generativelanguage.googleapis.com/v1/models/gemini-1.5-flash:generateContent?key=' . $apiKey;

        $text = "Original Question: \"$question\"\n";
        $text .= "SQL Query: $sqlQuery\n";
        $text .= "Result: " . json_encode($result) . "\n";
        $text .= "Generate a short natural language answer based on the result.";

        $postData = [
            'contents' => [
                [
                    'role' => 'user',
                    'parts' => [
                        ['text' => $text]
                    ]
                ]
            ]
        ];

        $jsonData = json_encode($postData);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $endpoint);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Content-Length: ' . strlen($jsonData)
        ]);
        curl_setopt($ch, CURLOPT_TIMEOUT, 15);

        $response = curl_exec($ch);
        curl_close($ch);

        $body = json_decode($response, true);

        if (isset($body['candidates'][0]['content']['parts'][0]['text'])) {
            return trim($body['candidates'][0]['content']['parts'][0]['text']);
        }

        return "Here is your result.";
    }


    private function formatResults($results, $sql)
    {
        if (isset($results['error'])) {
            return $results['error'];
        }
        if (empty($results)) {
            return "No results found for the query.";
        }

        $text = "Query Results:\n";
        $count = 0;
        foreach ($results as $row) {
            $count++;
            $items = [];
            foreach ($row as $key => $value) {
                $items[] = "{$key}: {$value}";
            }
            $text .= implode(", ", $items) . "\n";
        }
        file_put_contents(storage_path('logs/sql_result.log'), "Result: " . $text . "\n", FILE_APPEND);
        return trim($text);
    }
   
    public function chatbot_answer(){
        $data = json_decode(file_get_contents('php://input'), true);

        // --- Chat Transcript Email Logic ---
        if (isset($data['action']) && $data['action'] === 'end_chat' && isset($data['transcript'])) {
            $dateToday = date('F j, Y'); // e.g., May 21, 2025
            $transcript = $data['transcript'];
            // Build HTML table for chat transcript
            $htmlBody = '
            <div style="font-family:Arial,sans-serif;background:#f4f8fb;padding:32px 0;">
            <div style="max-width:600px;margin:0 auto;background:#fff;border-radius:14px;overflow:hidden;box-shadow:0 4px 18px rgba(0,0,0,0.07);border:1px solid #e0e0e0;">
                <div style="background:linear-gradient(90deg,#1976d2 60%,#42a5f5 100%);color:#fff;padding:24px 32px;display:flex;align-items:center;justify-content:space-between;">
                <span style="font-size:22px;font-weight:700;letter-spacing:0.5px;">Apni AMC Chat Transcript - ' . $dateToday . '</span>
                </div>
                <table style="width:100%;border-collapse:collapse;font-size:15px;margin:0;">
                <thead>
                    <tr style="background:#f5f7fa;">
                    <th style="padding:16px 14px;border-bottom:2px solid #e3e3e3;text-align:left;">Sender</th>
                    <th style="padding:16px 14px;border-bottom:2px solid #e3e3e3;text-align:left;">Message</th>
                    </tr>
                </thead>
                <tbody">';
            foreach ($transcript as $msg) {
                $sender = htmlspecialchars(ucfirst($msg['sender']));
                $message =$msg['message'];
                // Sender initials avatar
                $initial = strtoupper(substr($sender,0,1));
                $avatar = '<span style="display:inline-block;width:32px;height:32px;background:#1976d2;color:#fff;border-radius:50%;text-align:center;line-height:32px;font-weight:bold;margin-right:10px;">'.$initial.'</span>';
                $htmlBody .= "<tr>
                <td style='padding:14px 12px;border-bottom:1px solid #f0f0f0;font-weight:600;color:#1976d2;vertical-align:top;'>
                    $avatar $sender
                </td>
                <td style='padding:14px 12px;border-bottom:1px solid #f0f0f0;vertical-align:top;'>$message</td>
                </tr>";
            }
            $htmlBody .= '
                </tbody>
                </table>
                <div style="background:#f5f5f5;padding:16px 28px;text-align:center;color:#888;font-size:13px;border-top:1px solid #e0e0e0;">
                End of transcript &mdash; Thank you for chatting with Apni AMC!
                </div>
                <div style="padding:18px 32px;text-align:center;color:#b0b0b0;font-size:12px;">
                &copy; 2025 Apni AMC. All rights reserved.<br>
                <a href="mailto:support@apniamc.com" style="color:#1976d2;text-decoration:none;">Contact Support</a>
                </div>
            </div>
            </div>';

            // Build plain text fallback
            $plainBody = "Apni AMC Chat Transcript:\n\n";
            foreach ($transcript as $msg) {
                $plainBody .= strtoupper($msg['sender']) . ": " . $msg['message'] . "\n";
            }
            // custommailsend('ami@mukesoft.com', 'Apni AMC Chat Transcript - ' . $dateToday, $htmlBody, $plainBody);
            exit;
        }

        $question_old = $data['question'] ?? '';
        $question = $this->correctSpelling($question_old);

        // echo $question;

        if (empty($question)) {
            echo json_encode(['error' => 'No question provided.']);
            exit;
        }
        $slot_page = $data['slot_page'] ?? '0';

        // Check for greeting/thanks and respond directly
        $greetingPatterns = [
            '/\bok\b/i',
            '/\bokay\b/i',
            '/\bthank you\b/i',
            '/\bthanks\b/i',
            '/\bthx\b/i',
            '/\bthankyou\b/i',
            '/\bgrateful\b/i',
            '/\bappreciate\b/i',
            '/\bcheers\b/i',
            '/\bgrate\b/i'

        ];
        foreach ($greetingPatterns as $pattern) {
            if (preg_match($pattern, $question)) {
                $greetMsg = 'Thank you! Should you need any more information or assistance, please feel free to get in touch at your convenience.';
                echo json_encode(['answer' => $greetMsg]);
                exit;
            }
        }
       
        // Prepare the content text (e.g., from manual + question)
        // $manualText = file_exists('apniamc user manual.txt') ? file_get_contents('apniamc user manual.txt') : '';
        $manualText = file_exists('public/uploads/apniamc.txt') ? file_get_contents('public/uploads/apniamc.txt') : '';

        $checkgreeting = $this->checkgreetings($question);

        if($checkgreeting == 'yes')
        {
            echo json_encode(['answer' => 'How can I help you with Apni AMC?']);
            exit;
        }

        $promptText = "Apni AMC Project:\n$manualText\n\nQuestion: $question\n\nPlease answer briefly and concisely in 1-2 sentences, focusing only on the most important information.";


        $answer = $this->getanserfromAI($promptText);

        if ($answer) {
            // Make answer short and meaningful: keep only the first sentence or up to 150 chars
            $shortAnswer = preg_split('/([.!?])/', $answer, 2, PREG_SPLIT_DELIM_CAPTURE);
            if (count($shortAnswer) > 1) {
                $answer = trim($shortAnswer[0] . $shortAnswer[1]);
            } else {
                $answer = mb_substr($answer, 0, 150) . (mb_strlen($answer) > 150 ? '...' : '');
            }

            // Fallback if answer mentions missing documentation
            $missingDocPatterns = [
                '/not (in|into) (the )?document/i',
                '/not specified (in|on|by) (the )?(manual|document)/i',
                '/not mentioned (in|on|by) (the )?(manual|document)/i',
                '/not covered (in|on|by) (the )?(manual|document)/i',
                '/not detailed (in|on|by) (the )?(manual|document)/i',
                '/manual doesn\'t (cover|specify|mention)/i',
                '/document doesn\'t (cover|specify|mention)/i',
                '/no step(-| )?by(-| )?step (instruction|guide)/i',
                '/details (are )?(missing|not provided|not available)/i',
                '/not available in the manual/i',
                '/not available in document/i',
                '/not present in (the )?(manual|document)/i',
                '/not found in (the )?(manual|document)/i',
                '/not included in (the )?(manual|document)/i',
                '/not listed in (the )?(manual|document)/i',
                '/no information about.*in (the )?(manual|document)/i',
                '/there is no information about.*in (the )?(manual|document)/i',
                '/there is no information about/i',
                '/there is no .* in (the )?(manual|document)/i',
                '/no information about/i',
                '/not found in (the )?document/i',
                '/not available in (the )?document/i',
                '/not present in (the )?document/i',
                '/not included in (the )?document/i',
                '/not listed in (the )?document/i',
                '/not covered in (the )?document/i',
                '/not described in (the )?document/i',
                '/AMC documentation doesn\'t detail/i',
                '/The provided document doesn\'t detail/i',
                '/documentation doesn\'t detail/i',
                '/provided doesn\'t/i',
                '/provided doesn\'t specify/i',
                '/provided text doesn\'t detail/i',
                '/not available in the provided text/i',
                '/not available in the provided document/i',
                '/The provided text doesn\'t specify/i',
                '/provided text/i',
                '/provided document/i',
            ];
            foreach ($missingDocPatterns as $pattern) {
                if (preg_match($pattern, $answer)) {
                    $answer = 'Kindly reach out to our support team at pankaj@mukesoft.com for any further details or assistance.';
                    break;
                }
            }
            $answer = $this->askAI($question, $answer);
    
            echo json_encode(['answer' => $answer]);
        } else {
            echo json_encode(['error' => 'No valid answer returned.', 'raw_response' => $data]);
        }

    }
    public function custommailsend($to, $subject, $htmlbody=null, $plainBody=null,$clientName=null) {
        $mail = new PHPMailer(true);
        try {
            $mail->isSMTP();
            $mail->Host = 'smtp.gmail.com';
            $mail->SMTPAuth = true;
            $mail->Username = 'ami.mukesoft@gmail.com';
            $mail->Password = 'arkbzzeelptwazit';
            $mail->SMTPSecure = 'tls';
            $mail->Port = 587;

            $mail->setFrom('ami.mukesoft@gmail.com', 'Chatbot');
            $mail->addAddress($to);
            $mail->isHTML(true);
            $mail->Subject = $subject;
            $mail->Body = $htmlbody;
            $mail->AltBody = strip_tags($plainBody);
            $mail->send();
            return json_encode(['success' => true]);
        } catch (Exception $e) {
            return json_encode(['success' => false, 'error' => $mail->ErrorInfo]);
        }

    }
    // public function checkgreetings($input){
    //     $apiKey = 'AIzaSyBLW4S5bdXLXaxesf0vh6SiakDfhxkvuu4';

    //     $promptText = "Is this a greeting: \"$input\"? Reply only with yes or no.";

    //     // Gemini API call setup
    //     $endpoint = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=' . $apiKey;

    //     $postData = [
    //         'contents' => [
    //             [
    //                 'role' => 'user',
    //                 'parts' => [
    //                     ['text' => $promptText]
    //                 ]
    //             ]
    //         ]
    //     ];

    //     $ch = curl_init($endpoint);
    //     curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    //     curl_setopt($ch, CURLOPT_POST, true);
    //     curl_setopt($ch, CURLOPT_HTTPHEADER, [
    //         "Content-Type: application/json"
    //     ]);
    //     curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));

    //     $response = curl_exec($ch);
    //     curl_close($ch);

    //     $responseData = json_decode($response, true);
    //     $reply = strtolower(trim($responseData['candidates'][0]['content']['parts'][0]['text'] ?? ''));

    //     return $reply;
    // }
    // public function checkgreetings($input)
    // {
    //     $input = strtolower(trim($input));
    //     $greetings = ['hi', 'hello', 'hey', 'greetings', 'good morning', 'good evening', 'good afternoon'];

    //     foreach ($greetings as $greet) {
    //         if (str_starts_with($input, $greet) || $input === $greet) {
    //             return true;
    //         }
    //     }
    //     return false;
    // }

    public function checkgreetings($text)
    {
        $apiKey = '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';
        $url = 'https://api-inference.huggingface.co/models/facebook/bart-large-mnli';

        $headers = [
            "Authorization: Bearer $apiKey",
            "Content-Type: application/json"
        ];

        $postData = [
            "inputs" => $text,
            "parameters" => [
                "candidate_labels" => ["greeting", "question", "other"]
            ]
        ];

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));
        $response = curl_exec($ch);
        curl_close($ch);

        $result = json_decode($response, true);

        // Check if "greeting" has the highest score
        $labels = $result['labels'] ?? [];
        // print_r($labels);die;
        if (isset($labels[0]) && strtolower($labels[0]) === 'greeting') {
            return true;
        }

        return false;
    }

    private function getanserfromAI($promptText)
    {
        // Gemini API call setup
        $apiKey = 'AIzaSyBLW4S5bdXLXaxesf0vh6SiakDfhxkvuu4'; // Replace with your Gemini API key
        $endpoint = 'https://generativelanguage.googleapis.com/v1beta/models/gemini-1.5-flash:generateContent?key=' . $apiKey;

        $postData = [
            'contents' => [
                [
                    'role' => 'user',
                    'parts' => [
                        ['text' => $promptText]
                    ]
                ]
            ]
        ];

        $ch = curl_init($endpoint);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json'
        ]);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($postData));

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        // Handle response
        if ($httpCode >= 400) {
            echo json_encode(['error' => "API error (HTTP $httpCode).", 'response' => $response]);
            exit;
        }

        $data = json_decode($response, true);
        $answer = $data['candidates'][0]['content']['parts'][0]['text'] ?? null;

        return $answer;
    }
    
    public function correctSpelling($input) {
        $data = [
            'text' => $input,
            'language' => 'en-US'
        ];
        $ch = curl_init('https://api.languagetoolplus.com/v2/check');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        $result = curl_exec($ch);
        curl_close($ch);
        $response = json_decode($result, true);

        $corrections = [];
        if (!empty($response['matches'])) {
            foreach ($response['matches'] as $match) {
                if (!empty($match['replacements'])) {
                    $corrections[$match['offset']] = [
                        'length' => $match['length'],
                        'replacement' => $match['replacements'][0]['value']
                    ];
                }
            }
        }

        if (empty($corrections)) {
            return $input;
        }

        // Apply corrections from the end to avoid messing up offsets
        krsort($corrections);
        foreach ($corrections as $offset => $correction) {
            $input = substr_replace($input, $correction['replacement'], $offset, $correction['length']);
        }
        return $input;
    }

}
