<?php

namespace App\Http\Controllers\VendorLogin;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use DB;
use Session;
use DateTime;

class OrderController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Respons
     */
    // public function __construct() {
    //     if((Session::has('vendor_id'))) {    
    //         return $this->index();
    //     } else {
    //        return view('vendorlogin.login');
    //     }
    // }
    public function index($domain, $tld, $status = false) {   
        if((Session::has('vendor_id'))) {  
            $filter_status = $status;         
            $query = DB::table('shipment')
                            ->select('*')
                            ->where('shipment.vendor_id', '=', Session::get('vendor_id'));
 		  $query->orderBy('sh.id','DESC');

          $deliveries = $query->get();
            $statuses = ['New','In Progress','Awaiting Spares','Work Pending','Client Side','Completed','Closed','Cancelled'];
            return view('vendorlogin.order')->withDeliveries($deliveries)->withStatuses($statuses);
        } else {
           return redirect("login/");
        }
        
    }
    public function DownloadExel() {
        $orders = DB::table('shipment')
                            ->leftjoin('buyer','buyer.id', '=', 'shipment.buyer_id')
                            ->leftjoin('address','address.id', '=', 'shipment.drop_address_id')
                            ->leftjoin('cod_collected as cc','shipment.id','=','cc.shipment_id')
                            ->select('shipment.awb_no', 'shipment.order_id', 'shipment.order_time','shipment.invoice_amount','buyer.name','shipment.delivery_status','shipment.cost','shipment.payment_mode','cc.amount as cod_collected_amount','cc.date as cod_collected_date','address.address','address.city','address.pincode')
                            ->where('shipment.vendor_id', '=', Session::get('vendor_id'))
                            ->whereIn('shipment.delivery_status',['Delivered','Delivered_Cash collected','Delivered_card on delivery','Delivered_Open box','RTN Delivered'])
                            ->orderBy('shipment.order_time', 'desc')
                            ->get();
            //$fields = array('awb_no','order_id','order_time','invoice_amount','name','delivery_status');
            $csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
            $csv->insertOne(array('AWB No.','Order ID','Order Placed','Invoice Amount','Ship To','Status','Cost','Payment Mode','COD Collected Amount','COD Collected Date','Drop Address','Drop City','Drop Pincode'));
            foreach ($orders as $line) { 
                    $line = (array) $line;
                    $order_time = new DateTime($line['order_time']);
                    $line['order_time'] = $order_time->format('d/m/Y H:i:s');
                    $cod_collected_date = new DateTime($line['cod_collected_date']);
                    $line['cod_collected_date'] = $cod_collected_date->format('d/m/Y');
                    //$line['drop_address'] = stripslashes(trim($line['drop_address']))." ".$line['city']." ".$line['pincode']." ".$line['state'];
                    $csv->insertOne($line);
            }
            $csv->output('cod_history_report.csv');
    }

    public function printinvoice($domain, $tld, $id) {
        if((Session::has('vendor_id'))) { 
            $shipment_detail = DB::table('shipment')
                                   ->select('shipment.*', 'pa.address as pickup_address','pa.address_1 as pickup_address_1','pa.landmark as pickup_landmark' ,'pa.city as pickup_city','pa.state as pickup_state','pa.pincode as pickup_pincode','da.address as drop_address','da.address_1 as drop_address_1' ,'da.pincode as drop_pincode','da.city as drop_city','da.state as drop_state','da.landmark as drop_landmark','bu.contact_no as contact_no','bu.name as buyer_name','vd.company_name as vendor_company_name', 'vd.name as vendor_name', 'vd.mobile_no as vendor_mobile_no',DB::raw('(SELECT SUM(weight) FROM shipment_packages as sp WHERE shipment.id = sp.shipment_id) as total_weight '))
                                   ->join('address as pa', 'pa.id', '=', 'shipment.pickup_address_id')
                                   ->join('address as da', 'da.id', '=', 'shipment.drop_address_id')
                                   ->join('buyer as bu','bu.id', '=', 'shipment.buyer_id')
                                   ->join('vendor as vd','vd.id', '=', 'shipment.vendor_id')
                                   ->where('shipment.id',$id)
                                   ->first();
            if($shipment_detail->vendor_id == Session::get('vendor_id')) {
                $shipment_packages = DB::table('shipment_packages')
                                       ->select('*')
                                       ->where('shipment_id',$id)
                                       ->get();
                return view('vendorlogin.invoice')->withshipment_detail($shipment_detail)->withShipmentPackages($shipment_packages);
            } else {
                return redirect('order');
            }
      } else {
        return view('vendorlogin.login');
      }
    }
    public function ShipmentReport() {
        return view('vendorlogin.vendor_shipment_report');
    }
    public function getStatusHead($status) {
        if($status == 'Order Received') {
            return 'Order Received';
        }

        if($status == 'Order Assigned_Cancel'||$status =='Order assigned_Pickup cancel') {
            return 'Order Cancelled';
        }


        if($status == 'Assigned' || $status == 'Order Assigned' ||  $status == 'Order Assigned not ready' || $status == 'Order Reassigned_1' || $status == 'Order Reassigned_2') {
            return 'Assigned';
        }

        if($status == 'At_SubStation'  || $status == 'At Substation_Reattempt1'|| $status == 'At_Substation_Reattempt2') {
            return 'At Sub Station';
        }

        if($status == 'At_substation_rtn'  || $status == 'At_Substation_rtn_Reattempt1'|| $status == 'At_Substation_rtn_Reattempt2') {
            return 'At Substation RTN';
        }

        if($status == 'Order picked_in transit' || $status == 'Order picked_weight changed' || $status == 'In transit' || $status == 'In transit_address changed' || $status == 'In transit_Business_or_house closed' || $status == 'In transit_COD amount not ready'|| $status == 'In transit_Customer Refused_or_Rejected'|| $status == 'In transit_undelivered'|| $status == 'In transit_Reattempt1'|| $status == 'In transit_Reattempt2'|| $status == 'In transit_delay out of our control'|| $status == 'In Transit_Out for Delivery'|| $status == 'In Transit_Out for Delivery1'|| $status == 'In Transit_Out for Delivery2'|| $status == 'In transit_Shipment Lost') {
            return 'In Transit';
        }

        if($status == 'RTN Order picked_in transit' || $status == 'RTN Order picked_weight changed' || $status == 'RTN In transit' || $status == 'RTN In transit_address changed' || $status == 'RTN In transit_Business_or_house closed' || $status == 'RTN In transit_COD amount not ready'|| $status == 'RTN In transit_Customer Refused_or_Rejected'|| $status == 'RTN In transit_undelivered'|| $status == 'RTN In transit_Reattempt1'|| $status == 'RTN In transit_Reattempt2'|| $status == 'RTN In transit_delay out of our control'|| $status == 'RTN  In Transit_Out for Delivery'|| $status == 'RTN In Transit_Out for Delivery1'|| $status == 'RTN In Transit_Out for Delivery2'|| $status == 'RTN In transit_Shipment Lost') {
            return 'Return In Transit';
        }

        if($status == 'Delivered' || $status == 'Delivered_Cash collected' || $status == 'Delivered_card on delivery' || $status == 'Delivered_Open box' || $status == 'RTN Delivered') {
            return 'Delivered';
        }

        
    }

    public function getStatus($status) {
        $filter_status = array();
        if($status == 'Order Received') {
            $filter_status[] = ['Order Received'];      
          }

          if($status == 'Order Cancelled') {
            $filter_status[] = ['Order Assigned_Cancel','Order assigned_Pickup cancel'];      
          }

          if($status == 'Assigned') {
            $filter_status[] = ['Assigned','Order Assigned','Order Assigned not ready','Order Reassigned_1','Order Reassigned_2'];      
          }
         
          if($status == 'At Sub Station') {
            $filter_status[] = ['At Sub Station','At_substation','At_Substation_Reattempt1','At_Substation_Reattempt2'];
          }

          if($status == 'At Substation RTN') {
            $filter_status[] = ['At_substation_rtn','At_Substation_rtn_Reattempt1','At_Substation_rtn_Reattempt2'];
          }

          if($status == 'In Transit') {
            $filter_status[] = ['In Transit','Order picked_in transit','Order picked_weight changed','In transit','In transit_address changed','In transit_Business_or_house closed','In transit_COD amount not ready','In transit_Customer Refused_or_Rejected','In transit_undelivered','In transit_Reattempt1','In transit_Reattempt2','In transit_delay out of our control','In Transit_Out for Delivery','In Transit_Out for Delivery1','In Transit_Out for Delivery2','In transit_Shipment Lost'];
          }

          if($status == 'Return In Transit') {
            $filter_status[] =['RTN Order picked_in transit','RTN Order picked_weight changed','RTN In transit','RTN In transit_address changed','RTN In transit_Business_or_house closed','RTN In transit_COD amount not ready','RTN In transit_Customer Refused_or_Rejected','RTN In transit_undelivered','RTN In transit_Reattempt1','RTN In transit_Reattempt2','RTN In transit_delay out of our control','RTN In Transit_Out for Delivery','RTN In Transit_Out for Delivery1','RTN In Transit_Out for Delivery2','RTN In transit_Shipment Lost'];
          }

          if($status == 'Delivered') {
            $filter_status[] = ['Delivered','Delivered_Cash collected','Delivered_card on delivery','Delivered_Open box','RTN Delivered'];      
          }
       return $filter_status;
    }
}
