<?php

namespace App\Http\Controllers\Substation;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Substation;
use App\CodCollected;
use App\Bikers;
use DB;
use Session;
use Input;
use DateTime;
use Redirect;

class SubstationController extends Controller
{
		public function __construct()
		{
				$this->middleware('auth');
		}
		/**
		 * Display a listing of the resource.
		 *
		 * @return \Illuminate\Http\Response
		 */
		public function index()
		{
				
			if (!empty(Input::get('sort'))) {
					$sort = Input::get('sort');
			} else {
					$sort = 'sub_station.name';
			}
			if (!empty(Input::get('order'))) {
					$order = Input::get('order');
			} else {
					$order = 'ASC';
			}

			if ($order == 'ASC') {
					$url = '?order=DESC';
			} else {
					$url = '?order=ASC';
			}

			if(!empty(Input::get('filter_name'))) {
					$url .= "&filter_name=".Input::get('filter_name');
			}

			$sort_data = array(
						'sub_station.name',
						'us.first_name',
						'sub_station.mobile',
						'sub_station.address',
						'sub_station.city',
						'sub_station.state'
				);
			$query = Substation::select('sub_station.*','us.id as user_table_id','us.first_name','us.last_name','us.deleted_at as user_deleted_at')
							->leftjoin('users as us','sub_station.user_id','=','us.id');
							if (isset($sort) && in_array($sort, $sort_data)) {
									$sort_col_name = $sort;
							} else {
								 $sort_col_name = "sub_station.name";
							}
							if (isset($order) && ($order == 'DESC')) {
									$query->orderby($sort_col_name,'desc');
							} else {
									$query->orderby($sort_col_name,'asc');
							}
							if(!empty(Input::get('filter_name'))) {
								$query->where(function($query) {
											$query->where('sub_station.name', 'LIKE', "%".Input::get('filter_name')."%")
												  ->orWhere('us.first_name', 'LIKE', "%".Input::get('filter_name')."%")
												  ->orWhere('sub_station.mobile', 'LIKE', "%".Input::get('filter_name')."%");
									});
							}
						//$query->where('us.deleted_at',NULL);
			$results = $query->paginate(20);
			$filter['order'] = $order;
			$filter['sort'] = $sort;
			$filter['url'] = $url;
			$total_cod = DB::table('sub_station')
										 ->SUM('cod_amount_collected');
			return view('substation.index')->withResults($results)->withFilter($filter);
		}

		/**
		 * Show the form for creating a new resource.
		 *
		 * @return \Illuminate\Http\Response
		 */
		public function create()
		{
			$states = DB::table('state')->get();
			$substation_list = DB::table('sub_station')
									->select(DB::raw('id, user_id'))
									->whereNull('deleted_at')
									->get();
			$assigned = array_unique(array_map(function($a) { return (int) $a->user_id; }, $substation_list));
			$users = DB::table('users')
						->select(DB::raw('id, first_name, last_name'))
						->where('role_id', 2)
						->whereNotIn('id', $assigned)
						->whereNull('deleted_at')
						->get();
		 	return view('substation.create')->withUsers($users)->withStates($states);
		}

		/**
		 * Store a newly created resource in storage.
		 *
		 * @param  \Illuminate\Http\Request  $request
		 * @return \Illuminate\Http\Response
		 */
		public function store(Request $request)
		{
				$this->validate($request, [
						'name' => 'required|regex:/^[\pL\s\-\']+$/u',
						'mobile' => 'required|digits:10|numeric',
						'address' => 'required',
						'landmark' => 'required',
						'city' => 'required',
						'state' => 'required',
						'pincode' => 'required|digits:6|numeric',
						'substation_manager' => 'required',
						'substation_pincode' => 'regex:/^([,]*\d{6})+[,]*$/'
				]);
				$input = $request->all();
				$substations = Substation::all();
				$assigned_pincodes = array();
				$errors = array();
				foreach ($substations as $key => $substation) {
						$assigned_pincodes = array_merge($assigned_pincodes, array_map('trim', explode(',', $substation->substation_pincode)));
				}
				$common_pincodes = array();
				$already_have_pincodes = array_intersect($assigned_pincodes, array_map('trim', explode(',', $input['substation_pincode'])));
				$common_pincodes = array_unique(array_map('trim', explode(',', $input['substation_pincode'])));
				if(count($already_have_pincodes) > 0) {
						$errors[] = "This Pincode is already assigned to another substation.";
						return Redirect::back()->withInput()->withErrors($errors);
				}
				if(count($common_pincodes) < count(array_map('trim', explode(',', $input['substation_pincode'])))) {
						$errors[] = "Pincodes can not be repeated in substation pin code field.";
						return Redirect::back()->withInput()->withErrors($errors);
				}
				$input['user_id'] = $input['substation_manager'];
				$input['substation_pincode'] = trim($input['substation_pincode']);
				Substation::create($input);
				$request->session()->flash('success', 'Substation was successfully added!');
				return redirect("substation/");
		}

		/**
		 * Display the specified resource.
		 *
		 * @param  int  $id
		 * @return \Illuminate\Http\Response
		 */
		public function show($id)
		{
				$substation = Substation::findOrFail($id);
				$user = DB::table('users')
							->select(DB::raw('first_name, last_name'))
							->where('id', $substation->user_id)
							->get();
				foreach ($user as $key => $value) {
						$substation['first_name'] = $value->first_name;
						$substation['last_name'] = $value->last_name;
				}
				return view('substation.show')->withsubstation($substation);
		}
		

		/**
		 * Show the form for editing the specified resource.
		 *
		 * @param  int  $id
		 * @return \Illuminate\Http\Response
		 */
		public function edit($id)
		{
				$substation = Substation::findOrFail($id);
				$states = DB::table('state')->get();
				$substation_list = DB::table('sub_station')
										->select(DB::raw('id, user_id'))
										->whereNull('deleted_at')
										->get();
				$assigned = array_unique(array_map(function($a) { return (int) $a->user_id; }, $substation_list));
				foreach ($assigned as $key => $assign) {
						if($substation->user_id == $assign) {
								unset($assigned[$key]);
						}
				}
				$users = DB::table('users')
							->select(DB::raw('id, first_name, last_name'))
							->where('role_id', 2)
							->whereNull('deleted_at')
							->whereNotIn('id', $assigned)
							->get();
				return view('substation.edit')->withSubstation($substation)->withUsers($users)->withStates($states);
		}

		/**
		 * Update the specified resource in storage.
		 *
		 * @param  \Illuminate\Http\Request  $request
		 * @param  int  $id
		 * @return \Illuminate\Http\Response
		 */
		public function update(Request $request, $id)
		{
				 $this->validate($request, [
						'name' => 'required|regex:/^[\pL\s\-\']+$/u',
						'mobile' => 'required|digits:10|numeric',
						'address' => 'required',
						'landmark' => 'required',
						'city' => 'required|regex:/^[\pL\s\-\']+$/u',
						'state' => 'required',
						'pincode' => 'required|digits:6|numeric',
						'substation_manager' => 'required',
						'substation_pincode' => 'required|regex:/^([,]*\d{6})+[,]*$/'
				]);

				$substation = Substation::findOrFail($id);
				$input = $request->all();
				$substations = Substation::whereNotIn('id', array($id))->get();
				$assigned_pincodes = array();
				$errors = array();
				foreach ($substations as $key => $substation_name) {
						$assigned_pincodes = array_merge($assigned_pincodes, array_map('trim', explode(',', $substation_name->substation_pincode)));
				}
				$common_pincodes = array();
				$already_have_pincodes = array_intersect($assigned_pincodes, array_map('trim', explode(',', $input['substation_pincode'])));
				$list_already_pincode = implode(',', $already_have_pincodes);
				$common_pincodes = array_unique(array_map('trim', explode(',', $input['substation_pincode'])));
				if(count($already_have_pincodes) > 0) {
						$errors[] = $list_already_pincode." pincode is/are already assigned to another substation.";
						return Redirect::back()->withInput()->withErrors($errors);
				}
				if(count($common_pincodes) < count(array_map('trim', explode(',', $input['substation_pincode'])))) {
						$errors[] = "Pincodes can not be repeated in substation pin code field.";
						return Redirect::back()->withInput()->withErrors($errors);
				}
			 $input['user_id'] = $input['substation_manager'];
			 $input['substation_pincode'] = trim($input['substation_pincode']);
			 $substation->fill($input)->save();
			 $request->session()->flash('success', 'Substation was successfully updated!');
			 return redirect("substation/");
		}

		/**
		 * Remove the specified resource from storage.
		 *
		 * @param  int  $id
		 * @return \Illuminate\Http\Response
		 */
		public function destroy($id)
		{
			 // $substation = Substation::findOrFail($id);
			 // $substation->delete();
				//$substation = Substation::destroy($id);
				$ids = explode(',', $id)    ;
		        for($i=0;$i<count($ids);$i++){
		            $substation = substation::destroy($ids[$i]);
        }
			 session()->flash('success', 'Substation deleted successfully.');
			 return redirect('substation/');
		}

		public function bankdeposit()
		{
				$substation_id = Session::get('sub_station_id');
				$substation_list = DB::table('sub_station')
								->select('id','name','deleted_at')
								->get();
				
				$query = DB::table('cod_collected as cc')
						->join('bikers as b','b.id','=','cc.biker_id')
						->join('shipment as sh','sh.id','=','cc.shipment_id')
						->leftjoin('bank_cod_deposit as bcd','bcd.bank_transaction_id','=','cc.bank_ref_id')
						->select('sh.*','cc.*','sh.id as shipment_table_id','b.*','bcd.datetime as deposited_date');
						$today_date = new DateTime('NOW');
						$end_date = $start_date = $today_date->format('Y-m-d');
						if(!empty(Input::get('start_date')) && !empty(Input::get('end_date')) || !empty(Input::get('bikers_id')) || !empty(Input::get('bank_ref_no')) || !empty(Input::get('substation_list')) || !empty($substation_id) || !empty(Input::get('collection_mode')))  {
								if(!empty(Input::get('start_date')) && !empty(Input::get('end_date'))) {
										$start_date = Input::get('start_date');
										$end_date = Input::get('end_date');
										$start_date = new DateTime($start_date);
										$start_date = $start_date->format('Y-m-d');
										$end_date = new DateTime($end_date);
										$end_date = $end_date->format('Y-m-d');
								}
								if(!empty(Input::get('bikers_id'))) {
										$bikers_id = Input::get('bikers_id');
										$biker_list = explode(',', $bikers_id);
										$query->whereIn('cc.biker_id', $biker_list);
								}
								if(!empty(Input::get('bank_ref_no'))) {
										$bank_ref_no = Input::get('bank_ref_no');
										$query->where('cc.bank_ref_id','=',$bank_ref_no);  
								}
								if(!empty(Input::get('substation_list'))) {
										$query->where('b.substation_id',Input::get('substation_list'));
								}
								if(!empty(Input::get('collection_mode'))) {
										$query->where('cc.payment_mode','=',Input::get('collection_mode'));
								}
								if(!empty($substation_id)) {
										$query->where('b.substation_id','=', $substation_id);
								}
						} 
						$query->whereBetween('cc.date', array($start_date,$end_date));
		                if(Input::get('report') == 1) {    
		                    $collected = $query->get();
		                } else {
		                    $collected = $query->paginate(20);
		                } 
				
				if(Input::get('report') == 1) {
						$csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
						$csv->insertOne(array('AWB No.','Shipment Date','Collection Date','Biker','Amount','Collection Type', 'Bank Ref No.', 'Deposited Date'));
						foreach ($collected as $line) { 
								$date = new DateTime($line->date);
								$collected_date = $date->format('d-m-Y');
								$shipment_date = new DateTime($line->order_time);
								$shipment_date = $shipment_date->format('d-m-Y');
								if($line->deposited_date) {
										$deposited_date = new DateTime($line->deposited_date);
										$deposited_date = $deposited_date->format('d-m-Y');
								} else {
										$deposited_date = 0;
								}
								$data = array(
										'awb_no' => $line->awb_no,
										'shipment_date' => $shipment_date,
										'collected_date' => $collected_date,
										'name' => ucwords(strtolower($line->first_name)) . ' ' . ucwords(strtolower($line->last_name)),
										'amount' => $line->amount,
										'Collection Type' => ucwords($line->payment_mode),
										'bank_ref_no' => $line->bank_ref_id,
										'deposited_date' => ($deposited_date == NULL) ? '0' : $deposited_date,
								);
								$line = (array) $data;
								$csv->insertOne($line);
						}
						$csv->output('bank_cod_deposit.csv');
						return;
				}
				$bikers_list_query = Bikers::select();
										if(!empty($substation_id)) {
												$bikers_list_query->where('substation_id', $substation_id);
										}
										$bikers_list_query->where('bikers.status','=','Active');
				$bikers = $bikers_list_query->get();
				return view('substation.bankdeposit')->withCollected($collected)->withBikers($bikers)->withSubstationList($substation_list);
		}

		public function bank_cod_deposit(Request $request){
				$input = $request->all();
				$deposited_date = new DateTime($input['datetime']);
				$input['datetime'] = $deposited_date->format('Y-m-d H:m:i');
				DB::table('bank_cod_deposit')->insert([
						'user_id' => $request->user()->id,
						'sub_station_id' => Session::get('sub_station_id') ,
						'bank_transaction_id' => $input['bank_transaction_no'],
						'amount' => $input['amount'],
						'datetime' => $input['datetime'],
				]);
				foreach ($input['selected'] as $key => $value) {
						DB::table('cod_collected')
								->where('shipment_id', $value)
								->update([
										'bank_ref_id' => $input['bank_transaction_no']
								]);
				}
				$cod_amount_collected = DB::table('sub_station')
								 ->select(DB::raw('cod_amount_collected'))
								 ->where('user_id', $request->user()->id)
								 ->first();
				$total_cod_amt = $cod_amount_collected->cod_amount_collected - $input['amount'];
				Session::put('sub_station_cod_amt',$total_cod_amt);
				DB::table('sub_station')
								->where('user_id', $request->user()->id)
								->update([
										'cod_amount_collected' => $total_cod_amt
								]);
				session()->flash('success', 'Transaction is successfully added.');
				return redirect('bankdeposit/'); 
		}
}
