<?php 
namespace App\Http\Controllers\Status;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ServiceType;

use Illuminate\Support\Facades\Validator;


class ServiceTypeController extends Controller
{
    public function index()
    {
        $serviceTypes = ServiceType::all()->map(function ($item, $index) {
        $item->serial = $index + 1; // Add serial number starting from 1
        return $item;
    });
        return view('service_types.index', compact('serviceTypes'));
    }

    public function create()
    {
        return view('service_types.create');
    }

    public function store(Request $request)
    {
       

         $validator = Validator::make($request->all(), [
            'service_type' => 'required|string|max:255',
            'status' => 'required|boolean',
        ]);

         if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        ServiceType::create($request->all());

        return redirect()->route('service-types.index')->with('success', 'Service Type added successfully.');
    }

    public function edit($id)
    {
        $serviceType = ServiceType::findOrFail($id);
        if (in_array($serviceType->service_type, ['New', 'Completed', 'Closed'])) {
        return redirect()->route('service-types.index')->with('error', 'This service type cannot be edited.');
    }
        return view('service_types.edit', compact('serviceType'));
    }

    public function update(Request $request, $id)
    {
      $serviceType = ServiceType::findOrFail($id);

    if (in_array($serviceType->service_type, ['New', 'Completed', 'Closed'])) {
        return redirect()->route('service-types.index')->with('error', 'This service type cannot be updated.');
    }

    $validator = Validator::make($request->all(), [
        'service_type' => 'required|string|max:255',
        'status' => 'required|boolean',
    ]);

    if ($validator->fails()) {
        return redirect()->back()->withErrors($validator)->withInput();
    }

    $serviceType->update($request->all());

        return redirect()->route('service-types.index')->with('success', 'Service Type updated successfully.');
    }

    public function destroy($id)
    {
        $serviceType = ServiceType::findOrFail($id);
        if (in_array($serviceType->service_type, ['New', 'Completed', 'Closed'])) {
        return redirect()->route('service-types.index')->with('error', 'This service type cannot be deleted.');
    }
    
        $serviceType->delete();

        return redirect()->route('service-types.index')->with('success', 'Service Type deleted successfully.');
    }

    public function toggle($id)
    {
        $serviceType = ServiceType::findOrFail($id);
        $serviceType->status = !$serviceType->status;
        $serviceType->save();

        return redirect()->route('service-types.index')->with('success', 'Status updated successfully.');
    }
}
