<?php

namespace App\Http\Controllers\Shipment;
use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\StatusHistory;
use DB;
use Carbon\Carbon;
use Session;

class UpdateStatusController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return view('shipment.updatestatus');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {   
        $this->validate($request, [
            'awb_no' => 'required',
            'delivery_status' => 'required'
        ]);
        $input = $request->all();
        $shipments = explode(',', $input['awb_no']);
        $failed = array();
        
        if($shipments) {
            $role = DB::table('roles')
                ->select(DB::raw('id, role_title'))
                ->where('id', $request->user()->role_id)
                ->first();
            foreach ($shipments as $key => $awb_no) {
                $awb_no = trim($awb_no);
                $result = DB::table('shipment')
                                    ->select(DB::raw('count(*) as count, id'))
                                    ->where('shipment.awb_no', $awb_no)
                                    ->first();
                if($result->count) {
                    $shipment = DB::table('shipment')
                                ->where('shipment.awb_no', $awb_no)
                                ->update(['delivery_status' => $input['delivery_status']]);

                    $input['by_whom_role'] = $role->role_title;
                    $input['by_whom_id'] = $request->user()->id;
                    $input['date_time'] = Carbon::now()->toDateTimeString();
                    $input['shipment_id'] = $result->id;
                    $input['status'] = $input['delivery_status'];
                    $id = StatusHistory::create($input);
                } else {
                    $failed[] = $awb_no;
                }
            }
        }

        if($failed) {
            Session::flash('error','Status cannot be updated for : ' . implode(', ', $failed));
        } else {
            $request->session()->flash('flash_message', 'Delivery Status successfully updated!');
        }
        return redirect('updatestatus');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
