<?php
namespace App\Http\Controllers\ServiceProvider;
ini_set('max_execution_time', 0);
use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use Mail;
use DB;
use Input;
use Config;
use Auth;
use App\Service_providers;

class ServiceproviderController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

public function index()
    {
        $userpermission = DB::table('users')
        ->join('permission_role','permission_role.role_id','=','users.role_id')
        ->select('*')
        ->where('users.id',Auth::user()->id)
        ->where('permission_role.permission_id',1)
        ->get();
        // echo "<pre>";

        if (!empty(Input::get('sort'))) {
                $sort = Input::get('sort');
        } else {
                $sort = 'service_providers.name';
        }
        if (!empty(Input::get('order'))) {
                $order = Input::get('order');
        } else {
                $order = 'ASC';
        }

        if ($order == 'ASC') {
                $url = '?order=DESC&filter_name='.(!empty(Input::get('filter_name'))?Input::get('filter_name'):'');
        } else {
                $url = '?order=ASC&filter_name='.(!empty(Input::get('filter_name'))?Input::get('filter_name'):'');
        }
        if(!empty(Input::get('order'))) {
       //     $url .= "?order=".Input::get('order');
        }
       
       if(!empty(Input::get('sort'))) {
         //   $url .= "&sort=".Input::get('sort');
        }

        $sort_data = array(
            'service_providers.company_name',
            'service_providers.name',
            'service_providers.mobile_no',
            'service_providers.email',
            'service_providers.status',
            
        );

        $query = DB::table('service_providers')->select('*')->where("deleted_at","=",'N');
        //$query = Vendor::select();
       // $query = DB::table('service_providers')->select('*');
        //->where("deleted_at","=",'N');
       // $query;
                    if (isset($sort) && in_array($sort, $sort_data)) {
                        $sort_col_name = $sort;
                    } else {
                        $sort_col_name = "service_providers.name";
                    }
                    if (isset($order) && ($order == 'DESC')) {
                        $query->orderby($sort_col_name,'desc');
                    } else {
                        $query->orderby($sort_col_name,'asc');
                    }
                    if(!empty(Input::get('filter_name'))) {
                        
        $query->whereRaw("(service_providers.company_name LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR  service_providers.name LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR service_providers.email LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR service_providers.status LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR service_providers.mobile_no LIKE '%".trim(addslashes(Input::get('filter_name')))."%')");
                           
                    }
                    //$myModelsPaginator->appends($input);

        $service_providers = $query->paginate(10);            
            //echo $url;exit();
                    $filter = array(
                        'sort' => $sort,
                        'url' => $url,
                        'order' => $order
                    );
                    //export start
        
              
         
         if(Input::get('report') == 1) {


             $query1tmp = DB::table('service_providers')          
                  ->select('*')
                  ->where('deleted_at','=','N');



            if(!empty(Input::get('filter_name'))) {

                        
                 $query1tmp->whereRaw("(service_providers.company_name LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR  service_providers.name LIKE '%".trim(addslashes(Input::get('filter_name')))."%'  OR service_providers.email LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR service_providers.status LIKE '%".trim(addslashes(Input::get('filter_name')))."%' OR service_providers.mobile_no LIKE '%".trim(addslashes(Input::get('filter_name')))."%' )");
                       
                    }

            if(!empty(Input::get('reportids'))) {
          
                $selectedval = Input::get('reportids');
                 $query1tmp->whereRaw("(service_providers.id IN (".$selectedval.") )");
            }

                if (isset($sort) && in_array($sort, $sort_data)) {
                        $sort_col_name = $sort;
                    } else {
                        $sort_col_name = "service_providers.name";
                    }
                    if (isset($order) && ($order == 'DESC')) {
                        $query1tmp->orderby($sort_col_name,'desc');
                    } else {
                        $query1tmp->orderby($sort_col_name,'asc');
                    }

                  $query1 =   $query1tmp->get();

            $csv = \League\Csv\Writer::createFromFileObject(new \SplTempFileObject());
            $csv->insertOne(array(' ','SERVICE PROVIDERS REPORT'));
            $csv->insertOne(array());

            $csv->insertOne(array('Name','Company Name', 'Email','MobileNo','Status'));
             foreach ($query1 as $line) {
                $data = array(
                    'name' => $line->name,
                    'company_name' => $line->company_name,
                    
                    'email' => $line->email,
                    
                    'mobileno' => $line->mobile_no,
                    
                    'status' => $line->status
                    
                );

                $line = (array) $data;
                $csv->insertOne($line);
            }
            $csv->output('serviceprovider_report.csv');
            die;
            return;
        }
        //end start
        return view('serviceprovider.index')
        ->withservice_providers($service_providers)
        ->withFilter($filter)
        ->withUserpermission($userpermission);
    }



    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create() {
         //$states = DB::table('state')->get();
         //$service_pros = DB::table('service_providers')->get();
         return view('serviceprovider.create');
         //->withStates($states)
        // ->withservice_pros($service_pros);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request) {
        // echo "ini";die;
        // echo "<pre>"; print_r($request->all()); die();
         $this->validate($request, [
            'company_name' => 'required',
            'name' => 'required',
            'email' => 'required|email',
            'mobile_no' => 'required',
            'status' => 'required'            
            ]);

        
            
            $input = $request->all();
                // echo "<pre>"; print_r($input['name']); die();
            // $vendor_id = service_provider::create($input);
            $values = array('name' =>  $input['name'],'company_name' =>  $input['company_name'], 'mobile_no' =>  $input['mobile_no'], 'status' =>  $input['status'], 'email' =>  $input['email']);
            DB::table('service_providers')->insert($values);
            
            $request->session()->flash('flash_message', 'Company added successfully !!!');
            return redirect('serviceprovider');
        
        
    }




    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //echo "rrr";die;
        
        $service_providers = DB::table('service_providers')->select('*')->where("id",'=',$id)->get();
          // echo "<pre>"; echo print_r($service_providers) ; die;
        //$states = DB::table('state')->get();
        //$service_pros = DB::table('service_providers')->get();
         //echo "<pre>"; echo print_r($service_pros) ; die;
        return view('serviceprovider.edit')->withservice_providers($service_providers[0]);
        //->withStates($states)
        //->withImgDir($img_dir)
        //->withservice_pros($service_pros);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
     public function update(Request $request, $id)
    { 
        //echo "ee"; die;
        $this->validate($request, [
            'company_name' => 'required',
            'name' => 'required',
            'email' => 'required|email',
            'mobile_no' => 'required',
            'status' => 'required'            
            ]);

        //$service_provider1 = DB::table('service_providers')->select('*')->where("id",'=',$id)->where("deleted_at",'=','N')->get();
        //$service_provider=$service_provider1[0];

        $input = $request->all(); 
        // echo "<pre>"; print_r($input); die;
      //  $input['company_name'] = ucwords($input['company_name']);
      //  $input['name'] = ucwords(strtolower($input['name']));

        DB::table('service_providers')
        ->where("id",'=',$id)
        ->update(['company_name' => $input['company_name'], 'name' => $input['name'], 'email' => $input['email'],
        'mobile_no' =>  $input['mobile_no'],'status' =>  $input['status'] ]);
        

        $request->session()->flash('flash_message', 'Client details updated successfully !!!');
        return redirect("serviceprovider?sort=".$_GET['sort']."&filter_name=".$_GET['filter_name']."&page=".$_GET['page']."&order=".$_GET['order']);
    }

    public function destroy($id)
    {
        //echo $id ; die;
         // echo "<pre>"; print_r($id); die();
        $date = date('Y-m-d H:i:s');
        $ids = explode(',', $id);
        $deleted_at = DB::table('service_providers')->whereIN('id', $ids)->update(['deleted_at' => $date]);
        // for($i=0;$i<count($ids);$i++){
        //     $Serviceproviders = Serviceprovider::destroy($ids[$i]);
        // }
        //Vendor::find(explode(',', $id))->destroy();
        return redirect('serviceprovider')->with('flash_message', 'Client deleted successfully !!!');
    }

}
